/*
 * Created on 08/08/2011
 *
 */
package s12.progrExperienciales.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Types;
import java.util.ArrayList;

import s12.progrExperienciales.valueObjects.S12EnlacesCapital;
import s12.progrExperienciales.valueObjects.S12ImagenDia;
import s12.progrExperienciales.valueObjects.S12UnidadMultimedia;
import s12.progrExperienciales.valueObjects.S12UnidadesContenidosVI;
import s12.util.S12ConnectionManager;
import bilbofrmk.util.BLogger;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * The Class S12ProgramasExperiencialesDao.
 * 
 *  
 */
public class S12ProgramasExperiencialesDao {

	private final static int VIAJARCON_PAREJA = 1;
	private final static int VIAJARCON_NINOS = 2;
	private final static int VIAJARCON_AMIGOS = 3;
	private final static int INTERES_CULTURA = 1;
	private final static int INTERES_GASTRONOMIA = 2;
	private final static int INTERES_BIENESTAR = 3;
	private final static int INTERES_NATURALEZA = 4;
	private final static int INTERES_COMPRAS = 5;
	private final static int INTERES_EVENTOS = 6;

	private static final String COMPONENTE = "PROGRAMAS_EXPERIENCIALES";
	private static final int SIZE_STRINGBUFFER = 160;
	
	/** tipo multimedia para las imagenes de la unidad de contenido */
	private final static int PEX_TIPOMULT_IMAGEN = 11;

	/**
	 * Devuelve las filas de la tabla Enlaces_Capital correspondiente al codigo de capital especificado.
	 * 
	 * @param capital the capital
	 * @param language the language
	 * 
	 * @return the enlaces capital
	 * 
	 * @throws Exception the exception
	 */
	public ArrayList getEnlacesCapital(String capital, String language) throws Exception {

		ArrayList resultado = new ArrayList();
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);
		S12EnlacesCapital enlacesCapital;

		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = S12ConnectionManager.getConnection();

			sqlBuffer.append("SELECT COENLACE, COCAPITAL, COIDIOMA, COESTADO, NOENLACE, URLENLACE, DEENLACE, COUSERFECREACION ");
			sqlBuffer.append("FROM PEX_ENLACES_CAPITAL WHERE COCAPITAL = ? AND COIDIOMA = ? AND COESTADO = 'PU'");

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, capital);	
			prepStmt.setString(index++, language);
			rs = prepStmt.executeQuery();

			while (rs != null && rs.next()) {
				enlacesCapital = new S12EnlacesCapital();
				enlacesCapital.setCodigoEnlace(rs.getLong("COENLACE"));
				enlacesCapital.setCodigoCapital(rs.getString("COCAPITAL"));
				enlacesCapital.setIdioma(rs.getString("COIDIOMA"));
				enlacesCapital.setCodigoEstado(rs.getString("COESTADO"));
				enlacesCapital.setNombreEnlace(rs.getString("NOENLACE"));
				enlacesCapital.setUrlEnlace(rs.getString("URLENLACE"));
				enlacesCapital.setDescripcionEnlace(rs.getString("DEENLACE"));
				enlacesCapital.setUsuario(rs.getString("COUSERFECREACION"));

				resultado.add(enlacesCapital);
			}
		} catch (Exception e) {
			BLogger.blog(BLogger.ERROR, "Error acceso a datos en getEnlacesCapital. ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

	/**
	 * Gets the unidades contenido.
	 * 
	 * @param capital the capital
	 * @param nDias the n dias
	 * @param viajarCon the viajar con
	 * @param interes the interes
	 * @param original the original
	 * @param language the language
	 * 
	 * @return the unidades contenido
	 * 
	 * @throws Exception the exception
	 */
	public ArrayList getUnidadesContenido(String capital, int nDias, int viajarCon, int interes, String original,
			String language) throws Exception {

		ArrayList resultado = new ArrayList();
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);
		StringBuffer sqlOpciones = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);
		String sqlViajarCon = "";
		String sqlInteres = "";
		S12UnidadesContenidosVI unidadContenidoVI;

		try {
			conn = S12ConnectionManager.getConnection();

			sqlBuffer.append(" SELECT UC.COUNID, UC.COIDIOMA, UC.COESTADO, UC.NOUNIDAD, UC.DEDESCRIPCION, ");
			sqlBuffer.append(" UP.COPROG, UP.CODIA, UP.COFRANJA, UP.CORDEN ");
			sqlBuffer.append(" FROM PEX_UNIDADCONTENIDO UC, PEX_UNID_PROGRAMAS UP WHERE ");
			sqlBuffer.append(" UC.COUNID = UP.COUNID AND COIDIOMA = ? AND COCAPITAL = ?");
			sqlBuffer.append(" AND COPROG = ? AND COESTADO = 'PU'");
			sqlBuffer.append(" AND FEBAJA IS NULL AND COUSERFEBAJA IS NULL ");

			switch (viajarCon) {
				case S12ProgramasExperiencialesDao.VIAJARCON_PAREJA:
					sqlViajarCon = "COGRUPOPAREJA = '1'";
					break;
				case S12ProgramasExperiencialesDao.VIAJARCON_NINOS:
					sqlViajarCon = "COGRUPONINOS = '1'";
					break;
				case S12ProgramasExperiencialesDao.VIAJARCON_AMIGOS:
					sqlViajarCon = "COGRUPOAMIGOS = '1'";
					break;
				default:
					break;
			}

			switch (interes) {
				case S12ProgramasExperiencialesDao.INTERES_CULTURA:
					sqlInteres = "COINTERESCULTURA = '1'";
					break;
				case S12ProgramasExperiencialesDao.INTERES_GASTRONOMIA:
					sqlInteres = "COINTERESGASTRONOMIA = '1'";
					break;
				case S12ProgramasExperiencialesDao.INTERES_BIENESTAR:
					sqlInteres = "COINTERESBIENESTAR = '1'";
					break;
				case S12ProgramasExperiencialesDao.INTERES_NATURALEZA:
					sqlInteres = "COINTERESNATURALEZA = '1'";
					break;
				case S12ProgramasExperiencialesDao.INTERES_COMPRAS:
					sqlInteres = "COINTERESCOMPRAS = '1'";
					break;
				case S12ProgramasExperiencialesDao.INTERES_EVENTOS:
					sqlInteres = "COINTERESEVENTOS = '1'";
					break;
				default:
					break;
			}

			if (sqlViajarCon.length() > 0 && sqlInteres.length() > 0 && !"".equals(original)) {
				sqlOpciones.append(" AND (").append(sqlViajarCon).append(" OR ").append(sqlInteres)
						.append(" OR COORIGINAL = '1')");
			} else if (sqlViajarCon.length() > 0 && sqlInteres.length() > 0) {
				sqlOpciones.append(" AND COORIGINAL = '0' AND (").append(sqlViajarCon).append(" OR ")
						.append(sqlInteres).append(")");
			} else if (sqlViajarCon.length() > 0 && !"".equals(original)) {
				sqlOpciones.append(" AND (").append(sqlViajarCon).append(" OR COORIGINAL = '1')");
			} else if (sqlInteres.length() > 0 && !"".equals(original)) {
				sqlOpciones.append(" AND (").append(sqlInteres).append(" OR COORIGINAL = '1')");
			} else if (sqlViajarCon.length() > 0) {
				sqlOpciones.append(" AND COORIGINAL = '0' AND ").append(sqlViajarCon);
			} else if (sqlInteres.length() > 0) {
				sqlOpciones.append(" AND COORIGINAL = '0' AND ").append(sqlInteres);
			} else if ("".equals(original)) {
				sqlOpciones.append(" AND COORIGINAL = '0'");
			}

			if (sqlOpciones.length() > 0) {
				sqlBuffer.append(sqlOpciones.toString());
			}

			sqlBuffer.append(" ORDER BY CORDEN");

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12ProgramasExperiencialesDao.COMPONENTE, Q70TraceLevel.DEBUG,
						"S12ProgramasExperiencialesDao:: SQL: " + sqlBuffer.toString());
			}
			BLogger.blog(BLogger.DEBUG, "Se realiza la SQL de UNIDADES DE CONTENIDO:" + sqlBuffer.toString());

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, language);
			prepStmt.setString(index++, capital);
			prepStmt.setInt(index++, nDias);
			rs = prepStmt.executeQuery();

			while (rs != null && rs.next()) {
				unidadContenidoVI = new S12UnidadesContenidosVI();
				unidadContenidoVI.setCodigoUnidad(rs.getLong("COUNID"));
				unidadContenidoVI.setIdioma(rs.getString("COIDIOMA"));
				unidadContenidoVI.setCodigoEstado(rs.getString("COESTADO"));
				unidadContenidoVI.setNombreUnidad(rs.getString("NOUNIDAD"));
				unidadContenidoVI.setDescripcionUnidad(rs.getString("DEDESCRIPCION"));
				unidadContenidoVI.setDiasPrograma(rs.getLong("COPROG"));
				unidadContenidoVI.setCodigoDia(rs.getLong("CODIA"));
				unidadContenidoVI.setCodigoFranja(rs.getLong("COFRANJA"));
				unidadContenidoVI.setCodigoOrden(rs.getLong("CORDEN"));
				unidadContenidoVI.setRecursosAsociados(this.getRecursosAsociados(rs.getLong("COUNID")));

				resultado.add(unidadContenidoVI);
			}
		} catch (Exception e) {
			BLogger.blog(BLogger.ERROR, "Error acceso a datos en getUnidadesContenido. ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

	/**
	 * Gets the multimedia.
	 * 
	 * @param arUnidadesContenido the ar unidades contenido
	 * @param dia the dia
	 * @param language the language
	 * @param diasPrograma the dias programa
	 * 
	 * @return the multimedia
	 * 
	 * @throws Exception the exception
	 */
	public ArrayList getMultimedia(ArrayList arUnidadesContenido, int dia, int diasPrograma, String language)
			throws Exception {

		ArrayList resultado = new ArrayList();
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);
		S12UnidadMultimedia unidadMultimedia;
		S12UnidadesContenidosVI unidadContenido;
		StringBuffer codUnidadesParam = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);

		try {
			conn = S12ConnectionManager.getConnection();
			ArrayList<Object> params = new ArrayList<Object>();
			
			for (int i = 0; i < arUnidadesContenido.size(); i++) {
				unidadContenido = (S12UnidadesContenidosVI) arUnidadesContenido.get(i);
				if (unidadContenido.getCodigoDia() == dia) {
					Long codigo = new Long(unidadContenido.getCodigoUnidad());
					params.add(codigo);
					if (codUnidadesParam.length() == 0) {
						codUnidadesParam.append("?");
					} else {
						codUnidadesParam.append(",?");
					}
				}
			}

			sqlBuffer.append("SELECT COMULT, UM.COUNID, COIDIOMA, ").append(PEX_TIPOMULT_IMAGEN).append(" COTIPMULT, URLMULT, DEMULT, UP.CODIA, UP.COFRANJA, UP.CORDEN ");
			sqlBuffer.append("FROM PEX_UNID_MULTIMEDIA UM, PEX_UNID_PROGRAMAS UP ");
			sqlBuffer.append("WHERE UM.COUNID = UP.COUNID AND COIDIOMA = ? AND COPROG = ?");
			sqlBuffer.append(" AND UM.COUNID IN (" + codUnidadesParam.toString() + ") ORDER BY COFRANJA,CORDEN");

			BLogger.blog(BLogger.DEBUG, "Se realiza la SQL de MULTIMEDIA del dia: " + dia + "; " + sqlBuffer.toString());

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, language);
			prepStmt.setInt(index++, diasPrograma);
			for (Object codigo : params) {
				prepStmt.setObject(index++, codigo, Types.NUMERIC);
			}
			rs = prepStmt.executeQuery();

			while (rs != null && rs.next()) {
				unidadMultimedia = new S12UnidadMultimedia();
				unidadMultimedia.setCodigoMultimedia(rs.getLong("COMULT"));
				unidadMultimedia.setCodigoUnidad(rs.getLong("COUNID"));
				unidadMultimedia.setIdioma(rs.getString("COIDIOMA"));
				unidadMultimedia.setCodigoTipoMultimedia(rs.getLong("COTIPMULT"));
				unidadMultimedia.setUrlMultimedia(rs.getString("URLMULT"));
				unidadMultimedia.setDescripcionMultimedia(rs.getString("DEMULT"));

				resultado.add(unidadMultimedia);
			}
		} catch (Exception e) {
			BLogger.blog(BLogger.ERROR, "Error acceso a datos en getMultimedia. ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

	/**
	 * Gets the recursos asociados.
	 * 
	 * @param codUnidadContenido the cod unidad contenido
	 * 
	 * @return the recursos asociados
	 * 
	 * @throws Exception the exception
	 */
	public ArrayList getRecursosAsociados(long codUnidadContenido) throws Exception {

		ArrayList resultado = new ArrayList();
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);

		try {
			conn = S12ConnectionManager.getConnection();

			sqlBuffer.append("SELECT COUNID, COREC ");
			sqlBuffer.append("FROM PEX_UNID_RECURSO WHERE COUNID = ?");

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setLong(index++, codUnidadContenido);
			rs = prepStmt.executeQuery();

			while (rs != null && rs.next()) {
				resultado.add(rs.getString("COREC"));
			}
		} catch (Exception e) {
			BLogger.blog(BLogger.ERROR, "Error acceso a datos en getRecursosAsociados. ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

	/**
	 * Obtiene la imagen de cada dia de un programa de N dias para una Capital.
	 * 
	 * @param capital
	 * @param nDias
	 * @return array con las rutas de las imagenes
	 */
	public ArrayList getImagenesDias(String capital, int nDias) {
		ArrayList resultado = new ArrayList();
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12ProgramasExperiencialesDao.SIZE_STRINGBUFFER);
		S12ImagenDia imagenDia;

		try {
			conn = S12ConnectionManager.getConnection();

			sqlBuffer.append("SELECT PRG.CODIA, IMG.NOMBREIMAGEN, IMG.NOMBREFICHERO, IMG.DESCRIPCION");
			sqlBuffer.append(" FROM PEX_IMAGENES IMG, PEX_IMAGENES_PROGRAMA PRG ");
			sqlBuffer.append(" WHERE IMG.CODIMAGEN = PRG.CODIMAGEN ");
			sqlBuffer.append(" AND IMG.CODCAPITAL = ? AND PRG.COPROG = ?");
			sqlBuffer.append(" ORDER BY PRG.CODIA");

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12ProgramasExperiencialesDao.COMPONENTE, Q70TraceLevel.DEBUG,
						"S12ProgramasExperiencialesDao:: SQL: " + sqlBuffer.toString());
			}
			BLogger.blog(BLogger.DEBUG, "Se realiza la SQL de IMAGEN DE CADA DIA DE PROGRAMA: " + sqlBuffer.toString());

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, capital);
			prepStmt.setInt(index++, nDias);
			rs = prepStmt.executeQuery();
			
			while (rs != null && rs.next()) {
				imagenDia = new S12ImagenDia();
				imagenDia.setCodigoDia(rs.getLong("CODIA"));
				imagenDia.setNombreImagen(rs.getString("NOMBREIMAGEN"));
				imagenDia.setNombreFichero(rs.getString("NOMBREFICHERO"));
				imagenDia.setDescripcionImagen(rs.getString("DESCRIPCION"));
				resultado.add(imagenDia);
			}
		} catch (Exception e) {
			BLogger.blog(BLogger.ERROR, "Error acceso a datos en getImagenesDias. ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

}
