/*
 * Created on 20/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;


/**
 * The Class S12UnidadContenidoVI.
 *  
 */
public class S12UnidadContenidoVI implements JSONString {

	private long codigoUnidad;
	private String codigoIdioma;
	private String nombreUnidad;
	private String descripcionUnidad;
	private long diasPrograma;
	private long codigoDia;
	private long codigoFranja;
	private long codigoOrden;
	
	private ArrayList<S12UnidadContenidoRecurso> recursos;

	/**
	 * Gets the codigo capital.
	 *
	 * @return Returns the codigoUsuario.
	 */
	public long getCodigoUnidad() {
		return this.codigoUnidad;
	}

	/**
	 * Sets the codigo Unidad.
	 *
	 * @param codigoUnidad The codigo Unidad to set.
	 */
	public void setCodigoUnidad(long codigoUnidad) {
		this.codigoUnidad = codigoUnidad;
	}

	/**
	 * Gets the fax.
	 *
	 * @return Returns the codigoIdioma.
	 */
	public String getIdioma() {
		return this.codigoIdioma;
	}

	/**
	 * Sets the fax.
	 *
	 * @param codigoIdioma The codigoIdioma to set.
	 */
	public void setIdioma(String codigoIdioma) {
		this.codigoIdioma = codigoIdioma;
	}

	/**
	 * Gets the fax.
	 *
	 * @return Returns the nombreUnidad.
	 */
	public String getNombreUnidad() {
		return this.nombreUnidad;
	}

	/**
	 * Sets the fax.
	 *
	 * @param nombreUnidad The nombreUnidad to set.
	 */
	public void setNombreUnidad(String nombreUnidad) {
		this.nombreUnidad = nombreUnidad;
	}

	/**
	 * Gets the fax.
	 *
	 * @return Returns the descripUnidad.
	 */
	public String getDescripcionUnidad() {
		return this.descripcionUnidad;
	}

	/**
	 * Sets the fax.
	 *
	 * @param descripcionUnidad The descripUnidad to set.
	 */
	public void setDescripcionUnidad(String descripcionUnidad) {
		this.descripcionUnidad = descripcionUnidad;
	}

	/**
	 * @return Retorna el valor del campo codigoIdioma.
	 */
	public String getCodigoIdioma() {
		return this.codigoIdioma;
	}

	/**
	 * @param codigoIdioma Establece el valor del campo codigoIdioma.
	 */
	public void setCodigoIdioma(String codigoIdioma) {
		this.codigoIdioma = codigoIdioma;
	}

	/**
	 * @return Retorna el valor del campo diasPrograma.
	 */
	public long getDiasPrograma() {
		return this.diasPrograma;
	}

	/**
	 * @param diasPrograma Establece el valor del campo diasPrograma.
	 */
	public void setDiasPrograma(long diasPrograma) {
		this.diasPrograma = diasPrograma;
	}

	/**
	 * @return Retorna el valor del campo codigoDia.
	 */
	public long getCodigoDia() {
		return this.codigoDia;
	}

	/**
	 * @param codigoDia Establece el valor del campo codigoDia.
	 */
	public void setCodigoDia(long codigoDia) {
		this.codigoDia = codigoDia;
	}

	/**
	 * @return Retorna el valor del campo codigoFranja.
	 */
	public long getCodigoFranja() {
		return this.codigoFranja;
	}

	/**
	 * @param codigoFranja Establece el valor del campo codigoFranja.
	 */
	public void setCodigoFranja(long codigoFranja) {
		this.codigoFranja = codigoFranja;
	}

	/**
	 * @return Retorna el valor del campo codigoOrden.
	 */
	public long getCodigoOrden() {
		return this.codigoOrden;
	}

	/**
	 * @param codigoOrden Establece el valor del campo codigoOrden.
	 */
	public void setCodigoOrden(long codigoOrden) {
		this.codigoOrden = codigoOrden;
	}

	/**
	 * @return Retorna el valor del campo recursos
	 */
	public ArrayList<S12UnidadContenidoRecurso> getRecursos() {
		return this.recursos;
	}

	/**
	 * @param recursos Establece el valor del campo recursos
	 */
	public void setRecursos(ArrayList<S12UnidadContenidoRecurso> recursos) {
		this.recursos = recursos;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("description", S12Utils.encodeHtmlTag(this.getDescripcionUnidad()));
			jObject.put("location", new JSONArray(this.getRecursos()));

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}