package s12.portalMovil.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 *  
 *
 */
public class S12UnidadContenidoRecurso implements JSONString {

	/**	Cdigo asociado al recurso */
	private int codigoRecurso;
	
	/** Template type */
	private String templateType;
	
	/**	Ruta de la imagen principal del recurso */
	private String fotoPrincipal;

	/** Nombre del recurso */
	private String nombre;
	
	/** Descripcin del recurso */
	private String descripcion;
	
	/** Idioma del recurso */
	private String idioma;

	/** URL amigable */
	private String urlAmigable;
	
	/** Longitud del recurso */
	private String gmlong;

	/** Latitud del recurso */
	private String gmlat;
	
	/**
	 * Retorna el valor del campo codigoRecurso.
	 *
	 * @return Cdigo asociado al recurso
	 */
	public int getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el valor del campo codigoRecurso.
	 *
	 * @param codigoRecurso Cdigo asociado al recurso
	 */
	public void setCodigoRecurso(int codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}
	
	/**
	 * Retorna el valor del campo gmlong.
	 *
	 * @return gmlong del recurso
	 */
	public String getGmlong() {
		return this.gmlong;
	}

	/**
	 * Establece el valor del campo gmlong.
	 *
	 * @param gmlong del recurso
	 */
	public void setGmlong(String gmlong) {
		this.gmlong = gmlong;
	}

	/**
	 * Retorna el valor del campo gmlat.
	 *
	 * @return gmlat del recurso
	 */
	public String getGmlat() {
		return this.gmlat;
	}

	/**
	 * Establece el valor del campo gmlat.
	 *
	 * @param gmlat del recurso
	 */
	public void setGmlat(String gmlat) {
		this.gmlat = gmlat;
	}
	
	
	/**
	 * @return Retorna el valor del campo templateType
	 */
	public String getTemplateType() {
		return this.templateType;
	}

	/**
	 * @param templateType Establece el valor del campo templateType
	 */
	public void setTemplateType(String templateType) {
		this.templateType = templateType;
	}

	/**
	 * @return Retorna el valor del campo fotoPrincipal
	 */
	public String getFotoPrincipal() {
		return this.fotoPrincipal;
	}

	/**
	 * @param fotoPrincipal Establece el valor del campo fotoPrincipal
	 */
	public void setFotoPrincipal(String fotoPrincipal) {
		this.fotoPrincipal = fotoPrincipal;
	}

	/**
	 * @return Retorna el valor del campo nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * @param nombre Establece el valor del campo nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return Retorna el valor del campo descripcion
	 */
	public String getDescripcion() {
		return this.descripcion;
	}

	/**
	 * @param descripcion Establece el valor del campo descripcion
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return Retorna el valor del campo idioma
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * @param idioma Establece el valor del campo idioma
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * @return Retorna el valor del campo urlAmigable
	 */
	public String getUrlAmigable() {
		return this.urlAmigable;
	}

	/**
	 * @param urlAmigable Establece el valor del campo urlAmigable
	 */
	public void setUrlAmigable(String urlAmigable) {
		this.urlAmigable = urlAmigable;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	@Override()
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("coordX", this.getGmlong());
			jObject.put("coordY", this.getGmlat());
			
			jObject.put("title", S12Utils.encodeHtmlTag(this.nombre));
			jObject.put("description", S12Utils.encodeHtmlTag(this.descripcion));
			
			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), this.templateType, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("url_picture", urlFotoPrincipal);
			}
			
			jObject.put("merkur_url", S12Utils.getURLMerkur(this.getCodigoRecurso(), this.templateType, this.getUrlAmigable(), this.getIdioma()));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}
