package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Recurso.
 *
 * Representa una Novedad
 *
 *  
 */
public class S12Ruta extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "D4";

	/** The Constant SIZE_STRINGBUFFER. */
	private final static int SIZE_STRINGBUFFER = 220;

	/** Duracin de la ruta */
	private String duracion;

	/** Transporte de la ruta */
	private String transporte;

	/** Coordenadas de la ruta (etapas) */
	private String gmruta;

	/** Perfil */
	private String idPerfil;

	/** Descripcion foto */
	private String descFoto;

	/** Importancia */
	private String importancia;
	
	/** Tipo de plantilla */
	private String tipoPlantilla;
	
	/**
	 * Constructor.
	 */
	public S12Ruta() {
	}

	/**
	 * Retorna el valor del campo duracion.
	 *
	 * @return duracion de la noticia
	 */
	public String getDuracion() {
		return this.duracion;
	}

	/**
	 * Establece el valor del campo duracion.
	 *
	 * @param duracion duracion de la noticia
	 */
	public void setDuracion(String duracion) {
		this.duracion = duracion;
	}

	/**
	 * Retorna el valor del campo transporte.
	 *
	 * @return Fecha de la transporte
	 */
	public String getTransporte() {
		return this.transporte;
	}

	/**
	 * Establece el valor del campo transporte.
	 *
	 * @param transporte transporte de la noticia.
	 */
	public void setTransporte(String transporte) {
		this.transporte = transporte;
	}


	/**
	 * Retorna el valor del campo gmruta.
	 *
	 * @return gmruta de la ruta
	 */
	public String getGmruta() {
		return this.gmruta;
	}

	/**
	 * Establece el valor del campo gmruta.
	 *
	 * @param gmruta de la ruta.
	 */
	public void setGmruta(String gmruta) {
		this.gmruta = gmruta;
	}

	/**
	 * Retorna el valor del campo idPerfil.
	 *
	 * @return perfil de la ruta
	 */
	public String getIdPerfil() {
		return this.idPerfil;
	}

	/**
	 * Establece el valor del campo idPerfil.
	 *
	 * @param idPerfil perfil de la ruta
	 */
	public void setIdPerfil(String idPerfil) {
		this.idPerfil = idPerfil;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * Retorna el valor del campo importancia.
	 *
	 * @return importancia
	 */
	public String getImportancia() {
		return this.importancia;
	}

	/**
	 * Establece el valor del campo importancia.
	 *
	 * @param importancia codigo de importancia
	 */
	public void setImportancia(String importancia) {
		this.importancia = importancia;
	}
	
	public String getTipoPlantilla() {
		return tipoPlantilla;
	}

	public void setTipoPlantilla(String tipoPlantilla) {
		this.tipoPlantilla = tipoPlantilla;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo D4.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataD4(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Ruta.TIPO_RECURSO));

		// Se establece routeType=1 para que filtre solo las rutas
		metaData.add(new R01MSearchedMetaData("routeType", R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));

		// Recogida de parmetros del mtodo
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		String tematica = request.getParameter(S12Constantes.SF_TYPE);
		if (tematica != null && !"".equals(tematica)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TYPE, R01MSearchEngineConstants.LIKE_OPERATOR, tematica));
	    } 

		String transporte = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
		if (transporte != null && !"".equals(transporte)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TRANSPORT_TYPE, R01MSearchEngineConstants.LIKE_OPERATOR, transporte));
	    }

		String duracion = request.getParameter(S12Constantes.SF_DURATION);
		if (duracion != null && !"".equals(duracion)) {
			StringBuffer strDuracion = new StringBuffer();
			if ("0001".equals(duracion)) {
				strDuracion.append("(01)");
			} else if ("0002".equals(duracion)) {
				strDuracion.append("(02,03)");
			} else if ("0003".equals(duracion)) {
				strDuracion.append("(07)");
			}
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DURATION, R01MSearchEngineConstants.IN_OPERATOR, strDuracion.toString()));
	    	
			//metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DURATION, R01MSearchEngineConstants.EQUALS_OPERATOR, duracion));
		}

		String perfil = request.getParameter(S12Constantes.SF_PERFIL);
		if (perfil != null && !"".equals(perfil)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_PROFILE, R01MSearchEngineConstants.EQUALS_OPERATOR, perfil));
	    }

		String accesibilidad = request.getParameter(S12Constantes.SF_ACCESIBILITY);
		if (accesibilidad != null) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ACCESIBILITY, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
		}

		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, "EQ", S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Crear sql d4.
	 *
	 * @param request the request
	 *
	 * @return the string
	 * @deprecated
	 */
	public static String crearSqlD4(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Ruta.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Ruta.TIPO_RECURSO);
		sql.append("' AND ");
		
		// Se establece CATEGORIA=1 para que filtre solo las rutas (descartando circuitos)
		sql.append(S12Constantes.PM_CATEGORY);
		sql.append(" = '1' AND ");

		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		//Tipo (paseos, en bici, vas verdes,...)
		String transporte = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
		if (transporte != null && !"".equals(transporte)) {
			sql.append(S12Constantes.PM_TRANSPORT_TYPE);
			sql.append(" LIKE '%");
			sql.append(transporte);
			sql.append("%' AND ");
		}

		String duration = request.getParameter(S12Constantes.SF_DURATION);
		if (duration != null && !"".equals(duration)) {
			sql.append(S12Constantes.PM_DURATION);
			sql.append(" IN ");
			sql.append("("+duration+")");
			sql.append(" AND ");
		}

		String perfil = request.getParameter(S12Constantes.SF_PROFILE);
		if (perfil != null && !"".equals(perfil)) {
			sql.append(S12Constantes.PM_PROFILE);
			sql.append(" = '");
			sql.append(perfil);
			sql.append("' AND ");
		}

		String tematica = request.getParameter(S12Constantes.SF_TYPE);
		if (tematica != null && !"".equals(tematica)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" LIKE '%");
			sql.append(tematica);
			sql.append("%' AND ");
	  	}

		String para = request.getParameter(S12Constantes.SF_PARA);
	    if (para != null) {
	    	if (S12Constantes.SRV_COUPLE.equals(para)){
		    	sql.append(S12Constantes.PM_COUPLE);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    	if (S12Constantes.SRV_CHILDREN.equals(para)){
		    	sql.append(S12Constantes.PM_CHILDREN);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    	if (S12Constantes.SRV_FRIENDS.equals(para)){
		    	sql.append(S12Constantes.PM_FRIENDS);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    }
	    
		String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	    	sql.append(" IS NOT NULL AND ");
	    }

	    
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funcin para obtener la lista de rutas.
	 *
	 * @param arrRutas arrRutas
	 * @param idioma idioma
	 * @param latitud the latitud
	 * @param longitud the longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de rutas
	 */
	public static String getRutasD4(ArrayList<String> arrRutas, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Rutas - D4");
			}
			S12Ruta[] rutasArray = portalMovilDAO.getRutas(arrRutas, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Ruta[] arrayOrdenado = (S12Ruta[])S12Utils.casarOrdenResultados(rutasArray, arrRutas, S12Ruta.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Ruta::getRutasD4: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Ruta::getRutasD4: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "FIN Generando JSON de Rutas - D4");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("importancia", this.importancia);
			jObject.put("tipoPlantilla", this.tipoPlantilla);
			jObject.put("type", S12Ruta.TIPO_RECURSO);

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Ruta.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			if (this.gmruta != null) {
				// Puntos de la ruta
				String gmRutaTmp = this.gmruta.replaceAll("\\[", "").replaceAll("\\]", "");
				String[] arrPuntos = gmRutaTmp.split(",");

				JSONArray jArrayLatLong = new JSONArray();

				String longitud = "";
				String latitud = "";
				if (arrPuntos.length > 1) {
					for (int i = 0; i < arrPuntos.length; i++) {
						if ((i % 2) == 0) {
							latitud = arrPuntos[i];
						} else {
							JSONObject jObjectLatLong = new JSONObject();
							longitud = arrPuntos[i];
							jObjectLatLong.put("coordX", longitud);
							jObjectLatLong.put("coordY", latitud);
	
							jArrayLatLong.put(jObjectLatLong);
						}
					}
					jObject.put("location", jArrayLatLong);
				}				
			} else {
				// Punto de origen de la ruta
				JSONObject jObjectLatLong = new JSONObject();
				jObjectLatLong.put("coordX", this.getGmlong());
				jObjectLatLong.put("coordY", this.getGmlat());

				jObject.put("location", jObjectLatLong);
			}

			jObject.put("url_amigable", this.getUrlAmigable());

			jObject.put("duracion", this.duracion);
			jObject.put("perfil_id", this.idPerfil);

			if (this.idPerfil != null) {
				jObject.put("perfil", S12Utils.encodeHtmlTag(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil", "d4." + this.idPerfil, this.getIdioma())));
			}

		} catch (JSONException e) {
			e.printStackTrace();
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlD4(HttpServletRequest) crearSqlD4} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlD4(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Ruta.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Ruta.TIPO_RECURSO);
		sql.append("' AND ");
		
		// Se establece CATEGORIA=1 para que filtre solo las rutas (descartando circuitos)
		sql.append(S12Constantes.PM_CATEGORY);
		sql.append(" = '1' AND ");

	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		//Tipo (paseos, en bici, vas verdes,...)
		String transporte = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
		if (transporte != null && !"".equals(transporte)) {
			sql.append(S12Constantes.PM_TRANSPORT_TYPE);
			sql.append(" = ? AND ");
			params.add(transporte);
			tiposSQL.add(Types.VARCHAR);
		}

		String duration = request.getParameter(S12Constantes.SF_DURATION);
		if (duration != null && !"".equals(duration)) {
			sql.append(S12Constantes.PM_DURATION);
			sql.append(" IN (?) AND ");
			params.add(duration);
			tiposSQL.add(Types.VARCHAR);
		}

		String perfil = request.getParameter(S12Constantes.SF_PROFILE);
		if (perfil != null && !"".equals(perfil)) {
			sql.append(S12Constantes.PM_PROFILE);
			sql.append(" = ? AND ");
			params.add(perfil);
			tiposSQL.add(Types.VARCHAR);
		}

		String tematica = request.getParameter(S12Constantes.SF_TYPE);
		if (tematica != null && !"".equals(tematica)) {
			sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+tematica+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	  	}

		String para = request.getParameter(S12Constantes.SF_PARA);
	    if (para != null) {
	    	if (S12Constantes.SRV_COUPLE.equals(para)){
		    	sql.append(S12Constantes.PM_COUPLE);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    	if (S12Constantes.SRV_CHILDREN.equals(para)){
		    	sql.append(S12Constantes.PM_CHILDREN);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    	if (S12Constantes.SRV_FRIENDS.equals(para)){
		    	sql.append(S12Constantes.PM_FRIENDS);
		    	sql.append(" IS NOT NULL AND ");
	    	}
	    }
	    
		String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	    	sql.append(" IS NOT NULL AND ");
	    }

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
