package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * Clase S12Recurso.
 *
 * Representa una restauraci�n
 *
 *  
 */
public class S12Restauracion extends S12RecursoTuristico implements JSONString {

	private final static int SIZE_STRINGBUFFER = 220;
	
	/** Valor usado en comprobaciones de paginaci�n */
	private int rowNum;
	
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "B1";

	/** Subtipo asociado al recurso B1. */
	private String subTipo;

	/** Nombre del Subtipo asociado al recurso B1. */
	private String nombreSubTipo;

	/** Tipo de Comida asociada al recurso B1. */
	private String tipoComida;

	/** Tel�fono del recurso B1 */
	private String telefono;

	/** Tel�fono del recurso B1*/
	private String desctelefono;
	
	/** Tel�fono del recurso B1 */
	private String telefono2;

	/** Tel�fono del recurso B1 */
	private String desctelefono2;
	
	/** Servicios del recurso */
	private ArrayList<String> arrServicios;

	/** Municipio del recurso */
	private String municipio;
	
	/** Codigo Municipio del recurso */
	private String municipioCode;

	/** Localidad del recurso */
	private String localidad;
	
	/** Codigo Localidad del recurso */
	private String localidadCode;

	/** Soles Repsol */
	private String repsol;
	
	/** Estrellas Michelin */
	private String michelin;

	/** C�digo de Importancia */
	private String importancia;
	
	
	/** Posici�n en el array de servicios */
//	private final static int SRV_REPSOL = 0;
//	private final static int SRV_MICHELIN = 1;
	private final static int SRV_QCALIDAD = 0;
	private final static int SRV_BUENASPRACTICAS = 1;
	private final static int SRV_ACCESIBILIDAD = 2;
	private final static int SRV_CLUBPRODUCTO = 3;
	private final static int SRV_50BEST = 4;
	private final static int SRV_QORO = 5;
	private final static int SRV_QPLATA = 6;
	private final static int SRV_ISO = 7;
	/** ECOLABEL */	
	private final static int SRV_ECOLABEL = 8;
	/** INNOVACION */	
	private final static int SRV_INNOVACION = 9;
	
	/**
	 * Constructor.
	 */
	public S12Restauracion() {
	}

	/**
	 * Obtiene el campo rowNum
	 *
	 * @return rowNum
	 */
	public int getRowNum() {
		return rowNum;
	}

	/**
	 * Establece el campo rowNum
	 * 
	 * @param rowNum rowNum
	 */
	public void setRowNum(int rowNum) {
		this.rowNum = rowNum;
	}

	/**
	 * @return Retorna el valor del campo subTipo.
	 */
	public String getSubTipo() {
		return this.subTipo;
	}

	/**
	 * @param subTipo Establece el valor del campo subTipo.
	 */
	public void setSubTipo(String subTipo) {
		this.subTipo = subTipo;
	}

	/**
	 * @return Retorna el valor del campo nombreSubTipo.
	 */
	public String getNombreSubTipo() {
		return this.nombreSubTipo;
	}

	/**
	 * @param nombreSubTipo Establece el valor del campo nombreSubTipo.
	 */
	public void setNombreSubTipo(String nombreSubTipo) {
		this.nombreSubTipo = nombreSubTipo;
	}

	/**
	 * @return Retorna el valor del campo Tipo Comida.
	 */
	public String getTipoComida() {
		return this.tipoComida;
	}

	/**
	 * @param tipoComida Establece el valor del campo Tipo Comida.
	 */
	public void setTipoComida(String tipoComida) {
		this.tipoComida = tipoComida;
	}

	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * @param desctelefono Establece el valor del campo descripcion telefono.
	 */
	public void setDescTelefono(String desctelefono) {
		this.desctelefono = desctelefono;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono.
	 */
	public String getDescTelefono() {
		return this.desctelefono;
	}

	/**
	 * @param telefono Establece el valor del campo telefono2.
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}

	/**
	 * @return Retorna el valor del campo telefono2.
	 */
	public String getTelefono2() {
		return this.telefono2;
	}

	/**
	 * @param desctelefono2 Establece el valor del campo descripcion telefono2.
	 */
	public void setDescTelefono2(String desctelefono2) {
		this.desctelefono2 = desctelefono2;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono2.
	 */
	public String getDescTelefono2() {
		return this.desctelefono2;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return Retorna el valor del campo localidad.
	 */
	public String getLocalidad() {
		return this.localidad;
	}

	/**
	 * @param localidad Establece el valor del campo localidad.
	 */
	public void setLocalidad(String localidad) {
		this.localidad = localidad;
	}
	
	/**
	 * @return Retorna el valor del campo localidadCode.
	 */
	public String getLocalidadCode() {
		return this.localidadCode;
	}

	/**
	 * @param localidadCode Establece el valor del campo localidadCode.
	 */
	public void setLocalidadCode(String localidadCode) {
		this.localidadCode = localidadCode;
	}

	/**
	 * Obtiene el campo repsol
	 *
	 * @return repsol
	 */
	public String getRepsol() {
		return repsol;
	}

	/**
	 * Establece el campo repsol
	 * 
	 * @param repsol repsol
	 */
	public void setRepsol(String repsol) {
		this.repsol = repsol;
	}

	/**
	 * Obtiene el campo michelin
	 *
	 * @return michelin
	 */
	public String getMichelin() {
		return michelin;
	}

	/**
	 * Establece el campo michelin
	 * 
	 * @param michelin michelin
	 */
	public void setMichelin(String michelin) {
		this.michelin = michelin;
	}

	/**
	 * Obtiene el campo importancia
	 *
	 * @return importancia
	 */
	public String getImportancia() {
		return importancia;
	}

	/**
	 * Establece el campo importancia
	 * 
	 * @param importancia importancia
	 */
	public void setImportancia(String importancia) {
		this.importancia = importancia;
	}

	/**
	 * Retorna el valor del campo arrServicios.
	 *
	 * @return arrServicios del recurso
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * Establece el valor del campo arrServicios.
	 *
	 * @param arrServicios del recurso.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}

	/**
	 * Funci�n que crea los metadatos para recursos de tipo B1.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataB1(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		String restorationType = request.getParameter(S12Constantes.SF_RESTORATION_TYPE);
		// Comprobamos si es 0002(Zona de Pintxos)
		if (S12Constantes.PINTXOS.equals(restorationType)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12ZonasBaresPintxos.TIPO_RECURSO));
			// Se establece el filtro para las Zonas de Pintxos
 	 		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_FUN_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, restorationType));

		} else if (S12Constantes.BARES_PINTXOS.equals(restorationType)) { // Comprobamos si es 0004 (Bares de Pintxos)
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Tiendas.TIPO_RECURSO));
			// Se establece el filtro para los Bares de Pintxos
 	 		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SECTOR_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, restorationType));

		} else {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Restauracion.TIPO_RECURSO));
			
			if (restorationType != null && !"".equals(restorationType)) {
				String tipoRestauracion = "(" + restorationType + ")";
		    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_RESTORATION_TYPE, R01MSearchEngineConstants.IN_OPERATOR, tipoRestauracion));
		  	} else {
		  		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_RESTORATION_TYPE, R01MSearchEngineConstants.IN_OPERATOR, "(1,42,4,41,3)"));
		  	}
		}

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, nombre));
	    }

	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY,R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }


	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); //ESTO HAY QUE MIRARLO
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE,R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }

	    String zona = request.getParameter(S12Constantes.SF_MARKS);
			if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
		if (accesible != null) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ACCESIBILITY, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
		}

		String recomendado = request.getParameter(S12Constantes.SF_RECOMENDED);
		if (recomendado != null) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_RECOMENDED, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
		}

		String qualityQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
		if (qualityQ != null) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_Q, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
		}

	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_ASSURANCE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String visitasGuiadas = request.getParameter(S12Constantes.SF_VISIT);
	    if (visitasGuiadas != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_VISIT, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String restaurant = request.getParameter(S12Constantes.SF_RESTAURANTE);
	    if (restaurant != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_RESTAURANTE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_CLUB_PRODUCTO, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }

	    // Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funci�n que crea la sql de consulta para recursos de tipo B1.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlB1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Restauracion.SIZE_STRINGBUFFER);
		
		String restorationType = request.getParameter(S12Constantes.SF_RESTORATION_TYPE);
		// Comprobamos si es 0002(Zona de Pintxos)
		if (S12Constantes.PINTXOS.equals(restorationType)) {
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12ZonasBaresPintxos.TIPO_RECURSO);
			sql.append("' AND ");

			// Se establece el filtro para las Zonas de Pintxos
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = '");
			sql.append(restorationType);
			sql.append("' AND ");
		} else if (S12Constantes.BARES_PINTXOS.equals(restorationType)) { // Comprobamos si es 0004 (Bares de Pintxos)
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12Tiendas.TIPO_RECURSO);
			sql.append("' AND ");

			// Se establece el filtro para los Bares de Pintxos
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = '");
			sql.append(restorationType);
			sql.append("' AND ");
		} else {
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12Restauracion.TIPO_RECURSO);
			sql.append("' AND ");

			if (restorationType != null && !"".equals(restorationType)) {
				String[] arrRestauranteTipo = restorationType.split(",");

		    	sql.append(S12Constantes.PM_TYPE);
		  		sql.append(" IN (");

		  		for (int i = 0; i < arrRestauranteTipo.length; i++) {
		  			if (i != 0) {
		  				sql.append(",");
		  			}
		  			sql.append("'");
		  			sql.append(arrRestauranteTipo[i]);
		  			sql.append("'");
		  		}

		  		sql.append(") AND ");
			} else {
		  		sql.append(S12Constantes.PM_TYPE);
		  		sql.append(" IN ('1','42','4','41','3') AND ");
		  	}
		}

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	sql.append("UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
	  		sql.append(")");
	  		sql.append(" LIKE '%");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		sql.append(nombre.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE '%");
	  		sql.append(zona);
	  		sql.append("%' AND ");
		}

		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
	    if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
	  	}

	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	  		sql.append(" IS NOT NULL AND ");
	    }
	
	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String recomendado = request.getParameter(S12Constantes.SF_RECOMENDED);
	    if (recomendado != null) {
	    	sql.append(S12Constantes.PM_RECOMENDED);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String visit = request.getParameter(S12Constantes.SF_VISIT);
	    if ( visit != null) {
	    	sql.append(S12Constantes.PM_VISIT);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String restaurant = request.getParameter(S12Constantes.SF_RESTAURANTE);
	    if ( restaurant != null) {
	    	sql.append(S12Constantes.PM_RESTAURANT);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String repsol = request.getParameter(S12Constantes.SF_REPSOL_SUN);
	    if (repsol != null) {
	    	sql.append(S12Constantes.PM_REPSOL_SUN);
	  		sql.append(" >'0' AND ");
	    }

	    String michelin = request.getParameter(S12Constantes.SF_MICHELIN);
	    if (michelin != null) {
	    	sql.append(S12Constantes.PM_MICHELIN);
	  		sql.append(" >'0' AND ");
	    }
	    
	    
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    if (michelin == null && repsol == null){
		    sql.append(S12Constantes.PM_IMPORTANCE);
		    sql.append(" ASC, ");
	    }
	    if (michelin!=null){
	    	sql.append(S12Constantes.PM_MICHELIN);
		    sql.append(" DESC, ");
	    }
	    if (repsol!=null){
	    	sql.append(S12Constantes.PM_REPSOL_SUN);
		    sql.append(" DESC, ");
	    }
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");
		return sql.toString();
	}


	/**
	 * Funci�n para obtener la lista de recursos de restauraci�n.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de restauraci�n
	 */
	public static String getRestauracionB1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado, double distanciaMax) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Restauraci�n - B1");
			}
			S12Restauracion[] restauracionArray = portalMovilDAO.getRestauracion(arrRecursos, idioma, latitud, longitud, numero_resultados, ultimo_resultado, distanciaMax);
			//corregimos el ORDER en base a la paginaci�n.
			S12Restauracion[] arrayOrdenado = (S12Restauracion[])S12Utils.casarOrdenResultados(restauracionArray, arrRecursos, S12Restauracion.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Restauracion::getRestauracionB1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12Restauracion::getRestauracionB1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Restauraci�n - B1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementaci�n de la serializaci�n JSON del objeto
	 *
	 * @return Serializaci�n JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12Restauracion.TIPO_RECURSO);
			
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Restauracion.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.getDescFoto()));
			}

			jObject.put("restorationType_id", this.subTipo);
			jObject.put("restorationType", S12Utils.encodeHtmlTag(this.nombreSubTipo));
			jObject.put("tipoComida", S12Utils.encodeHtmlTag(this.tipoComida));
			jObject.put("phone_number", this.telefono);
			jObject.put("phone_desc",  S12Utils.encodeHtmlTag(this.desctelefono));	
			jObject.put("phone_number_2", this.telefono2);
			jObject.put("phone_desc_2",  S12Utils.encodeHtmlTag(this.desctelefono2));
			
			//servicios
			jObject.put("accesibility", this.arrServicios.get(S12Restauracion.SRV_ACCESIBILIDAD).toString());
			jObject.put("qualityQ", this.arrServicios.get(S12Restauracion.SRV_QCALIDAD).toString());
			jObject.put("qualityAssurance", this.arrServicios.get(S12Restauracion.SRV_BUENASPRACTICAS).toString());
			jObject.put("productClub", this.arrServicios.get(S12Restauracion.SRV_CLUBPRODUCTO).toString());
			jObject.put("best50", this.arrServicios.get(S12Restauracion.SRV_50BEST).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12Restauracion.SRV_QORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12Restauracion.SRV_QPLATA).toString());
			jObject.put("ISO", this.arrServicios.get(S12Restauracion.SRV_ISO).toString());
			jObject.put("ECOLABEL", this.arrServicios.get(S12Restauracion.SRV_ECOLABEL).toString());
			jObject.put("innovation", this.arrServicios.get(S12Restauracion.SRV_INNOVACION).toString());

			//Soles Repsol y Estrellas Michelin (antes eran servicios)
			jObject.put("michelin", this.michelin);
			jObject.put("repsol", this.repsol);

			jObject.put("importance", this.getImportancia());
			
		} catch (JSONException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Restauracion::toJSONString: Exception: " + e.getMessage());
			}
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlB1(HttpServletRequest) crearSqlB1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlB1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
	
		StringBuffer sql = new StringBuffer(S12Restauracion.SIZE_STRINGBUFFER);
		
		String restorationType = request.getParameter(S12Constantes.SF_RESTORATION_TYPE);
		// Comprobamos si es 0002(Zona de Pintxos)
		if (S12Constantes.PINTXOS.equals(restorationType)) {
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12ZonasBaresPintxos.TIPO_RECURSO);
			sql.append("' AND ");

			// Se establece el filtro para las Zonas de Pintxos
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(restorationType);
			tiposSQL.add(Types.VARCHAR);
		} else if (S12Constantes.BARES_PINTXOS.equals(restorationType)) { // Comprobamos si es 0004 (Bares de Pintxos)
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12Tiendas.TIPO_RECURSO);
			sql.append("' AND ");

			// Se establece el filtro para los Bares de Pintxos
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(restorationType);
			tiposSQL.add(Types.VARCHAR);
		} else {
			sql.append(S12Constantes.PM_TEMPLATE_TYPE);
			sql.append(" = '");
			sql.append(S12Restauracion.TIPO_RECURSO);
			sql.append("' AND ");

			if (restorationType != null && !"".equals(restorationType)) {
				String[] arrRestauranteTipo = restorationType.split(",");

		    	sql.append(S12Constantes.PM_TYPE);
		  		sql.append(" IN (");

		  		for (int i = 0; i < arrRestauranteTipo.length; i++) {
		  			if (i != 0) {
		  				sql.append(",");
		  			}
		  			sql.append("?");
		  			params.add(arrRestauranteTipo[i]);
		  			tiposSQL.add(Types.VARCHAR);
		  		}

		  		sql.append(") AND ");
			} else {
		  		sql.append(S12Constantes.PM_TYPE);
		  		sql.append(" IN ('1','42','4','41','3') AND ");
		  	}
		}

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
	  		sql.append(")");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		nombre = nombre.toUpperCase(new Locale("es", "es"));
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+nombre+"%";
	  		params.add(expresionLIKE);
	  		tiposSQL.add(Types.VARCHAR);
	    }
		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
	    if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
	  	}

	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	  		sql.append(" IS NOT NULL AND ");
	    }
	
	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String recomendado = request.getParameter(S12Constantes.SF_RECOMENDED);
	    if (recomendado != null) {
	    	sql.append(S12Constantes.PM_RECOMENDED);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String visit = request.getParameter(S12Constantes.SF_VISIT);
	    if ( visit != null) {
	    	sql.append(S12Constantes.PM_VISIT);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String restaurant = request.getParameter(S12Constantes.SF_RESTAURANTE);
	    if ( restaurant != null) {
	    	sql.append(S12Constantes.PM_RESTAURANT);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String repsol = request.getParameter(S12Constantes.SF_REPSOL_SUN);
	    if (repsol != null) {
	    	sql.append(S12Constantes.PM_REPSOL_SUN);
	  		sql.append(" >'0' AND ");
	    }

	    String michelin = request.getParameter(S12Constantes.SF_MICHELIN);
	    if (michelin != null) {
	    	sql.append(S12Constantes.PM_MICHELIN);
	  		sql.append(" >'0' AND ");
	    }
	    
	    
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    if (michelin == null && repsol == null){
		    sql.append(S12Constantes.PM_IMPORTANCE);
		    sql.append(" ASC, ");
	    }
	    if (michelin!=null){
	    	sql.append(S12Constantes.PM_MICHELIN);
		    sql.append(" DESC, ");
	    }
	    if (repsol!=null){
	    	sql.append(S12Constantes.PM_REPSOL_SUN);
		    sql.append(" DESC, ");
	    }
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");
		return sql.toString();
	}

}
