package s12.portalMovil.valueObjects;

/**
 * Clase S12RecursoTuristico.
 *
 * Representa un Recurso Turistico
 *
 *  
 */
public class S12RecursoTuristico {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	public static final String COMPONENTE = "PORTAL_MOVIL";

	/**	Cdigo asociado al recurso */
	private int codigoRecurso;

	/**	Ruta de la imagen principal del recurso */
	private String fotoPrincipal;

	/** Descripcion foto */
	private String descFoto;
	
	/** Nombre del recurso */
	private String nombre;

	/** Longitud del recurso */
	private String gmlong;

	/** Latitud del recurso */
	private String gmlat;

	/** Idioma del recurso */
	private String idioma;

	/** Distancia del recurso */
	private String distancia;

	/** URL amigable */
	private String urlAmigable;
	/** subtipo Padre **/
	private String subtipoPadre;
	/**
	 * Constructor.
	 */
	public S12RecursoTuristico() {
	}

	/**
	 * Retorna el valor del campo codigoRecurso.
	 *
	 * @return Cdigo asociado al recurso
	 */
	public int getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el valor del campo codigoRecurso.
	 *
	 * @param codigoRecurso Cdigo asociado al recurso
	 */
	public void setCodigoRecurso(int codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * Retorna el valor del campo fotoPrincipal.
	 *
	 * @return Ruta de la imagen principal del recurso
	 */
	public String getFotoPrincipal() {
		return this.fotoPrincipal;
	}

	/**
	 * Establece el valor del campo fotoPrincipal.
	 *
	 * @param fotoPrincipal Ruta de la imagen principal del recurso
	 */
	public void setFotoPrincipal(String fotoPrincipal) {
		this.fotoPrincipal = fotoPrincipal;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}
	
	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}
	
	/**
	 * Retorna el valor del campo idioma.
	 *
	 * @return Idioma del recurso
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * Establece el valor del campo idioma.
	 *
	 * @param idioma Idioma del recurso
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * Retorna el valor del campo nombre.
	 *
	 * @return nombre del recurso
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el valor del campo nombre.
	 *
	 * @param nombre del recurso
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Retorna el valor del campo gmlong.
	 *
	 * @return gmlong del recurso
	 */
	public String getGmlong() {
		return this.gmlong;
	}

	/**
	 * Establece el valor del campo gmlong.
	 *
	 * @param gmlong del recurso
	 */
	public void setGmlong(String gmlong) {
		this.gmlong = gmlong;
	}

	/**
	 * Retorna el valor del campo gmlat.
	 *
	 * @return gmlat del recurso
	 */
	public String getGmlat() {
		return this.gmlat;
	}

	/**
	 * Establece el valor del campo gmlat.
	 *
	 * @param gmlat del recurso
	 */
	public void setGmlat(String gmlat) {
		this.gmlat = gmlat;
	}

	/**
	 * Retorna el valor del campo distancia.
	 *
	 * @return distancia del recurso
	 */
	public String getDistancia() {
		return this.distancia;
	}

	/**
	 * Establece el valor del campo distancia.
	 *
	 * @param distancia del recurso
	 */
	public void setDistancia(String distancia) {
		this.distancia = distancia;
	}

	/**
	 * @return Retorna el valor del campo urlAmigable.
	 */
	public String getUrlAmigable() {
		return this.urlAmigable;
	}

	/**
	 * @param urlAmigable Establece el valor del campo urlAmigable.
	 */
	public void setUrlAmigable(String urlAmigable) {
		this.urlAmigable = urlAmigable;
	}
	/**
	 * @return Retorna el valor del campo subtipo Padre.
	 */
	public String getSubTipoPadre() {
		return this.subtipoPadre;
	}

	/**
	 * @param subtipoPadre Establece el valor del campo subtipoPadre.
	 */
	public void setSubTipoPadre(String subtipoPadre) {
		this.subtipoPadre = subtipoPadre;
	}
	
	

}
