/*
 * Created on 20/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;


/**
 * The Class S12ProgramasExperienciales.
 *  
 */
public class S12ProgramasExperienciales implements JSONString {

	private String titulo;
	private ArrayList<S12DiasProgrExperienciales> dias;
	private ArrayList<S12EnlacesCapital> enlaces;
	private ArrayList<S12MasInformacion> masInformacion;


	/**
	 * @return Retorna el valor del campo titulo.
	 */
	public String getTitulo() {
		return this.titulo;
	}

	/**
	 * @param titulo Establece el valor del campo titulo.
	 */
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	/**
	 * @return Retorna el valor del campo dias.
	 */
	public ArrayList<S12DiasProgrExperienciales> getDias() {
		return this.dias;
	}

	/**
	 * @param dias Establece el valor del campo dias.
	 */
	public void setDias(ArrayList<S12DiasProgrExperienciales> dias) {
		this.dias = dias;
	}

	/**
	 * @return Retorna el valor del campo enlaces.
	 */
	public ArrayList<S12EnlacesCapital> getEnlaces() {
		return this.enlaces;
	}

	/**
	 * @param enlaces Establece el valor del campo enlaces.
	 */
	public void setEnlaces(ArrayList<S12EnlacesCapital> enlaces) {
		this.enlaces = enlaces;
	}

	/**
	 * @return Retorna el valor del campo masInformacion.
	 */
	public ArrayList<S12MasInformacion> getMasInformacion() {
		return this.masInformacion;
	}

	/**
	 * @param masInformacion Establece el valor del campo masInformacion.
	 */
	public void setMasInformacion(ArrayList<S12MasInformacion> masInformacion) {
		this.masInformacion = masInformacion;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("title", S12Utils.encodeHtmlTag(this.getTitulo()));

			jObject.put("dias", new JSONArray(this.getDias()));

			jObject.put("mas_informacion", new JSONArray(this.getMasInformacion()));

			jObject.put("enlaces", new JSONArray(this.getEnlaces()));

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}