package s12.portalMovil.valueObjects;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 * Clase S12Poi.
 *
 * Representa un POI (punto de interes) a pintar en un mapa
 *
 *  
 */
public class S12Poi extends S12RecursoTuristico implements JSONString {
	/** Tipo de recurso */
	private String tipoRecurso;
	
	/** Template type */
	private String templateType;

	/**
	 * Constructor.
	 */
	public S12Poi() {
	}

	/**
	 * @return Retorna el valor del campo tipoRecurso.
	 */
	public String getTipoRecurso() {
		return this.tipoRecurso;
	}

	/**
	 * @param tipoRecurso Establece el valor del campo tipoRecurso.
	 */
	public void setTipoRecurso(String tipoRecurso) {
		this.tipoRecurso = tipoRecurso;
	}
	
	/**
	 * @return Retorna el valor del campo templateType
	 */
	public String getTemplateType() {
		return this.templateType;
	}

	/**
	 * @param templateType Establece el valor del campo templateType
	 */
	public void setTemplateType(String templateType) {
		this.templateType = templateType;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("id", this.getCodigoRecurso());
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", this.tipoRecurso);
			
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), this.templateType, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
			}

			jObject.put("longitude", this.getGmlong());
			jObject.put("latitude", this.getGmlat());

			jObject.put("merkur_url", S12Utils.getURLMerkur(this.getCodigoRecurso(), this.templateType, this.getUrlAmigable(), this.getIdioma()));

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}
}
