package s12.portalMovil.valueObjects;

import java.util.ArrayList;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 * Clase S12Playground.
 *
 * Representa un Playground
 *
 *  
 */
public class S12Playground implements JSONString {

	/** Coordenadas del playground */
	private double[][] coordenadas;

	private ArrayList<S12Poi> pois = new ArrayList<S12Poi>();

	/**
	 * Constructor
	 */
	public S12Playground() {

	}

	/**
	 * @return Retorna el valor del campo coordenadas.
	 */
	public double[][] getCoordenadas() {
		return this.coordenadas;
	}

	/**
	 * @param coordenadas Establece el valor del campo coordenadas.
	 */
	public void setCoordenadas(double[][] coordenadas) {
		this.coordenadas = coordenadas;
	}

	/**
	 * @return Retorna el valor del campo pois.
	 */
	public ArrayList<S12Poi> getPois() {
		return this.pois;
	}

	/**
	 * @param pois Establece el valor del campo pois.
	 */
	public void setPois(ArrayList<S12Poi> pois) {
		this.pois = pois;
	}

	/**
	 * Almacena en el campo pois del playground aquellos pois que estn contenidos en l.
	 *
	 * @param pois lista de pois. Objetos S12Pois
	 */
	public void setPoisInPlayground(ArrayList<S12Poi> pois) {
		ArrayList<S12Poi> poisPlayground = new ArrayList<S12Poi>();

		Iterator<S12Poi> it = pois.iterator();
		while(it.hasNext()) {
			S12Poi poi = it.next();
			if (poi.getGmlat() != null && poi.getGmlong() != null &&
					S12Utils.contienePunto(this.getCoordenadas(), Double.parseDouble(poi.getGmlat()), Double.parseDouble(poi.getGmlong()))) {
				poisPlayground.add(poi);
			}
		}

		this.pois = poisPlayground;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			JSONArray jArrayLatLong = new JSONArray();

			double longitud = 0;
			double latitud = 0;
			for (int i = 0; i < this.coordenadas.length; i++) {
				latitud = this.coordenadas[i][0];
				longitud = this.coordenadas[i][1];

				JSONObject jObjectLatLong = new JSONObject();

				jObjectLatLong.put("latitude", latitud);
				jObjectLatLong.put("longitude", longitud);

				jArrayLatLong.put(jObjectLatLong);
			}
			jObject.put("zona", jArrayLatLong);

			jObject.put("pois", this.pois);
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}
