package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12PlatosTipicos.
 *
 * Representa un Platos Tpicos
 *
 *  
 */
public class S12PlatosTipicos extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "J1";
	
	/** Id Zona asociado al recurso J1. */
	private String idZona;

	/** Nombre de la Zona asociado al recurso J1. */
	private String nombreZona;

	/** Descripcion foto */
	private String descFoto;
	
	/**
	 * Constructor.
	 */
	public S12PlatosTipicos() {
	}
	
	/**
	 * @return Retorna el valor del campo idZona.
	 */
	public String getIdZona() {
		return this.idZona;
	}

	/**
	 * @param idZona Establece el valor del campo idZona.
	 */
	public void setIdZona(String idZona) {
		this.idZona = idZona;
	}

	/**
	 * @return Retorna el valor del campo nombreZona.
	 */
	public String getNombreZona() {
		return this.nombreZona;
	}

	/**
	 * @param nombreZona Establece el valor del campo nombreZona.
	 */
	public void setNombreZona(String nombreZona) {
		this.nombreZona = nombreZona;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo J1.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataJ1(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12PlatosTipicos.TIPO_RECURSO));

		// Filtramos los recursos locales
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));

		return metaData;
	}

	/**
	 * Funcin que crea la sql de consulta para recursos de tipo J1.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlJ1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer();

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12PlatosTipicos.TIPO_RECURSO);
		sql.append("' AND ");

		String gastronomyType = request.getParameter(S12Constantes.SF_GASTRONOMY_TYPE);
		if (gastronomyType != null && !"".equals(gastronomyType)) {
			sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" = '");
	  		sql.append(gastronomyType);
	  		sql.append("' AND ");
		}
		
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funcin para obtener la lista de recursos de Platos Tpicos.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de Platos Tpicos
	 */
	public static String getPlatosTipicosJ1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Platos Tpicos - J1");
			}
			S12PlatosTipicos[] platosTipicosArray = portalMovilDAO.getPlatosTipicos(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12PlatosTipicos[] arrayOrdenado = (S12PlatosTipicos[])S12Utils.casarOrdenResultados(platosTipicosArray, arrRecursos, S12PlatosTipicos.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12PlatosTipicos::getPlatosTipicosJ1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12PlatosTipicos::getPlatosTipicosJ1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Platos Tpicos - J1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12PlatosTipicos.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

//			jObject.put("merkur_url", S12Utils.getURLMerkur(this.getCodigoRecurso(), S12PlatosTipicos.TIPO_RECURSO, this.getUrlAmigable(), this.getIdioma()));
			jObject.put("url_amigable", this.getUrlAmigable());

			jObject.put("zona_id", this.getIdZona());
			jObject.put("zona", S12Utils.encodeHtmlTag(this.getNombreZona()));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlJ1(HttpServletRequest) crearSqlJ1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlJ1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer();

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12PlatosTipicos.TIPO_RECURSO);
		sql.append("' AND ");

		String gastronomyType = request.getParameter(S12Constantes.SF_GASTRONOMY_TYPE);
		if (gastronomyType != null && !"".equals(gastronomyType)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(gastronomyType);
			tiposSQL.add(Types.VARCHAR);
		}
		
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
