package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12OficinasTurismo.
 *
 * Representa una Oficina de Turismo
 *
 *  
 */
public class S12OficinasTurismo extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "E1";

	private final static int SIZE_STRINGBUFFER = 220;

	/** Subtipo asociado al recurso E1. */
	private String subTipo;
	
	/** Categor�a de la oficina de turismo */
	private String categoria;
	/** Tel�fono de la oficina de turismo */
	private String telefono;
	/** Descripci�n Tel�fono de la oficina de turismo */
	private String desctelefono;
	/** Tel�fono 2 de la oficina de turismo */
	private String telefono2;
	/** Descripci�n Tel�fono 2 de la oficina de turismo */
	private String desctelefono2;

	/** Nombre de la provincia */
	private String provincia;
	
	/** C�digo de la provincia  */
	private String provinciaCode;
	
	/** Municipio de la oficina de turismo */
	private String municipio;
	
	private String municipioCode;

	/** Localidad de la oficina de turismo */
	private String localidad;
	
	private String localidadCode;

	/** Descripcion foto */
	private String descFoto;
	
	/** Servicios de la oficina de turismo */
	private ArrayList<String> arrServicios;
	
	/** Direcci�n de la oficina de turismo */
	private String direccion;
	
	/** Email de la oficina de turismo */
	private String email;
	
	/** Web de la oficina de turismo */
	private String web;
	
	/** C�digo Postal de la oficina de turismo */
	private String codigoPostal;
	
	/** Posici�n en el array de servicios */
	private final static int SRV_QCALIDAD = 0;
	private final static int SRV_BUENASPRACTICAS = 1;
	private final static int SRV_ACCESIBILIDAD = 2;
	private final static int SRV_CLUBPRODUCTO = 3;
	private final static int SRV_SURFING = 4;
	private final static int SRV_QORO = 5;
	private final static int SRV_QPLATA = 6;
	private final static int SRV_ISO = 7;
	/** ECOLABEL */	
	private final static int SRV_ECOLABEL = 8;
	/** INNOVACION */	
	private final static int SRV_INNOVACION = 9;
	

	/**
	 * Constructor.
	 */
	public S12OficinasTurismo() {
	}


	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}
	/**
	 * @param desctelefono Establece el valor del campo telefono.
	 */
	public void setDescTelefono(String desctelefono) {
		this.desctelefono = desctelefono;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getDescTelefono() {
		return this.desctelefono;
	}
	/**
	 * @param telefono2 Establece el valor del campo telefono.
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono2() {
		return this.telefono2;
	}
	/**
	 * @param desctelefono2 Establece el valor del campo telefono.
	 */
	public void setDescTelefono2(String desctelefono2) {
		this.desctelefono2 = desctelefono2;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getDescTelefono2() {
		return this.desctelefono2;
	}


	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}
	
	/**
	 * Obtiene el campo municipioCode
	 *
	 * @return municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}


	/**
	 * Establece el campo municipioCode
	 * 
	 * @param municipioCode municipioCode
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}


	/**
	 * Obtiene el campo localidad
	 *
	 * @return localidad
	 */
	public String getLocalidad() {
		return localidad;
	}


	/**
	 * Establece el campo localidad
	 * 
	 * @param localidad localidad
	 */
	public void setLocalidad(String localidad) {
		this.localidad = localidad;
	}


	/**
	 * Obtiene el campo localidadCode
	 *
	 * @return localidadCode
	 */
	public String getLocalidadCode() {
		return localidadCode;
	}


	/**
	 * Establece el campo localidadCode
	 * 
	 * @param localidadCode localidadCode
	 */
	public void setLocalidadCode(String localidadCode) {
		this.localidadCode = localidadCode;
	}


	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * @return Retorna el valor del campo arrServicios.
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * @param arrServicios Establece el valor del campo arrServicios.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}

	/**
	 * @return the subTipo
	 */
	public String getSubTipo() {
		return subTipo;
	}


	/**
	 * @param subTipo the subTipo to set
	 */
	public void setSubTipo(String subTipo) {
		this.subTipo = subTipo;
	}


	/**
	 * @return the categoria
	 */
	public String getCategoria() {
		return categoria;
	}


	/**
	 * @param categoria the categoria to set
	 */
	public void setCategoria(String categoria) {
		this.categoria = categoria;
	}

	
	/**
	 * Obtiene el campo direccion
	 *
	 * @return direccion
	 */
	public String getDireccion() {
		return direccion;
	}


	/**
	 * Establece el campo direccion
	 * 
	 * @param direccion direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}


	/**
	 * Obtiene el campo email
	 *
	 * @return email
	 */
	public String getEmail() {
		return email;
	}


	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}


	/**
	 * Obtiene el campo web
	 *
	 * @return web
	 */
	public String getWeb() {
		return web;
	}


	/**
	 * Establece el campo web
	 * 
	 * @param web web
	 */
	public void setWeb(String web) {
		this.web = web;
	}


	/**
	 * Obtiene el campo codigoPostal
	 *
	 * @return codigoPostal
	 */
	public String getCodigoPostal() {
		return codigoPostal;
	}


	/**
	 * Establece el campo codigoPostal
	 * 
	 * @param codigoPostal codigoPostal
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}


	public String getProvincia() {
		return provincia;
	}


	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}


	public String getProvinciaCode() {
		return provinciaCode;
	}


	public void setProvinciaCode(String provinciaCode) {
		this.provinciaCode = provinciaCode;
	}


	/**
	 * Funci�n que crea los metadatos para recursos de tipo E1.
	 *
	 * @param request the request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataE1(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12OficinasTurismo.TIPO_RECURSO));

		// Recogida de par�metros del m�todo
		String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, tipo));
	    }

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ACCESIBILITY, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }

	    String visitasGuiadas = request.getParameter(S12Constantes.SF_VISIT);
	    if (visitasGuiadas != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_VISIT, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    String surfing = request.getParameter(S12Constantes.SF_SURFING);
	    if (surfing != null && !"0".equals(surfing)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SURFING, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }
	
	    return metaData;
	}

	/**
	 * Crear sql e1.
	 *
	 * @param request the request
	 *
	 * @return the string
	 * @deprecated
	 */
	public static String crearSqlE1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12OficinasTurismo.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12OficinasTurismo.TIPO_RECURSO);
		sql.append("' AND ");

		String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			String[] arrOficinaTipo = tipo.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrOficinaTipo.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("'");
	  			sql.append(arrOficinaTipo[i]);
	  			sql.append("'");
	  		}

	  		sql.append(") AND ");
		}

		String municipio = request.getParameter(S12Constantes.SF_MUNICIPALITY);
		if (municipio != null && !"".equals(municipio)) {
			sql.append(S12Constantes.PM_MUNICIPALITY);
			sql.append(" LIKE '%");
			sql.append(S12Utils.utf8toIso88591(municipio));
			sql.append("%' AND ");
		}
		
		String municipioCod = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE);
		if (municipioCod != null && !"".equals(municipioCod)) {
			sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
			sql.append(" LIKE '%");
			sql.append(municipioCod);
			sql.append("%' AND ");
		}

	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
		String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
		if (accesible != null) {
			sql.append(S12Constantes.PM_ACCESIBILITY);
			sql.append(" IS NOT NULL AND ");
		}
		String surfing = request.getParameter(S12Constantes.SF_SURFING);
		if (surfing != null  && !"0".equals(surfing)) {
			sql.append(S12Constantes.PM_SURFING);
			sql.append(" IS NOT NULL AND ");
		}
		String visitas = request.getParameter(S12Constantes.SF_VISIT);
		if (visitas != null) {
			sql.append(S12Constantes.PM_VISIT);
			sql.append(" IS NOT NULL AND ");
		}
		
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE '%");
	  		sql.append(zona);
	  		sql.append("%' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

	    return sql.toString();
	}

	/**
	 * Funci�n para obtener la lista de recursos de oficinas de turismo.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de oficinas de turismo
	 */
	public static String getOficinasE1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Oficinas de Turismo - E1");
			}
			S12OficinasTurismo[] oficinasArray = portalMovilDAO.getOficinasTurismo(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginaci�n.
			S12OficinasTurismo[] arrayOrdenado = (S12OficinasTurismo[])S12Utils.casarOrdenResultados(oficinasArray, arrRecursos, S12OficinasTurismo.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12OficinasTurismo::getOficinasE1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12OficinasTurismo::getOficinasE1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Oficinas de Turismo - E1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementaci�n de la serializaci�n JSON del objeto
	 *
	 * @return Serializaci�n JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12OficinasTurismo.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			jObject.put("phone_number", this.telefono);
			jObject.put("phone_desc",  S12Utils.encodeHtmlTag(this.desctelefono));			
			jObject.put("phone_number_2", this.telefono2);
			jObject.put("phone_desc_2",  S12Utils.encodeHtmlTag(this.desctelefono2));	
		
			jObject.put("historicTerritory", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("historicTerritoryCode", this.provinciaCode);
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.municipio));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("locality", S12Utils.encodeHtmlTag(this.localidad));
			jObject.put("localityCode",  S12Utils.encodeHtmlTag(this.localidadCode));

			//servicios
			jObject.put("accesibility", this.arrServicios.get(S12OficinasTurismo.SRV_ACCESIBILIDAD).toString());
			jObject.put("qualityQ", this.arrServicios.get(S12OficinasTurismo.SRV_QCALIDAD).toString());
			jObject.put("qualityAssurance", this.arrServicios.get(S12OficinasTurismo.SRV_BUENASPRACTICAS).toString());
			jObject.put("productClub", this.arrServicios.get(S12OficinasTurismo.SRV_CLUBPRODUCTO).toString());
			jObject.put("surfing", this.arrServicios.get(S12OficinasTurismo.SRV_SURFING).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12OficinasTurismo.SRV_QORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12OficinasTurismo.SRV_QPLATA).toString());
			jObject.put("ISO", this.arrServicios.get(S12OficinasTurismo.SRV_ISO).toString());
			jObject.put("ECOLABEL", this.arrServicios.get(S12OficinasTurismo.SRV_ECOLABEL).toString());
			jObject.put("innovation", this.arrServicios.get(S12OficinasTurismo.SRV_INNOVACION).toString());

			jObject.put("type", S12OficinasTurismo.TIPO_RECURSO);
			jObject.put("subtype", this.subTipo);
			
			jObject.put("direction", S12Utils.encodeHtmlTag(this.direccion));
			jObject.put("mail", this.email);
			jObject.put("web",  S12Utils.encodeHtmlTag(this.web));
			jObject.put("postal_code", this.codigoPostal);

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}


	/**
	 * Adaptacion del metodo {@link #crearSqlE1(HttpServletRequest) crearSqlE1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlE1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12OficinasTurismo.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12OficinasTurismo.TIPO_RECURSO);
		sql.append("' AND ");

		String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			String[] arrOficinaTipo = tipo.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrOficinaTipo.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("?");
	  			params.add(arrOficinaTipo[i]);
	  			tiposSQL.add(Types.VARCHAR);
	  		}

	  		sql.append(") AND ");
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
		String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
		if (accesible != null) {
			sql.append(S12Constantes.PM_ACCESIBILITY);
			sql.append(" IS NOT NULL AND ");
		}
		String surfing = request.getParameter(S12Constantes.SF_SURFING);
		if (surfing != null  && !"0".equals(surfing)) {
			sql.append(S12Constantes.PM_SURFING);
			sql.append(" IS NOT NULL AND ");
		}
		String visitas = request.getParameter(S12Constantes.SF_VISIT);
		if (visitas != null) {
			sql.append(S12Constantes.PM_VISIT);
			sql.append(" IS NOT NULL AND ");
		}
		
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

	    return sql.toString();
	}

}
