	package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Ofertas.
 *
 * Representa una Oferta
 *
 *  
 */
public class S12Ofertas extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso. */
	public final static String TIPO_RECURSO = "M2";

	/** The Constant SIZE_STRINGBUFFER. */
	private static final int SIZE_STRINGBUFFER = 220;

	/** Precio de la oferta. */
	private String precio;

	/** Municipio de la oferta. */
	private String municipio;

	/** Fechas de la oferta. */
	private String fechas;

	/** Descripcin. */
	private String description;

	/** Mail. */
	private String mail;

	/** Telfono del recurso que propone la oferta. */
	private String phone;

	/** Web del recurso. */
	private String webRecurso;
	
	/** Nombre del recurso que propone la oferta. */
	private String nombrePadre;
	
	/** Cdigo del recurso que propone la oferta. */
	private String codigoPadre;
	
	/** Tipo del recurso que propone la oferta. */
	private String tipoPadre;

	/** Enlace a la ficha del recurso padre, emisor de la oferta. */
	private String enlacePadre;
	
	/** Descripcion foto */
	private String descFoto;
	
	/** URL amigable */
	private String urlAmigablePadre;
	
	/** signatura Padre */
	private String signaturaPadre;
	
	/** tipo alojamiento / subtipo recurso (hotel, pensin...) */
	private String subtipoPadre;
	
	/** Estrellas, llaves o lo que sea que tenga el Hotel */
	private String categoria;
	
	/** Listado de condiciones de la oferta */
	private List<String> condiciones;
	

	/**
	 * Constructor.
	 */
	public S12Ofertas() {
	}

	/**
	 * Gets the municipio.
	 *
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * Sets the municipio.
	 *
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * Gets the precio.
	 *
	 * @return Retorna el valor del campo precio.
	 */
	public String getPrecio() {
		return this.precio;
	}

	/**
	 * Sets the precio.
	 *
	 * @param precio Establece el valor del campo precio.
	 */
	public void setPrecio(String precio) {
		this.precio = precio;
	}

	/**
	 * Gets the fechas.
	 *
	 * @return Retorna el valor del campo fechas.
	 */
	public String getFechas() {
		return this.fechas;
	}

	/**
	 * Sets the fechas.
	 *
	 * @param fechas Establece el valor del campo fechas.
	 */
	public void setFechas(String fechas) {
		this.fechas = fechas;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the mail.
	 *
	 * @return the mail
	 */
	public String getMail() {
		return this.mail;
	}

	/**
	 * Sets the mail.
	 *
	 * @param mail the new mail
	 */
	public void setMail(String mail) {
		this.mail = mail;
	}

	/**
	 * Gets the phone.
	 *
	 * @return the phone
	 */
	public String getPhone() {
		return this.phone;
	}

	/**
	 * Sets the phone.
	 *
	 * @param phone the new phone
	 */
	public void setPhone(String phone) {
		this.phone = phone;
	}

	/**
	 * Gets the web recurso.
	 *
	 * @return the web recurso
	 */
	public String getWebRecurso() {
		return this.webRecurso;
	}

	/**
	 * Sets the web recurso.
	 *
	 * @param webRecurso the new web recurso
	 */
	public void setWebRecurso(String webRecurso) {
		this.webRecurso = webRecurso;
	}	

	/**
	 * @return Retorna el valor del campo nombrePadre
	 */
	public String getNombrePadre() {
		return this.nombrePadre;
	}

	/**
	 * @param nombrePadre Establece el valor del campo nombrePadre
	 */
	public void setNombrePadre(String nombrePadre) {
		this.nombrePadre = nombrePadre;
	}
	
	/**
	 * @return Retorna el valor del campo Signatura del recurso padre (si la tiene)
	 */
	public String getSignaturaPadre() {
		return signaturaPadre;
	}

	/**
	 * @param signaturaPadre Establece el valor de la signatura del recurso Padre
	 */
	public void setSignaturaPadre(String signaturaPadre) {
		this.signaturaPadre = signaturaPadre;
	}


	

	/**
	 * @return Retorna el valor del campo codigoPadre
	 */
	public String getCodigoPadre() {
		return this.codigoPadre;
	}

	/**
	 * @param codigoPadre Establece el valor del campo codigoPadre
	 */
	public void setCodigoPadre(String codigoPadre) {
		this.codigoPadre = codigoPadre;
	}

	/**
	 * @return Retorna el valor del campo tipoPadre
	 */
	public String getTipoPadre() {
		return this.tipoPadre;
	}

	/**
	 * @param tipoPadre Establece el valor del campo tipoPadre
	 */
	public void setTipoPadre(String tipoPadre) {
		this.tipoPadre = tipoPadre;
	}

	/**
	 * @return Retorna el valor del campo enlacePadre
	 */
	public String getEnlacePadre() {
		return this.enlacePadre;
	}

	/**
	 * @param enlacePadre Establece el valor del campo enlacePadre
	 */
	public void setEnlacePadre(String enlacePadre) {
		this.enlacePadre = enlacePadre;
	}

	/**
	 * @return Retorna el valor del campo urlAmigable del recurso padre
	 */
	public String getUrlAmigablePadre() {
		return this.urlAmigablePadre;
	}

	/**
	 * @param urlAmigable Establece el valor del campo urlAmigable del recurso padre
	 */
	public void setUrlAmigablePadre(String urlAmigablePadre) {
		this.urlAmigablePadre = urlAmigablePadre;
	}

	/**
	 * @param urlAmigable Establece el valor del campo subtipo del recurso padre
	 */
	public String getSubTipoPadre() {
		return this.subtipoPadre;
	}
	public void setSubTipoPadre(String subtipoPadre) {
		this.subtipoPadre = subtipoPadre;
	}
	

	/**
	 * @return Retorna el valor del campo urlAmigable del recurso padre
	 */
	public String getCategoria() {
		return this.categoria;
	}

	/**
	 * @param urlAmigable Establece el valor del campo urlAmigable del recurso padre
	 */
	public void setCategoria(String categoria) {
		this.categoria	= categoria;
	}
	
	
	/** 
	 * @return devuelve la lista de condiciones de la oferta
	 */
	public List<String> getCondiciones() {
		return condiciones;
	}

	/**
	 * @param condiciones establece la lista de condiciones de la oferta
	 */
	public void setCondiciones(List<String> condiciones) {
		this.condiciones = condiciones;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo M2.
	 *
	 * @param request the request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataM2(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Ofertas.TIPO_RECURSO));

		// Recogida de parmetros del mtodo
		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	// El metadato equivalente a municipality en la familia evento es eventTownName
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_TOWN_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }

 		String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
 	    if (municipalityCode != null && !"".equals(municipalityCode)) {
 	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_TOWN, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
 	    }
    
	    // Se obtiene la fechaDesde de la request
	    String fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    if (fechaDesde != null && !"".equals(fechaDesde)) {	    	
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_EVENT_SEARCH_DATE_2, R01MSearchEngineConstants.GREATER_THAN_OR_EQUAL_TO_OPERATOR, S12Utils.parsearFecha(fechaDesde)) );
	    }

	    // Se obtiene la fechaHasta de la request
	    String fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if (fechaHasta != null && !"".equals(fechaHasta)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_EVENT_SEARCH_DATE_1, R01MSearchEngineConstants.LESS_THAN_OR_EQUAL_TO_OPERATOR, S12Utils.parsearFecha(fechaHasta)) );
	    }
	    
	   
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}


	/**
	 * Funcin para obtener la lista de recursos de ofertas.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de ofertas
	 */
	public static String getOfertasM2(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Ofertas - M2");
			}
			S12Ofertas[] ofertasArray = portalMovilDAO.getOfertas(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Ofertas[] arrayOrdenado = (S12Ofertas[])S12Utils.casarOrdenResultados(ofertasArray, arrRecursos, S12Ofertas.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Ofertas::getOfertasM2: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12Ofertas::getOfertasM2: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Ofertas - M2");
		}

		return sRespuesta.toString();
	}

	/**
	 * Crear sql m2.
	 *
	 * @param request the request
	 *
	 * @return the string
	 * @deprecated
	 */
	public static String crearSqlM2(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Ofertas.SIZE_STRINGBUFFER);

		String idioma = request.getParameter("language");
		if (idioma == null || "".equals(idioma)){
			idioma = "es";
		}
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Ofertas.TIPO_RECURSO);
		sql.append("' AND ");

		String municipio = request.getParameter(S12Constantes.SF_MUNICIPALITY);
		if (municipio != null && !"".equals(municipio)) {
			sql.append(S12Constantes.PM_MUNICIPALITY);
			sql.append(" LIKE '%");
			sql.append(S12Utils.utf8toIso88591(municipio));
			sql.append("%' AND ");
		}
		
		String municipioCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE);
		if (municipioCode != null && !"".equals(municipioCode)) {
			sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
			sql.append(" LIKE '%");
			sql.append(municipioCode);
			sql.append("%' AND ");
		}		
		
		
		String tipo = request.getParameter(S12Constantes.SF_EVENT_TYPE);
		if (tipo != null && !"".equals(tipo)) {			
			sql.append(S12Constantes.PM_TYPE);
			if (tipo.equals(S12Constantes.TIPO_OFERTA_A1)){
				sql.append(" = '");					
			}else{
				sql.append(" <> '");
			}
			sql.append(S12Constantes.TIPO_OFERTA_A1);
			sql.append("' AND ");
		}
		
	    //Cuando se usa el filtro de fechas, deben venir los parmetros de ambos lmites inicial y final.
	    //Si no se cumple, se ignora.
	    //Las fechas estn representadas como string en formato YYYYMMDD
	    String fechaIni = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    String fechaFin = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if ((fechaIni != null && !"".equals(fechaIni)) && (fechaFin != null && !"".equals(fechaFin))) {
		    //Las fechas llegan con su formato de entrada, dependiente del idioma, las transformamos para usarlas en la bsqueda (YYYYMMDD)
	    	fechaIni = S12Utils.fechaFormatoYYYYMMDD(fechaIni, idioma);
	    	fechaFin = S12Utils.fechaFormatoYYYYMMDD(fechaFin, idioma);
	    	
	    	//un evento estar dentro del periodo de bsqueda cuando:
	    	//a)uno de los lmites de bsqueda est dentro de las fechas del evento.
	    	//b)ambas fechas del evento estn dentro de los lmites de bsqueda
	  		sql.append("(");
	  		//(a)
	  		sql.append("(");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= '");
	  		sql.append(fechaIni);
//	  		sql.append(S12Utils.parsearFecha(fechaFin));
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= '");
	  		sql.append(fechaIni);
	  		sql.append("' )");
	  		sql.append(" OR ");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= '");
	  		sql.append(fechaFin);
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= '");
	  		sql.append(fechaFin);
	  		sql.append("' )");
	  		sql.append(") OR (");
	  		//(b)
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" >= '");
	  		sql.append(fechaIni);
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" <= '");
	  		sql.append(fechaFin);
	  		sql.append("'))");
	  		sql.append(") AND ");
	    }
		
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_FECREACION);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

	/**
	 * Implementacin de la serializacin JSON del objeto.
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Ofertas.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable",  S12Utils.encodeHtmlTag(this.getUrlAmigable()));
			
			// La oferta puede NO tener padre asociado
			if (this.codigoPadre != null && this.tipoPadre != null && !"0".equals(this.codigoPadre)) {
				jObject.put("urlAmigablePadre", this.getUrlAmigablePadre());
			}
			
			jObject.put("municipio", S12Utils.encodeHtmlTag(this.municipio));

			jObject.put("fechas", this.fechas);
			jObject.put("precio", this.precio);

			jObject.put("descripcion", S12Utils.encodeHtmlTag(this.description));
			jObject.put("mail_para_reservar", this.mail);
			jObject.put("telefono_para_reservar", S12Utils.encodeHtmlTag(this.phone));
			jObject.put("sitio_web",  S12Utils.encodeHtmlTag(this.webRecurso));		//(del recurso que propone esta oferta.)
			jObject.put("name_recurso", S12Utils.encodeHtmlTag(this.nombrePadre)); //(del recurso que propone esta oferta.)
			jObject.put("signatura_padre", S12Utils.encodeHtmlTag(this.signaturaPadre)); //(del recurso que propone esta oferta.)
			jObject.put("subtipo_padre", S12Utils.encodeHtmlTag(this.subtipoPadre)); //(del recurso que propone esta oferta.)
			jObject.put("categoria", S12Utils.encodeHtmlTag(this.categoria)); //(del recurso que propone esta oferta.)
			jObject.put("tipo_padre", S12Utils.encodeHtmlTag(this.tipoPadre)); //(del recurso que propone esta oferta.)
			
			//devuelvo las condiciones de la oferta
			if (this.getCondiciones() != null && this.getCondiciones().size() > 0){
				List<String> listCondiciones = new ArrayList<String>();
				//escapo el html de cada una de las condiciones
				for (String condicion : this.getCondiciones()){
					listCondiciones.add(S12Utils.encodeHtmlTag(condicion));
				}
				jObject.put("condiciones", listCondiciones);
			}
			

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlM2(HttpServletRequest) crearSqlM2} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlM2(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Ofertas.SIZE_STRINGBUFFER);

		String idioma = request.getParameter("language");
		if (!S12Utils.esIdiomaValido(idioma)){
			idioma = "es";
		}
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Ofertas.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		
		String tipo = request.getParameter(S12Constantes.SF_EVENT_TYPE);
		if (tipo != null && !"".equals(tipo)) {			
			sql.append(S12Constantes.PM_TYPE);
			if (tipo.equals(S12Constantes.TIPO_OFERTA_A1)){
				sql.append(" = '");					
			}else{
				sql.append(" <> '");
			}
			sql.append(S12Constantes.TIPO_OFERTA_A1);
			sql.append("' AND ");
		}
		
	    //Cuando se usa el filtro de fechas, deben venir los parmetros de ambos lmites inicial y final.
	    //Si no se cumple, se ignora.
	    //Las fechas estn representadas como string en formato YYYYMMDD
	    String fechaIni = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    String fechaFin = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if ((fechaIni != null && !"".equals(fechaIni)) && (fechaFin != null && !"".equals(fechaFin))) {
		    //Las fechas llegan con su formato de entrada, dependiente del idioma, las transformamos para usarlas en la bsqueda (YYYYMMDD)
	    	fechaIni = S12Utils.fechaFormatoYYYYMMDD(fechaIni, idioma);
	    	fechaFin = S12Utils.fechaFormatoYYYYMMDD(fechaFin, idioma);
	    	
	    	//un evento estar dentro del periodo de bsqueda cuando:
	    	//a)uno de los lmites de bsqueda est dentro de las fechas del evento.
	    	//b)ambas fechas del evento estn dentro de los lmites de bsqueda
	  		sql.append("(");
	  		//(a)
	  		sql.append("(");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" )");
	  		sql.append(" OR ");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" )");
	  		sql.append(") OR (");
	  		//(b)
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" >= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" <= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append("))");
	  		sql.append(") AND ");
	    }
		
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_FECREACION);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
 