package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Recurso.
 *
 * Representa una Novedad
 *
 *  
 */
public class S12Novedad extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "O1";

	private static final int SIZE_STRINGBUFFER = 202;

	/** Fecha de la noticia */
	private String fecha;

	/** Id de la temtica de la noticia */
	private String tematica;

	/** Nombre de la temtica de la noticia */
	private String nombreTematica;

	/** Descripcion foto */
	private String descFoto;

	/** Entrada */
	private String entrada;
	
	/**
	 * Constructor.
	 */
	public S12Novedad() {
	}

	/**
	 * Retorna el valor del campo fecha.
	 *
	 * @return Fecha de la noticia
	 */
	public String getFecha() {
		return this.fecha;
	}

	/**
	 * Establece el valor del campo fecha.
	 *
	 * @param fecha Fecha de la noticia.
	 */
	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	/**
	 * @return Retorna el valor del campo tematica.
	 */
	public String getTematica() {
		return this.tematica;
	}

	/**
	 * @param tematica Establece el valor del campo tematica.
	 */
	public void setTematica(String tematica) {
		this.tematica = tematica;
	}


	/**
	 * @return Retorna el valor del campo nombreTematica.
	 */
	public String getNombreTematica() {
		return this.nombreTematica;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}


	/**
	 * @param nombreTematica Establece el valor del campo nombreTematica.
	 */
	public void setNombreTematica(String nombreTematica) {
		this.nombreTematica = nombreTematica;
	}

	/**
	 * Obtiene el campo entrada
	 *
	 * @return entrada
	 */
	public String getEntrada() {
		return entrada;
	}

	/**
	 * Establece el campo entrada
	 * 
	 * @param entrada entrada
	 */
	public void setEntrada(String entrada) {
		this.entrada = entrada;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo A1.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataO1(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Novedad.TIPO_RECURSO) );

		String tematica = request.getParameter(S12Constantes.SF_TEMATICA);
		if (tematica != null && !"".equals(tematica)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMATICA, R01MSearchEngineConstants.EQUALS_OPERATOR, tematica));
	    }
		
		String fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
		String fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
		if (fechaDesde != null && !"".equals(fechaDesde) && fechaHasta != null && !"".equals(fechaHasta)) { // metadato con between
			StringBuffer fecha = new StringBuffer();
	    	fecha.append(fechaDesde).append(R01MSearchEngineConstants.BETWEEN_VALUES_SEPARATOR).append(fechaHasta);
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_FECHA_NOVEDADES, R01MSearchEngineConstants.BETWEEN_OPERATOR, fecha.toString()));
		} else if (fechaDesde != null && !"".equals(fechaDesde)) {
	    	// metadato mayor que fecha desde
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_FECHA_NOVEDADES, R01MSearchEngineConstants.GREATER_THAN_OR_EQUAL_TO_OPERATOR, fechaDesde));
		} else if (fechaHasta != null && !"".equals(fechaHasta)) {
			// metadato menor que fecha hasta
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_FECHA_NOVEDADES, R01MSearchEngineConstants.LESS_THAN_OR_EQUAL_TO_OPERATOR, fechaHasta));
	    }

		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Crear sql o1.
	 *
	 * @param request the request
	 *
	 * @return the object
	 * @deprecated
	 */
	public static Object crearSqlO1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Novedad.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Novedad.TIPO_RECURSO);
		sql.append("' AND ");

		String seccion = request.getParameter(S12Constantes.SF_SECCION_NOTICIAS_ASINOSVEN);
		if (!S12Constantes.SECCION_ASI_NOS_VEN.equals(seccion)) {
			seccion=S12Constantes.SECCION_NOTICIAS; //por defecto
		}
		sql.append(S12Constantes.PM_SECCION);
		sql.append(" = '");
		sql.append(seccion);
		sql.append("' AND ");
		
		String fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
		String fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
		if (fechaDesde != null && !"".equals(fechaDesde)){
			sql.append(S12Constantes.PM_DATE_FROM);
			sql.append(" >= '");
			sql.append(S12Utils.parsearFecha(fechaDesde));
			sql.append("' AND ");
		}
		if (fechaHasta != null && !"".equals(fechaHasta)) {
			sql.append(S12Constantes.PM_DATE_FROM);
			sql.append(" <= '");
			sql.append(S12Utils.parsearFecha(fechaHasta));
			sql.append("' AND ");
		}

		String tematica = request.getParameter(S12Constantes.SF_TEMATICA);
		if (tematica != null && !"".equals(tematica)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = '");
			sql.append(tematica);
			sql.append("' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_DATE_FROM);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

	/**
	 * Funcin para obtener la lista de recursos de novedades.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de novedades
	 */
	public static String getNovedadesO1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Novedades - O1");
			}
			S12Novedad[] novedadesArray = portalMovilDAO.getNovedades(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Novedad[] arrayOrdenado = (S12Novedad[])S12Utils.casarOrdenResultados(novedadesArray, arrRecursos, S12Novedad.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Novedad::getNovedadesO1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12Novedad::getNovedadesO1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Novedades - O1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Novedad.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());

			jObject.put("tematica_id", this.tematica);
			jObject.put("tematica", S12Utils.encodeHtmlTag(this.nombreTematica));

			jObject.put("fecha", this.fecha);

			jObject.put("entrada", S12Utils.encodeHtmlTag(this.getEntrada()));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlO1(HttpServletRequest) crearSqlO1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlO1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Novedad.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Novedad.TIPO_RECURSO);
		sql.append("' AND ");

		String seccion = request.getParameter(S12Constantes.SF_SECCION_NOTICIAS_ASINOSVEN);
		if (!S12Constantes.SECCION_ASI_NOS_VEN.equals(seccion)) {
			seccion=S12Constantes.SECCION_NOTICIAS; //por defecto
		}
		sql.append(S12Constantes.PM_SECCION);
		sql.append(" = ? AND ");
		params.add(seccion);
		tiposSQL.add(Types.VARCHAR);
		
		String fechaDesde = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
		String fechaHasta = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
		if (fechaDesde != null && !"".equals(fechaDesde)){
			String fechaini = S12Utils.parsearFecha(fechaDesde);
			sql.append(S12Constantes.PM_DATE_FROM);
			sql.append(" >= ?");
			params.add(fechaini);
			tiposSQL.add(Types.VARCHAR);
			sql.append(" AND ");
		}
		if (fechaHasta != null && !"".equals(fechaHasta)) {
			String fechafin = S12Utils.parsearFecha(fechaHasta);
			sql.append(S12Constantes.PM_DATE_FROM);
			sql.append(" <= ?");
			params.add(fechafin);
			tiposSQL.add(Types.VARCHAR);
			sql.append(" AND ");
		}

		String tematica = request.getParameter(S12Constantes.SF_TEMATICA);
		if (tematica != null && !"".equals(tematica)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(tematica);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_DATE_FROM);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
