package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12NoTeLoPierdas.
 *
 * Representa un No te lo Pierdas
 *
 *  
 */
public class S12NoTeLoPierdas extends S12RecursoTuristico implements JSONString {

	private final static int SIZE_STRINGBUFFER = 220;
	
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "F1";

	/** Descripcin asociada al recurso F1. */
	private String descripcion;

	/** Pefil asociado al recurso F1. */
	private String perfil;

	/** Nombre del Pefil asociado al recurso F1. */
	private String nombrePerfil;

	/**
	 * Constructor.
	 */
	public S12NoTeLoPierdas() {
	}


	/**
	 * @return Retorna el valor del campo descripcion.
	 */
	public String getDescripcion() {
		return this.descripcion;
	}


	/**
	 * @param descripcion Establece el valor del campo descripcion.
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}


	/**
	 * @return Retorna el valor del campo perfil.
	 */
	public String getPerfil() {
		return this.perfil;
	}


	/**
	 * @param perfil Establece el valor del campo perfil.
	 */
	public void setPerfil(String perfil) {
		this.perfil = perfil;
	}


	/**
	 * @return Retorna el valor del campo nombrePerfil.
	 */
	public String getNombrePerfil() {
		return this.nombrePerfil;
	}


	/**
	 * @param nombrePerfil Establece el valor del campo nombrePerfil.
	 */
	public void setNombrePerfil(String nombrePerfil) {
		this.nombrePerfil = nombrePerfil;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo F1.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataF1(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12NoTeLoPierdas.TIPO_RECURSO));
	
	    String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, nombre));
	    }

	    String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, tipo));
	    }

	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
			if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funcin que crea la sql de consulta para recursos de tipo F1.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlF1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12NoTeLoPierdas.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12NoTeLoPierdas.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	sql.append(S12Constantes.PM_NAME);
	  		sql.append(" LIKE '%");
	  		sql.append(nombre);
	  		sql.append("%' AND ");
	    }
	
	    String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = '");
			sql.append(tipo);
			sql.append("' AND ");
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funcin para obtener la lista de recursos de No te lo Pierdas.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de No te lo Pierdas
	 */
	public static String getNoTeLoPierdasF1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de No Te Lo Pierdas - F1");
			}
			S12NoTeLoPierdas[] noTeLoPierdasArray = portalMovilDAO.getNoTeLoPierdas(arrRecursos, idioma, latitud, longitud);

			try {
				sRespuesta.append(new JSONArray(noTeLoPierdasArray).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12NoTeLoPierdas::getNoTeLoPierdasF1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12NoTeLoPierdas::getNoTeLoPierdasF1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de No Te Lo Pierdas - F1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12NoTeLoPierdas.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("merkur_url", S12Utils.getURLMerkur(this.getCodigoRecurso(), S12NoTeLoPierdas.TIPO_RECURSO, this.getUrlAmigable(), this.getIdioma()));

			jObject.put("description", S12Utils.encodeHtmlTag(this.getDescripcion()));

			jObject.put("perfil_id", this.getPerfil());
			jObject.put("perfil", S12Utils.encodeHtmlTag(this.getNombrePerfil()));

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}


	/**
	 * Adaptacion del metodo {@link #crearSqlF1(HttpServletRequest) crearSqlF1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlF1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12NoTeLoPierdas.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12NoTeLoPierdas.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		nombre = nombre.toUpperCase(new Locale("es", "es"));
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+nombre+"%";
	  		params.add(expresionLIKE);
	  		tiposSQL.add(Types.VARCHAR);
	    }
	
	    String tipo = request.getParameter(S12Constantes.SF_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(tipo);
			tiposSQL.add(Types.VARCHAR);
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
