/*
 * Created on 20/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;


/**
 * The Class S12MasInformacion.
 *  
 */
public class S12MasInformacion implements JSONString {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "PORTAL_MOVIL";

	private long codigoMasInformacion;
	private String codigoIdioma;
	private String nombreMasInformacion;
	private String urlMasInformacion;

	/**
	 * @return Retorna el valor del campo codigoMasInformacion.
	 */
	public long getCodigoMasInformacion() {
		return this.codigoMasInformacion;
	}

	/**
	 * @param codigoMasInformacion Establece el valor del campo codigoMasInformacion.
	 */
	public void setCodigoMasInformacion(long codigoMasInformacion) {
		this.codigoMasInformacion = codigoMasInformacion;
	}

	/**
	 * @return Retorna el valor del campo codigoIdioma.
	 */
	public String getCodigoIdioma() {
		return this.codigoIdioma;
	}

	/**
	 * @param codigoIdioma Establece el valor del campo codigoIdioma.
	 */
	public void setCodigoIdioma(String codigoIdioma) {
		this.codigoIdioma = codigoIdioma;
	}

	/**
	 * @return Retorna el valor del campo nombreMasInformacion.
	 */
	public String getNombreMasInformacion() {
		return this.nombreMasInformacion;
	}

	/**
	 * @param nombreMasInformacion Establece el valor del campo nombreMasInformacion.
	 */
	public void setNombreMasInformacion(String nombreMasInformacion) {
		this.nombreMasInformacion = nombreMasInformacion;
	}

	/**
	 * @return Retorna el valor del campo urlMasInformacion.
	 */
	public String getUrlMasInformacion() {
		return this.urlMasInformacion;
	}

	/**
	 * @param urlMasInformacion Establece el valor del campo urlMasInformacion.
	 */
	public void setUrlMasInformacion(String urlMasInformacion) {
		this.urlMasInformacion = urlMasInformacion;
	}

	/**
	 * Gets the mas informacion.
	 *
	 * @param idioma the idioma
	 * @param codigoProvincia the codigo provincia
	 * @param nombreCapital the nombre capital
	 * @param codigoCapital the codigo capital
	 *
	 * @return the mas informacion
	 */
	public static ArrayList<S12MasInformacion> getMasInformacion(String codigoCapital, String codigoProvincia, String nombreCapital, String idioma) {
		ArrayList<S12MasInformacion> masInformacionList = new ArrayList<S12MasInformacion>();
		S12MasInformacion masInformacion;

		try {
			// Dominio
			String dominioMovil = Q70ListenerUtils.getApplicationProperty("url_dominio_movil_" + idioma);
			
			// Marcas
			String marks = "";
			if ("01".equals(codigoProvincia)) {
				marks = "6"; // Vitoria-Gasteiz
			} else if ("20".equals(codigoProvincia)) {
				marks = "5"; // San Sebastin
			} else if ("48".equals(codigoProvincia)) {
				marks = "4"; // Bilbao
			}
			
			String dondeComer = "";
			String dondeDormir = "";
			String experienciasTop = "";
			String oficinasTurismo = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.oficinasEn", idioma).replaceAll("##CAPITAL##",nombreCapital);
			if ("01".equals(codigoProvincia) && "eu".equals(idioma)) {
				dondeComer = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.comerEn", idioma).replaceAll("##CAPITAL##",nombreCapital + "e");
				dondeDormir = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.dormirEn", idioma).replaceAll("##CAPITAL##",nombreCapital + "e");
				experienciasTop = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.experienciasEn", idioma).replaceAll("##CAPITAL##",nombreCapital + "e");
			} else {
				dondeComer = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.comerEn", idioma).replaceAll("##CAPITAL##",nombreCapital);
				dondeDormir = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.dormirEn", idioma).replaceAll("##CAPITAL##",nombreCapital);
				experienciasTop = Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil","progrExperienciales.experienciasEn", idioma).replaceAll("##CAPITAL##",nombreCapital);
			}

			String urlDondeComer = dominioMovil + "mobile/15634x/?R01HLang=" + idioma + "&r01kLang=" + idioma + "&municipalityCode=" + codigoCapital + "&municipality=" + URLEncoder.encode(nombreCapital.toUpperCase(),"ISO-8859-1");
			String urlDondeDormir = dominioMovil + "mobile/15633x/?R01HLang=" + idioma + "&r01kLang=" + idioma + "&municipalityCode=" + codigoCapital + "&municipality=" + URLEncoder.encode(nombreCapital.toUpperCase(),"ISO-8859-1");
			String urlOficinasTurismo = dominioMovil + "mobile/15613x/?R01HLang=" + idioma + "&r01kLang=" + idioma + "&municipalityCode=" + codigoCapital + "&municipality=" + URLEncoder.encode(nombreCapital.toUpperCase(),"ISO-8859-1");
			String urlExperienciasTop = dominioMovil + "mobile/12390x/?R01HLang=" + idioma + "&r01kLang=" + idioma + "&marks=" + marks;

			String[] textosMasInformacion = {dondeComer, dondeDormir, oficinasTurismo, experienciasTop};
			String[] urlInformacion = {urlDondeComer, urlDondeDormir, urlOficinasTurismo, urlExperienciasTop};

			for (int i = 0; i < textosMasInformacion.length; i++) {
				masInformacion = new S12MasInformacion();
				masInformacion.setCodigoMasInformacion(i+1);
				masInformacion.setCodigoIdioma(idioma);
				masInformacion.setNombreMasInformacion(textosMasInformacion[i]);
				masInformacion.setUrlMasInformacion(urlInformacion[i]);

				masInformacionList.add(masInformacion);
			}

		} catch (Q70GestorMensajesException e) {
	    	if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12MasInformacion.COMPONENTE, Q70TraceLevel.ERROR,"S12MasInformacion::getMasInformacion: Exception: " + e.getMessage());
			}
	    } catch (UnsupportedEncodingException e) {
	    	if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12MasInformacion.COMPONENTE, Q70TraceLevel.ERROR,"S12MasInformacion::getMasInformacion: Exception: " + e.getMessage());
			}
		}

		return masInformacionList;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("id", this.getCodigoMasInformacion());
			jObject.put("title", S12Utils.encodeHtmlTag(this.getNombreMasInformacion()));
			jObject.put("internal_url", this.getUrlMasInformacion());

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}