package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Localidades.
 *
 * Representa una Localidad
 *
 *  
 */
public class S12Localidades extends S12RecursoTuristico implements JSONString {

	private final static int SIZE_STRINGBUFFER = 220;
	
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "D2";

	/** Descripcion foto */
	private String descFoto;
	
	/**
	 * Constructor.
	 */
	public S12Localidades() {
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	
	/**
	 * Funcin que crea los metadatos para recursos de tipo D2.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataD2(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Localidades.TIPO_RECURSO));
	
	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
			if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }
	
			// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funcin que crea la sql de consulta para recursos de tipo D2.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlD2(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Localidades.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Localidades.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE);
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE);
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funcin para obtener la lista de recursos de localidades.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de localidades
	 */
	public static String getLocalidadesD2(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Localidades - D2");
			}
			S12Localidades[] localidadesArray = portalMovilDAO.getLocalidades(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Localidades[] arrayOrdenado = (S12Localidades[])S12Utils.casarOrdenResultados(localidadesArray, arrRecursos, S12Localidades.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Localidad::getLocalidadesD2: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12Localidad::getLocalidadesD2: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Localidades - D2");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12Localidades.TIPO_RECURSO);

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Localidades.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlD2(HttpServletRequest) crearSqlD2} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlD2(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Localidades.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Localidades.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}
		
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
