/*
 * Created on 28/02/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * The Class S12Experiencia.
 *  
 */
public class S12Experiencia extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso. */
	public final static String TIPO_RECURSO = "D6";

	private final static int SIZE_STRINGBUFFER = 220;

	/** The nombre. */
	private String nombre;

	/** The descripcion. */
	private String descripcion;

	/** The foto principal. */
	private String fotoPrincipal;

	/** Descripcion foto */
	private String descFoto;
	
	/** The url amigable. */
	private String urlAmigable;

	/** The distancia. */
	private String distancia;

	/** The tipos id. */
	private String tiposId;

	/**
	 * Gets the tipos id.
	 *
	 * @return the tipos id
	 */
	public String getTiposId() {
		return this.tiposId;
	}

	/**
	 * Sets the tipos id.
	 *
	 * @param tiposId the new tipos id
	 */
	public void setTiposId(String tiposId) {
		this.tiposId = tiposId;
	}

	/**
	 * Gets the distancia.
	 *
	 * @return the distancia
	 */
	public String getDistancia() {
		return this.distancia;
	}

	/**
	 * Sets the distancia.
	 *
	 * @param distancia the new distancia
	 */
	public void setDistancia(String distancia) {
		this.distancia = distancia;
	}

	/**
	 * Gets the nombre.
	 *
	 * @return the nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Sets the nombre.
	 *
	 * @param nombre the new nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Gets the descripcion.
	 *
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return this.descripcion;
	}

	/**
	 * Sets the descripcion.
	 *
	 * @param descripcion the new descripcion
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * Gets the foto principal.
	 *
	 * @return the foto principal
	 */
	public String getFotoPrincipal() {
		return this.fotoPrincipal;
	}

	/**
	 * Sets the foto principal.
	 *
	 * @param fotoPrincipal the new foto principal
	 */
	public void setFotoPrincipal(String fotoPrincipal) {
		this.fotoPrincipal = fotoPrincipal;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * Gets the url amigable.
	 *
	 * @return the url amigable
	 */
	public String getUrlAmigable() {
		return this.urlAmigable;
	}

	/**
	 * Sets the url amigable.
	 *
	 * @param urlAmigable the new url amigable
	 */
	public void setUrlAmigable(String urlAmigable) {
		this.urlAmigable = urlAmigable;
	}

	/**
	 * Funcin que crea los metadatos para recursos de tipo D6.
	 *
	 * @param request the request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataD6(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Experiencia.TIPO_RECURSO));

		String cuandoIr = request.getParameter(S12Constantes.SF_MONTHS);
		if (cuandoIr != null && !"".equals(cuandoIr)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MONTHS, R01MSearchEngineConstants.LIKE_OPERATOR, cuandoIr));
	    }
		
		String idiomas = request.getParameter(S12Constantes.SF_LANGUAGES);
		if (idiomas != null && !"".equals(idiomas)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_LANGUAGES, R01MSearchEngineConstants.LIKE_OPERATOR, idiomas));
	    }

		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		String idealPara = request.getParameter(S12Constantes.SF_PARA);
		if (idealPara != null && !"".equals(idealPara)) {
			if ("205".equals(idealPara)) {
				metaData.add(new R01MSearchedMetaData(S12Constantes.SF_PARA_PAREJA, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
			} else if ("206".equals(idealPara)) {
				metaData.add(new R01MSearchedMetaData(S12Constantes.SF_PARA_NINIOS, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
			} else if ("207".equals(idealPara)) {
				metaData.add(new R01MSearchedMetaData(S12Constantes.SF_PARA_AMIGOS, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
			}
		}

		String tematicaAgua = request.getParameter(S12Constantes.SF_TEMATICA_AGUA);		
		if (tematicaAgua != null) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMATICA_AGUA, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
		String tematicaPaisaje = request.getParameter(S12Constantes.SF_TEMATICA_PAISAJE);
		if (tematicaPaisaje != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMATICA_PAISAJE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
		String tematicaGastronomia = request.getParameter(S12Constantes.SF_TEMATICA_GASTRONOMIA);
		if (tematicaGastronomia != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMATICA_GASTRONOMIA, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
		String tematicaCultura = request.getParameter(S12Constantes.SF_TEMATICA_CULTURA);
		if (tematicaCultura != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMATICA_CULTURA, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
		
		// Metadato Searchable (Experiencias madres o que no tienen madre) 
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SEARCHABLE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, "EQ", S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Crear sql d6.
	 *
	 * @param request the request
	 *
	 * @return the string
	 * @deprecated
	 */
	public static String crearSqlD6(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Experiencia.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Experiencia.TIPO_RECURSO);
		sql.append("' AND ");

		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		String languages = request.getParameter(S12Constantes.SF_LANGUAGES);
		if (languages != null && !"".equals(languages)) {
			sql.append(S12Constantes.PM_LANGUAGES);
			sql.append(" LIKE '%");
			sql.append(languages);
			sql.append("%' AND ");
		}

		String cuandoIr = request.getParameter(S12Constantes.SF_MONTHS);
		if (cuandoIr != null && !"".equals(cuandoIr)) {
			sql.append(S12Constantes.PM_MONTHS);
			sql.append(" LIKE '%");
			sql.append(cuandoIr);
			sql.append("%' AND ");
		}

		String tematica = request.getParameter(S12Constantes.SF_TEMATICA_PLANES);
		if (tematica != null && !"".equals(tematica)) {
			if ("201".equals(tematica)) {
				sql.append(S12Constantes.PM_WATER);
				sql.append(" IS NOT NULL AND ");
			} else if ("202".equals(tematica)) {
				sql.append(S12Constantes.PM_LANDSCAPE); //paisaje
				sql.append(" IS NOT NULL AND ");
			} else if ("203".equals(tematica)) {
				sql.append(S12Constantes.PM_CUISINE); //gastronomia
				sql.append(" IS NOT NULL AND ");
			} else if ("204".equals(tematica)) {
				sql.append(S12Constantes.PM_CULTURE);
				sql.append(" IS NOT NULL AND ");
			} else if ("212".equals(tematica)) {
				sql.append(S12Constantes.PM_BASQUE);
				sql.append(" IS NOT NULL AND ");
			} else if ("215".equals(tematica)) {
				sql.append(S12Constantes.PM_ACCESIBLE);
				sql.append(" IS NOT NULL AND ");
			} else if ("216".equals(tematica)) {
				sql.append(S12Constantes.PM_DEPORTE);
				sql.append(" IS NOT NULL AND ");
			} else if ("217".equals(tematica)) {
				sql.append(S12Constantes.PM_PEQUE);
				sql.append(" IS NOT NULL AND ");
			} else if ("218".equals(tematica)) {
				sql.append(S12Constantes.PM_SALUD);
				sql.append(" IS NOT NULL AND ");
			} else if ("219".equals(tematica)) {
				sql.append(S12Constantes.PM_URBANAS);
				sql.append(" IS NOT NULL AND ");
			}
		}
		
		String idealPara = request.getParameter(S12Constantes.SF_PARA);
		if (idealPara != null && !"".equals(idealPara)) {
			if ("205".equals(idealPara)) {
				sql.append(S12Constantes.PM_COUPLE);
				sql.append(" IS NOT NULL AND ");
			} else if ("206".equals(idealPara)) {
				sql.append(S12Constantes.PM_CHILDREN);
				sql.append(" IS NOT NULL AND ");
			} else if ("207".equals(idealPara)) {
				sql.append(S12Constantes.PM_FRIENDS);
				sql.append(" IS NOT NULL AND ");
			}
		}
		
		String top = request.getParameter(S12Constantes.SF_TOP);
		String premium = request.getParameter(S12Constantes.SF_PREMIUM);
		if (top != null && !"".equals(top) && premium != null && !"".equals(premium)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '7' AND ");
		} else if (top != null && !"".equals(top)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" > '3' AND ");
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '7' AND ");
		} else if (premium != null && !"".equals(premium)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '4' AND ");
		}
		
		// Searchable (Experiencias madres o que no tienen madre) 
		sql.append(S12Constantes.PM_SEARCHABLE);
		sql.append(" = '1' AND ");
	
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_FEPUBLICACION);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		
		return sql.toString();
	}

	/**
	 * Gets the experiencias d6.
	 *
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latitud the latitud
	 * @param longitud the longitud
	 * @param numero_resultados the numero_resultados
	 * @param ultimo_resultado the ultimo_resultado
	 *
	 * @return the experiencias d6
	 */
	public static String getExperienciasD6(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud,
			int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Experiencias - D6");
			}
			S12Experiencia[] experienciasArray = portalMovilDAO.getExperiencias(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Experiencia[] arrayOrdenado = (S12Experiencia[])S12Utils.casarOrdenResultados(experienciasArray, arrRecursos, S12Experiencia.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12PortalMovilServlet::getExperienciasD6: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12PortalMovilServlet::getExperienciasD6: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Experiencias - D6");
		}

		return sRespuesta.toString();
	}

	/**
	 * To json string.
	 *
	 * @return the string
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Experiencia.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());
			
			jObject.put("description", S12Utils.encodeHtmlTag(this.getDescripcion()));
			jObject.put("tipos_id", this.getTiposId());

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlD6(HttpServletRequest) crearSqlD6} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlD6(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Experiencia.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Experiencia.TIPO_RECURSO);
		sql.append("' AND ");

	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String languages = request.getParameter(S12Constantes.SF_LANGUAGES);
		if (languages != null && !"".equals(languages)) {
			sql.append(S12Constantes.PM_LANGUAGES);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+languages+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String cuandoIr = request.getParameter(S12Constantes.SF_MONTHS);
		if (cuandoIr != null && !"".equals(cuandoIr)) {
			sql.append(S12Constantes.PM_MONTHS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+cuandoIr+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String tematica = request.getParameter(S12Constantes.SF_TEMATICA_PLANES);
		if (tematica != null && !"".equals(tematica)) {
			if ("201".equals(tematica)) {
				sql.append(S12Constantes.PM_WATER);
				sql.append(" IS NOT NULL AND ");
			} else if ("202".equals(tematica)) {
				sql.append(S12Constantes.PM_LANDSCAPE); //paisaje
				sql.append(" IS NOT NULL AND ");
			} else if ("203".equals(tematica)) {
				sql.append(S12Constantes.PM_CUISINE); //gastronomia
				sql.append(" IS NOT NULL AND ");
			} else if ("204".equals(tematica)) {
				sql.append(S12Constantes.PM_CULTURE);
				sql.append(" IS NOT NULL AND ");
			} else if ("212".equals(tematica)) {
				sql.append(S12Constantes.PM_BASQUE);
				sql.append(" IS NOT NULL AND ");
			} else if ("215".equals(tematica)) {
				sql.append(S12Constantes.PM_ACCESIBLE);
				sql.append(" IS NOT NULL AND ");
			} else if ("216".equals(tematica)) {
				sql.append(S12Constantes.PM_DEPORTE);
				sql.append(" IS NOT NULL AND ");
			} else if ("217".equals(tematica)) {
				sql.append(S12Constantes.PM_PEQUE);
				sql.append(" IS NOT NULL AND ");
			} else if ("218".equals(tematica)) {
				sql.append(S12Constantes.PM_SALUD);
				sql.append(" IS NOT NULL AND ");
			} else if ("219".equals(tematica)) {
				sql.append(S12Constantes.PM_URBANAS);
				sql.append(" IS NOT NULL AND ");
			}
		}
		
		String idealPara = request.getParameter(S12Constantes.SF_PARA);
		if (idealPara != null && !"".equals(idealPara)) {
			if ("205".equals(idealPara)) {
				sql.append(S12Constantes.PM_COUPLE);
				sql.append(" IS NOT NULL AND ");
			} else if ("206".equals(idealPara)) {
				sql.append(S12Constantes.PM_CHILDREN);
				sql.append(" IS NOT NULL AND ");
			} else if ("207".equals(idealPara)) {
				sql.append(S12Constantes.PM_FRIENDS);
				sql.append(" IS NOT NULL AND ");
			}
		}
		
		String top = request.getParameter(S12Constantes.SF_TOP);
		String premium = request.getParameter(S12Constantes.SF_PREMIUM);
		if (top != null && !"".equals(top) && premium != null && !"".equals(premium)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '7' AND ");
		} else if (top != null && !"".equals(top)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" > '3' AND ");
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '7' AND ");
		} else if (premium != null && !"".equals(premium)) {
			sql.append(S12Constantes.PM_IMPORTANCE);
			sql.append(" < '4' AND ");
		}
		
		// Searchable (Experiencias madres o que no tienen madre) 
		sql.append(S12Constantes.PM_SEARCHABLE);
		sql.append(" = '1' AND ");
	
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_FEPUBLICACION);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		
		return sql.toString();
	}

}
