package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12EstacionesTransporte.
 *
 * Representa una Estaci�n de Transporte
 *
 *  
 */
public class S12EstacionesTransporte extends S12RecursoTuristico implements JSONString {

	private final static int SIZE_STRINGBUFFER = 220;
	
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "C3";

	/** Tel�fono asociado al recurso C3. */
	private String telefono;

	/** Descripcion Tel�fono asociado al recurso C3. */
	private String desctelefono;

	/** Tel�fono2 asociado al recurso C3. */
	private String telefono2;

	/** Descripcion Tel�fono2 asociado al recurso C3. */
	private String desctelefono2;

	/** Fax asociado al recurso C3. */
	private String fax;

	/** Direcci�n asociada al recurso C3. */
	private String direccion;

	/** Codigo postal asociado al recurso C3. */
	private String codigoPostal;

	/** Municipio asociado al recurso C3. */
	private String municipio;

	/** Codigo Municipio */
	private String municipioCode;

	/** Provincia asociado al recurso C3. */
	private String provincia;
	
	/** Email asociado al recurso C3. */
	private String email;

	/** Web asociada al recurso C3. */
	private String web;

	/** Descripcion foto */
	private String descFoto;

	/** Foto miniatura A */
	private String fotoA;
	
	/** Descripcion foto miniatura A */
	private String descFotoA;
	
	/** URL amigable a la localidad del recurso **/
	private String urltownamigable; 
	
	/** Servicios del recurso */
	private ArrayList<String> arrServicios;
	
	private final static int SRV_ISO = 0;
	private final static int SRV_BUENASPRACTICAS = 1;
	private final static int SRV_ACCESIBILIDAD = 2;
	private final static int SRV_Q_ORO = 3;
	private final static int SRV_Q_PLATA = 4;
	private final static int SRV_Q_CALIDAD = 5;
	private final static int SRV_INNOVACION = 6;
	
	/**
	 * Constructor.
	 */
	public S12EstacionesTransporte() {
	}

	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * @param desctelefono Establece el valor del campo descripcion telefono.
	 */
	public void setDescTelefono(String desctelefono) {
		this.desctelefono = desctelefono;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono.
	 */
	public String getDescTelefono() {
		return this.desctelefono;
	}

	/**
	 * @param telefono Establece el valor del campo telefono2.
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}

	/**
	 * @return Retorna el valor del campo telefono2.
	 */
	public String getTelefono2() {
		return this.telefono2;
	}

	/**
	 * @param desctelefono2 Establece el valor del campo descripcion telefono2.
	 */
	public void setDescTelefono2(String desctelefono2) {
		this.desctelefono2 = desctelefono2;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono2.
	 */
	public String getDescTelefono2() {
		return this.desctelefono2;
	}

	/**
	 * @return Retorna el valor del campo fax.
	 */
	public String getFax() {
		return this.fax;
	}

	/**
	 * @param fax Establece el valor del campo fax.
	 */
	public void setFax(String fax) {
		this.fax = fax;
	}

	/**
	 * @return Retorna el valor del campo direccion.
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * @param direccion Establece el valor del campo direccion.
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * @return Retorna el valor del campo codigoPostal.
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * @param codigoPostal Establece el valor del campo codigoPostal.
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	/**
	 * @return Retorna el valor del campo provincia.
	 */
	public String getProvincia() {
		return this.provincia;
	}

	/**
	 * @param provincia Establece el valor del campo provincia.
	 */
	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return Retorna el valor del campo email.
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @param email Establece el valor del campo email.
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return Retorna el valor del campo web.
	 */
	public String getWeb() {
		return this.web;
	}

	/**
	 * @param web Establece el valor del campo web.
	 */
	public void setWeb(String web) {
		this.web = web;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}
	
	/**
	 * Obtiene el campo fotoA
	 *
	 * @return fotoA
	 */
	public String getFotoA() {
		return fotoA;
	}

	/**
	 * Establece el campo fotoA
	 * 
	 * @param fotoA fotoA
	 */
	public void setFotoA(String fotoA) {
		this.fotoA = fotoA;
	}

	/**
	 * Obtiene el campo descFotoA
	 *
	 * @return descFotoA
	 */
	public String getDescFotoA() {
		return descFotoA;
	}

	/**
	 * Establece el campo descFotoA
	 * 
	 * @param descFotoA descFotoA
	 */
	public void setDescFotoA(String descFotoA) {
		this.descFotoA = descFotoA;
	}
	
	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	/**
	 * Obtiene el campo urltownamigable
	 *
	 * @return urltownamigable
	 */
	public String getUrlTownAmigable() {
		return urltownamigable;
	}

	/**
	 * Establece el campo urltownamigable
	 * 
	 * @param urltownamigable urltownamigable
	 */
	public void setUrlTownAmigable(String urltownamigable) {
		this.urltownamigable = urltownamigable;
	}

	/**
	 * Retorna el valor del campo arrServicios.
	 *
	 * @return arrServicios del recurso
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * Establece el valor del campo arrServicios.
	 *
	 * @param arrServicios del recurso.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}

	/**
	 * Funci�n que crea los metadatos para recursos de tipo C3.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataC3(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12EstacionesTransporte.TIPO_RECURSO));
	
	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
			if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		String transportType = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
	    if (transportType != null && !"".equals(transportType)) {
	    	metaData.add( new R01MSearchedMetaData(S12Constantes.SF_TRANSPORT_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, transportType) );
	    }

		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funci�n que crea la sql de consulta para recursos de tipo C3.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlC3(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12EstacionesTransporte.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EstacionesTransporte.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }

	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }


		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		String tipo = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = '");
			sql.append(tipo);
			sql.append("' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funci�n para obtener la lista de recursos de estaciones de transporte.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de estaciones de transporte
	 */
	public static String getEstacionesTransporteC3(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Estaciones Tranposrte - C3");
			}
			S12EstacionesTransporte[] estacionesTransporteArray = portalMovilDAO.getEstacionesTransporte(arrRecursos, idioma, latitud, longitud );
			//corregimos el ORDER en base a la paginaci�n.
			S12EstacionesTransporte[] arrayOrdenado = (S12EstacionesTransporte[])S12Utils.casarOrdenResultados(estacionesTransporteArray, arrRecursos, S12EstacionesTransporte.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12EstacionesTransporte::getEstacionesTransporteC3: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12EstacionesTransporte::getEstacionesTransporteC3: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Estaciones Tranposrte - C3");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementaci�n de la serializaci�n JSON del objeto
	 *
	 * @return Serializaci�n JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12EstacionesTransporte.TIPO_RECURSO);

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());
			jObject.put("url_town", this.getUrlTownAmigable());

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EstacionesTransporte.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			if (this.getFotoA() != null) {
				//excepcionalmente para listado particular
				StringBuffer urlFotoA = new StringBuffer();
				urlFotoA.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EstacionesTransporte.TIPO_RECURSO, null));
				urlFotoA.append("images/");
				urlFotoA.append(this.getFotoA());
				jObject.put("imageA", urlFotoA);
				jObject.put("imageA_desc", S12Utils.encodeHtmlTag(this.getDescFotoA()));
			}
			jObject.put("accesibility", this.arrServicios.get(S12EstacionesTransporte.SRV_ACCESIBILIDAD).toString());
			jObject.put("qualityAssurance", this.arrServicios.get(S12EstacionesTransporte.SRV_BUENASPRACTICAS).toString());
			jObject.put("ISO", this.arrServicios.get(S12EstacionesTransporte.SRV_ISO).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12EstacionesTransporte.SRV_Q_ORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12EstacionesTransporte.SRV_Q_PLATA).toString());
			jObject.put("qualityQ", this.arrServicios.get(S12EstacionesTransporte.SRV_Q_CALIDAD).toString());
			jObject.put("innovation", this.arrServicios.get(S12EstacionesTransporte.SRV_INNOVACION).toString());
			
			jObject.put("direction", S12Utils.encodeHtmlTag(this.direccion));
			jObject.put("postal_code", this.codigoPostal);
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.municipio));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("provincia", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("phone_number", this.telefono);
			jObject.put("phone_desc",  S12Utils.encodeHtmlTag(this.desctelefono));			
			jObject.put("phone_number_2", this.telefono2);
			jObject.put("phone_desc_2",  S12Utils.encodeHtmlTag(this.desctelefono2));			
			jObject.put("fax", this.fax);
			jObject.put("mail", this.email);
			jObject.put("web",  S12Utils.encodeHtmlTag(this.web));

			jObject.put ("map_data", S12Constantes.rutaContenidoAdjunto(this.getIdioma(), 
					S12EstacionesTransporte.TIPO_RECURSO, Integer.toString(this.getCodigoRecurso()),
					"s41MapData2.txt"));
			
		} catch (JSONException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12EstacionesTransporte::toJSONString: Exception: " + e.getMessage());
			}
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlC3(HttpServletRequest) crearSqlC3} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlC3(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12EstacionesTransporte.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EstacionesTransporte.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String tipo = request.getParameter(S12Constantes.SF_TRANSPORT_TYPE);
		if (tipo != null && !"".equals(tipo)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(tipo);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
