/*
 * Created on 20/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;


/**
 * The Class S12EnlacesCapital.
 *  
 */
public class S12EnlacesCapital implements JSONString {

	private long codigoEnlace;
	private String codigoIdioma;
	private String nombreEnlace;
	private String urlEnlace;

	/**
	 * Gets the codigo Enlace.
	 *
	 * @return Returns the codigoEnlace.
	 */
	public long getCodigoEnlace() {
		return this.codigoEnlace;
	}

	/**
	 * Sets the codigo enlace.
	 *
	 * @param codigoEnlace the codigo enlace
	 */
	public void setCodigoEnlace(long codigoEnlace) {
		this.codigoEnlace = codigoEnlace;
	}

	/**
	 * Gets the codigo idioma.
	 *
	 * @return Returns the codigoIdioma.
	 */
	public String getIdioma() {
		return this.codigoIdioma;
	}

	/**
	 * Sets the codigo idioma.
	 *
	 * @param codigoIdioma the codigo idioma
	 */
	public void setIdioma(String codigoIdioma) {
		this.codigoIdioma = codigoIdioma;
	}

	/**
	 * Gets the nombre enlace.
	 *
	 * @return Returns the nombreEnlace.
	 */
	public String getNombreEnlace() {
		return this.nombreEnlace;
	}

	/**
	 * Sets the nombre enlace.
	 *
	 * @param nombreEnlace The nombre enlace.
	 */
	public void setNombreEnlace(String nombreEnlace) {
		this.nombreEnlace = nombreEnlace;
	}

	/**
	 * Gets the url enlace.
	 *
	 * @return Returns the urlEnlace.
	 */
	public String getUrlEnlace() {
		return this.urlEnlace;
	}

	/**
	 * Sets the url Enlace.
	 *
	 * @param urlEnlace The url Enlace to set.
	 */
	public void setUrlEnlace(String urlEnlace) {
		this.urlEnlace = urlEnlace;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("title", S12Utils.encodeHtmlTag(this.getNombreEnlace()));
			jObject.put("external_url", this.getUrlEnlace());
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}