/*
 * Created on 05/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * The Class S12EmpresaRelacionada.
 *
 *  
 */
public class S12EmpresaRelacionada extends S12RecursoTuristico implements JSONString {

	/** The Constant SIZE_STRINGBUFFER. */
	public final static int SIZE_STRINGBUFFER = 220;

	/** The Constant TIPO_RECURSO. */
	private final static String TIPO_RECURSO = "N3";

	/** The mail. */
	private String mail;

	/** The telefono. */
	private String telefono;

	/** The direccion. */
	private String direccion;

	/** The codigoPostal. */
	private String codigoPostal;

	/** The web. */
	private String web;

	/** The town. */
	private String town;

	/** Codigo Municipio */
	private String municipioCode;
	
	/** Provincia asociado al recurso. */
	private String provincia;

	/** Descripcion foto */
	private String descFoto;

	/** Foto miniatura A */
	private String fotoA;
	
	/** Descripcion foto miniatura A */
	private String descFotoA;
	
	/** URL amigable a la localidad del recurso **/
	private String urltownamigable;

	private String especialidad;
	
	private String codigoCIE;

	/** Servicios del recurso */
	private ArrayList<String> arrServicios;
	
	/** Posici�n en el array de servicios */
	private final static int SRV_QCALIDAD = 0;
	private final static int SRV_BUENASPRACTICAS = 1;
	private final static int SRV_CLUBPRODUCTO = 2;
	private final static int SRV_QORO = 3;
	private final static int SRV_QPLATA = 4;
	private final static int SRV_ISO = 5;
	/** ECOLABEL */	
	private final static int SRV_ECOLABEL = 6;
		/** INNOVACION */	
	private final static int SRV_INNOVACION = 7;

	/**
	 * Obtiene el campo especialidad
	 *
	 * @return especialidad
	 */
	public String getEspecialidad() {
		return especialidad;
	}

	/**
	 * Establece el campo especialidad
	 * 
	 * @param especialidad especialidad
	 */
	public void setEspecialidad(String especialidad) {
		this.especialidad = especialidad;
	}

	/**
	 * Obtiene el campo codigoCIE
	 *
	 * @return codigoCIE
	 */
	public String getCodigoCIE() {
		return codigoCIE;
	}

	/**
	 * Establece el campo codigoCIE
	 * 
	 * @param codigoCIE codigoCIE
	 */
	public void setCodigoCIE(String codigoCIE) {
		this.codigoCIE = codigoCIE;
	}
	
	/**
	 * Gets the mail.
	 *
	 * @return the mail
	 */
	public String getMail() {
		return this.mail;
	}

	/**
	 * Sets the mail.
	 *
	 * @param mail the new mail
	 */
	public void setMail(String mail) {
		this.mail = mail;
	}

	/**
	 * Gets the telefono.
	 *
	 * @return the telefono
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Sets the telefono.
	 *
	 * @param telefono the new telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Gets the direccion.
	 *
	 * @return the direccion
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * Sets the direccion.
	 *
	 * @param direccion the new direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * Gets the codigoPostal.
	 *
	 * @return the codigoPostal
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * Sets the codigoPostal.
	 *
	 * @param codigopostal the codigopostal
	 */
	public void setCodigoPostal(String codigopostal) {
		this.codigoPostal = codigopostal;
	}

	/**
	 * Gets the web.
	 *
	 * @return the web
	 */
	public String getWeb() {
		return this.web;
	}

	/**
	 * Sets the web.
	 *
	 * @param web the new web
	 */
	public void setWeb(String web) {
		this.web = web;
	}

	/**
	 * Gets the town.
	 *
	 * @return the town
	 */
	public String getTown() {
		return this.town;
	}

	/**
	 * Sets the town.
	 *
	 * @param town the new town
	 */
	public void setTown(String town) {
		this.town = town;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	public String getProvincia() {
		return provincia;
	}

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}

	
	/**
	 * Obtiene el campo fotoA
	 *
	 * @return fotoA
	 */
	public String getFotoA() {
		return fotoA;
	}

	/**
	 * Establece el campo fotoA
	 * 
	 * @param fotoA fotoA
	 */
	public void setFotoA(String fotoA) {
		this.fotoA = fotoA;
	}

	/**
	 * Obtiene el campo descFotoA
	 *
	 * @return descFotoA
	 */
	public String getDescFotoA() {
		return descFotoA;
	}

	/**
	 * Establece el campo descFotoA
	 * 
	 * @param descFotoA descFotoA
	 */
	public void setDescFotoA(String descFotoA) {
		this.descFotoA = descFotoA;
	}
	/**
	 * Obtiene el campo urltownamigable
	 *
	 * @return urltownamigable
	 */
	public String getUrlTownAmigable() {
		return urltownamigable;
	}

	/**
	 * Establece el campo urltownamigable
	 * 
	 * @param urltownamigable urltownamigable
	 */
	public void setUrlTownAmigable(String urltownamigable) {
		this.urltownamigable = urltownamigable;
	}

	/**
	 * Retorna el valor del campo arrServicios.
	 *
	 * @return arrServicios del recurso
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * Establece el valor del campo arrServicios.
	 *
	 * @param arrServicios del recurso.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}
	
	/**
	 * Crear meta data n3.
	 *
	 * @param request the request
	 *
	 * @return the list
	 */
	public static List<R01MSearchedMetaData> crearMetaDataN3(HttpServletRequest request) {
		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();
		
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12EmpresaRelacionada.TIPO_RECURSO) );
		
		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
		if (nombre != null && !"".equals(nombre)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, nombre));
		}
		
		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); //ESTO HAY QUE MIRARLO
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }
		
		String tipo = request.getParameter(S12Constantes.SF_SECTOR_TYPE);
		if (tipo != null && !"".equals(tipo)) {
	    	String sectorType = "(" + tipo + ")";
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SECTOR_TYPE, R01MSearchEngineConstants.IN_OPERATOR, sectorType));
		}
		
		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
	    if (calidadQ != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_Q, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_ASSURANCE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_CLUB_PRODUCTO, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    } 
		
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Crear sql n3.
	 *
	 * @param request the request
	 *
	 * @return the string
	 * @deprecated
	 */
	public static String crearSqlN3(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12EmpresaRelacionada.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EmpresaRelacionada.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		sql.append(" LIKE '%");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		sql.append(nombre.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String sectorType = request.getParameter(S12Constantes.SF_SECTOR_TYPE);
	    if (sectorType != null && !"".equals(sectorType)) {
			String[] arrSectorType = sectorType.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrSectorType.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("'");
	  			sql.append(arrSectorType[i]);
	  			sql.append("'");
	  		}

	  		sql.append(") AND ");
		}
	    
	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE '%");
	  		sql.append(zona);
	  		sql.append("%' AND ");
		}
		
		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
		if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
		}
		
		String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }
		    
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

	/**
	 * Gets the empresa relacionada n3.
	 *
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latitud the latitud
	 * @param longitud the longitud
	 * @param numero_resultados the numero_resultados
	 * @param ultimo_resultado the ultimo_resultado
	 *
	 * @return the empresa relacionada n3
	 */
	public static String getEmpresaRelacionadaN3(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Empresas Relacionadas - N3");
			}
			S12EmpresaRelacionada[] empresasArray = portalMovilDAO.getEmpresasRelacionadas(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginaci�n.
			S12EmpresaRelacionada[] arrayOrdenado = (S12EmpresaRelacionada[])S12Utils.casarOrdenResultados(empresasArray, arrRecursos, S12EmpresaRelacionada.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12EmpresaRelacionada::getEmpresaRelacionadaN3: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12EmpresaRelacionada::getEmpresaRelacionadaN3: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Empresas Relacionadas - N3");
		}

		return sRespuesta.toString();
	}


	/**
	 * To json string.
	 *
	 * @return the string
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12EmpresaRelacionada.TIPO_RECURSO);

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EmpresaRelacionada.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}

			if (this.getFotoA() != null) {
				//excepcionalmente para listado particular
				StringBuffer urlFotoA = new StringBuffer();
				urlFotoA.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EmpresaRelacionada.TIPO_RECURSO, null));
				urlFotoA.append("images/");
				urlFotoA.append(this.getFotoA());
				
				jObject.put("imageA", urlFotoA);
				jObject.put("imageA_desc", S12Utils.encodeHtmlTag(this.getDescFotoA()));
			}
			
			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());
			jObject.put("url_town", this.getUrlTownAmigable());

			jObject.put("direction", S12Utils.encodeHtmlTag(this.getDireccion()));
			jObject.put("postal_code", this.getCodigoPostal());
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.getTown()));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("provincia", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("phone_number", this.getTelefono());
			jObject.put("mail", this.getMail());
			jObject.put("web", S12Utils.encodeHtmlTag(this.getWeb()));
			jObject.put("especialidad", S12Utils.encodeHtmlTag(this.getEspecialidad()));
			jObject.put("codigoCIE", this.getCodigoCIE());

			//servicios
			jObject.put("qualityQ", this.arrServicios.get(S12EmpresaRelacionada.SRV_QCALIDAD).toString());
			jObject.put("qualityAssurance", this.arrServicios.get(S12EmpresaRelacionada.SRV_BUENASPRACTICAS).toString());
			jObject.put("productClub", this.arrServicios.get(S12EmpresaRelacionada.SRV_CLUBPRODUCTO).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12EmpresaRelacionada.SRV_QORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12EmpresaRelacionada.SRV_QPLATA).toString());
			jObject.put("ISO", this.arrServicios.get(S12EmpresaRelacionada.SRV_ISO).toString());
			jObject.put("ECOLABEL", this.arrServicios.get(S12EmpresaRelacionada.SRV_ECOLABEL).toString());
			jObject.put("innovation", this.arrServicios.get(S12EmpresaRelacionada.SRV_INNOVACION).toString());

			jObject.put ("map_data", S12Constantes.rutaContenidoAdjunto(this.getIdioma(), 
					S12EmpresaRelacionada.TIPO_RECURSO, Integer.toString(this.getCodigoRecurso()),
					"s41MapData2.txt"));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlN3(HttpServletRequest) crearSqlN3} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlN3(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12EmpresaRelacionada.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EmpresaRelacionada.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		nombre = nombre.toUpperCase(new Locale("es", "es"));
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+nombre+"%";
	  		params.add(expresionLIKE);
	  		tiposSQL.add(Types.VARCHAR);
	    }
	    
	    String sectorType = request.getParameter(S12Constantes.SF_SECTOR_TYPE);
	    if (sectorType != null && !"".equals(sectorType)) {
			String[] arrSectorType = sectorType.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrSectorType.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("?");
	  			params.add(arrSectorType[i]);
	  			tiposSQL.add(Types.VARCHAR);
	  		}

	  		sql.append(") AND ");
		}
	    
		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}
		
		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
		if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
		}
		
		String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }
		    
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
