package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12EmpresasAlquilerDeportivo.
 *
 * Representa una Empresa de Alquiler Deportivo
 *
 *  
 */
public class S12EmpresaAlquilerDeportivo extends S12RecursoTuristico implements JSONString {

	private final static int SIZE_STRINGBUFFER = 220;
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "I31";

	/** The telefono. */
	private String telefono;
	/** Descripci�n Tel�fono */
	private String desctelefono;
	/** Tel�fono 2 */
	private String telefono2;
	/** Descripci�n Tel�fono 2 */
	private String desctelefono2;

	/** Direcci�n asociada al recurso I31. */
	private String direccion;

	/** Codigo postal asociado al recurso I31. */
	private String codigoPostal;

	/** Municipio asociado al recurso I31. */
	private String municipio;

	/** Codigo Municipio */
	private String municipioCode;
	
	/** Provincia asociado al recurso. */
	private String provincia;

	/** Email asociado al recurso I31. */
	private String email;

	/** Foto miniatura A */
	private String fotoA;
	
	/** Descripcion foto miniatura A */
	private String descFotoA;

	/** Web asociada al recurso I31. */
	private String web;

	/** Material alquilable */
	private String material;
	
	/** Actividades */
	private String actividades;
	
	/** URL amigable a la localidad del recurso **/
	private String urltownamigable; 
	
	/** Servicios */
	private ArrayList<String> arrServicios;

	/** Posici�n en el array de servicios */
		/** Buenas pr�cticas */
	private final static int SRV_BUENASPRACTICAS = 0;
		/** Surfing */
	private final static int SRV_SURFING = 1;
		/** Q de Oro */	
	private final static int SRV_QORO = 2;
		/** Q de Plata */	
	private final static int SRV_QPLATA = 3;
		/** ISO */	
	private final static int SRV_ISO = 4;
		/** INNOVACION */	
	private final static int SRV_INNOVACION = 5;
		
	/**
	 * Constructor.
	 */
	public S12EmpresaAlquilerDeportivo() {
	}

	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}
	/**
	 * @param desctelefono Establece el valor del campo telefono.
	 */
	public void setDescTelefono(String desctelefono) {
		this.desctelefono = desctelefono;
	}
	public String getProvincia() {
		return provincia;
	}

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getDescTelefono() {
		return this.desctelefono;
	}
	/**
	 * @param telefono2 Establece el valor del campo telefono.
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono2() {
		return this.telefono2;
	}
	/**
	 * @param desctelefono2 Establece el valor del campo telefono.
	 */
	public void setDescTelefono2(String desctelefono2) {
		this.desctelefono2 = desctelefono2;
	}
	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getDescTelefono2() {
		return this.desctelefono2;
	}

	/**
	 * @return Retorna el valor del campo direccion.
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * @param direccion Establece el valor del campo direccion.
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * @return Retorna el valor del campo codigoPostal.
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * @param codigoPostal Establece el valor del campo codigoPostal.
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	/**
	 * @return Retorna el valor del campo email.
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @param email Establece el valor del campo email.
	 */
	public void setEmail(String email) {
		this.email = email;
	}


	/**
	 * Obtiene el campo fotoA
	 *
	 * @return fotoA
	 */
	public String getFotoA() {
		return fotoA;
	}

	/**
	 * Establece el campo fotoA
	 * 
	 * @param fotoA fotoA
	 */
	public void setFotoA(String fotoA) {
		this.fotoA = fotoA;
	}

	/**
	 * Obtiene el campo descFotoA
	 *
	 * @return descFotoA
	 */
	public String getDescFotoA() {
		return descFotoA;
	}

	/**
	 * Establece el campo descFotoA
	 * 
	 * @param descFotoA descFotoA
	 */
	public void setDescFotoA(String descFotoA) {
		this.descFotoA = descFotoA;
	}
	
	
	/**
	 * @return Retorna el valor del campo web.
	 */
	public String getWeb() {
		return this.web;
	}

	/**
	 * @param web Establece el valor del campo web.
	 */
	public void setWeb(String web) {
		this.web = web;
	}

	/**
	 * @return Retorna el valor del campo material.
	 */
	public String getMaterial() {
		return this.material;
	}

	/**
	 * @param material Establece el valor del campo material.
	 */
	public void setMaterial(String material) {
		this.material = material;
	}

	/**
	 * @return Retorna el valor del campo actividades.
	 */
	public String getActividades() {
		return this.actividades;
	}

	/**
	 * @param actividades Establece el valor del campo actividades.
	 */
	public void setActividades(String actividades) {
		this.actividades = actividades;
	}

	/**
	 * Obtiene el campo urltownamigable
	 *
	 * @return urltownamigable
	 */
	public String getUrlTownAmigable() {
		return urltownamigable;
	}

	/**
	 * Establece el campo urltownamigable
	 * 
	 * @param urltownamigable urltownamigable
	 */
	public void setUrlTownAmigable(String urltownamigable) {
		this.urltownamigable = urltownamigable;
	}

	/**
	 * @return Retorna el valor del campo arrServicios.
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * @param arrServicios Establece el valor del campo arrServicios.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}
	
	/**
	 * Funci�n que crea los metadatos para recursos de tipo I31.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataI31(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12EmpresaAlquilerDeportivo.TIPO_RECURSO));
    
	    String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY,R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE,R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }
	
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funci�n que crea la sql de consulta para recursos de tipo I31.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlI31(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12EmpresaAlquilerDeportivo.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EmpresaAlquilerDeportivo.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }


		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funci�n para obtener la lista de recursos de Empresa de Alquiler Deportivo.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de Empresa de Alquiler Deportivo
	 */
	public static String getEmpresasAlquilerDeportivoI31(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Empresa de Alquiler Deportivo - I31");
			}
			S12EmpresaAlquilerDeportivo[] empresasAlqDepArray = portalMovilDAO.getEmpresasAlquilerDeportivo(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginaci�n.
			S12EmpresaAlquilerDeportivo[] arrayOrdenado = (S12EmpresaAlquilerDeportivo[])S12Utils.casarOrdenResultados(empresasAlqDepArray, arrRecursos, S12EmpresaAlquilerDeportivo.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12EmpresasAlquilerDeportivo::getEmpresasAlquilerDeportivoI31: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12EmpresasAlquilerDeportivo::getEmpresasAlquilerDeportivoI31: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Empresa de Alquiler Deportivo - I31");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementaci�n de la serializaci�n JSON del objeto
	 *
	 * @return Serializaci�n JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12EmpresaAlquilerDeportivo.TIPO_RECURSO);

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EmpresaAlquilerDeportivo.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.getDescFoto()));
			}
			
			//excepcionalmente para listado particular
			if (this.getFotoA() != null) {
				StringBuffer urlFotoA = new StringBuffer();
				urlFotoA.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12EmpresaAlquilerDeportivo.TIPO_RECURSO, null));
				urlFotoA.append("images/");
				urlFotoA.append(this.getFotoA());
				jObject.put("imageA", urlFotoA);
				jObject.put("imageA_desc", S12Utils.encodeHtmlTag(this.getDescFotoA()));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());
			jObject.put("url_town", this.getUrlTownAmigable());

			jObject.put("direction", S12Utils.encodeHtmlTag(this.getDireccion()));
			jObject.put("postal_code", this.getCodigoPostal());
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.getMunicipio()));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("provincia", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("phone_number", this.telefono);
			jObject.put("phone_desc", this.desctelefono);
			jObject.put("phone_number_2", this.telefono2);
			jObject.put("phone_desc_2", this.desctelefono2);
			jObject.put("mail", this.getEmail());
			jObject.put("web", S12Utils.encodeHtmlTag(this.getWeb()));
			jObject.put("material", S12Utils.encodeHtmlTag(this.getMaterial()));
			jObject.put("activities", S12Utils.encodeHtmlTag(this.getActividades()));

			//servicios
			jObject.put("qualityAssurance", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_BUENASPRACTICAS).toString());
			jObject.put("surfing", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_SURFING).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_QORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_QPLATA).toString());
			jObject.put("ISO", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_ISO).toString());
			jObject.put("innovation", this.arrServicios.get(S12EmpresaAlquilerDeportivo.SRV_INNOVACION).toString());
			
			jObject.put ("map_data", S12Constantes.rutaContenidoAdjunto(this.getIdioma(), 
					S12EmpresaAlquilerDeportivo.TIPO_RECURSO, Integer.toString(this.getCodigoRecurso()),
					"s41MapData2.txt"));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlI31(HttpServletRequest) crearSqlI31} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlI31(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12EmpresaAlquilerDeportivo.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12EmpresaAlquilerDeportivo.TIPO_RECURSO);
		sql.append("' AND ");

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
