/*
 * Created on 20/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.progrExperienciales.valueObjects.S12GaleriaXml;


/**
 * The Class S12DiasProgrExperienciales.
 *  
 */
public class S12DiasProgrExperienciales implements JSONString {

	private int numDia;
	private S12GaleriaXml urlGaleriaMultimedia;
	private ArrayList<S12UnidadContenidoVI> franjaManana;
	private ArrayList<S12UnidadContenidoVI> franjaComida;
	private ArrayList<S12UnidadContenidoVI> franjaTarde;
	private ArrayList<S12UnidadContenidoVI> franjaCena;
	private ArrayList<String> codUnidadesList;

	/**
	 * Constructor.
	 */
	public S12DiasProgrExperienciales() {
	}

	/**
	 * @return Retorna el valor del campo numDia.
	 */
	public int getNumDia() {
		return this.numDia;
	}

	/**
	 * @param numDia Establece el valor del campo numDia.
	 */
	public void setNumDia(int numDia) {
		this.numDia = numDia;
	}

	/**
	 * @return Retorna el valor del campo urlGaleriaMultimedia.
	 */
	public S12GaleriaXml getUrlGaleriaMultimedia() {
		return this.urlGaleriaMultimedia;
	}

	/**
	 * @param urlGaleriaMultimedia Establece el valor del campo urlGaleriaMultimedia.
	 */
	public void setUrlGaleriaMultimedia(S12GaleriaXml urlGaleriaMultimedia) {
		this.urlGaleriaMultimedia = urlGaleriaMultimedia;
	}

	/**
	 * Gets the franja manana.
	 *
	 * @return Retorna el valor del campo franjaManana.
	 */
	public ArrayList<S12UnidadContenidoVI> getFranjaManana() {
		return this.franjaManana;
	}

	/**
	 * Sets the franja manana.
	 *
	 * @param franjaManana the franja manana
	 */
	public void setFranjaManana(ArrayList<S12UnidadContenidoVI> franjaManana) {
		this.franjaManana = franjaManana;
	}

	/**
	 * @return Retorna el valor del campo franjaComida.
	 */
	public ArrayList<S12UnidadContenidoVI> getFranjaComida() {
		return this.franjaComida;
	}

	/**
	 * @param franjaComida Establece el valor del campo franjaComida.
	 */
	public void setFranjaComida(ArrayList<S12UnidadContenidoVI> franjaComida) {
		this.franjaComida = franjaComida;
	}

	/**
	 * @return Retorna el valor del campo franjaTarde.
	 */
	public ArrayList<S12UnidadContenidoVI> getFranjaTarde() {
		return this.franjaTarde;
	}

	/**
	 * @param franjaTarde Establece el valor del campo franjaTarde.
	 */
	public void setFranjaTarde(ArrayList<S12UnidadContenidoVI> franjaTarde) {
		this.franjaTarde = franjaTarde;
	}

	/**
	 * @return Retorna el valor del campo franjaCena.
	 */
	public ArrayList<S12UnidadContenidoVI> getFranjaCena() {
		return this.franjaCena;
	}

	/**
	 * @param franjaCena Establece el valor del campo franjaCena.
	 */
	public void setFranjaCena(ArrayList<S12UnidadContenidoVI> franjaCena) {
		this.franjaCena = franjaCena;
	}

	/**
	 * @return Retorna el valor del campo codUnidadesList.
	 */
	public ArrayList<String> getCodUnidadesList() {
		return this.codUnidadesList;
	}

	/**
	 * @param codUnidadesList Establece el valor del campo codUnidadesList.
	 */
	public void setCodUnidadesList(ArrayList<String> codUnidadesList) {
		this.codUnidadesList = codUnidadesList;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("dia_num", this.getNumDia());

			jObject.put("media", this.getUrlGaleriaMultimedia());

			jObject.put("manana", new JSONArray(this.getFranjaManana()));

			jObject.put("comida", new JSONArray(this.getFranjaComida()));

			jObject.put("tarde", new JSONArray(this.getFranjaTarde()));

			jObject.put("cena", new JSONArray(this.getFranjaCena()));

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

}