package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Deportes.
 *
 * Representa un Deporte
 *
 *  
 */
public class S12Deportes extends S12RecursoTuristico implements JSONString {

	/** The Constant SIZE_STRINGBUFFER. */
	private final static int SIZE_STRINGBUFFER = 220;
	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "I2";

	/** Nombre de la provincia */
	private String provincia;
	
	/** Cdigo de la provincia */
	private String provinciaCode;
	
	/** Municipio asociado al recurso I2. */
	private String municipio;

	/** Codigo Municipio */
	private String municipioCode;

	/** Localidad del recurso */
	private String localidad;
	
	/** Subtipo asociado al recurso I2. */
	private String subTipo;
	
	/**	Ruta de la imagen para el buscador de puertos deportivos */
	private String fotoPuertos;

	/** Descripcion foto para el buscador de puertos deportivos */
	private String descFotoPuertos;
	
	/**
	 * Constructor.
	 */
	public S12Deportes() {
	}

	public String getProvincia() {
		return provincia;
	}

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	public String getProvinciaCode() {
		return provinciaCode;
	}

	public void setProvinciaCode(String provinciaCode) {
		this.provinciaCode = provinciaCode;
	}

	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	/**
	 * @return Retorna el valor del campo localidad.
	 */
	public String getLocalidad() {
		return this.localidad;
	}

	/**
	 * @param localidad Establece el valor del campo localidad.
	 */
	public void setLocalidad(String localidad) {
		this.localidad = localidad;
	}
	
	/**
	 * @return the subTipo
	 */
	public String getSubTipo() {
		return subTipo;
	}


	/**
	 * @param subTipo the subTipo to set
	 */
	public void setSubTipo(String subTipo) {
		this.subTipo = subTipo;
	}

	/**
	 * Retorna el valor del campo fotoPuertos.
	 *
	 * @return Ruta de la imagen del recurso para buscador de puertos deportivos
	 */
	public String getFotoPuertos() {
		return this.fotoPuertos;
	}

	/**
	 * Establece el valor del campo fotoPuertos.
	 *
	 * @param fotoPuertos Ruta de la imagen del recurso para buscador de puertos deportivos
	 */
	public void setFotoPuertos(String fotoPuertos) {
		this.fotoPuertos = fotoPuertos;
	}

	/**
	 * @return Retorna el valor del campo descFotoPuertos.
	 */
	public String getDescFotoPuertos() {
		return this.descFotoPuertos;
	}
	
	/**
	 * @param descFoto Establece el valor del campo descFotoPuertos.
	 */
	public void setDescFotoPuertos(String descFotoPuertos) {
		this.descFotoPuertos = descFotoPuertos;
	}
	
	/**
	 * Funcin que crea los metadatos para recursos de tipo I2.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataI2(HttpServletRequest request){

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		// Se establece el templateType
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Deportes.TIPO_RECURSO));
	    
	    String sportType = request.getParameter(S12Constantes.SF_SPORT_TYPE);
		if (sportType != null && !"".equals(sportType)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SPORT_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, sportType));
		}
		
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }
	    
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funcin que crea la sql de consulta para recursos de tipo I2.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlI2(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Deportes.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Deportes.TIPO_RECURSO);
		sql.append("' AND ");
		
		String sportType = request.getParameter(S12Constantes.SF_SPORT_TYPE);
		if (sportType != null && !"".equals(sportType)) {
			sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" = '");
	  		sql.append(sportType);
	  		sql.append("' AND ");
		}
		
		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE '%");
	  		sql.append(zona);
	  		sql.append("%' AND ");
		}

		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}


	/**
	 * Funcin para obtener la lista de recursos de Deportes.
	 *
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de Deportes
	 */
	public static String getDeportesI2(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Deportes - I2");
			}
			S12Deportes[] deportesArray = portalMovilDAO.getDeportes(arrRecursos, idioma, latitud, longitud);
			//corregimos el ORDER en base a la paginacin.
			S12Deportes[] arrayOrdenado = (S12Deportes[])S12Utils.casarOrdenResultados(deportesArray, arrRecursos, S12Deportes.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Deportes::getDeportesI2: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12Deportes::getDeportesI2: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Deportes - I2");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {

			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));

			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Deportes.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.getDescFoto()));
			}

			if (this.getFotoPuertos() != null) {
				StringBuffer urlFotoPuertos = new StringBuffer();
				urlFotoPuertos.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Deportes.TIPO_RECURSO, null));
				urlFotoPuertos.append("images/");
				urlFotoPuertos.append(this.getFotoPuertos());

				jObject.put("imageH6", urlFotoPuertos);
				jObject.put("image_descH6", S12Utils.encodeHtmlTag(this.getDescFotoPuertos()));
			}
			
			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());

			jObject.put("historicTerritory", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("historicTerritoryCode", this.provinciaCode);
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.getMunicipio()));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("locality", S12Utils.encodeHtmlTag(this.localidad));
			jObject.put("type", S12Deportes.TIPO_RECURSO);
			jObject.put("subtype", this.subTipo);

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlI2(HttpServletRequest) crearSqlI2} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlI2(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Deportes.SIZE_STRINGBUFFER);

		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Deportes.TIPO_RECURSO);
		sql.append("' AND ");
		
		String sportType = request.getParameter(S12Constantes.SF_SPORT_TYPE);
		if (sportType != null && !"".equals(sportType)) {
			sql.append(S12Constantes.PM_TYPE);
			sql.append(" = ? AND ");
			params.add(sportType);
			tiposSQL.add(Types.VARCHAR);
		}
		
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
