package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * Clase S12Alojamiento.
 *
 * Representa un Alojamiento
 *
 *  
 */
public class S12Alojamiento extends S12RecursoTuristico implements JSONString {

	/** Tipo de recurso */
	public final static String TIPO_RECURSO = "A1";
	
	private final static int SIZE_STRINGBUFFER = 220;

	/** Valor usado en comprobaciones de paginaci�n */
	private int rowNum;
	
	/** Subtipo asociado al recurso A1. */
	private String subTipo;

	/** Nombre del Subtipo asociado al recurso A1. */
	private String nombreSubTipo;

	/** Tel�fono del alojamiento */
	private String telefono;

	/** Tel�fono del alojamiento */
	private String desctelefono;
	
	/** Tel�fono del alojamiento */
	private String telefono2;

	/** Tel�fono del alojamiento */
	private String desctelefono2;
	
	/** Nombre de la provincia del alojamiento */
	private String provincia;
	
	/** C�digo de la provincia del alojamiento */
	private String provinciaCode;
	
	/** Municipio del alojamiento */
	private String municipio;
	
	/** Codigo Municipio */
	private String municipioCode;

	/** Localidad del alojamiento */
	private String localidad;
	
	/** Codigo Localidad del alojamiento */
	private String localidadCode;

	/** Servicios del alojamiento */
	private ArrayList<String> arrServicios;
	
	/** Categor�a del alojamiento */
	private String categoria;
	
	/** Direcci�n del alojamiento */
	private String direccion;
	
	/** Email del alojamiento */
	private String email;
	
	/** Web del alojamiento */
	private String web;
	
	/** C�digo Postal del alojamiento */
	private String codigoPostal;

	/** Modalidad asociado al recurso A1. */
	private String modalidad;
	
	/** Posici�n en el array de servicios */
		/** Q de calidad */	
	private final static int SRV_QCALIDAD = 0;
		/** Accesibilidad */
	private final static int SRV_ACCESIBILIDAD = 1;
		/** Buenas pr�cticas */
	private final static int SRV_BUENASPRACTICAS = 2;
		/** Surfing */
	private final static int SRV_SURFING = 3;
		/** 50BEST */
	private final static int SRV_50BEST = 4;
		/** Club de Producto */
	private final static int SRV_CLUBPRODUCTO = 5;
		/** Q de Oro */	
	private final static int SRV_QORO = 6;
		/** Q de Plata */	
	private final static int SRV_QPLATA = 7;
		/** ISO */	
	private final static int SRV_ISO = 8;
		/** ECOLABEL */	
	private final static int SRV_ECOLABEL = 9;
		/** innovation */	
	private final static int SRV_INNOVACION = 10;
	

	/**
	 * Constructor.
	 */
	public S12Alojamiento() {
	}

	/**
	 * @return Retorna el valor del campo subTipo.
	 */
	public String getSubTipo() {
		return this.subTipo;
	}

	/**
	 * @param subTipo Establece el valor del campo subTipo.
	 */
	public void setSubTipo(String subTipo) {
		this.subTipo = subTipo;
	}

	/**
	 * Obtiene el campo modalidad
	 *
	 * @return modalidad
	 */
	public String getModalidad() {
		return modalidad;
	}

	/**
	 * Establece el campo modalidad
	 * 
	 * @param modalidad modalidad
	 */
	public void setModalidad(String modalidad) {
		this.modalidad = modalidad;
	}

	/**
	 * Obtiene el campo rowNum
	 *
	 * @return rowNum
	 */
	public int getRowNum() {
		return rowNum;
	}

	/**
	 * Establece el campo rowNum
	 * 
	 * @param rowNum rowNum
	 */
	public void setRowNum(int rowNum) {
		this.rowNum = rowNum;
	}

	/**
	 * @return Retorna el valor del campo nombreSubTipo.
	 */
	public String getNombreSubTipo() {
		return this.nombreSubTipo;
	}

	/**
	 * @param nombreSubTipo Establece el valor del campo nombreSubTipo.
	 */
	public void setNombreSubTipo(String nombreSubTipo) {
		this.nombreSubTipo = nombreSubTipo;
	}

	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * @param desctelefono Establece el valor del campo descripcion telefono.
	 */
	public void setDescTelefono(String desctelefono) {
		this.desctelefono = desctelefono;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono.
	 */
	public String getDescTelefono() {
		return this.desctelefono;
	}

	/**
	 * @param telefono Establece el valor del campo telefono2.
	 */
	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}

	/**
	 * @return Retorna el valor del campo telefono2.
	 */
	public String getTelefono2() {
		return this.telefono2;
	}

	/**
	 * @param desctelefono Establece el valor del campo descripcion telefono2.
	 */
	public void setDescTelefono2(String desctelefono2) {
		this.desctelefono2 = desctelefono2;
	}


	/**
	 * @return Retorna el valor del campo descripcion telefono2.
	 */
	public String getDescTelefono2() {
		return this.desctelefono2;
	}

	/**
	 * @return Retorna el valor del campo municipio.
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * @param municipio Establece el valor del campo municipio.
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * @return Retorna el valor del campo localidad.
	 */
	public String getLocalidad() {
		return this.localidad;
	}

	/**
	 * @param localidad Establece el valor del campo localidad.
	 */
	public void setLocalidad(String localidad) {
		this.localidad = localidad;
	}
	
	/**
	 * @return Retorna el valor del campo localidadCode.
	 */
	public String getLocalidadCode() {
		return this.localidadCode;
	}

	/**
	 * @param localidadCode Establece el valor del campo localidadCode.
	 */
	public void setLocalidadCode(String localidadCode) {
		this.localidadCode = localidadCode;
	}

	/**
	 * @return Retorna el valor del campo arrServicios.
	 */
	public ArrayList<String> getArrServicios() {
		return this.arrServicios;
	}

	/**
	 * @param arrServicios Establece el valor del campo arrServicios.
	 */
	public void setArrServicios(ArrayList<String> arrServicios) {
		this.arrServicios = arrServicios;
	}
	
	/**
	 * @return Retorna el valor del campo categoria
	 */
	public String getCategoria() {
		return this.categoria;
	}

	/**
	 * @param categoria Establece el valor del campo categoria
	 */
	public void setCategoria(String categoria) {
		this.categoria = categoria;
	}
	
	
	public String getProvincia() {
		return provincia;
	}

	public void setProvincia(String provincia) {
		this.provincia = provincia;
	}

	public String getProvinciaCode() {
		return provinciaCode;
	}

	public void setProvinciaCode(String provinciaCode) {
		this.provinciaCode = provinciaCode;
	}

	/**
	 * @return the municipioCode
	 */
	public String getMunicipioCode() {
		return municipioCode;
	}

	/**
	 * @param municipioCode the municipioCode to set
	 */
	public void setMunicipioCode(String municipioCode) {
		this.municipioCode = municipioCode;
	}
	
	/**
	 * Obtiene el campo direccion
	 *
	 * @return direccion
	 */
	public String getDireccion() {
		return direccion;
	}

	/**
	 * Establece el campo direccion
	 * 
	 * @param direccion direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}
	
	/**
	 * Obtiene el campo email
	 *
	 * @return email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * Establece el campo email
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo web
	 *
	 * @return web
	 */
	public String getWeb() {
		return web;
	}

	/**
	 * Establece el campo web
	 * 
	 * @param web web
	 */
	public void setWeb(String web) {
		this.web = web;
	}

	/**
	 * Obtiene el campo codigoPostal
	 *
	 * @return codigoPostal
	 */
	public String getCodigoPostal() {
		return codigoPostal;
	}

	/**
	 * Establece el campo codigoPostal
	 * 
	 * @param codigoPostal codigoPostal
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * Funci�n que crea los metadatos para recursos de tipo A1.
	 *
	 * @param request request
	 *
	 * @return lista de metadatos
	 */
	public static List<R01MSearchedMetaData> crearMetaDataA1(HttpServletRequest request) {

		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Alojamiento.TIPO_RECURSO) );

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
		if (nombre != null && !"".equals(nombre)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, nombre));
		}

		String alojamientoTipo = request.getParameter(S12Constantes.SF_LODGING_TYPE);
		if (alojamientoTipo != null && !"".equals(alojamientoTipo)) {
	    	String lodgingType = "(" + alojamientoTipo + ")";
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_LODGING_TYPE, R01MSearchEngineConstants.IN_OPERATOR, lodgingType));

    		//Solo cogemos la categoria si existe el tipo de Alojamiento
    		String categoria = request.getParameter(S12Constantes.SF_CATEGORY);
    		if (categoria != null && !"".equals(categoria)) {
    			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_CATEGORY, R01MSearchEngineConstants.EQUALS_OPERATOR, categoria));
    		}
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); //ESTO HAY QUE MIRARLO
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MUNICIPALITY_CODE, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    
    	String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
	    if (calidadQ != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_Q, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }

	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ACCESIBILITY, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	
	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_QUALITY_ASSURANCE, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    

	/*    String ecoLabel = request.getParameter(S12Constantes.SF_ECOLABEL);
	    if (ecoLabel != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ECOLABEL, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
*/
	    String room = request.getParameter(S12Constantes.SF_ROOM);
	    if (room != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_ROOM, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String surfing = request.getParameter(S12Constantes.SF_SURFING);
	    if (surfing != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_SURFING, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_CLUB_PRODUCTO, R01MSearchEngineConstants.EQUALS_OPERATOR, "1"));
	    }
	    
		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Funci�n que crea la sql de consulta para recursos de tipo A1.
	 *
	 * @param request request
	 *
	 * @return sql de consulta
	 * @deprecated
	 */
	public static String crearSqlA1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Alojamiento.SIZE_STRINGBUFFER);
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Alojamiento.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		sql.append(" LIKE '%");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		sql.append(nombre.toUpperCase(new Locale("es", "es")));
	  		sql.append("%' AND ");
	    }

		String alojamientoTipo = request.getParameter(S12Constantes.SF_LODGING_TYPE);
		if (alojamientoTipo != null && !"".equals(alojamientoTipo)) {
			String[] arrAlojamientoTipo = alojamientoTipo.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrAlojamientoTipo.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("'");
	  			sql.append(arrAlojamientoTipo[i]);
	  			sql.append("'");
	  		}

	  		sql.append(") AND ");

	  		//Solo cogemos la categoria si existe el tipo de Alojamiento
	  		String categoria = request.getParameter(S12Constantes.SF_CATEGORY);
			if (categoria != null && !"".equals(categoria)) {
				sql.append(S12Constantes.PM_CATEGORY);
				sql.append(" = '");
				sql.append(categoria);
				sql.append("' AND ");
			}
		}
		
		String modalidad = request.getParameter(S12Constantes.SF_MODALIDAD);
		if(modalidad != null && !"".equalsIgnoreCase(modalidad)){
			sql.append(S12Constantes.PM_MODALIDAD);
			sql.append(" = '");
			sql.append(modalidad);
			sql.append("' AND ");
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		sql.append(municipality.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipalityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localityCode.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    
				String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		locality = S12Utils.utf8toIso88591(locality);
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(locality.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE '%");
	  		sql.append(zona);
	  		sql.append("%' AND ");
		}

		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
		if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
		}

	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String surfing = request.getParameter(S12Constantes.SF_SURFING);
	    if (surfing != null  && !"0".equals(surfing)) {
	    	sql.append(S12Constantes.PM_SURFING);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }

	 /*   String ecolLabel = request.getParameter(S12Constantes.SF_ECOLABEL);
	    if (ecolLabel != null) {
	    	sql.append(S12Constantes.PM_ECOLABEL);
	  		sql.append(" IS NOT NULL AND ");
	    }
*/
	    String room = request.getParameter(S12Constantes.SF_ROOM);
	    if (room != null) {
	    	sql.append(S12Constantes.PM_ROOM);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    
		sql.append(" LANGUAGE = '");
		sql.append(request.getParameter("language"));
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");
	    
	    S12Utils.trazaLarga(S12Alojamiento.COMPONENTE, Q70TraceLevel.DEBUG, "crearSqlA1 = "+sql.toString());
		return sql.toString();
	}


	/**
	 * Funci�n para obtener la lista de alojamientos.
	 *
	 * @param arrRecursos Lista de c�digos de recurso.
	 * @param idioma idioma
	 * @param latitud latitud
	 * @param longitud longitud
	 * @param numero_resultados numero_resultados
	 * @param ultimo_resultado ultimo_resultado
	 *
	 * @return lista de recursos de alojamientos
	 */
	public static String getAlojamientosA1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado, double distanciaMax) {
		StringBuffer sRespuesta = new StringBuffer();

		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		try {
			
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Alojamientos - A1");
			}

			S12Alojamiento[] alojamientoArray = portalMovilDAO.getAlojamientos(arrRecursos, idioma, latitud, longitud, numero_resultados, ultimo_resultado, distanciaMax);
			//corregimos el ORDER en base a la paginaci�n.
			S12Alojamiento[] arrayOrdenado = (S12Alojamiento[])S12Utils.casarOrdenResultados(alojamientoArray, arrRecursos, S12Alojamiento.class);
			
			try {
				
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
				
				
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Alojamiento::getAlojamientosA1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12Alojamiento::getAlojamientosA1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "FIN Generando JSON de Alojamientos - A1");
		}

		return sRespuesta.toString();
	}


	/**
	 * Implementaci�n de la serializaci�n JSON del objeto
	 *
	 * @return Serializaci�n JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("rowNum", Integer.toString(this.getRowNum()));
			jObject.put("id", Integer.toString(this.getCodigoRecurso()));
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12Alojamiento.TIPO_RECURSO);
			
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

			jObject.put("url_amigable", this.getUrlAmigable());
			
			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Alojamiento.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.getDescFoto()));
			}

			jObject.put("lodgingType_id", this.subTipo);
			jObject.put("lodgingType", S12Utils.encodeHtmlTag(this.nombreSubTipo));
			
			jObject.put("modalidad", this.getModalidad());
			
			// Se saca la categor�a (estrellas/llaves/categoriaCamping). La codificaci�n var�a con el tipo de alojamiento.
			jObject.put("category", this.categoria);

			// Eliminar "-" al final del n�mero de tel�fono
//OJO: ESTA LINEA ESTABA DANDO PROBLEMAS y acaba produciendo un JSONString "null"
//			jObject.put("phone_number", this.telefono.trim().replaceAll("\\s+-$", ""));			
			jObject.put("phone_number", this.telefono);
			jObject.put("phone_desc", S12Utils.encodeHtmlTag(this.desctelefono));
			jObject.put("phone_number_2", this.telefono2);
			jObject.put("phone_desc_2", S12Utils.encodeHtmlTag(this.desctelefono2));
			jObject.put("historicTerritory", S12Utils.encodeHtmlTag(this.provincia));
			jObject.put("historicTerritoryCode", this.provinciaCode);
			jObject.put("municipality", S12Utils.encodeHtmlTag(this.municipio));
			jObject.put("municipalityCode",  S12Utils.encodeHtmlTag(this.municipioCode));
			jObject.put("locality", S12Utils.encodeHtmlTag(this.localidad));
			jObject.put("localityCode",  S12Utils.encodeHtmlTag(this.localidadCode));

			//servicios
			jObject.put("qualityQ", this.arrServicios.get(S12Alojamiento.SRV_QCALIDAD).toString());
			jObject.put("accesibility", this.arrServicios.get(S12Alojamiento.SRV_ACCESIBILIDAD).toString());
			jObject.put("qualityAssurance", this.arrServicios.get(S12Alojamiento.SRV_BUENASPRACTICAS).toString());
			jObject.put("surfing", this.arrServicios.get(S12Alojamiento.SRV_SURFING).toString());
			jObject.put("best50", this.arrServicios.get(S12Alojamiento.SRV_50BEST).toString());
			jObject.put("productClub", this.arrServicios.get(S12Alojamiento.SRV_CLUBPRODUCTO).toString());
			jObject.put("Q_Oro", this.arrServicios.get(S12Alojamiento.SRV_QORO).toString());
			jObject.put("Q_Plata", this.arrServicios.get(S12Alojamiento.SRV_QPLATA).toString());
			jObject.put("ISO", this.arrServicios.get(S12Alojamiento.SRV_ISO).toString());
			jObject.put("ECOLABEL", this.arrServicios.get(S12Alojamiento.SRV_ECOLABEL).toString());
			jObject.put("innovation", this.arrServicios.get(S12Alojamiento.SRV_INNOVACION).toString());
			
			jObject.put("direction", S12Utils.encodeHtmlTag(this.direccion));
			jObject.put("mail", this.email);
			jObject.put("web",  S12Utils.encodeHtmlTag(this.web));			
			jObject.put("postal_code", this.codigoPostal);
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlA1(HttpServletRequest) crearSQLA1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlA1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Alojamiento.SIZE_STRINGBUFFER);
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Alojamiento.TIPO_RECURSO);
		sql.append("' AND ");

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		nombre = nombre.toUpperCase(new Locale("es", "es"));
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+nombre+"%";
	  		params.add(expresionLIKE);
	  		tiposSQL.add(Types.VARCHAR);
	    }

		String alojamientoTipo = request.getParameter(S12Constantes.SF_LODGING_TYPE);
		if (alojamientoTipo != null && !"".equals(alojamientoTipo)) {
			String[] arrAlojamientoTipo = alojamientoTipo.split(",");

	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" IN (");

	  		for (int i = 0; i < arrAlojamientoTipo.length; i++) {
	  			if (i != 0) {
	  				sql.append(",");
	  			}
	  			sql.append("?");
	  			params.add(arrAlojamientoTipo[i]);
	  			tiposSQL.add(Types.VARCHAR);
	  		}

	  		sql.append(") AND ");

	  		//Solo cogemos la categoria si existe el tipo de Alojamiento
	  		String categoria = request.getParameter(S12Constantes.SF_CATEGORY);
			if (categoria != null && !"".equals(categoria)) {
				sql.append(S12Constantes.PM_CATEGORY);
				sql.append(" = ? AND ");
				params.add(categoria);
				tiposSQL.add(Types.VARCHAR);
			}
		}
		
		String modalidad = request.getParameter(S12Constantes.SF_MODALIDAD);
		if(modalidad != null && !"".equalsIgnoreCase(modalidad)){
			sql.append(S12Constantes.PM_MODALIDAD);
			sql.append(" = ? AND ");
			params.add(modalidad);
			tiposSQL.add(Types.VARCHAR);
		}

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}

		String calidadQ = request.getParameter(S12Constantes.SF_QUALITY_Q);
		if (calidadQ != null) {
	    	sql.append(S12Constantes.PM_QUALITY_Q);
	  		sql.append(" IS NOT NULL AND ");
		}

	    String accesible = request.getParameter(S12Constantes.SF_ACCESIBILITY);
	    if (accesible != null) {
	    	sql.append(S12Constantes.PM_ACCESIBILITY);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String surfing = request.getParameter(S12Constantes.SF_SURFING);
	    if (surfing != null  && !"0".equals(surfing)) {
	    	sql.append(S12Constantes.PM_SURFING);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    String buenasPracticas = request.getParameter(S12Constantes.SF_QUALITY_ASSURANCE);
	    if (buenasPracticas != null) {
	    	sql.append(S12Constantes.PM_QUALITY_ASSURANCE);
	  		sql.append(" IS NOT NULL AND ");
	    }

	 /*   String ecolLabel = request.getParameter(S12Constantes.SF_ECOLABEL);
	    if (ecolLabel != null) {
	    	sql.append(S12Constantes.PM_ECOLABEL);
	  		sql.append(" IS NOT NULL AND ");
	    }
*/
	    String room = request.getParameter(S12Constantes.SF_ROOM);
	    if (room != null) {
	    	sql.append(S12Constantes.PM_ROOM);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }
	    
		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");
	    
	    S12Utils.trazaLarga(S12Alojamiento.COMPONENTE, Q70TraceLevel.DEBUG, "crearSqlA1 = "+sql.toString());
		return sql.toString();
	}
}
