/*
 * Created on 01/03/2013
 *
 */
package s12.portalMovil.valueObjects;

import java.sql.Types;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * The Class S12Agenda.
 *
 *  
 */
public class S12Agenda extends S12RecursoTuristico implements JSONString {

	/** The Constant TIPO_RECURSO. */
	public final static String TIPO_RECURSO = "M1";

	private final static int SIZE_STRINGBUFFER = 220;

	/** The municipio. */
	private String municipio;

	/** The fechas. */
	private String fechas;

	/** The fecha inicio. */
	private String fechaInicio;

	/** The fechafin. */
	private String fechaFin;
	
	/** Id del tipo de evento */
	private String tipo;

	/** Nombre del tipo de evento */
	private String nombreTipo;

	/** Descripcion foto */
	private String descFoto;
	
	/** Nombre de la foto de la miniatura B */
	private String imageB;
	
	/** Fecha orientativa */
	private String fechaOrientativa;

	/**
	 * Gets the municipio.
	 *
	 * @return the municipio
	 */
	public String getMunicipio() {
		return this.municipio;
	}

	/**
	 * Sets the municipio.
	 *
	 * @param municipio the new municipio
	 */
	public void setMunicipio(String municipio) {
		this.municipio = municipio;
	}

	/**
	 * Gets the fechas.
	 *
	 * @return the fechas
	 */
	public String getFechas() {
		return this.fechas;
	}

	/**
	 * Sets the fechas.
	 *
	 * @param fechas the new fechas
	 */
	public void setFechas(String fechas) {
		this.fechas = fechas;
	}

	/**
	 * Gets the fecha inicio.
	 *
	 * @return the fecha inicio
	 */
	public String getFechaInicio() {
		return this.fechaInicio;
	}

	/**
	 * Sets the fecha inicio.
	 *
	 * @param fechaInicio the new fecha inicio
	 */
	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	/**
	 * Gets the fechaFin.
	 *
	 * @return the fechaFin
	 */
	public String getFechaFin() {
		return this.fechaFin;
	}

	/**
	 * Sets the fechaFin.
	 *
	 * @param fechaFin the new fechaFin
	 */
	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	/**
	 * @return Retorna el valor del campo tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * @param tipo Establece el valor del campo tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * @return Retorna el valor del campo nombreTipo
	 */
	public String getNombreTipo() {
		return this.nombreTipo;
	}

	/**
	 * @param nombreTipo Establece el valor del campo nombreTipo
	 */
	public void setNombreTipo(String nombreTipo) {
		this.nombreTipo = nombreTipo;
	}

	/**
	 * @return Retorna el valor del campo descFoto.
	 */
	public String getDescFoto() {
		return this.descFoto;
	}

	/**
	 * @param descFoto Establece el valor del campo descFoto.
	 */
	public void setDescFoto(String descFoto) {
		this.descFoto = descFoto;
	}
	
	/**
	 * 
	 * @return nombre imagen miniatura B
	 */
	public String getImageB() {
		return imageB;
	}

	/**
	 * 
	 * @param imageB nombre imagen miniatura B
	 */
	public void setImageB(String imageB) {
		this.imageB = imageB;
	}
	
	/**
	 * @return fecha orientativa
	 */
	public String getFechaOrientativa() {
		return fechaOrientativa;
	}

	/**
	 * 
	 * @param fechaOrientativa  fecha orientativa
	 */
	public void setFechaOrientativa(String fechaOrientativa) {
		this.fechaOrientativa = fechaOrientativa;
	}

	/**
	 * Crear meta data m1.
	 *
	 * @param request the request
	 *
	 * @return the list
	 */
	public static List<R01MSearchedMetaData> crearMetaDataM1(HttpServletRequest request) {
		List<R01MSearchedMetaData> metaData = new ArrayList<R01MSearchedMetaData>();

		metaData.add(new R01MSearchedMetaData(S12Constantes.SF_TEMPLATE_TYPE,R01MSearchEngineConstants.EQUALS_OPERATOR, S12Agenda.TIPO_RECURSO));

		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
		if (nombre != null && !"".equals(nombre)) {
			metaData.add(new R01MSearchedMetaData(S12Constantes.SF_DOCUMENT_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, nombre));
		}
		
		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY); //ESTO HAY QUE MIRARLO
	    if (municipality != null && !"".equals(municipality)) {
	    	// El metadato equivalente a municipality en la familia evento es eventTownName
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_TOWN_NAME, R01MSearchEngineConstants.LIKE_OPERATOR, municipality.toUpperCase(new Locale("es","es"))));
	    }
	    
		String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_TOWN, R01MSearchEngineConstants.LIKE_OPERATOR, municipalityCode.toUpperCase(new Locale("es","es"))));
	    }
	    String tipo = request.getParameter(S12Constantes.SF_EVENT_TYPE);
			if (tipo != null && !"".equals(tipo)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_TYPE, R01MSearchEngineConstants.EQUALS_OPERATOR, tipo));
	    }

		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_MARKS, R01MSearchEngineConstants.LIKE_OPERATOR, zona));
	    }

	    String fechaFin = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if (fechaFin != null && !"".equals(fechaFin)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_SEARCH_DATE_1, R01MSearchEngineConstants.LESS_THAN_OR_EQUAL_TO_OPERATOR, S12Utils.parsearFecha(fechaFin)));
	    }

	    String fechaIni = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    if (fechaIni != null && !"".equals(fechaIni)) {
	    	metaData.add(new R01MSearchedMetaData(S12Constantes.SF_EVENT_SEARCH_DATE_2, R01MSearchEngineConstants.GREATER_THAN_OR_EQUAL_TO_OPERATOR, S12Utils.parsearFecha(fechaIni)));
	    }

		// Filtramos los recursos locales
	    metaData.add(new R01MSearchedMetaData(S12Constantes.SF_GENERAL, R01MSearchEngineConstants.EQUALS_OPERATOR, S12Constantes.GENERAL));
	
	    return metaData;
	}

	/**
	 * Crear sql m1.
	 *
	 * @param request the request
	 *
	 * @return the string
	 */
	public static String crearSqlM1(HttpServletRequest request) {
		StringBuffer sql = new StringBuffer(S12Agenda.SIZE_STRINGBUFFER);
		
		String idioma = request.getParameter("language");
		if (idioma == null || "".equals(idioma)){
			idioma = "es";
		}
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Agenda.TIPO_RECURSO);
		sql.append("' AND ");
		
		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
	    	sql.append(S12Constantes.PM_NAME);
	  		sql.append(" LIKE '%");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		sql.append(nombre);
	  		sql.append("%' AND ");
	    }

		String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
			sql.append(" LIKE '%");
			sql.append(zona);
			sql.append("%' AND ");
		}

		String municipio = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipio != null && !"".equals(municipio)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE '%");
	  		municipio = S12Utils.utf8toIso88591(municipio);
	  		sql.append(municipio.toUpperCase(new Locale("es","es")));
	  		sql.append("%' AND ");
	    }
	    
	    String municipioCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE);
	    if (municipioCode != null && !"".equals(municipioCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(municipioCode);
	  		sql.append("%' AND ");
	    }
	    
	    String localidadCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE);
	    if (localidadCode != null && !"".equals(localidadCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE '%");
	  		sql.append(localidadCode);
	  		sql.append("%' AND ");
	    }

		String localidad = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (localidad != null && !"".equals(localidad)) {
	    	if (localidadCode != null && !"".equals(localidadCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		localidad = S12Utils.utf8toIso88591(localidad);
		  		sql.append(localidad.toUpperCase(new Locale("es","es")));
		  		sql.append("%' AND ");
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE '%");
		  		localidad = S12Utils.utf8toIso88591(localidad);
		  		sql.append(localidad.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE '%");
		  		sql.append(localidad.toUpperCase(new Locale("es","es")));
		  		sql.append("%' ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
	    	}
	    }
	    String tipo = request.getParameter(S12Constantes.SF_EVENT_TYPE);
	    if (tipo != null && !"".equals(tipo)) {
	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" LIKE '%");
	  		sql.append(tipo);
	  		sql.append("%' AND ");
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    //Cuando se usa el filtro de fechas, deben venir los parmetros de ambos lmites inicial y final.
	    //Si no se cumple, se ignora.
	    String fechaIni = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    String fechaFin = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if ((fechaIni != null && !"".equals(fechaIni)) && (fechaFin != null && !"".equals(fechaFin))) {
		    //Las fechas llegan con su formato de entrada, dependiente del idioma, las transformamos para usarlas en la bsqueda (YYYYMMDD)
	    	fechaIni = S12Utils.fechaFormatoYYYYMMDD(fechaIni, idioma);
	    	fechaFin = S12Utils.fechaFormatoYYYYMMDD(fechaFin, idioma);
	    	
	    	//un evento estar dentro del periodo de bsqueda cuando:
	    	//a)uno de los lmites de bsqueda est dentro de las fechas del evento.
	    	//b)ambas fechas del evento estn dentro de los lmites de bsqueda
	  		sql.append("(");
	  		//(a)
	  		sql.append("(");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= '");
	  		sql.append(fechaIni);
//	  		sql.append(S12Utils.parsearFecha(fechaFin));
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= '");
	  		sql.append(fechaIni);
	  		sql.append("' )");
	  		sql.append(" OR ");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= '");
	  		sql.append(fechaFin);
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= '");
	  		sql.append(fechaFin);
	  		sql.append("' )");
	  		sql.append(") OR (");
	  		//(b)
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" >= '");
	  		sql.append(fechaIni);
	  		sql.append("' AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" <= '");
	  		sql.append(fechaFin);
	  		sql.append("'))");
	  		sql.append(") AND ");
	    }

		sql.append(" LANGUAGE = '");
		sql.append(idioma);
		sql.append("'");
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_DATE_FROM);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

	/**
	 * Gets the agenda m1.
	 *
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latitud the latitud
	 * @param longitud the longitud
	 * @param numero_resultados the numero_resultados
	 * @param ultimo_resultado the ultimo_resultado
	 * @param distanciaMax the distancia max
	 * 
	 * @return the agenda m1
	 */
	public static String getAgendaM1(ArrayList<String> arrRecursos, String idioma, double latitud, double longitud, int numero_resultados, int ultimo_resultado, double distanciaMax) {
		S12PortalMovilDAO portalMovilDAO = new S12PortalMovilDAO();

		StringBuffer sRespuesta = new StringBuffer();
		try {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG, "Generando JSON de Agenda - M1");
			}
			S12Agenda[] agendaArray = portalMovilDAO.getAgenda(arrRecursos, idioma, latitud, longitud, distanciaMax);
			//corregimos el ORDER en base a la paginacin.
			S12Agenda[] arrayOrdenado = (S12Agenda[])S12Utils.casarOrdenResultados(agendaArray, arrRecursos, S12Agenda.class);

			try {
				sRespuesta.append(new JSONArray(arrayOrdenado).toString());
			} catch (JSONException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR, "S12PortalMovilServlet::getAgendaM1: Exception: " + e.getMessage());
				}
				sRespuesta.append("[]");
			}

		} catch (S12PortalMovilDaoException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.ERROR,"S12PortalMovilServlet::getAgendaM1: Exception: " + e.getMessage());
			}
		}
		if (Q70Factoria.getTraza().isTraceActive()) {
			Q70Factoria.getTraza().trace(S12RecursoTuristico.COMPONENTE, Q70TraceLevel.DEBUG,"FIN Generando JSON de Agenda - M1");
		}

		return sRespuesta.toString();
	}


	/**
	 * To json string.
	 *
	 * @return the string
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("name", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("type", S12Agenda.TIPO_RECURSO);
			if (this.getDistancia() != null) {
				// Formatear la distancia con un decimal
				NumberFormat nf = NumberFormat.getNumberInstance(new Locale(this.getIdioma()));
				DecimalFormat df = (DecimalFormat) nf;
				df.applyPattern("###.#");
				
				jObject.put("distance", df.format(Double.parseDouble(this.getDistancia())));
			}

			if (this.getFotoPrincipal() != null) {
				StringBuffer urlFotoPrincipal = new StringBuffer();
				urlFotoPrincipal.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Agenda.TIPO_RECURSO, null));
				urlFotoPrincipal.append("images/");
				urlFotoPrincipal.append(this.getFotoPrincipal());

				jObject.put("image", urlFotoPrincipal);
				jObject.put("image_desc", S12Utils.encodeHtmlTag(this.descFoto));
			}
			
			if (this.getImageB() != null) {
				StringBuffer urlFotoMiniB = new StringBuffer();
				urlFotoMiniB.append(S12Utils.getURLContenido(this.getCodigoRecurso(), S12Agenda.TIPO_RECURSO, null));
				urlFotoMiniB.append("images/");
				urlFotoMiniB.append(this.getImageB());
				
				jObject.put("imageB", urlFotoMiniB);
			}			

			JSONObject jObjectLatLong = new JSONObject();
			jObjectLatLong.put("coordX", this.getGmlong());
			jObjectLatLong.put("coordY", this.getGmlat());
			jObject.put("location", jObjectLatLong);

//			jObject.put("merkur_url", S12Utils.getURLMerkur(this.getCodigoRecurso(), S12Agenda.TIPO_RECURSO, this.getUrlAmigable(), this.getIdioma()));
			jObject.put("url_amigable", this.getUrlAmigable());
			
			jObject.put("municipio", S12Utils.encodeHtmlTag(this.getMunicipio()));
			jObject.put("fechas", this.getFechas());
			
			jObject.put("eventType_id", this.tipo);
			jObject.put("eventType", S12Utils.encodeHtmlTag(this.nombreTipo));
			
			jObject.put("fechaOrientativa", S12Utils.encodeHtmlTag(this.getFechaOrientativa()));
			
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return jObject.toString();
	}

	/**
	 * Adaptacion del metodo {@link #crearSqlM1(HttpServletRequest) crearSqlM1} que parametriza la consulta para construir un PreparedStatement en el DAO
	 * @param request	request recibida del servlet, tendra los parametros a consultar
	 * @param params	array de objetos con los valores a sustituir
	 * @param tiposSQL	array de tipos SQL para usar en el PreparedStatement
	 * @return	String con la where parametrizada
	 */
	public static String prepararSqlM1(HttpServletRequest request,
			ArrayList<Object> params, ArrayList<Integer> tiposSQL) {
		StringBuffer sql = new StringBuffer(S12Agenda.SIZE_STRINGBUFFER);
		
		String idioma = request.getParameter("language");
		if (!S12Utils.esIdiomaValido(idioma)){
			idioma = "es";
		}
		
		sql.append(S12Constantes.PM_TEMPLATE_TYPE);
		sql.append(" = '");
		sql.append(S12Agenda.TIPO_RECURSO);
		sql.append("' AND ");
		
		String nombre = request.getParameter(S12Constantes.SF_DOCUMENT_NAME);
	    if (nombre != null && !"".equals(nombre)) {
        	sql.append(" UPPER(");
	    	sql.append(S12Constantes.PM_NAME);
        	sql.append(")");
	  		nombre = S12Utils.utf8toIso88591(nombre);
	  		nombre = nombre.toUpperCase(new Locale("es", "es"));
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+nombre+"%";
	  		params.add(expresionLIKE);
	  		tiposSQL.add(Types.VARCHAR);
	    }

		String municipality = request.getParameter(S12Constantes.SF_MUNICIPALITY);
	    if (municipality != null && !"".equals(municipality)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY);
	  		sql.append(" LIKE ? AND ");
	  		municipality = S12Utils.utf8toIso88591(municipality);
	  		municipality = municipality.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipality+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String municipalityCode = request.getParameter(S12Constantes.SF_MUNICIPALITY_CODE); 
	    if (municipalityCode != null && !"".equals(municipalityCode)) {
	    	sql.append(S12Constantes.PM_MUNICIPALITY_CODE);
	  		sql.append(" LIKE ? AND ");
	  		municipalityCode = municipalityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+municipalityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    String localityCode = request.getParameter(S12Constantes.SF_LOCALITY_CODE); 
	    if (localityCode != null && !"".equals(localityCode)) {
	    	sql.append(S12Constantes.PM_LOCALITY_CODE);
	  		sql.append(" LIKE ? AND ");
			localityCode = localityCode.toUpperCase(new Locale("es","es"));
	  		String expresionLIKE = "%"+localityCode+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
		String locality = request.getParameter(S12Constantes.SF_LOCALITY); 
	    if (locality != null && !"".equals(locality)) {
	  		locality = S12Utils.utf8toIso88591(locality);
	  		locality = locality.toUpperCase(new Locale("es","es"));
	    	if (localityCode != null && !"".equals(localityCode)) {
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}else{
	    		sql.append(" ( ");
		    	sql.append(S12Constantes.PM_LOCALITY);
		  		sql.append(" LIKE ? ");
		  		sql.append(" OR ");
		    	sql.append(S12Constantes.PM_MUNICIPALITY);
		  		sql.append(" LIKE ? ");
	    		sql.append(" ) ");
		  		sql.append(" AND ");
		  		String expresionLIKE = "%"+locality+"%";
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
				params.add(expresionLIKE);
				tiposSQL.add(Types.VARCHAR);
	    	}
	    }
	    String zona = request.getParameter(S12Constantes.SF_MARKS);
		if (zona != null && !"".equals(zona)) {
			sql.append(S12Constantes.PM_MARKS);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+zona+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
		}
	    String tipo = request.getParameter(S12Constantes.SF_EVENT_TYPE);
	    if (tipo != null && !"".equals(tipo)) {
	    	sql.append(S12Constantes.PM_TYPE);
	  		sql.append(" LIKE ? AND ");
	  		String expresionLIKE = "%"+tipo+"%";
			params.add(expresionLIKE);
			tiposSQL.add(Types.VARCHAR);
	    }
	    
	    String clubProducto = request.getParameter(S12Constantes.SF_CLUB_PRODUCTO);
	    if (clubProducto != null) {
	    	sql.append(S12Constantes.PM_PRODUCT_CLUB);
	  		sql.append(" IS NOT NULL AND ");
	    }

	    //Cuando se usa el filtro de fechas, deben venir los parmetros de ambos lmites inicial y final.
	    //Si no se cumple, se ignora.
	    String fechaIni = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_1);
	    String fechaFin = request.getParameter(S12Constantes.SF_EVENT_SEARCH_DATE_2);
	    if ((fechaIni != null && !"".equals(fechaIni)) && (fechaFin != null && !"".equals(fechaFin))) {
		    //Las fechas llegan con su formato de entrada, dependiente del idioma, las transformamos para usarlas en la bsqueda (YYYYMMDD)
	    	fechaIni = S12Utils.fechaFormatoYYYYMMDD(fechaIni, idioma);
	    	fechaFin = S12Utils.fechaFormatoYYYYMMDD(fechaFin, idioma);
	    	
	    	//un evento estar dentro del periodo de bsqueda cuando:
	    	//a)uno de los lmites de bsqueda est dentro de las fechas del evento.
	    	//b)ambas fechas del evento estn dentro de los lmites de bsqueda
	  		sql.append("(");
	  		//(a)
	  		sql.append("(");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" )");
	  		sql.append(" OR ");
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" <= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" >= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" )");
	  		sql.append(") OR (");
	  		//(b)
	  		sql.append("(");
	    	sql.append(S12Constantes.PM_DATE_FROM);
	  		sql.append(" >= ?");
			params.add(fechaIni);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append(" AND ");
	    	sql.append(S12Constantes.PM_DATE_TO);
	  		sql.append(" <= ?");
			params.add(fechaFin);
			tiposSQL.add(Types.VARCHAR);
	  		sql.append("))");
	  		sql.append(") AND ");
	    }

		sql.append(" LANGUAGE = ?");
		String language = request.getParameter("language");
		params.add(language);
		tiposSQL.add(Types.VARCHAR);
	    sql.append(" ORDER BY ");
	    sql.append(S12Constantes.PM_DATE_FROM);
	    sql.append(" DESC, ");
	    sql.append(S12Constantes.PM_IMPORTANCE);
	    sql.append(" ASC, ");
	    sql.append(S12Constantes.PM_NAME);
	    sql.append(" ASC ");

		return sql.toString();
	}

}
