package s12.portalMovil.dao;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

import s12.portalMovil.valueObjects.S12RecursoTuristico;

/**
 * The Class S12RecursosDefaultComparator.
 *
 *  
 */
public class S12RecursosDefaultComparator implements Comparator<S12RecursoTuristico> {

	/**
	 * @param o1 the o1
	 * @param o2 the o2
	 *
	 * @return the int
	 *
	 */
	public int compare(S12RecursoTuristico o1, S12RecursoTuristico o2) {
		Locale locale = new Locale(((S12RecursoTuristico) o1).getIdioma());

		// Se obtiene un Collator adecuado para el idioma.
		Collator comparador = Collator.getInstance(locale);

		// Se configura para que A, a y  sean iguales.
		comparador.setStrength(Collator.PRIMARY);

		return comparador.compare(o1.getNombre(), o2.getNombre());
	}
}