/*
 * Created on Feb 28, 2013
 *
 */

package s12.portalMovil.dao;

import java.util.Comparator;
import s12.portalMovil.valueObjects.S12RecursoTuristico;

/**
 * The Class S12RecursosComparator.
 *  
 */
public class S12RecursosComparator implements Comparator<S12RecursoTuristico> {

	/**
	 * @param o1 the o1
	 * @param o2 the o2
	 *
	 * @return the int
	 *
	 */
	public int compare(S12RecursoTuristico o1, S12RecursoTuristico o2) {
		if (o1.getDistancia() != null && o2.getDistancia() != null) {
			return Double.compare(Double.parseDouble(o1.getDistancia()), Double.parseDouble(o2.getDistancia()));
		} else if (o1.getDistancia() == null && o2.getDistancia() == null) {
			// si ninguno de los objetos S12RecursoTuristico tiene distancia decimos que son iguales
			return 0;
		} else if (o1.getDistancia() == null) {
			// si el primer objeto S12RecursoTuristico no tiene distancia decimos que es el mayor para mandarlo al final
			return 1;
		} else {
			// si el segundo objeto S12RecursoTuristico no tiene distancia decimos que es el mayor para mandarlo al final
			return -1;
		}

	}
}