package s12.portalMovil.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.naming.NamingException;

import s12.constantes.S12Constantes;
import s12.portalMovil.valueObjects.S12Aeropuerto;
import s12.portalMovil.valueObjects.S12Agenda;
import s12.portalMovil.valueObjects.S12Alojamiento;
import s12.portalMovil.valueObjects.S12Aquariums;
import s12.portalMovil.valueObjects.S12Artesania;
import s12.portalMovil.valueObjects.S12Casinos;
import s12.portalMovil.valueObjects.S12CentrosComerciales;
import s12.portalMovil.valueObjects.S12CentrosFormacion;
import s12.portalMovil.valueObjects.S12Circuito;
import s12.portalMovil.valueObjects.S12CompaniasTransporte;
import s12.portalMovil.valueObjects.S12Deportes;
import s12.portalMovil.valueObjects.S12Destinos;
import s12.portalMovil.valueObjects.S12DiasProgrExperienciales;
import s12.portalMovil.valueObjects.S12EmpresaAlquilerDeportivo;
import s12.portalMovil.valueObjects.S12EmpresaRelacionada;
import s12.portalMovil.valueObjects.S12EmpresaTurismoActivo;
import s12.portalMovil.valueObjects.S12EnlacesCapital;
import s12.portalMovil.valueObjects.S12EspaciosNaturales;
import s12.portalMovil.valueObjects.S12EstacionesTransporte;
import s12.portalMovil.valueObjects.S12Experiencia;
import s12.portalMovil.valueObjects.S12Localidades;
import s12.portalMovil.valueObjects.S12MercadosTradicionales;
import s12.portalMovil.valueObjects.S12Museos;
import s12.portalMovil.valueObjects.S12NoTeLoPierdas;
import s12.portalMovil.valueObjects.S12Novedad;
import s12.portalMovil.valueObjects.S12Ofertas;
import s12.portalMovil.valueObjects.S12OficinasTurismo;
import s12.portalMovil.valueObjects.S12PalacioCongreso;
import s12.portalMovil.valueObjects.S12Parking;
import s12.portalMovil.valueObjects.S12ParquesTematicosAtracciones;
import s12.portalMovil.valueObjects.S12PatrimonioCultural;
import s12.portalMovil.valueObjects.S12PlatosTipicos;
import s12.portalMovil.valueObjects.S12Playas;
import s12.portalMovil.valueObjects.S12PlazasToros;
import s12.portalMovil.valueObjects.S12Poi;
import s12.portalMovil.valueObjects.S12ProductosTierra;
import s12.portalMovil.valueObjects.S12Puertos;
import s12.portalMovil.valueObjects.S12RecintoFerial;
import s12.portalMovil.valueObjects.S12Restauracion;
import s12.portalMovil.valueObjects.S12Ruta;
import s12.portalMovil.valueObjects.S12TeatrosCines;
import s12.portalMovil.valueObjects.S12Tiendas;
import s12.portalMovil.valueObjects.S12TurismoSalud;
import s12.portalMovil.valueObjects.S12UnidadContenidoRecurso;
import s12.portalMovil.valueObjects.S12UnidadContenidoVI;
import s12.portalMovil.valueObjects.S12ViaVerde;
import s12.portalMovil.valueObjects.S12ZonasBaresPintxos;
import s12.portalMovil.valueObjects.S12ZonasTiendas;
import s12.progrExperienciales.valueObjects.S12GaleriaXml;
import s12.progrExperienciales.valueObjects.S12ImagenXml;
import s12.progrExperienciales.valueObjects.S12UnidadMultimedia;
import s12.util.S12ConnectionManager;
import s12.util.S12Utils;
import bilbofrmk.util.BLogger;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 *  
 */
public class S12PortalMovilDAO {

	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "PORTAL_MOVIL";

	/** The Constant SIZE_STRINGBUFFER. */
	private static final int SIZE_STRINGBUFFER = 220;

	private static final int DISTANCIA_DEFECTO = 50000;

	/** Programas Experienciales **/
	private final static int VIAJARCON_PAREJA = 1;
	private final static int VIAJARCON_NINOS = 2;
	private final static int VIAJARCON_AMIGOS = 3;
	private final static int INTERES_CULTURA = 1;
	private final static int INTERES_GASTRONOMIA = 2;
	private final static int INTERES_BIENESTAR = 3;
	private final static int INTERES_NATURALEZA = 4;
	private final static int INTERES_COMPRAS = 5;
	private final static int INTERES_EVENTOS = 6;

	/**
	 * Obtiene la lista de novedades que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de novedades
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Novedad[] getNovedades(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Novedad> novedadesList = new ArrayList<S12Novedad>();
		S12Novedad novedad;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT NOVEDADES.COREC, NOVEDADES.COIDIOMA, DATOS_GENERALES.NOMBRE, NOVEDADES.ENTRADA, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(NOVEDADES.COREC, NOVEDADES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(NOVEDADES.COREC, NOVEDADES.COIDIOMA) AS DEPIEFOTO, NOVEDADES.FECHA, NOVEDADES.TEMATICA, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM NOVEDADES LEFT OUTER JOIN GEOREFERENCIACION ON NOVEDADES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON NOVEDADES.COREC = POSICIONAMIENTO.COREC AND NOVEDADES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON NOVEDADES.COREC = DATOS_GENERALES.COREC AND NOVEDADES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON NOVEDADES.COREC = MULTIMEDIA.COREC AND NOVEDADES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_7).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND NOVEDADES.COIDIOMA = ? ");
			sql.append("AND NOVEDADES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(") ORDER BY FECHA DESC");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				novedad = new S12Novedad();

				novedad.setCodigoRecurso(rs.getInt("COREC"));
				novedad.setIdioma(rs.getString("COIDIOMA"));
				novedad.setNombre(rs.getString("NOMBRE"));
				novedad.setEntrada(rs.getString("ENTRADA"));
				novedad.setTematica(rs.getString("TEMATICA"));
				if (novedad.getTematica() != null && !"".equals(novedad.getTematica())) {
					novedad.setNombreTematica(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"o1." + novedad.getTematica(), novedad.getIdioma()));
				}

				if (rs.getString("FECHA") != null) {
					novedad.setFecha(S12Utils.getFechaFormateada(rs.getDate("FECHA"), idioma));
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					novedad.setFotoPrincipal(multimedia);
					novedad.setDescFoto(descMultimedia);
				} else {
					novedad.setFotoPrincipal(foto);
					novedad.setDescFoto(pieFoto);
				}

				novedad.setUrlAmigable(rs.getString("URLAMIGABLE"));

				novedad.setGmlong(rs.getString("GMLNG"));
				novedad.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& novedad.getGmlong() != null && novedad.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(novedad.getGmlat()),
							Double.parseDouble(novedad.getGmlong()), latUser, longUser);
					novedad.setDistancia(String.valueOf(distancia));
				}

				novedadesList.add(novedad);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNovedades: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getNovedades: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNovedades: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getNovedades: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNovedades: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		S12Novedad[] novedadesArray = new S12Novedad[novedadesList.size()];
		novedadesList.toArray(novedadesArray);
		return novedadesArray;
	}

	/**
	 * Obtiene la lista de parkings que cumplen los criterios.
	 * 
	 * @param idioma the idioma
	 * @param arrRecursos the arr recursos
	 * @param latUser the lat user
	 * @param longUser the long user
	 * 
	 * @return lista de parkings
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Parking[] getParkings(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Parking> parkingsList = new ArrayList<S12Parking>();
		S12Parking parking;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PARKINGS.COREC, PARKINGS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PARKINGS.COREC, PARKINGS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PARKINGS.COREC, PARKINGS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL,  ");
			sql.append("S12.GEO_MUNICIPALITY(PARKINGS.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(PARKINGS.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(PARKINGS.COREC) AS NOPROV, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("PARKINGS.ALTURAMAXIMA, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, DATOS_GENERALES.FAX, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVISO.COSERVICIO AS ISO, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, TSERVPDISC.COSERVICIO as PLAZAS_DISCAPACITADOS, ");
			sql.append("TSERVQO.COSERVICIO as Q_ORO, TSERVQP.COSERVICIO as Q_PLATA, TSERVQC.COSERVICIO as Q_CALIDAD, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE ");
			sql.append("FROM PARKINGS LEFT OUTER JOIN GEOREFERENCIACION ON PARKINGS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PARKINGS.COREC = POSICIONAMIENTO.COREC AND PARKINGS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON PARKINGS.COREC = PM_RECURSOS_TOWN.COREC AND  PARKINGS.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PARKINGS.COREC = DATOS_GENERALES.COREC AND PARKINGS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON PARKINGS.COREC = MULTI1.COREC AND PARKINGS.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON PARKINGS.COREC = MULTI2.COREC AND PARKINGS.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			// Plazas para discapacitados
			sql.append(" LEFT JOIN REC_SRV TSERVPDISC ON TSERVPDISC.COREC = PARKINGS.COREC AND TSERVPDISC.COSERVICIO = ").append(S12Constantes.SRV_PLAZAS_DISCAP);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// Q Oro
			sql.append(" LEFT JOIN REC_SRV TSERVQO ON TSERVQO.COREC = PARKINGS.COREC AND TSERVQO.COSERVICIO = ").append(S12Constantes.SRV_Q_ORO);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// Q Plata
			sql.append(" LEFT JOIN REC_SRV TSERVQP ON TSERVQP.COREC = PARKINGS.COREC AND TSERVQP.COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// Q de Calidad
			sql.append(" LEFT JOIN REC_SRV TSERVQC ON TSERVQC.COREC = PARKINGS.COREC AND TSERVQC.COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// buenas pr�cticas
			sql.append(" LEFT JOIN REC_SRV TSERVBP ON TSERVBP.COREC = PARKINGS.COREC AND TSERVBP.COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// ISO
			sql.append(" LEFT JOIN REC_SRV TSERVISO ON TSERVISO.COREC = PARKINGS.COREC AND TSERVISO.COSERVICIO = ").append(S12Constantes.SRV_ISO);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// accesibilidad
			sql.append(" LEFT JOIN ACCESIBILIDAD ACC ON ACC.COREC = PARKINGS.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");
			// Certif. Innovacion
			sql.append(" LEFT JOIN REC_SRV TSERVINNOVA ON TSERVINNOVA.COREC = PARKINGS.COREC AND TSERVINNOVA.COSERVICIO = ").append(S12Constantes.SRV_INNOVACION);
			sql.append(" AND PARKINGS.COIDIOMA = ? ");

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND PARKINGS.COIDIOMA = ? ");

			sql.append("AND PARKINGS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				parking = new S12Parking();
				arrServicios = new ArrayList<String>();

				parking.setCodigoRecurso(rs.getInt("COREC"));
				parking.setIdioma(rs.getString("COIDIOMA"));
				parking.setNombre(rs.getString("NOMBRE"));

				parking.setDireccion(rs.getString("DIRECCION"));
				parking.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				parking.setMunicipio(rs.getString("MUNICIPIO"));
				parking.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				parking.setProvincia(rs.getString("NOPROV"));
				parking.setTelefono(rs.getString("TELEFONO1"));
				parking.setDescTelefono(rs.getString("DESCTELEFONO1"));
				parking.setTelefono2(rs.getString("TELEFONO2"));
				parking.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				parking.setFax(rs.getString("FAX"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					parking.setFotoPrincipal(multimedia);
					parking.setDescFoto(descMultimedia);
				} else {
					parking.setFotoPrincipal(foto);
					parking.setDescFoto(pieFoto);
				}

				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				parking.setFotoA(multimediaA);
				parking.setDescFotoA(descMultimediaA);

				parking.setAlturaMaxima(rs.getString("ALTURAMAXIMA"));
				parking.setUrlAmigable(rs.getString("URLAMIGABLE"));
				parking.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("PLAZAS_DISCAPACITADOS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				parking.setArrServicios(arrServicios);

				parking.setEmail(rs.getString("MAIL"));
				parking.setWeb(rs.getString("URL"));

				parking.setGmlong(rs.getString("GMLNG"));
				parking.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& parking.getGmlong() != null && parking.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(parking.getGmlat()),
							Double.parseDouble(parking.getGmlong()), latUser, longUser);
					parking.setDistancia(String.valueOf(distancia));
				}

				parkingsList.add(parking);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getParkings: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getParkings: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getParkings: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getParkings: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(parkingsList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(parkingsList, new S12RecursosDefaultComparator());
		}

		S12Parking[] parkingsArray = new S12Parking[parkingsList.size()];
		parkingsList.toArray(parkingsArray);
		return parkingsArray;
	}

	/**
	 * Obtiene la lista de rutas que cumplen los criterios.
	 * 
	 * @param arrRutas arrRutas
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de rutas ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Ruta[] getRutas(ArrayList<String> arrRutas, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Ruta> rutasList = new ArrayList<S12Ruta>();

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("SELECT RUTAS.COREC, RUTAS.COIDIOMA, DATOS_GENERALES.NOMBRE, RUTAS.TRANSPORTE, ");
			sql.append("DATOS_GENERALES.IMPORTANCIA, RUTAS.TIPOPLANTILLA, ");
			sql.append("RUTAS.DURACION, S12.FOTO_PRINCIPAL_RECURSO(RUTAS.COREC, RUTAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(RUTAS.COREC, RUTAS.COIDIOMA) AS DEPIEFOTO, RUTAS.PERFIL,");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, GEOREFERENCIACION.GMRUTA, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM RUTAS LEFT OUTER JOIN GEOREFERENCIACION ON RUTAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON RUTAS.COREC = POSICIONAMIENTO.COREC AND RUTAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON RUTAS.COREC = DATOS_GENERALES.COREC AND RUTAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON RUTAS.COREC = MULTIMEDIA.COREC AND RUTAS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1");

			// Idioma
			sql.append(" AND RUTAS.COIDIOMA = ? ");
			sql.append(" AND RUTAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRutas.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRutas, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				S12Ruta ruta = new S12Ruta();

				ruta.setCodigoRecurso(rs.getInt("COREC"));
				ruta.setIdioma(rs.getString("COIDIOMA"));
				ruta.setNombre(rs.getString("NOMBRE"));
				ruta.setTransporte(rs.getString("TRANSPORTE"));
				ruta.setDuracion(rs.getString("DURACION"));
				ruta.setImportancia(rs.getString("IMPORTANCIA"));
				ruta.setTipoPlantilla(rs.getString("TIPOPLANTILLA"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					ruta.setFotoPrincipal(multimedia);
					ruta.setDescFoto(descMultimedia);
				} else {
					ruta.setFotoPrincipal(foto);
					ruta.setDescFoto(pieFoto);
				}

				ruta.setIdPerfil(rs.getString("PERFIL"));
				ruta.setUrlAmigable(rs.getString("URLAMIGABLE"));

				ruta.setGmlong(rs.getString("GMLNG"));
				ruta.setGmlat(rs.getString("GMLAT"));
				ruta.setGmruta(rs.getString("GMRUTA"));

				// Llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				// y el recurso tiene definida su posici�n
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& ruta.getGmlat() != null && ruta.getGmlong() != null) {
					double distancia = this.getDistanciaRuta(ruta.getGmruta(), Double.parseDouble(ruta.getGmlat()),
							Double.parseDouble(ruta.getGmlong()), latUser, longUser);
					ruta.setDistancia(String.valueOf(distancia));
				}

				rutasList.add(ruta);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRutas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRutas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRutas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRutas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(rutasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(rutasList, new S12RecursosDefaultComparator());
		}

		S12Ruta[] rutasArray = new S12Ruta[rutasList.size()];
		rutasList.toArray(rutasArray);
		return rutasArray;
	}

	/**
	 * Obtiene la lista de circuitos que cumplen los criterios.
	 * 
	 * @param arrCircuitos arrCircuitos
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de circuitos ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Circuito[] getCircuitos(ArrayList<String> arrCircuitos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Circuito> circuitosList = new ArrayList<S12Circuito>();

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("SELECT RUTAS.COREC, RUTAS.COIDIOMA, DATOS_GENERALES.NOMBRE, RUTAS.TRANSPORTE, RUTAS.DURACION, S12.FOTO_PRINCIPAL_RECURSO(RUTAS.COREC, RUTAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(RUTAS.COREC, RUTAS.COIDIOMA) AS DEPIEFOTO, RUTAS.TEMATICA,");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, GEOREFERENCIACION.GMRUTA, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM RUTAS LEFT OUTER JOIN GEOREFERENCIACION ON RUTAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON RUTAS.COREC = POSICIONAMIENTO.COREC AND RUTAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON RUTAS.COREC = DATOS_GENERALES.COREC AND RUTAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON RUTAS.COREC = MULTIMEDIA.COREC AND RUTAS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1");

			// Idioma
			sql.append(" AND RUTAS.COIDIOMA = ? ");
			sql.append(" AND RUTAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrCircuitos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);
			index = prepareCodigosRecursoIN(arrCircuitos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				S12Circuito circuito = new S12Circuito();

				circuito.setCodigoRecurso(rs.getInt("COREC"));
				circuito.setIdioma(rs.getString("COIDIOMA"));
				circuito.setNombre(rs.getString("NOMBRE"));
				circuito.setTransporte(rs.getString("TRANSPORTE"));
				circuito.setDuracion(rs.getString("DURACION"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					circuito.setFotoPrincipal(multimedia);
					circuito.setDescFoto(descMultimedia);
				} else {
					circuito.setFotoPrincipal(foto);
					circuito.setDescFoto(pieFoto);
				}

				circuito.setIdTematica(rs.getString("COCATEGORIA"));
				circuito.setUrlAmigable(rs.getString("URLAMIGABLE"));

				circuito.setGmlong(rs.getString("GMLNG"));
				circuito.setGmlat(rs.getString("GMLAT"));
				circuito.setGmruta(rs.getString("GMRUTA"));

				// Llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				// y el recurso tiene definida su posici�n
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& circuito.getGmlat() != null && circuito.getGmlong() != null) {
					double distancia = this.getDistanciaRuta(circuito.getGmruta(),
							Double.parseDouble(circuito.getGmlat()), Double.parseDouble(circuito.getGmlong()), latUser,
							longUser);
					circuito.setDistancia(String.valueOf(distancia));
				}

				circuitosList.add(circuito);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRutas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRutas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRutas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRutas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(circuitosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(circuitosList, new S12RecursosDefaultComparator());
		}

		S12Circuito[] circuitosArray = new S12Circuito[circuitosList.size()];
		circuitosList.toArray(circuitosArray);
		return circuitosArray;
	}

	/**
	 * Funci�n para obtener la distancia entre la localizaci�n de un usuario y una ruta.
	 * 
	 * @param gmRuta gmRuta
	 * @param gmLong gmLong
	 * @param gmLat gmLat
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return distancia
	 */
	private double getDistanciaRuta(String gmRuta, double gmLat, double gmLong, double latUser, double longUser) {
		double distancia = S12PortalMovilDAO.DISTANCIA_DEFECTO;

		if (gmRuta != null) {
			String gmRutaTmp = gmRuta.replaceAll("\\[", "").replaceAll("\\]", "");
			String[] arrPuntos = gmRutaTmp.split(",");
			double longitud = 0;
			double latitud = 0;
			if (arrPuntos.length > 1) {
				for (int i = 0; i < arrPuntos.length; i++) {
					if ((i % 2) == 0) {
						latitud = Double.parseDouble(arrPuntos[i]);
					} else {
						longitud = Double.parseDouble(arrPuntos[i]);
						if (S12Utils.getDistanciaGeodesica(latitud, longitud, latUser, longUser) < distancia) {
							distancia = S12Utils.getDistanciaGeodesica(gmLat, gmLong, latUser, longUser);
						}
					}
				}
			}
		} else {
			distancia = S12Utils.getDistanciaGeodesica(gmLat, gmLong, latUser, longUser);
		}

		return distancia;
	}

	/**
	 * Obtiene la lista de restauraci�n que cumplen los criterios.
	 * 
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de restauraci�n ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Restauracion[] getRestauracion(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser, int numero_resultados, int ultimo_resultado, double distanciaMax)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Restauracion> restauracionList = new ArrayList<S12Restauracion>();
		S12Restauracion restauracion;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("SELECT RESTAURACION.COREC, RESTAURACION.COIDIOMA, DATOS_GENERALES.NOMBRE, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("RESTAURACION.ESPECIALIDAD, RESTAURACION.ESTRELLAS, RESTAURACION.SOLES, S12.DESC_FOTO_PRINCIPAL_RECURSO (RESTAURACION.COREC, RESTAURACION.COIDIOMA) AS DESCIMAGE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(RESTAURACION.COREC, RESTAURACION.COIDIOMA) AS IMAGE, GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, TSERVQC.COSERVICIO AS Q_CALIDAD, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO , TSERV50BEST.COSERVICIO as BEST50, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, DATOS_GENERALES.IMPORTANCIA, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("S12.GEO_MUNICIPALITY(RESTAURACION.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(RESTAURACION.COREC) AS CODMUNICIPIO ");
			sql.append("FROM RESTAURACION LEFT OUTER JOIN GEOREFERENCIACION ON RESTAURACION.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON RESTAURACION.COREC = POSICIONAMIENTO.COREC AND RESTAURACION.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON RESTAURACION.COREC = DATOS_GENERALES.COREC AND RESTAURACION.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON RESTAURACION.COREC = MULTIMEDIA.COREC AND RESTAURACION.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			sql.append("AND COSERVICIO = ")
					.append(S12Constantes.SRV_BUENAS_PRACTICAS)
					.append(" AND COIDIOMA = ?")
					.append(" GROUP BY RESTAURACION.COREC, COSERVICIO) TSERVBP ON RESTAURACION.COREC = TSERVBP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			sql.append("AND COSERVICIO = ")
					.append(S12Constantes.SRV_Q_CALIDAD)
					.append(" AND COIDIOMA = ?")
					.append(" GROUP BY RESTAURACION.COREC, COSERVICIO) TSERVQC ON RESTAURACION.COREC = TSERVQC.COREC ");
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON RESTAURACION.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO).append(" AND COIDIOMA = ?")
					.append(") TSERVPRODUCTO ON RESTAURACION.COREC = TSERVPRODUCTO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			// best50
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BEST50).append(" AND COIDIOMA = ?")
					.append(") TSERV50BEST ON RESTAURACION.COREC = TSERV50BEST.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			// Q Oro
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON RESTAURACION.COREC = TSERVQO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			// Q Plata
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON RESTAURACION.COREC = TSERVQP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			// ECOLABEL
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL).append(" AND COIDIOMA = ?")
					.append(") TSERVECOL ON RESTAURACION.COREC = TSERVECOL.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			// ISO
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON RESTAURACION.COREC = TSERVISO.COREC ");
			//Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT RESTAURACION.COREC, COSERVICIO FROM RESTAURACION, REC_SRV WHERE REC_SRV.COREC = RESTAURACION.COREC ");
			sql.append("AND COSERVICIO = ")
					.append(S12Constantes.SRV_INNOVACION)
					.append(" AND COIDIOMA = ?")
					.append(" GROUP BY RESTAURACION.COREC, COSERVICIO) TSERVINNOVA ON RESTAURACION.COREC = TSERVINNOVA.COREC ");

			// Idioma
			sql.append(" WHERE RESTAURACION.COIDIOMA = ?");
			sql.append(" AND RESTAURACION.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();
			int contFila = 0;
			while (rs.next()) {

				restauracion = new S12Restauracion();
				arrServicios = new ArrayList<String>();

				restauracion.setRowNum(contFila);
				contFila++;
				restauracion.setCodigoRecurso(rs.getInt("COREC"));
				restauracion.setIdioma(rs.getString("COIDIOMA"));
				// restauracion.setNombre(rs.getString("NORECURSO"));
				restauracion.setNombre(rs.getString("NOMBRE"));
				// restauracion.setSubTipo(rs.getString("COTIPOESTABLECIMIENTO"));
				restauracion.setSubTipo(rs.getString("CODSUBTIPO"));
				if (restauracion.getSubTipo() != null && !"".equals(restauracion.getSubTipo())) {
					restauracion.setNombreSubTipo(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"b1." + restauracion.getSubTipo(), restauracion.getIdioma()));
				}

				restauracion.setMunicipio(rs.getString("MUNICIPIO"));
				restauracion.setMunicipioCode(rs.getString("CODMUNICIPIO"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				// String foto = rs.getString("NOFOTO");
				String foto = rs.getString("IMAGE");
				// String pieFoto = rs.getString("DEPIEFOTO");
				String pieFoto = rs.getString("DESCIMAGE");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					restauracion.setFotoPrincipal(multimedia);
					restauracion.setDescFoto(descMultimedia);
				} else {
					restauracion.setFotoPrincipal(foto);
					restauracion.setDescFoto(pieFoto);
				}

				restauracion.setUrlAmigable(rs.getString("URLAMIGABLE"));
				// restauracion.setTelefono(rs.getString("NOTELEFONO"));
				restauracion.setTelefono(rs.getString("TELEFONO1"));
				// restauracion.setTelefono2(rs.getString("NOTELEFONO2"));
				restauracion.setTelefono2(rs.getString("TELEFONO2"));
				// restauracion.setDescTelefono(rs.getString("DEDESCTELEFONO"));
				restauracion.setDescTelefono(rs.getString("DESCTELEFONO1"));
				// restauracion.setDescTelefono2(rs.getString("DEDESCTELEFONO2"));
				restauracion.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				// restauracion.setRepsol(rs.getString("COREPSOL"));
				restauracion.setRepsol(rs.getString("SOLES"));
				// restauracion.setMichelin(rs.getString("COMICHELIN"));
				restauracion.setMichelin(rs.getString("ESTRELLAS"));

				// restauracion.setImportancia(rs.getString("COIMPORTANCIA"));
				restauracion.setImportancia(rs.getString("IMPORTANCIA"));

				/*
				 * if (rs.getString("DETIPOCOMIDA") != null) { restauracion.setTipoComida(rs.getString("DETIPOCOMIDA"));
				 * }
				 */
				if (rs.getString("ESPECIALIDAD") != null) {
					restauracion.setTipoComida(rs.getString("ESPECIALIDAD"));
				}
				// OJO: el orden de los servicios en el array IDENTIFICA CADA SERVICIO.
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BEST50") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				restauracion.setArrServicios(arrServicios);

				restauracion.setGmlong(rs.getString("GMLNG"));
				restauracion.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& restauracion.getGmlong() != null && restauracion.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(restauracion.getGmlat()),
							Double.parseDouble(restauracion.getGmlong()), latUser, longUser);
					restauracion.setDistancia(String.valueOf(distancia));
				}

				// FILTRO DISTANCIA: lo hemos movido a la SELECT previa sobre la vista materializada.
				// if (restauracion.getDistancia()==null || distanciaMax == -1 || distanciaMax >=
				// Double.parseDouble(restauracion.getDistancia()) ){
				restauracionList.add(restauracion);
				// }

			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRestauracion: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRestauracion: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRestauracion: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRestauracion: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRestauracion: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// //ordenar array por distancia
		// if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
		// Collections.sort(restauracionList, new S12RecursosComparator());
		// }else{ // Alfab�tica
		// Collections.sort(restauracionList, new S12RecursosDefaultComparator());
		// }

		S12Restauracion[] restauracionArray = new S12Restauracion[restauracionList.size()];
		restauracionList.toArray(restauracionArray);
		return restauracionArray;
	}

	/**
	 * Obtiene la lista de alojamientos que cumplen los criterios.
	 * 
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de alojamientos ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal Movil
	 */
	public S12Alojamiento[] getAlojamientos(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser, int numero_resultados, int ultimo_resultado, double distanciaMax)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Alojamiento> alojamientosList = new ArrayList<S12Alojamiento>();
		S12Alojamiento alojamiento;
		ArrayList<String> arrServicios;

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("SELECT ALOJAMIENTO.COREC, ALOJAMIENTO.COIDIOMA, DATOS_GENERALES.NOMBRE, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("DATOS_GENERALES.CODIGOPOSTAL, DATOS_GENERALES.DIRECCION, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("S12.GEO_PROVINCIA(ALOJAMIENTO.COREC) AS PROVINCIA, S12.GEO_PROVINCIACODE(ALOJAMIENTO.COREC) AS CODPROVINCIA, ");
			sql.append("ALOJAMIENTO.CATEGORIA, S12.GEO_MUNICIPALITY(ALOJAMIENTO.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(ALOJAMIENTO.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_LOCALITY(ALOJAMIENTO.COREC) AS LOCALIDAD, ");
			sql.append("S12.GEO_LOCALITYCODE(ALOJAMIENTO.COREC) AS CODLOCALIDAD, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(ALOJAMIENTO.COREC, ALOJAMIENTO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(ALOJAMIENTO.COREC, ALOJAMIENTO.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("ALOJAMIENTO.MODALIDAD, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVQC.COSERVICIO AS Q_CALIDAD, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVSURF.COSERVICIO as SURFING, ");
			sql.append("TSERV50BEST.COSERVICIO as BEST50, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM ALOJAMIENTO LEFT OUTER JOIN GEOREFERENCIACION ON ALOJAMIENTO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON ALOJAMIENTO.COREC = POSICIONAMIENTO.COREC AND ALOJAMIENTO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON ALOJAMIENTO.COREC = DATOS_GENERALES.COREC AND ALOJAMIENTO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append("LEFT JOIN MULTIMEDIA ON ALOJAMIENTO.COREC = MULTIMEDIA.COREC AND ALOJAMIENTO.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1);

			// Q de calidad
			sql.append(" LEFT JOIN REC_SRV TSERVQC ON ALOJAMIENTO.COREC = TSERVQC.COREC AND TSERVQC.COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD);
			
			// Q Oro
			sql.append(" LEFT JOIN REC_SRV TSERVQO ON ALOJAMIENTO.COREC = TSERVQO.COREC AND TSERVQO.COSERVICIO = ").append(S12Constantes.SRV_Q_ORO);
			
			// Q Plata
			sql.append(" LEFT JOIN REC_SRV TSERVQP ON ALOJAMIENTO.COREC = TSERVQP.COREC AND TSERVQP.COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA);
			
			// ISO
			sql.append(" LEFT JOIN REC_SRV TSERVISO ON ALOJAMIENTO.COREC = TSERVISO.COREC AND TSERVISO.COSERVICIO = ").append(S12Constantes.SRV_ISO);
			
			// ECOLABEL
			sql.append(" LEFT JOIN REC_SRV TSERVECOL ON ALOJAMIENTO.COREC = TSERVECOL.COREC AND TSERVECOL.COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL);
			
			// accesible
			sql.append(" LEFT JOIN ACCESIBILIDAD ACC ON ALOJAMIENTO.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			
			// buenas practicas
			sql.append(" LEFT JOIN REC_SRV TSERVBP ON ALOJAMIENTO.COREC = TSERVBP.COREC AND TSERVBP.COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS);
			
			// surfing
			sql.append(" LEFT JOIN REC_SRV TSERVSURF ON ALOJAMIENTO.COREC = TSERVSURF.COREC AND TSERVSURF.COSERVICIO = ").append(S12Constantes.SRV_SURFING);
			
			// best50
			sql.append(" LEFT JOIN REC_SRV TSERV50BEST ON ALOJAMIENTO.COREC =  TSERV50BEST.COREC AND TSERV50BEST.COSERVICIO = ").append(S12Constantes.SRV_BEST50);
			
			// club producto
			sql.append(" LEFT JOIN REC_SRV TSERVPRODUCTO ON ALOJAMIENTO.COREC = TSERVPRODUCTO.COREC AND TSERVPRODUCTO.COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO);

			// Certif. Innovación
			sql.append(" LEFT JOIN REC_SRV TSERVINNOVA ON ALOJAMIENTO.COREC = TSERVINNOVA.COREC AND TSERVINNOVA.COSERVICIO = ").append(S12Constantes.SRV_INNOVACION);
			
			// Idioma
			sql.append(" WHERE ALOJAMIENTO.COIDIOMA = ? ");
			sql.append(" AND ALOJAMIENTO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				alojamiento = new S12Alojamiento();
				arrServicios = new ArrayList<String>();

				alojamiento.setCodigoRecurso(rs.getInt("COREC"));
				alojamiento.setIdioma(rs.getString("COIDIOMA"));
				alojamiento.setNombre(rs.getString("NOMBRE"));
				alojamiento.setSubTipo(rs.getString("CODSUBTIPO"));
				if (alojamiento.getSubTipo() != null && !"".equals(alojamiento.getSubTipo())) {
					alojamiento.setNombreSubTipo(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"a1." + alojamiento.getSubTipo(), alojamiento.getIdioma()));
				}
				alojamiento.setModalidad(rs.getString("MODALIDAD"));
				alojamiento.setCategoria(rs.getString("CATEGORIA"));
				alojamiento.setProvincia(rs.getString("PROVINCIA"));
				alojamiento.setProvinciaCode(rs.getString("CODPROVINCIA"));
				alojamiento.setMunicipio(rs.getString("MUNICIPIO"));
				alojamiento.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				alojamiento.setLocalidad(rs.getString("LOCALIDAD"));
				alojamiento.setLocalidadCode(rs.getString("CODLOCALIDAD"));

				alojamiento.setTelefono(rs.getString("TELEFONO1"));
				alojamiento.setTelefono2(rs.getString("TELEFONO2"));
				alojamiento.setDescTelefono(rs.getString("DESCTELEFONO1"));
				alojamiento.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				alojamiento.setDireccion(rs.getString("DIRECCION"));
				alojamiento.setEmail(rs.getString("MAIL"));
				alojamiento.setWeb(rs.getString("URL"));
				alojamiento.setCodigoPostal(rs.getString("CODIGOPOSTAL"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String descFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					alojamiento.setFotoPrincipal(multimedia);
					alojamiento.setDescFoto(descMultimedia);
				} else {
					alojamiento.setFotoPrincipal(foto);
					alojamiento.setDescFoto(descFoto);
				}

				alojamiento.setUrlAmigable(rs.getString("URLAMIGABLE"));

				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("SURFING") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BEST50") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				alojamiento.setArrServicios(arrServicios);

				alojamiento.setGmlong(rs.getString("GMLNG"));
				alojamiento.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				double distancia = 0.0;
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& alojamiento.getGmlong() != null && alojamiento.getGmlat() != null) {
					distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(alojamiento.getGmlat()),
							Double.parseDouble(alojamiento.getGmlong()), latUser, longUser);
					alojamiento.setDistancia(String.valueOf(distancia));
				}

				alojamientosList.add(alojamiento);

			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAlojamientos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAlojamientos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAlojamientos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAlojamientos: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAlojamientos: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(alojamientosList, new S12RecursosComparator());
		} else {
			Collections.sort(alojamientosList, new S12RecursosDefaultComparator());
		}

		S12Alojamiento[] alojamientosArray = new S12Alojamiento[alojamientosList.size()];
		alojamientosList.toArray(alojamientosArray);
		return alojamientosArray;
	}

	/**
	 * Gets the experiencias.
	 * 
	 * @param arrExperiencias the arr experiencias
	 * @param idioma the idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * 
	 * @return the experiencias
	 * 
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	public S12Experiencia[] getExperiencias(ArrayList<String> arrExperiencias, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Experiencia> experienciasList = new ArrayList<S12Experiencia>();
		S12Experiencia experiencia;

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT EXPERIENCIASTOP.COREC, EXPERIENCIASTOP.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("EXPERIENCIASTOP.INTRODUCCION, S12.FOTO_PRINCIPAL_RECURSO(EXPERIENCIASTOP.COREC, EXPERIENCIASTOP.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(EXPERIENCIASTOP.COREC, EXPERIENCIASTOP.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("TSERVAGUA.COSERVICIO AS AGUA, TSERVPAISAJE.COSERVICIO AS PAISAJE, TSERVGASTRO.COSERVICIO AS GASTRONOMIA, TSERVCULTURA.COSERVICIO AS CULTURA ");
			sql.append("FROM EXPERIENCIASTOP LEFT OUTER JOIN GEOREFERENCIACION ON EXPERIENCIASTOP.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON EXPERIENCIASTOP.COREC = POSICIONAMIENTO.COREC AND EXPERIENCIASTOP.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN RECURSO ON EXPERIENCIASTOP.COREC = RECURSO.COREC ");
			sql.append("INNER JOIN DATOS_GENERALES ON EXPERIENCIASTOP.COREC = DATOS_GENERALES.COREC AND EXPERIENCIASTOP.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON EXPERIENCIASTOP.COREC = MULTIMEDIA.COREC AND EXPERIENCIASTOP.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("LEFT OUTER JOIN (SELECT EXPERIENCIASTOP.COREC, COSERVICIO FROM EXPERIENCIASTOP, REC_SRV WHERE REC_SRV.COREC = EXPERIENCIASTOP.COREC ");
			sql.append("AND COSERVICIO = 201 AND COIDIOMA = ?")
					.append(" GROUP BY EXPERIENCIASTOP.COREC, COSERVICIO) TSERVAGUA ON EXPERIENCIASTOP.COREC = TSERVAGUA.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EXPERIENCIASTOP.COREC, COSERVICIO FROM EXPERIENCIASTOP, REC_SRV WHERE REC_SRV.COREC = EXPERIENCIASTOP.COREC ");
			sql.append("AND COSERVICIO = 202 AND COIDIOMA = ?")
					.append(" GROUP BY EXPERIENCIASTOP.COREC, COSERVICIO) TSERVPAISAJE ON EXPERIENCIASTOP.COREC = TSERVPAISAJE.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EXPERIENCIASTOP.COREC, COSERVICIO FROM EXPERIENCIASTOP, REC_SRV WHERE REC_SRV.COREC = EXPERIENCIASTOP.COREC ");
			sql.append("AND COSERVICIO = 203 AND COIDIOMA = ?")
					.append(" GROUP BY EXPERIENCIASTOP.COREC, COSERVICIO) TSERVGASTRO ON EXPERIENCIASTOP.COREC = TSERVGASTRO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EXPERIENCIASTOP.COREC, COSERVICIO FROM EXPERIENCIASTOP, REC_SRV WHERE REC_SRV.COREC = EXPERIENCIASTOP.COREC ");
			sql.append("AND COSERVICIO = 204 AND COIDIOMA = ?")
					.append(" GROUP BY EXPERIENCIASTOP.COREC, COSERVICIO) TSERVCULTURA ON EXPERIENCIASTOP.COREC = TSERVCULTURA.COREC ");

			sql.append("WHERE 1 = 1 ");
			sql.append("AND EXPERIENCIASTOP.COIDIOMA = ? ");
			sql.append("AND EXPERIENCIASTOP.COREC IN ( ");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrExperiencias.size()));
			sql.append(") ORDER BY RECURSO.FEPUBLICACION DESC NULLS LAST");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrExperiencias, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				experiencia = new S12Experiencia();

				experiencia.setCodigoRecurso(rs.getInt("COREC"));
				experiencia.setIdioma(rs.getString("COIDIOMA"));
				experiencia.setNombre(rs.getString("NOMBRE"));
				experiencia.setDescripcion(rs.getString("INTRODUCCION"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String descFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					experiencia.setFotoPrincipal(multimedia);
					experiencia.setDescFoto(descMultimedia);
				} else {
					experiencia.setFotoPrincipal(foto);
					experiencia.setDescFoto(descFoto);
				}

				experiencia.setUrlAmigable(rs.getString("URLAMIGABLE"));

				experiencia.setGmlong(rs.getString("GMLNG"));
				experiencia.setGmlat(rs.getString("GMLAT"));

				// Llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				// y el recurso tiene definida su posici�n
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& experiencia.getGmlat() != null && experiencia.getGmlong() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(experiencia.getGmlat()),
							Double.parseDouble(experiencia.getGmlong()), latUser, longUser);
					experiencia.setDistancia(String.valueOf(distancia));
				}

				StringBuffer tiposId = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
				String agua = rs.getString("AGUA");
				if (agua != null && !"".equals(agua)) {
					tiposId.append(",");
					tiposId = tiposId.append(agua);
				}
				String paisaje = rs.getString("PAISAJE");
				if (paisaje != null && !"".equals(paisaje)) {
					tiposId.append(",");
					tiposId = tiposId.append(paisaje);
				}
				String gastronomia = rs.getString("GASTRONOMIA");
				if (gastronomia != null && !"".equals(gastronomia)) {
					tiposId.append(",");
					tiposId = tiposId.append(gastronomia);
				}
				String cultura = rs.getString("CULTURA");
				if (cultura != null && !"".equals(cultura)) {
					tiposId.append(",");
					tiposId = tiposId.append(cultura);
				}
				experiencia.setTiposId(tiposId.toString().replaceFirst(",", ""));

				experienciasList.add(experiencia);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getExperiencias: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getExperiencias: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getExperiencias: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getExperiencias: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(experienciasList, new S12RecursosComparator());
		}

		S12Experiencia[] experienciaArray = new S12Experiencia[experienciasList.size()];
		experienciasList.toArray(experienciaArray);
		return experienciaArray;
	}

	/**
	 * Obtiene la lista de oficinas de turismo que cumplen los criterios.
	 * 
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de oficinas de turismo ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12OficinasTurismo[] getOficinasTurismo(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12OficinasTurismo> oficinasTurismoList = new ArrayList<S12OficinasTurismo>();
		S12OficinasTurismo oficinaTurismo;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT OFICINASTURISMO.COREC, OFICINASTURISMO.COIDIOMA, DATOS_GENERALES.NOMBRE, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("DATOS_GENERALES.CODIGOPOSTAL, DATOS_GENERALES.DIRECCION, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("S12.GEO_PROVINCIA(OFICINASTURISMO.COREC) AS PROVINCIA, S12.GEO_PROVINCIACODE(OFICINASTURISMO.COREC) AS CODPROVINCIA, ");
			sql.append("S12.GEO_MUNICIPALITY(OFICINASTURISMO.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(OFICINASTURISMO.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_LOCALITY(OFICINASTURISMO.COREC) AS LOCALIDAD, ");
			sql.append("S12.GEO_LOCALITYCODE(OFICINASTURISMO.COREC) AS CODLOCALIDAD, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(OFICINASTURISMO.COREC, OFICINASTURISMO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(OFICINASTURISMO.COREC, OFICINASTURISMO.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, TSERVQC.COSERVICIO AS Q_CALIDAD, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, TSERVSURF.COSERVICIO as SURFING, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM OFICINASTURISMO LEFT OUTER JOIN GEOREFERENCIACION ON OFICINASTURISMO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON OFICINASTURISMO.COREC = POSICIONAMIENTO.COREC AND OFICINASTURISMO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON OFICINASTURISMO.COREC = DATOS_GENERALES.COREC AND OFICINASTURISMO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON OFICINASTURISMO.COREC = MULTIMEDIA.COREC AND OFICINASTURISMO.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON OFICINASTURISMO.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO).append(" AND COIDIOMA = ?")
					.append(") TSERVPRODUCTO ON OFICINASTURISMO.COREC = TSERVPRODUCTO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON OFICINASTURISMO.COREC = TSERVQO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON OFICINASTURISMO.COREC = TSERVQP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON OFICINASTURISMO.COREC = TSERVISO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");

			// ECOLABEL
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL).append(" AND COIDIOMA = ?")
					.append(") TSERVECOL ON OFICINASTURISMO.COREC = TSERVECOL.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");

			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON OFICINASTURISMO.COREC = TSERVQC.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON OFICINASTURISMO.COREC = TSERVBP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_SURFING).append(" AND COIDIOMA = ?")
					.append(") TSERVSURF ON OFICINASTURISMO.COREC = TSERVSURF.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT OFICINASTURISMO.COREC, COSERVICIO FROM OFICINASTURISMO, REC_SRV WHERE REC_SRV.COREC = OFICINASTURISMO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON OFICINASTURISMO.COREC = TSERVINNOVA.COREC ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND OFICINASTURISMO.COIDIOMA = ? ");
			sql.append("AND OFICINASTURISMO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				oficinaTurismo = new S12OficinasTurismo();
				arrServicios = new ArrayList<String>();

				oficinaTurismo.setCodigoRecurso(rs.getInt("COREC"));
				oficinaTurismo.setIdioma(rs.getString("COIDIOMA"));
				oficinaTurismo.setNombre(rs.getString("NOMBRE"));
				oficinaTurismo.setTelefono(rs.getString("TELEFONO1"));
				oficinaTurismo.setTelefono2(rs.getString("TELEFONO2"));
				oficinaTurismo.setDescTelefono(rs.getString("DESCTELEFONO1"));
				oficinaTurismo.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				oficinaTurismo.setSubTipo(rs.getString("CODSUBTIPO"));

				oficinaTurismo.setDireccion(rs.getString("DIRECCION"));
				oficinaTurismo.setEmail(rs.getString("MAIL"));
				oficinaTurismo.setWeb(rs.getString("URL"));
				oficinaTurismo.setCodigoPostal(rs.getString("CODIGOPOSTAL"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					oficinaTurismo.setFotoPrincipal(multimedia);
					oficinaTurismo.setDescFoto(descMultimedia);
				} else {
					oficinaTurismo.setFotoPrincipal(foto);
					oficinaTurismo.setDescFoto(pieFoto);
				}

				oficinaTurismo.setProvincia(rs.getString("PROVINCIA"));
				oficinaTurismo.setProvinciaCode(rs.getString("CODPROVINCIA"));
				oficinaTurismo.setMunicipio(rs.getString("MUNICIPIO"));
				oficinaTurismo.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				oficinaTurismo.setLocalidad(rs.getString("LOCALIDAD"));
				oficinaTurismo.setLocalidadCode(rs.getString("CODLOCALIDAD"));
				oficinaTurismo.setUrlAmigable(rs.getString("URLAMIGABLE"));

				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("SURFING") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				oficinaTurismo.setArrServicios(arrServicios);

				oficinaTurismo.setGmlong(rs.getString("GMLNG"));
				oficinaTurismo.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& oficinaTurismo.getGmlong() != null && oficinaTurismo.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(oficinaTurismo.getGmlat()),
							Double.parseDouble(oficinaTurismo.getGmlong()), latUser, longUser);
					oficinaTurismo.setDistancia(String.valueOf(distancia));
				}

				oficinasTurismoList.add(oficinaTurismo);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getOficinasTurismo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getOficinasTurismo: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getOficinasTurismo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getOficinasTurismo: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(oficinasTurismoList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(oficinasTurismoList, new S12RecursosDefaultComparator());
		}

		S12OficinasTurismo[] oficinaTurismoArray = new S12OficinasTurismo[oficinasTurismoList.size()];
		oficinasTurismoList.toArray(oficinaTurismoArray);
		return oficinaTurismoArray;
	}

	/**
	 * Gets the agenda.
	 * 
	 * @param arrAgenda the arr agenda
	 * @param idioma the idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param distanciaMax the distancia max
	 * 
	 * @return lista de eventos
	 * 
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	public S12Agenda[] getAgenda(ArrayList<String> arrAgenda, String idioma, double latUser, double longUser,
			double distanciaMax) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Agenda> agendaList = new ArrayList<S12Agenda>();
		S12Agenda agenda;

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("SELECT AGENDA.COREC, AGENDA.COIDIOMA, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("DATOS_GENERALES.NOMBRE, AGENDA.FECHAINICIO, AGENDA.FECHAFIN, ");
			sql.append("S12.GEO_MUNICIPALITY (AGENDA.COREC) AS MUNICIPIO, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(AGENDA.COREC, AGENDA.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(AGENDA.COREC, AGENDA.COIDIOMA) AS DEPIEFOTO, GEOREFERENCIACION.GMLNG, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS IMGB, AGENDA.FEFECHAORIENTATIVA, ");
			sql.append("GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM AGENDA LEFT OUTER JOIN GEOREFERENCIACION ON AGENDA.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON AGENDA.COREC = POSICIONAMIENTO.COREC AND AGENDA.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON AGENDA.COREC = DATOS_GENERALES.COREC AND AGENDA.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					" LEFT JOIN MULTIMEDIA MULTI1 ON AGENDA.COREC = MULTI1.COREC AND AGENDA.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append(
					" LEFT JOIN MULTIMEDIA MULTI2 ON AGENDA.COREC = MULTI2.COREC AND AGENDA.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");
			sql.append("AND AGENDA.COIDIOMA = ? ");
			sql.append("AND AGENDA.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrAgenda.size()));
			sql.append(") ORDER BY IMPORTANCIA ASC, FECHAINICIO DESC");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrAgenda, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				agenda = new S12Agenda();

				agenda.setCodigoRecurso(rs.getInt("COREC"));
				agenda.setIdioma(rs.getString("COIDIOMA"));
				agenda.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					agenda.setFotoPrincipal(multimedia);
					agenda.setDescFoto(descMultimedia);
				} else {
					agenda.setFotoPrincipal(foto);
					agenda.setDescFoto(pieFoto);
				}

				agenda.setUrlAmigable(rs.getString("URLAMIGABLE"));
				agenda.setFechaInicio(rs.getString("FECHAINICIO"));
				agenda.setFechaFin(rs.getString("FECHAFIN"));
				agenda.setGmlong(rs.getString("GMLNG"));
				agenda.setGmlat(rs.getString("GMLAT"));
				agenda.setMunicipio(rs.getString("MUNICIPIO"));

				agenda.setTipo(rs.getString("CODSUBTIPO"));
				if (agenda.getTipo() != null && !"".equals(agenda.getTipo())) {
					agenda.setNombreTipo(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"m1." + agenda.getTipo(), agenda.getIdioma()));
				}

				if (rs.getString("FECHAINICIO") != null && rs.getString("FECHAFIN") != null) {
					String fechaInicio = S12Utils.getFechaFormateada(rs.getDate("FECHAINICIO"), idioma);
					String fechaFin = S12Utils.getFechaFormateada(rs.getDate("FECHAFIN"), idioma);
					StringBuffer fechas = new StringBuffer(fechaInicio).append(" - ").append(fechaFin);
					agenda.setFechas(fechas.toString());
				}

				// Llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				// y el recurso tiene definida su posici�n
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& agenda.getGmlat() != null && agenda.getGmlong() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(agenda.getGmlat()),
							Double.parseDouble(agenda.getGmlong()), latUser, longUser);
					agenda.setDistancia(String.valueOf(distancia));
				}

				agenda.setImageB(rs.getString("IMGB"));
				agenda.setFechaOrientativa(rs.getString("FEFECHAORIENTATIVA"));

				agendaList.add(agenda);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAgenda: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAgenda: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAgenda: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAgenda: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNovedades: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(agendaList, new S12RecursosComparator());
		}

		S12Agenda[] experienciaArray = new S12Agenda[agendaList.size()];
		agendaList.toArray(experienciaArray);
		return experienciaArray;
	}

	/**
	 * Obtiene la lista de ofertas que cumplen los criterios.
	 * 
	 * @param arrRecursos arrRecursos
	 * @param idioma idioma
	 * @param longUser longUser
	 * @param latUser latUser
	 * 
	 * @return lista de ofertas ordenadas por distancia
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Ofertas[] getOfertas(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Ofertas> ofertasList = new ArrayList<S12Ofertas>();
		S12Ofertas oferta;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT OFERTAS.COREC, S12.GET_SUBTIPORECURSO(OFERTAS.COPARENTREC) AS SUBTIPOPADRE, OFERTAS.COIDIOMA, DATOS_GENERALES.NOMBRE, OFERTAS.PRECIO, ");
			sql.append("OFERTAS.FECHAINICIO, OFERTAS.FECHAFIN, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.DESCRIPCION, DATOS_GENERALES.MAIL, DATOS_GENERALES.TELEFONO1, S12.GET_TIPORECURSO(OFERTAS.COPARENTREC) AS TIPOPADRE, OFERTAS.COPARENTREC, ");
			sql.append("S12.GET_URLAMIGABLE_RECURSOPADRE(OFERTAS.COPARENTREC) AS DEENLACEPADRE, S12.FOTO_PRINCIPAL_RECURSO(OFERTAS.COREC, OFERTAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(OFERTAS.COREC, OFERTAS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("S12.GEO_MUNICIPALITY(OFERTAS.COREC) AS MUNICIPIO, S12.GET_NOMBRE_RECURSOPADRE(OFERTAS.COPARENTREC, OFERTAS.COIDIOMA) AS NORECURSOPADRE, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("CONSULTAMAT_RECURSOS_PM.URLAMIGABLE AS URLAMIGABLEPARENT, CONSULTAMAT_RECURSOS_PM.CATEGORY AS CATEGORIA, RECURSO.COREGNB29 AS SIGNATURE, RECURSO.TOP, DATOS_GENERALES.IMPORTANCIA ");
			sql.append("FROM OFERTAS LEFT OUTER JOIN GEOREFERENCIACION ON OFERTAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON OFERTAS.COREC = POSICIONAMIENTO.COREC AND OFERTAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN CONSULTAMAT_RECURSOS_PM ON OFERTAS.COPARENTREC = CONSULTAMAT_RECURSOS_PM.COREC AND OFERTAS.COIDIOMA = CONSULTAMAT_RECURSOS_PM.LANGUAGE ");
			sql.append("LEFT OUTER JOIN RECURSO ON OFERTAS.COPARENTREC = RECURSO.COREC ");
			sql.append("INNER JOIN DATOS_GENERALES ON OFERTAS.COREC = DATOS_GENERALES.COREC AND  OFERTAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON OFERTAS.COREC = MULTIMEDIA.COREC AND OFERTAS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2);
			sql.append(" WHERE 1 = 1 ");
			// Idioma
			sql.append("AND OFERTAS.COIDIOMA = ? ");
			sql.append("AND OFERTAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(") ORDER BY COREC DESC");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				oferta = new S12Ofertas();

				oferta.setCodigoRecurso(rs.getInt("COREC"));
				oferta.setIdioma(rs.getString("COIDIOMA"));
				// oferta.setNombre(rs.getString("NORECURSO"));
				oferta.setNombre(rs.getString("NOMBRE"));
				// oferta.setPrecio(rs.getString("IMPRECIO"));
				oferta.setPrecio(rs.getString("PRECIO"));

				if (rs.getString("FECHAINICIO") != null && rs.getString("FECHAFIN") != null) {
					String fechaInicio = S12Utils.getFechaFormateada(rs.getDate("FECHAINICIO"), idioma);
					String fechaFin = S12Utils.getFechaFormateada(rs.getDate("FECHAFIN"), idioma);
					StringBuffer fechas = new StringBuffer(fechaInicio).append(" - ").append(fechaFin);
					oferta.setFechas(fechas.toString());
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					oferta.setFotoPrincipal(multimedia);
					oferta.setDescFoto(descMultimedia);
				} else {
					oferta.setFotoPrincipal(foto);
					oferta.setDescFoto(pieFoto);
				}

				oferta.setMunicipio(rs.getString("MUNICIPIO"));
				oferta.setUrlAmigable(rs.getString("URLAMIGABLE"));

				oferta.setGmlong(rs.getString("GMLNG"));
				oferta.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& oferta.getGmlong() != null && oferta.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(oferta.getGmlat()),
							Double.parseDouble(oferta.getGmlong()), latUser, longUser);
					oferta.setDistancia(String.valueOf(distancia));
				}

				oferta.setDescription(rs.getString("DESCRIPCION"));
				oferta.setMail(rs.getString("MAIL"));
				oferta.setPhone(rs.getString("TELEFONO1"));
				oferta.setNombrePadre(rs.getString("NORECURSOPADRE"));

				oferta.setTipoPadre(rs.getString("TIPOPADRE"));
				oferta.setCodigoPadre(rs.getString("COPARENTREC"));
				oferta.setEnlacePadre(rs.getString("DEENLACEPADRE"));
				oferta.setUrlAmigablePadre(rs.getString("URLAMIGABLEPARENT"));
				oferta.setSubTipoPadre(rs.getString("SUBTIPOPADRE"));
				oferta.setSignaturaPadre(rs.getString("SIGNATURE"));
				oferta.setCategoria(rs.getString("CATEGORIA"));
				// oferta.setWebRecurso(rs.getString("DEENLACEOFERTA"));
				oferta.setWebRecurso(rs.getString("URL"));

				Boolean top = rs.getBoolean("TOP");
				Integer importancia = rs.getInt("IMPORTANCIA");
				String enlacePadre = oferta.getEnlacePadre();
				if (enlacePadre == null) {
					// llamar a la funcion q no devuelve la URLAmigable (añadirlas a S12Utils)
					S12Utils.getURLFicha(oferta.getCodigoPadre(), oferta.getTipoPadre(), idioma, top, importancia);

				} else {
					// llamar a la funcion q devuelve la URLAmigable (añadirlas a S12Utils)
					S12Utils.getURLFicha(oferta.getUrlAmigablePadre(), oferta.getTipoPadre(), idioma, top, importancia);
				}

				// obtengo la lista de condiciones de la oferta
				sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
				sql.append("SELECT TEXTOCONDICION FROM CONDICIONES WHERE COIDIOMA = ? ");
				sql.append(" AND COREC = ").append(oferta.getCodigoRecurso());
				PreparedStatement stmtCondiciones = conn.prepareStatement(sql.toString());
				stmtCondiciones.setString(1, idioma);	
				ResultSet rsCondiciones = stmtCondiciones.executeQuery();
				List<String> condiciones = new ArrayList<String>();
				while (rsCondiciones.next()) {
					condiciones.add(rsCondiciones.getString("TEXTOCONDICION"));
				}
				oferta.setCondiciones(condiciones);

				ofertasList.add(oferta);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getOfertas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getOfertas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getOfertas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getOfertas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(ofertasList, new S12RecursosComparator());
		}

		S12Ofertas[] ofertasArray = new S12Ofertas[ofertasList.size()];
		ofertasList.toArray(ofertasArray);
		return ofertasArray;
	}

	/**
	 * Adaptacion del metodo para usar prepared statement y evitar SQL Injection
	 * @param sqlWhere condiciones SQL parametrizadas
	 * @param params objetos con los valores de parametros
	 * @param tipos de cada parametro (as defined in java.sql.Types) to be sent to the database
	 * @param numParams numero de parametros a preparar
	 * @return array con los codigos de recursos que ha cumplido las condiciones de busqueda
	 * @throws S12PortalMovilDaoException
	 */
	public ArrayList<String> getRecursosBaseDatosConPrepare(String sqlWhere, ArrayList<Object> params, ArrayList<Integer> tiposSQL) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<String> corecList = new ArrayList<String>();
		String corec;

		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();
			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("alter session set nls_comp=linguistic");
			stmt = conn.createStatement();
			stmt.execute(sql.toString());

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("alter session set nls_sort=binary_ai");
			stmt.execute(sql.toString());

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT COREC FROM CONSULTAMAT_RECURSOS_PM ");
			sql.append("WHERE ");
			sql.append(sqlWhere);

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			Object[] arrParams = params.toArray();
			Integer[] arrTipos = (Integer[]) tiposSQL.toArray();
			for (int i = 0; i < arrParams.length; i++) {
				prepStmt.setObject(index++, arrParams[i], arrTipos[i]);	
			}
			
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				corec = rs.getString("COREC");

				corecList.add(corec);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return corecList;
	}
	
	/**
	 * Obtiene la lista de codigos de recurso que cumplen los criterios de busqueda. Tira siempre contra la tabla
	 * materializada CONSULTAMAT_RECURSOS_PM
	 * 
	 * @param sqlWhere condiciones de busqueda. Dependen del tipo de recurso.
	 * 
	 * @return lista de codigos de recurso
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal Movil
	 */
	public ArrayList<String> getRecursosBaseDatos(String sqlWhere) throws S12PortalMovilDaoException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<String> corecList = new ArrayList<String>();
		String corec;

		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();
			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("alter session set nls_comp=linguistic");
			stmt = conn.createStatement();
			stmt.execute(sql.toString());

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("alter session set nls_sort=binary_ai");
			stmt.execute(sql.toString());

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT COREC FROM CONSULTAMAT_RECURSOS_PM ");
			sql.append("WHERE ");
			sql.append(sqlWhere);

			rs = stmt.executeQuery(sql.toString());

			while (rs.next()) {
				corec = rs.getString("COREC");

				corecList.add(corec);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return corecList;
	}

	/**
	 * Adaptacion del metodo para usar prepared statement y evitar SQL Injection
	 * Obtiene la lista de cdigos de recurso que cumplen los criterios de bsqueda. (ordenados por distancia a un punto
	 * geogrfico) Tira siempre contra la tabla materializada CONSULTAMAT_RECURSOS_PM
	 * 
	 * @param sqlWhere condiciones de bsqueda. Dependen del tipo de recurso.
	 * @param latOrigen coordenada latitud de referencia
	 * @param longOrigen coordenada longitud de referencia
	 * @param numero_resultados num resultados a obtener (para paginacion)
	 * @param ultimo_resultado numero de linea del ltimo resultado de la paginacin previa (0 para inicial)
	 * @param distanciaMax valor del filtro de distancia mxima
	 * @return lista de cdigos de recurso
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public ArrayList<String> getRecursosBaseDatosDistanciaConPrepare(String sqlWhere, ArrayList<Object> params, ArrayList<Integer> tiposSQL,
			double latOrigen, double longOrigen,
			int numero_resultados, int ultimo_resultado, double distanciaMax) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<String> corecList = new ArrayList<String>();
		String corec;

		StringBuffer sql;

		try {

			S12Utils.trazaLarga(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.DEBUG,
					"getRecursosBaseDatosDistancia: sqlWhere recibida: " + sqlWhere);

			conn = S12ConnectionManager.getConnection();
			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("alter session set nls_comp=linguistic");
			stmt = conn.createStatement();
			stmt.execute(sql.toString());

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("alter session set nls_sort=binary_ai");
			stmt.execute(sql.toString());

			// NOTA: se asumen coordenadas v�lidas en los par�metros de entrada, no se validar�n aqu�.
			int numFilaMax = ultimo_resultado + numero_resultados;

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);

			sql.append("select * from ( select a.*, rownum rnum from (");
			if (distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
				sql.append("select * from ("); // anidamiento para evitar recalculo de distancia
			}
			sql.append("SELECT COREC, ");
//			sql.append("F_DISTANCIA_HAVERSINE(" + latOrigen + ", " + longOrigen
//					+ ",CONSULTAMAT_RECURSOS_PM.GMLAT, CONSULTAMAT_RECURSOS_PM.GMLNG) DISTANCIA ");
			sql.append("F_DISTANCIA_HAVERSINE( ? , ? ,CONSULTAMAT_RECURSOS_PM.GMLAT, CONSULTAMAT_RECURSOS_PM.GMLNG) DISTANCIA ");
			sql.append("FROM CONSULTAMAT_RECURSOS_PM WHERE ");

			// WHERE y ORDER BY
			// Orden de resultados: En sqlWhere nos llega ya con ORDER BY en funcion del tipo de recurso y par�metros de
			// b�squeda, y en todo caso siempre por NAME
			// En este punto, si hemos recibido coordenadas v�lidas, ordenamos con prioridad por distancia (tenemos que
			// ponerlo delante de lo que ya nos llega)
			if (latOrigen != S12Constantes.LATITUD_SIN_VALOR && distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
				String orderBy = "";
				// Partimos la sqlWhere, por el ORDER BY
				int indexOrderBy = sqlWhere.indexOf("ORDER BY"); // -1 cuando no tiene ORDER BY
				if (indexOrderBy < 0) {
					// (siempre va a venir ORDER BY pero nos aseguramos de que as� sea o lo establecemos por defecto)
					orderBy = " ORDER BY DISTANCIA DESC, IMPORTANCIA ASC, NAME ASC";
				} else {
					orderBy = sqlWhere.substring(indexOrderBy);
					sqlWhere = sqlWhere.substring(0, indexOrderBy);
					orderBy = " ORDER BY DISTANCIA ASC, ".concat(orderBy.substring("ORDER BY".length()));
				}
				sqlWhere = sqlWhere.concat(orderBy);
			}
			sql.append(sqlWhere);

			if (distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
//				sql.append(") WHERE DISTANCIA<=" + distanciaMax);
				sql.append(") WHERE DISTANCIA <= ?");
			}
			sql.append(") a where rownum <= " + numFilaMax + " ) where rnum > " + ultimo_resultado);

			S12Utils.trazaLarga(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.DEBUG,
					"S12PortalMovilDAO::getRecursosBaseDatosDistancia: SQL = " + sql.toString());

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			//lat, long para funcion de distancia
			prepStmt.setDouble(index++, latOrigen);				
			prepStmt.setDouble(index++, longOrigen);				
			//params y tiposSQL deberian tener el mismo numero de elementos, es decir, que cada vez que hemos aadido un parmetro, hemos aadido tambin su tipo.
			//aun asi se comprueba en cada iteracion que ambos tengan elementos
			Iterator<Object> iteratorParams = params.iterator();
			Iterator<Integer> iteratorTipos = tiposSQL.iterator();
			while(iteratorParams.hasNext() && iteratorTipos.hasNext()){
				Object object = (Object) iteratorParams.next();
				Integer tipo = (Integer) iteratorTipos.next();
				prepStmt.setObject(index++, object, tipo);				
			}
			//distanciaMax
			if (distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
				prepStmt.setDouble(index++, distanciaMax);				
			}
			
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				corec = rs.getString("COREC");

				corecList.add(corec);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return corecList;
	}

	/**
	 * Obtiene la lista de c�digos de recurso que cumplen los criterios de b�squeda. (ordenados por distancia a un punto
	 * geogr�fico) Tira siempre contra la tabla materializada CONSULTAMAT_RECURSOS_PM
	 * 
	 * @param sqlWhere condiciones de b�squeda. Dependen del tipo de recurso.
	 * @param latOrigen coordenada latitud de referencia
	 * @param longOrigen coordenada longitud de referencia
	 * @param numero_resultados num resultados a obtener (para paginacion)
	 * @param ultimo_resultado numero de linea del �ltimo resultado de la paginaci�n previa (0 para inicial)
	 * @param distanciaMax valor del filtro de distancia m�xima
	 * @return lista de c�digos de recurso
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
//	public ArrayList<String> getRecursosBaseDatosDistancia(String sqlWhere, double latOrigen, double longOrigen,
//			int numero_resultados, int ultimo_resultado, double distanciaMax) throws S12PortalMovilDaoException {
//		Connection conn = null;
//		Statement stmt = null;
//		ResultSet rs = null;
//		ArrayList<String> corecList = new ArrayList<String>();
//		String corec;
//
//		StringBuffer sql;
//
//		try {
//
//			S12Utils.trazaLarga(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.DEBUG,
//					"getRecursosBaseDatosDistancia: sqlWhere recibida: " + sqlWhere);
//
//			conn = S12ConnectionManager.getConnection();
//			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
//
//			sql.append("alter session set nls_comp=linguistic");
//			stmt = conn.createStatement();
//			stmt.execute(sql.toString());
//
//			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
//			sql.append("alter session set nls_sort=binary_ai");
//			stmt.execute(sql.toString());
//
//			// NOTA: se asumen coordenadas v�lidas en los par�metros de entrada, no se validar�n aqu�.
//			int numFilaMax = ultimo_resultado + numero_resultados;
//
//			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
//
//			sql.append("select * from ( select a.*, rownum rnum from (");
//			if (distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
//				sql.append("select * from ("); // anidamiento para evitar recalculo de distancia
//			}
//			sql.append("SELECT COREC, ");
//			sql.append("F_DISTANCIA_HAVERSINE(" + latOrigen + ", " + longOrigen
//					+ ",CONSULTAMAT_RECURSOS_PM.GMLAT, CONSULTAMAT_RECURSOS_PM.GMLNG) DISTANCIA ");
//			sql.append("FROM CONSULTAMAT_RECURSOS_PM WHERE ");
//
//			// WHERE y ORDER BY
//			// Orden de resultados: En sqlWhere nos llega ya con ORDER BY en funcion del tipo de recurso y par�metros de
//			// b�squeda, y en todo caso siempre por NAME
//			// En este punto, si hemos recibido coordenadas v�lidas, ordenamos con prioridad por distancia (tenemos que
//			// ponerlo delante de lo que ya nos llega)
//			if (latOrigen != S12Constantes.LATITUD_SIN_VALOR && distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
//				String orderBy = "";
//				// Partimos la sqlWhere, por el ORDER BY
//				int indexOrderBy = sqlWhere.indexOf("ORDER BY"); // -1 cuando no tiene ORDER BY
//				if (indexOrderBy < 0) {
//					// (siempre va a venir ORDER BY pero nos aseguramos de que as� sea o lo establecemos por defecto)
//					orderBy = " ORDER BY DISTANCIA DESC, IMPORTANCIA ASC, NAME ASC";
//				} else {
//					orderBy = sqlWhere.substring(indexOrderBy);
//					sqlWhere = sqlWhere.substring(0, indexOrderBy);
//					orderBy = " ORDER BY DISTANCIA ASC, ".concat(orderBy.substring("ORDER BY".length()));
//				}
//				sqlWhere = sqlWhere.concat(orderBy);
//			}
//			sql.append(sqlWhere);
//
//			if (distanciaMax != S12Constantes.DISTANCIA_SIN_VALOR) {
//				sql.append(") WHERE DISTANCIA<=" + distanciaMax);
//			}
//			sql.append(") a where rownum <= " + numFilaMax + " ) where rnum > " + ultimo_resultado);
//
//			S12Utils.trazaLarga(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.DEBUG,
//					"S12PortalMovilDAO::getRecursosBaseDatosDistancia: SQL = " + sql.toString());
//
//			rs = stmt.executeQuery(sql.toString());
//
//			while (rs.next()) {
//				corec = rs.getString("COREC");
//
//				corecList.add(corec);
//			}
//		} catch (NamingException e) {
//			if (Q70Factoria.getTraza().isTraceActive()) {
//				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
//						"S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception: " + e.getMessage());
//			}
//			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatos: Exception ", e);
//		} catch (SQLException e) {
//			if (Q70Factoria.getTraza().isTraceActive()) {
//				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
//						"S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception: " + e.getMessage());
//			}
//			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosBaseDatosDistancia: Exception ", e);
//		} finally {
//			S12ConnectionManager.close(rs);
//			S12ConnectionManager.close(stmt);
//			S12ConnectionManager.close(conn);
//		}
//
//		return corecList;
//	}

	/**
	 * Gets the palacio congreso.
	 * 
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * 
	 * @return the palacio congreso
	 * 
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	public S12PalacioCongreso[] getPalacioCongreso(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12PalacioCongreso> palacioCongresosList = new ArrayList<S12PalacioCongreso>();
		S12PalacioCongreso palacioCongreso;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PALACIOSCONGRESO.COREC, PALACIOSCONGRESO.COIDIOMA, DATOS_GENERALES.NOMBRE, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PALACIOSCONGRESO.COREC, PALACIOSCONGRESO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PALACIOSCONGRESO.COREC, PALACIOSCONGRESO.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PALACIOSCONGRESO LEFT OUTER JOIN GEOREFERENCIACION ON PALACIOSCONGRESO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PALACIOSCONGRESO.COREC = POSICIONAMIENTO.COREC AND PALACIOSCONGRESO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PALACIOSCONGRESO.COREC = DATOS_GENERALES.COREC AND PALACIOSCONGRESO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PALACIOSCONGRESO.COREC = MULTIMEDIA.COREC AND PALACIOSCONGRESO.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");

			sql.append("WHERE 1 = 1 ");
			sql.append("AND PALACIOSCONGRESO.COIDIOMA = ? ");

			sql.append("AND PALACIOSCONGRESO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				palacioCongreso = new S12PalacioCongreso();

				palacioCongreso.setCodigoRecurso(rs.getInt("COREC"));
				palacioCongreso.setIdioma(rs.getString("COIDIOMA"));
				palacioCongreso.setNombre(rs.getString("NOMBRE"));
				palacioCongreso.setTelefono(rs.getString("TELEFONO1"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					palacioCongreso.setFotoPrincipal(multimedia);
					palacioCongreso.setDescFoto(descMultimedia);
				} else {
					palacioCongreso.setFotoPrincipal(foto);
					palacioCongreso.setDescFoto(pieFoto);
				}

				palacioCongreso.setUrlAmigable(rs.getString("URLAMIGABLE"));
				palacioCongreso.setGmlong(rs.getString("GMLNG"));
				palacioCongreso.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& palacioCongreso.getGmlong() != null && palacioCongreso.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(palacioCongreso.getGmlat()),
							Double.parseDouble(palacioCongreso.getGmlong()), latUser, longUser);
					palacioCongreso.setDistancia(String.valueOf(distancia));
				}

				palacioCongresosList.add(palacioCongreso);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPalacioCongreso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPalacioCongreso: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPalacioCongreso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPalacioCongreso: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(palacioCongresosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(palacioCongresosList, new S12RecursosDefaultComparator());
		}

		S12PalacioCongreso[] palacioCongresoArray = new S12PalacioCongreso[palacioCongresosList.size()];
		palacioCongresosList.toArray(palacioCongresoArray);
		return palacioCongresoArray;
	}

	/**
	 * Gets the empresas relacionadas.
	 * 
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * 
	 * @return the empresas relacionadas
	 * 
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	public S12EmpresaRelacionada[] getEmpresasRelacionadas(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EmpresaRelacionada> empresaRelacionadaList = new ArrayList<S12EmpresaRelacionada>();
		S12EmpresaRelacionada empresaRelacionada;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT EMPRESASRELACIONADAS.COREC, EMPRESASRELACIONADAS.COIDIOMA, ");
			sql.append("DATOS_GENERALES.NOMBRE, DATOS_GENERALES.TELEFONO1, ");
			sql.append("DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("S12.GEO_MUNICIPALITY(EMPRESASRELACIONADAS.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(EMPRESASRELACIONADAS.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(EMPRESASRELACIONADAS.COREC) AS NOPROV, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(EMPRESASRELACIONADAS.COREC, EMPRESASRELACIONADAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(EMPRESASRELACIONADAS.COREC, EMPRESASRELACIONADAS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("EMPRESASRELACIONADAS.ESPECIALIDAD, EMPRESASRELACIONADAS.CODIGOCIE, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, TSERVISO.COSERVICIO AS ISO, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, TSERVQC.COSERVICIO as Q_CALIDAD, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVQO.COSERVICIO as Q_ORO, TSERVQP.COSERVICIO as Q_PLATA, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM EMPRESASRELACIONADAS LEFT OUTER JOIN GEOREFERENCIACION ON EMPRESASRELACIONADAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON EMPRESASRELACIONADAS.COREC = POSICIONAMIENTO.COREC AND EMPRESASRELACIONADAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON EMPRESASRELACIONADAS.COREC = PM_RECURSOS_TOWN.COREC AND EMPRESASRELACIONADAS.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON EMPRESASRELACIONADAS.COREC = DATOS_GENERALES.COREC AND EMPRESASRELACIONADAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON EMPRESASRELACIONADAS.COREC = MULTI1.COREC AND EMPRESASRELACIONADAS.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON EMPRESASRELACIONADAS.COREC = MULTI2.COREC AND EMPRESASRELACIONADAS.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			// Club Producto
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO).append(" AND COIDIOMA = ?")
					.append(") TSERVPRODUCTO ON EMPRESASRELACIONADAS.COREC = TSERVPRODUCTO.COREC ");
			// Q Oro
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON EMPRESASRELACIONADAS.COREC = TSERVQO.COREC ");
			// Q Plata
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON EMPRESASRELACIONADAS.COREC = TSERVQP.COREC ");
			// Q de Calidad
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON EMPRESASRELACIONADAS.COREC = TSERVQC.COREC ");
			// buenas practicas
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON EMPRESASRELACIONADAS.COREC = TSERVBP.COREC ");
			// ECOLABEL
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL).append(" AND COIDIOMA = ?")
					.append(") TSERVECOL ON EMPRESASRELACIONADAS.COREC = TSERVECOL.COREC ");
			// ISO
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON EMPRESASRELACIONADAS.COREC = TSERVISO.COREC ");
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASRELACIONADAS.COREC, COSERVICIO FROM EMPRESASRELACIONADAS, REC_SRV WHERE REC_SRV.COREC = EMPRESASRELACIONADAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON EMPRESASRELACIONADAS.COREC = TSERVINNOVA.COREC ");

			sql.append("WHERE 1 = 1 ");
			sql.append("AND EMPRESASRELACIONADAS.COIDIOMA = ? ");

			sql.append("AND EMPRESASRELACIONADAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				empresaRelacionada = new S12EmpresaRelacionada();
				arrServicios = new ArrayList<String>();

				empresaRelacionada.setCodigoRecurso(rs.getInt("COREC"));
				empresaRelacionada.setIdioma(rs.getString("COIDIOMA"));
				empresaRelacionada.setNombre(rs.getString("NOMBRE"));

				empresaRelacionada.setCodigoCIE(rs.getString("CODIGOCIE"));
				empresaRelacionada.setEspecialidad(rs.getString("ESPECIALIDAD"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					empresaRelacionada.setFotoPrincipal(multimedia);
					empresaRelacionada.setDescFoto(descMultimedia);
				} else {
					empresaRelacionada.setFotoPrincipal(foto);
					empresaRelacionada.setDescFoto(pieFoto);
				}

				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				empresaRelacionada.setFotoA(multimediaA);
				empresaRelacionada.setDescFotoA(descMultimediaA);

				empresaRelacionada.setUrlAmigable(rs.getString("URLAMIGABLE"));
				empresaRelacionada.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));
				empresaRelacionada.setGmlong(rs.getString("GMLNG"));
				empresaRelacionada.setGmlat(rs.getString("GMLAT"));

				empresaRelacionada.setMail(rs.getString("MAIL"));
				empresaRelacionada.setTelefono(rs.getString("TELEFONO1"));
				empresaRelacionada.setDireccion(rs.getString("DIRECCION"));
				empresaRelacionada.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				empresaRelacionada.setWeb(rs.getString("URL"));
				empresaRelacionada.setTown(rs.getString("MUNICIPIO"));
				empresaRelacionada.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				empresaRelacionada.setProvincia(rs.getString("NOPROV"));

				// OJO: el orden de los servicios en el array IDENTIFICA CADA SERVICIO.
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				empresaRelacionada.setArrServicios(arrServicios);

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& empresaRelacionada.getGmlong() != null && empresaRelacionada.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(empresaRelacionada.getGmlat()),
							Double.parseDouble(empresaRelacionada.getGmlong()), latUser, longUser);
					empresaRelacionada.setDistancia(String.valueOf(distancia));
				}

				empresaRelacionadaList.add(empresaRelacionada);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPalacioCongreso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPalacioCongreso: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPalacioCongreso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPalacioCongreso: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(empresaRelacionadaList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(empresaRelacionadaList, new S12RecursosDefaultComparator());
		}

		S12EmpresaRelacionada[] empresasRelacionadasArray = new S12EmpresaRelacionada[empresaRelacionadaList.size()];
		empresaRelacionadaList.toArray(empresasRelacionadasArray);
		return empresasRelacionadasArray;
	}

	/**
	 * Obtiene la lista de recintos feriales que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de recintos feriales
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12RecintoFerial[] getRecintoFerial(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12RecintoFerial> recintoFerialesList = new ArrayList<S12RecintoFerial>();
		S12RecintoFerial recintoFerial;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM DATOS_GENERALES LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				recintoFerial = new S12RecintoFerial();

				recintoFerial.setCodigoRecurso(rs.getInt("COREC"));
				recintoFerial.setIdioma(rs.getString("COIDIOMA"));
				recintoFerial.setNombre(rs.getString("NOMBRE"));

				recintoFerial.setTelefono(rs.getString("TELEFONO1"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					recintoFerial.setFotoPrincipal(multimedia);
					recintoFerial.setDescFoto(descMultimedia);
				} else {
					recintoFerial.setFotoPrincipal(foto);
					recintoFerial.setDescFoto(pieFoto);
				}

				recintoFerial.setUrlAmigable(rs.getString("URLAMIGABLE"));

				recintoFerial.setGmlong(rs.getString("GMLNG"));
				recintoFerial.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& recintoFerial.getGmlong() != null && recintoFerial.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(recintoFerial.getGmlat()),
							Double.parseDouble(recintoFerial.getGmlong()), latUser, longUser);
					recintoFerial.setDistancia(String.valueOf(distancia));
				}

				recintoFerialesList.add(recintoFerial);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecintoFerial: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecintoFerial: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecintoFerial: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecintoFerial: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(recintoFerialesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(recintoFerialesList, new S12RecursosDefaultComparator());
		}

		S12RecintoFerial[] recintoFerialArray = new S12RecintoFerial[recintoFerialesList.size()];
		recintoFerialesList.toArray(recintoFerialArray);
		return recintoFerialArray;
	}

	/**
	 * Obtiene la lista de turismo salud que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de turismo salud
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12TurismoSalud[] getTurismoSalud(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12TurismoSalud> turismoSaludList = new ArrayList<S12TurismoSalud>();
		S12TurismoSalud turismoSalud;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT EMPRESASSALUD.COREC, EMPRESASSALUD.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(EMPRESASSALUD.COREC, EMPRESASSALUD.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(EMPRESASSALUD.COREC, EMPRESASSALUD.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("TSERVQC.COSERVICIO AS Q_CALIDAD, TSERVIS.COSERVICIO as ISO, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM EMPRESASSALUD LEFT OUTER JOIN GEOREFERENCIACION ON EMPRESASSALUD.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON EMPRESASSALUD.COREC = POSICIONAMIENTO.COREC AND EMPRESASSALUD.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON EMPRESASSALUD.COREC = DATOS_GENERALES.COREC AND EMPRESASSALUD.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA  ON EMPRESASSALUD.COREC = MULTIMEDIA.COREC AND EMPRESASSALUD.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");

			sql.append("LEFT OUTER JOIN (SELECT EMPRESASSALUD.COREC, COSERVICIO FROM EMPRESASSALUD, REC_SRV WHERE REC_SRV.COREC = EMPRESASSALUD.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON EMPRESASSALUD.COREC = TSERVQC.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASSALUD.COREC, COSERVICIO FROM EMPRESASSALUD, REC_SRV WHERE REC_SRV.COREC = EMPRESASSALUD.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON EMPRESASSALUD.COREC = TSERVINNOVA.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASSALUD.COREC, COSERVICIO FROM EMPRESASSALUD, REC_SRV WHERE REC_SRV.COREC = EMPRESASSALUD.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVIS ON EMPRESASSALUD.COREC = TSERVIS.COREC ");

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND EMPRESASSALUD.COIDIOMA = ? ");
			sql.append("AND EMPRESASSALUD.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				turismoSalud = new S12TurismoSalud();
				arrServicios = new ArrayList<String>();

				turismoSalud.setCodigoRecurso(rs.getInt("COREC"));
				turismoSalud.setIdioma(rs.getString("COIDIOMA"));
				turismoSalud.setNombre(rs.getString("NOMBRE"));

				turismoSalud.setTelefono(rs.getString("TELEFONO1"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					turismoSalud.setFotoPrincipal(multimedia);
					turismoSalud.setDescFoto(descMultimedia);
				} else {
					turismoSalud.setFotoPrincipal(foto);
					turismoSalud.setDescFoto(pieFoto);
				}

				turismoSalud.setUrlAmigable(rs.getString("URLAMIGABLE"));

				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				turismoSalud.setArrServicios(arrServicios);

				turismoSalud.setGmlong(rs.getString("GMLNG"));
				turismoSalud.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& turismoSalud.getGmlong() != null && turismoSalud.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(turismoSalud.getGmlat()),
							Double.parseDouble(turismoSalud.getGmlong()), latUser, longUser);
					turismoSalud.setDistancia(String.valueOf(distancia));
				}

				turismoSaludList.add(turismoSalud);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecintoFerial: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecintoFerial: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecintoFerial: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecintoFerial: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(turismoSaludList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(turismoSaludList, new S12RecursosDefaultComparator());
		}

		S12TurismoSalud[] turismoSaludArray = new S12TurismoSalud[turismoSaludList.size()];
		turismoSaludList.toArray(turismoSaludArray);
		return turismoSaludArray;
	}

	/**
	 * Obtiene la lista de aeropuertos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de aeropuertoS
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Aeropuerto[] getAeropuertos(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Aeropuerto> aeropuertosList = new ArrayList<S12Aeropuerto>();
		S12Aeropuerto aeropuerto;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT AEROPUERTO.COREC, AEROPUERTO.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(AEROPUERTO.COREC, AEROPUERTO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(AEROPUERTO.COREC, AEROPUERTO.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM AEROPUERTO LEFT OUTER JOIN GEOREFERENCIACION ON AEROPUERTO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON AEROPUERTO.COREC = POSICIONAMIENTO.COREC AND AEROPUERTO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON AEROPUERTO.COREC = DATOS_GENERALES.COREC AND AEROPUERTO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON AEROPUERTO.COREC = MULTIMEDIA.COREC AND AEROPUERTO.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND AEROPUERTO.COIDIOMA = ? ");
			sql.append("AND AEROPUERTO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				aeropuerto = new S12Aeropuerto();

				aeropuerto.setCodigoRecurso(rs.getInt("COREC"));
				aeropuerto.setIdioma(rs.getString("COIDIOMA"));
				aeropuerto.setNombre(rs.getString("NOMBRE"));

				aeropuerto.setTelefono(rs.getString("TELEFONO1"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					aeropuerto.setFotoPrincipal(multimedia);
					aeropuerto.setDescFoto(descMultimedia);
				} else {
					aeropuerto.setFotoPrincipal(foto);
					aeropuerto.setDescFoto(pieFoto);
				}

				aeropuerto.setUrlAmigable(rs.getString("URLAMIGABLE"));

				aeropuerto.setGmlong(rs.getString("GMLNG"));
				aeropuerto.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& aeropuerto.getGmlong() != null && aeropuerto.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(aeropuerto.getGmlat()),
							Double.parseDouble(aeropuerto.getGmlong()), latUser, longUser);
					aeropuerto.setDistancia(String.valueOf(distancia));
				}

				aeropuertosList.add(aeropuerto);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAeropuertos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAeropuertos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAeropuertos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAeropuertos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(aeropuertosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(aeropuertosList, new S12RecursosDefaultComparator());
		}

		S12Aeropuerto[] aeropuertosArray = new S12Aeropuerto[aeropuertosList.size()];
		aeropuertosList.toArray(aeropuertosArray);
		return aeropuertosArray;
	}

	/**
	 * Obtiene la lista de compa�ias de transporte que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de compa�ias de transporte
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12CompaniasTransporte[] getCompaniasTransporte(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		// public S12Compa�iasTransporte[] getCompaniasTransporte(ArrayList<String> arrRecursos, String idioma, double
		// latUser, double longUser, int numero_resultados, int ultimo_resultado, double distanciaMax) throws
		// S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12CompaniasTransporte> companiasTransporteList = new ArrayList<S12CompaniasTransporte>();
		S12CompaniasTransporte companiaTransporte;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT COMPANIASTRANSPORTE.COREC, COMPANIASTRANSPORTE.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(COMPANIASTRANSPORTE.COREC, COMPANIASTRANSPORTE.COIDIOMA) AS NOLOGO, DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("S12.GEO_MUNICIPALITY(COMPANIASTRANSPORTE.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(COMPANIASTRANSPORTE.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(DATOS_GENERALES.COREC) AS NOPROV, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.TELEFONO2, ");
			sql.append("DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.FAX, S12.DESC_FOTO_PRINCIPAL_RECURSO(COMPANIASTRANSPORTE.COREC, COMPANIASTRANSPORTE.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVISO.COSERVICIO AS ISO, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVQO.COSERVICIO as Q_ORO, TSERVQP.COSERVICIO as Q_PLATA, TSERVQC.COSERVICIO as Q_CALIDAD, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE ");
			sql.append("FROM COMPANIASTRANSPORTE LEFT OUTER JOIN GEOREFERENCIACION ON COMPANIASTRANSPORTE.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON COMPANIASTRANSPORTE.COREC = POSICIONAMIENTO.COREC AND COMPANIASTRANSPORTE.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON COMPANIASTRANSPORTE.COREC = PM_RECURSOS_TOWN.COREC AND COMPANIASTRANSPORTE.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON COMPANIASTRANSPORTE.COREC = DATOS_GENERALES.COREC AND COMPANIASTRANSPORTE.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON COMPANIASTRANSPORTE.COREC = MULTI1.COREC AND COMPANIASTRANSPORTE.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON COMPANIASTRANSPORTE.COREC = MULTI2.COREC AND COMPANIASTRANSPORTE.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			// buenas practicas
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON COMPANIASTRANSPORTE.COREC = TSERVBP.COREC ");
			// ISO
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON COMPANIASTRANSPORTE.COREC = TSERVISO.COREC ");
			// accesibilidad
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON COMPANIASTRANSPORTE.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			// Q Oro
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON COMPANIASTRANSPORTE.COREC = TSERVQO.COREC ");
			// Q Plata
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON COMPANIASTRANSPORTE.COREC = TSERVQP.COREC ");
			// Q de Calidad
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON COMPANIASTRANSPORTE.COREC = TSERVQC.COREC ");
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT COMPANIASTRANSPORTE.COREC, COSERVICIO FROM COMPANIASTRANSPORTE, REC_SRV WHERE REC_SRV.COREC = COMPANIASTRANSPORTE.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON COMPANIASTRANSPORTE.COREC = TSERVINNOVA.COREC ");

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND COMPANIASTRANSPORTE.COIDIOMA = ? ");

			sql.append("AND COMPANIASTRANSPORTE.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				companiaTransporte = new S12CompaniasTransporte();
				arrServicios = new ArrayList<String>();

				companiaTransporte.setCodigoRecurso(rs.getInt("COREC"));
				companiaTransporte.setIdioma(rs.getString("COIDIOMA"));
				companiaTransporte.setNombre(rs.getString("NOMBRE"));

				companiaTransporte.setDireccion(rs.getString("DIRECCION"));
				companiaTransporte.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				companiaTransporte.setMunicipio(rs.getString("MUNICIPIO"));
				companiaTransporte.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				companiaTransporte.setProvincia(rs.getString("NOPROV"));

				companiaTransporte.setTelefono(rs.getString("TELEFONO1"));
				companiaTransporte.setTelefono2(rs.getString("TELEFONO2"));
				companiaTransporte.setTelefonoDescripcion(rs.getString("DESCTELEFONO1"));
				companiaTransporte.setTelefonoDescripcion2(rs.getString("DESCTELEFONO2"));
				companiaTransporte.setFax(rs.getString("FAX"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOLOGO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					companiaTransporte.setFotoPrincipal(multimedia);
					companiaTransporte.setDescFoto(descMultimedia);
				} else {
					companiaTransporte.setFotoPrincipal(foto);
					companiaTransporte.setDescFoto(pieFoto);
				}
				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				companiaTransporte.setFotoA(multimediaA);
				companiaTransporte.setDescFotoA(descMultimediaA);

				companiaTransporte.setUrlAmigable(rs.getString("URLAMIGABLE"));
				companiaTransporte.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				// OJO: el orden de los servicios en el array IDENTIFICA CADA SERVICIO.
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				companiaTransporte.setArrServicios(arrServicios);

				companiaTransporte.setEmail(rs.getString("MAIL"));
				companiaTransporte.setWeb(rs.getString("URL"));

				companiaTransporte.setGmlong(rs.getString("GMLNG"));
				companiaTransporte.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& companiaTransporte.getGmlong() != null && companiaTransporte.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(companiaTransporte.getGmlat()),
							Double.parseDouble(companiaTransporte.getGmlong()), latUser, longUser);
					companiaTransporte.setDistancia(String.valueOf(distancia));
				}

				companiasTransporteList.add(companiaTransporte);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCompaniasTransporte: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCompaniasTransporte: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCompaniasTransporte: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCompaniasTransporte: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(companiasTransporteList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(companiasTransporteList, new S12RecursosDefaultComparator());
		}

		S12CompaniasTransporte[] companiasTransporteArray = new S12CompaniasTransporte[companiasTransporteList.size()];
		companiasTransporteList.toArray(companiasTransporteArray);
		return companiasTransporteArray;
	}

	/**
	 * Obtiene la lista de estaciones de transporte que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de estaciones de transporte
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12EstacionesTransporte[] getEstacionesTransporte(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		// public S12EstacionesTransporte[] getEstacionesTransporte(ArrayList<String> arrRecursos, String idioma, double
		// latUser, double longUser, int numero_resultados, int ultimo_resultado, double distanciaMax) throws
		// S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EstacionesTransporte> estacionesTransporteList = new ArrayList<S12EstacionesTransporte>();
		S12EstacionesTransporte estacionTransporte;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("S12.GEO_MUNICIPALITY(DATOS_GENERALES.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(DATOS_GENERALES.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(DATOS_GENERALES.COREC) AS NOPROV, ");
			sql.append("DATOS_GENERALES.FAX, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVISO.COSERVICIO AS ISO, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVQO.COSERVICIO as Q_ORO, TSERVQP.COSERVICIO as Q_PLATA, TSERVQC.COSERVICIO as Q_CALIDAD, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM DATOS_GENERALES LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON DATOS_GENERALES.COREC = PM_RECURSOS_TOWN.COREC AND DATOS_GENERALES.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON DATOS_GENERALES.COREC = MULTI1.COREC AND DATOS_GENERALES.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON DATOS_GENERALES.COREC = MULTI2.COREC AND DATOS_GENERALES.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			// Q Oro
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON DATOS_GENERALES.COREC = TSERVQO.COREC ");
			// Q Plata
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON DATOS_GENERALES.COREC = TSERVQP.COREC ");
			// Q de Calidad
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON DATOS_GENERALES.COREC = TSERVQC.COREC ");
			// buenas practicas
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON DATOS_GENERALES.COREC = TSERVBP.COREC ");
			// ISO
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON DATOS_GENERALES.COREC = TSERVISO.COREC ");
			// accesibilidad
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON DATOS_GENERALES.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT DATOS_GENERALES.COREC, COSERVICIO FROM DATOS_GENERALES, REC_SRV WHERE REC_SRV.COREC = DATOS_GENERALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON DATOS_GENERALES.COREC = TSERVINNOVA.COREC ");

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");

			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				estacionTransporte = new S12EstacionesTransporte();
				arrServicios = new ArrayList<String>();

				estacionTransporte.setCodigoRecurso(rs.getInt("COREC"));
				estacionTransporte.setIdioma(rs.getString("COIDIOMA"));
				estacionTransporte.setNombre(rs.getString("NOMBRE"));

				estacionTransporte.setDireccion(rs.getString("DIRECCION"));
				estacionTransporte.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				estacionTransporte.setMunicipio(rs.getString("MUNICIPIO"));
				estacionTransporte.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				estacionTransporte.setProvincia(rs.getString("NOPROV"));

				estacionTransporte.setTelefono(rs.getString("TELEFONO1"));
				estacionTransporte.setTelefono2(rs.getString("TELEFONO2"));
				estacionTransporte.setDescTelefono(rs.getString("DESCTELEFONO1"));
				estacionTransporte.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				estacionTransporte.setFax(rs.getString("FAX"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					estacionTransporte.setFotoPrincipal(multimedia);
					estacionTransporte.setDescFoto(descMultimedia);
				} else {
					estacionTransporte.setFotoPrincipal(foto);
					estacionTransporte.setDescFoto(pieFoto);
				}

				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				estacionTransporte.setFotoA(multimediaA);
				estacionTransporte.setDescFotoA(descMultimediaA);

				estacionTransporte.setUrlAmigable(rs.getString("URLAMIGABLE"));
				estacionTransporte.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				estacionTransporte.setArrServicios(arrServicios);

				estacionTransporte.setEmail(rs.getString("MAIL"));
				estacionTransporte.setWeb(rs.getString("URL"));

				estacionTransporte.setGmlong(rs.getString("GMLNG"));
				estacionTransporte.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& estacionTransporte.getGmlong() != null && estacionTransporte.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(estacionTransporte.getGmlat()),
							Double.parseDouble(estacionTransporte.getGmlong()), latUser, longUser);
					estacionTransporte.setDistancia(String.valueOf(distancia));
				}

				estacionesTransporteList.add(estacionTransporte);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEstacionesTransporte: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEstacionesTransporte: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEstacionesTransporte: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEstacionesTransporte: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(estacionesTransporteList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(estacionesTransporteList, new S12RecursosDefaultComparator());
		}

		S12EstacionesTransporte[] estacionesTransporteArray = new S12EstacionesTransporte[estacionesTransporteList
				.size()];
		estacionesTransporteList.toArray(estacionesTransporteArray);
		return estacionesTransporteArray;
	}

	/**
	 * Obtiene la lista de localidades que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de localidades
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Localidades[] getLocalidades(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Localidades> localidadesList = new ArrayList<S12Localidades>();
		S12Localidades localidad;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT LOCALIDADES.COREC, LOCALIDADES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(LOCALIDADES.COREC, LOCALIDADES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(LOCALIDADES.COREC, LOCALIDADES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM LOCALIDADES LEFT OUTER JOIN GEOREFERENCIACION ON LOCALIDADES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON LOCALIDADES.COREC = POSICIONAMIENTO.COREC AND LOCALIDADES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON LOCALIDADES.COREC = DATOS_GENERALES.COREC AND LOCALIDADES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON LOCALIDADES.COREC = MULTIMEDIA.COREC AND LOCALIDADES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND LOCALIDADES.COIDIOMA = ? ");
			sql.append("AND LOCALIDADES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				localidad = new S12Localidades();

				localidad.setCodigoRecurso(rs.getInt("COREC"));
				localidad.setIdioma(rs.getString("COIDIOMA"));
				localidad.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					localidad.setFotoPrincipal(multimedia);
					localidad.setDescFoto(descMultimedia);
				} else {
					localidad.setFotoPrincipal(foto);
					localidad.setDescFoto(pieFoto);
				}

				localidad.setUrlAmigable(rs.getString("URLAMIGABLE"));

				localidad.setGmlong(rs.getString("GMLNG"));
				localidad.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& localidad.getGmlong() != null && localidad.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(localidad.getGmlat()),
							Double.parseDouble(localidad.getGmlong()), latUser, longUser);
					localidad.setDistancia(String.valueOf(distancia));
				}

				localidadesList.add(localidad);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getLocalidades: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getLocalidades: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getLocalidades: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getLocalidades: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(localidadesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(localidadesList, new S12RecursosDefaultComparator());
		}

		S12Localidades[] localidadesArray = new S12Localidades[localidadesList.size()];
		localidadesList.toArray(localidadesArray);
		return localidadesArray;
	}

	/**
	 * Obtiene la lista de destinos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de destinos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Destinos[] getDestinos(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Destinos> destinosList = new ArrayList<S12Destinos>();
		S12Destinos destino;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, RECURSO.MARCAS ");
			sql.append("FROM RECURSO INNER JOIN DATOS_GENERALES ON RECURSO.COREC = DATOS_GENERALES.COREC ");
			sql.append("LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				destino = new S12Destinos();

				destino.setCodigoRecurso(rs.getInt("COREC"));
				destino.setIdioma(rs.getString("COIDIOMA"));
				destino.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					destino.setFotoPrincipal(multimedia);
					destino.setDescFoto(descMultimedia);
				} else {
					destino.setFotoPrincipal(foto);
					destino.setDescFoto(pieFoto);
				}

				destino.setUrlAmigable(rs.getString("URLAMIGABLE"));

				String marcas = rs.getString("MARCAS");
				if (marcas != null) {
					String[] arrayMarcas = marcas.split(",");
					StringBuffer strMarcas = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
					for (int i = 0; i < arrayMarcas.length; i++) {
						if (i == 0) {
							strMarcas.append(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
									"zona." + arrayMarcas[i], destino.getIdioma()));
						} else {
							strMarcas.append(", ").append(
									Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
											"zona." + arrayMarcas[i], destino.getIdioma()));
						}
					}
					destino.setZona(strMarcas.toString());
				}

				destino.setGmlong(rs.getString("GMLNG"));
				destino.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& destino.getGmlong() != null && destino.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(destino.getGmlat()),
							Double.parseDouble(destino.getGmlong()), latUser, longUser);
					destino.setDistancia(String.valueOf(distancia));
				}

				destinosList.add(destino);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDestinos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDestinos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDestinos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDestinos: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDestinos: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(destinosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(destinosList, new S12RecursosDefaultComparator());
		}

		S12Destinos[] destinosArray = new S12Destinos[destinosList.size()];
		destinosList.toArray(destinosArray);
		return destinosArray;
	}

	/**
	 * Obtiene la lista de Vias Verdes que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Vias Verdes
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12ViaVerde[] getViasVerdes(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12ViaVerde> viasVerdesList = new ArrayList<S12ViaVerde>();
		S12ViaVerde viaVerde;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT VIASVERDES.COREC, VIASVERDES.COIDIOMA, VIASVERDES.NORECURSO, VIASVERDES.NOFOTOPUNTO1,");
			sql.append("VIASVERDES.NOMINIATURAB AS MULTIMEDIA, VIASVERDES.DEMINIATURAB AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, DESTACADOS.URLAMIGABLE, VIASVERDES.NOLONGITUD ");
			sql.append("FROM VIASVERDES, GEOREFERENCIACION, DESTACADOS ");
			sql.append("WHERE VIASVERDES.COREC = GEOREFERENCIACION.COREC(+) ");
			sql.append("AND VIASVERDES.COREC = DESTACADOS.COREC ");
			sql.append("AND VIASVERDES.COIDIOMA = DESTACADOS.COIDIOMA ");

			// Idioma
			sql.append("AND VIASVERDES.COIDIOMA = ? ");
			sql.append("AND VIASVERDES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				viaVerde = new S12ViaVerde();

				viaVerde.setCodigoRecurso(rs.getInt("COREC"));
				viaVerde.setIdioma(rs.getString("COIDIOMA"));
				viaVerde.setNombre(rs.getString("NORECURSO"));

				viaVerde.setFotoPrincipal(rs.getString("MULTIMEDIA"));
				viaVerde.setDescFoto(rs.getString("DESCMULTIMEDIA"));

				viaVerde.setUrlAmigable(rs.getString("URLAMIGABLE"));
				viaVerde.setLongitud(rs.getString("NOLONGITUD"));

				viaVerde.setGmlong(rs.getString("GMLNG"));
				viaVerde.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& viaVerde.getGmlong() != null && viaVerde.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(viaVerde.getGmlat()),
							Double.parseDouble(viaVerde.getGmlong()), latUser, longUser);
					viaVerde.setDistancia(String.valueOf(distancia));
				}

				viasVerdesList.add(viaVerde);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getViasVerdes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getViasVerdes: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getViasVerdes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getViasVerdes: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(viasVerdesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(viasVerdesList, new S12RecursosDefaultComparator());
		}

		S12ViaVerde[] viasVerdesArray = new S12ViaVerde[viasVerdesList.size()];
		viasVerdesList.toArray(viasVerdesArray);
		return viasVerdesArray;
	}

	/**
	 * Obtiene la lista de No Te Lo Pierdas que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de No Te Lo Pierdas
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12NoTeLoPierdas[] getNoTeLoPierdas(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12NoTeLoPierdas> noTeLoPierdasList = new ArrayList<S12NoTeLoPierdas>();
		S12NoTeLoPierdas noTeLoPierdas;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT VISITAS.COREC, VISITAS.COIDIOMA, VISITAS.NORECURSO, VISITAS.NOFOTO, VISITAS.DEPIEFOTO, VISITAS.COPERFIL, ");
			sql.append("VISITAS.NOMINIATURAB AS MULTIMEDIA, VISITAS.DEMINIATURAB AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, DESTACADOS.URLAMIGABLE, VISITAS.NOENTRADILLA ");
			sql.append("FROM VISITAS, GEOREFERENCIACION, DESTACADOS ");
			sql.append("WHERE VISITAS.COREC = GEOREFERENCIACION.COREC(+) ");
			sql.append("AND VISITAS.COREC = DESTACADOS.COREC ");
			sql.append("AND VISITAS.COIDIOMA = DESTACADOS.COIDIOMA ");

			// Idioma
			sql.append("AND VISITAS.COIDIOMA = ? ");
			sql.append("AND VISITAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				noTeLoPierdas = new S12NoTeLoPierdas();

				noTeLoPierdas.setCodigoRecurso(rs.getInt("COREC"));
				noTeLoPierdas.setIdioma(rs.getString("COIDIOMA"));
				noTeLoPierdas.setNombre(rs.getString("NORECURSO"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					noTeLoPierdas.setFotoPrincipal(multimedia);
					noTeLoPierdas.setDescFoto(descMultimedia);
				} else {
					noTeLoPierdas.setFotoPrincipal(foto);
					noTeLoPierdas.setDescFoto(pieFoto);
				}

				noTeLoPierdas.setUrlAmigable(rs.getString("URLAMIGABLE"));

				noTeLoPierdas.setGmlong(rs.getString("GMLNG"));
				noTeLoPierdas.setGmlat(rs.getString("GMLAT"));

				noTeLoPierdas.setDescripcion(rs.getString("NOENTRADILLA"));
				noTeLoPierdas.setPerfil(rs.getString("COPERFIL"));
				if (noTeLoPierdas.getPerfil() != null && !"".equals(noTeLoPierdas.getPerfil())) {
					noTeLoPierdas.setNombrePerfil(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"f1." + noTeLoPierdas.getPerfil(), noTeLoPierdas.getIdioma()));
				}

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& noTeLoPierdas.getGmlong() != null && noTeLoPierdas.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(noTeLoPierdas.getGmlat()),
							Double.parseDouble(noTeLoPierdas.getGmlong()), latUser, longUser);
					noTeLoPierdas.setDistancia(String.valueOf(distancia));
				}

				noTeLoPierdasList.add(noTeLoPierdas);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNoTeLoPierdas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getNoTeLoPierdas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNoTeLoPierdas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getNoTeLoPierdas: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getNoTeLoPierdas: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(noTeLoPierdasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(noTeLoPierdasList, new S12RecursosDefaultComparator());
		}

		S12NoTeLoPierdas[] noTeLoPierdasArray = new S12NoTeLoPierdas[noTeLoPierdasList.size()];
		noTeLoPierdasList.toArray(noTeLoPierdasArray);
		return noTeLoPierdasArray;
	}

	/**
	 * Obtiene la lista de Playas que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Playas
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Playas[] getPlayas(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Playas> playasList = new ArrayList<S12Playas>();
		S12Playas playa;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PLAYAS.COREC, PLAYAS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PLAYAS.COREC, PLAYAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PLAYAS.COREC, PLAYAS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("S12.GEO_MUNICIPALITY(PLAYAS.COREC) AS MUNICIPIO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PLAYAS LEFT OUTER JOIN GEOREFERENCIACION ON PLAYAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PLAYAS.COREC = POSICIONAMIENTO.COREC AND PLAYAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PLAYAS.COREC = DATOS_GENERALES.COREC AND PLAYAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PLAYAS.COREC = MULTIMEDIA.COREC AND PLAYAS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND PLAYAS.COIDIOMA = ? ");
			sql.append("AND PLAYAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				playa = new S12Playas();

				playa.setCodigoRecurso(rs.getInt("COREC"));
				playa.setIdioma(rs.getString("COIDIOMA"));
				playa.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					playa.setFotoPrincipal(multimedia);
					playa.setDescFoto(descMultimedia);
				} else {
					playa.setFotoPrincipal(foto);
					playa.setDescFoto(pieFoto);
				}

				playa.setUrlAmigable(rs.getString("URLAMIGABLE"));

				playa.setGmlong(rs.getString("GMLNG"));
				playa.setGmlat(rs.getString("GMLAT"));

				playa.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& playa.getGmlong() != null && playa.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(playa.getGmlat()),
							Double.parseDouble(playa.getGmlong()), latUser, longUser);
					playa.setDistancia(String.valueOf(distancia));
				}

				playasList.add(playa);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlayas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlayas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlayas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlayas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(playasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(playasList, new S12RecursosDefaultComparator());
		}

		S12Playas[] playasArray = new S12Playas[playasList.size()];
		playasList.toArray(playasArray);
		return playasArray;
	}

	/**
	 * Obtiene la lista de Espacios Naturales que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Espacios Naturales
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12EspaciosNaturales[] getEspaciosNaturales(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EspaciosNaturales> espaciosNaturalesList = new ArrayList<S12EspaciosNaturales>();
		S12EspaciosNaturales espacioNatural;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT ESPACIOSNATURALES.COREC, ESPACIOSNATURALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(ESPACIOSNATURALES.COREC, ESPACIOSNATURALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(ESPACIOSNATURALES.COREC, ESPACIOSNATURALES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("S12.GEO_MUNICIPALITY(ESPACIOSNATURALES.COREC) AS MUNICIPIO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM ESPACIOSNATURALES LEFT OUTER JOIN GEOREFERENCIACION ON ESPACIOSNATURALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON ESPACIOSNATURALES.COREC = POSICIONAMIENTO.COREC AND ESPACIOSNATURALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON ESPACIOSNATURALES.COREC = DATOS_GENERALES.COREC AND ESPACIOSNATURALES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON ESPACIOSNATURALES.COREC = MULTIMEDIA.COREC AND ESPACIOSNATURALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND ESPACIOSNATURALES.COIDIOMA = ? ");
			sql.append("AND ESPACIOSNATURALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				espacioNatural = new S12EspaciosNaturales();

				espacioNatural.setCodigoRecurso(rs.getInt("COREC"));
				espacioNatural.setIdioma(rs.getString("COIDIOMA"));
				espacioNatural.setNombre(rs.getString("NOMBRE"));
				espacioNatural.setSubTipo(rs.getString("CODSUBTIPO"));
				if (espacioNatural.getSubTipo() != null && !"".equals(espacioNatural.getSubTipo())) {
					espacioNatural.setNombreSubTipo(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"g2." + espacioNatural.getSubTipo(), espacioNatural.getIdioma()));
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					espacioNatural.setFotoPrincipal(multimedia);
					espacioNatural.setDescFoto(descMultimedia);
				} else {
					espacioNatural.setFotoPrincipal(foto);
					espacioNatural.setDescFoto(pieFoto);
				}

				espacioNatural.setUrlAmigable(rs.getString("URLAMIGABLE"));

				espacioNatural.setGmlong(rs.getString("GMLNG"));
				espacioNatural.setGmlat(rs.getString("GMLAT"));

				espacioNatural.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& espacioNatural.getGmlong() != null && espacioNatural.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(espacioNatural.getGmlat()),
							Double.parseDouble(espacioNatural.getGmlong()), latUser, longUser);
					espacioNatural.setDistancia(String.valueOf(distancia));
				}

				espaciosNaturalesList.add(espacioNatural);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEspaciosNaturales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEspaciosNaturales: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEspaciosNaturales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEspaciosNaturales: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEspaciosNaturales: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(espaciosNaturalesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(espaciosNaturalesList, new S12RecursosDefaultComparator());
		}

		S12EspaciosNaturales[] espaciosNaturalesArray = new S12EspaciosNaturales[espaciosNaturalesList.size()];
		espaciosNaturalesList.toArray(espaciosNaturalesArray);
		return espaciosNaturalesArray;
	}

	/**
	 * Obtiene la lista de artesanias que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de artesanias
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Artesania[] getArtesanias(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Artesania> artesaniasList = new ArrayList<S12Artesania>();
		S12Artesania artesania;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT ARTESANOSYASOCIACIONES.COREC, ARTESANOSYASOCIACIONES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(ARTESANOSYASOCIACIONES.COREC, ARTESANOSYASOCIACIONES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(ARTESANOSYASOCIACIONES.COREC, ARTESANOSYASOCIACIONES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("S12.GEO_MUNICIPALITY(ARTESANOSYASOCIACIONES.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(ARTESANOSYASOCIACIONES.COREC) AS NOPROV, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM ARTESANOSYASOCIACIONES LEFT OUTER JOIN GEOREFERENCIACION ON ARTESANOSYASOCIACIONES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON ARTESANOSYASOCIACIONES.COREC = POSICIONAMIENTO.COREC AND ARTESANOSYASOCIACIONES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON ARTESANOSYASOCIACIONES.COREC = DATOS_GENERALES.COREC AND ARTESANOSYASOCIACIONES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON ARTESANOSYASOCIACIONES.COREC = MULTIMEDIA.COREC AND ARTESANOSYASOCIACIONES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND ARTESANOSYASOCIACIONES.COIDIOMA = ? ");
			sql.append("AND ARTESANOSYASOCIACIONES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				artesania = new S12Artesania();

				artesania.setCodigoRecurso(rs.getInt("COREC"));
				artesania.setIdioma(rs.getString("COIDIOMA"));
				artesania.setNombre(rs.getString("NOMBRE"));

				artesania.setDireccion(rs.getString("DIRECCION"));
				artesania.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				artesania.setMunicipio(rs.getString("MUNICIPIO"));
				artesania.setProvincia(rs.getString("NOPROV"));

				artesania.setTelefono(rs.getString("TELEFONO1"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					artesania.setFotoPrincipal(multimedia);
					artesania.setDescFoto(descMultimedia);
				} else {
					artesania.setFotoPrincipal(foto);
					artesania.setDescFoto(pieFoto);
				}

				artesania.setUrlAmigable(rs.getString("URLAMIGABLE"));

				artesania.setEmail(rs.getString("MAIL"));
				artesania.setWeb(rs.getString("URL"));

				artesania.setGmlong(rs.getString("GMLNG"));
				artesania.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& artesania.getGmlong() != null && artesania.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(artesania.getGmlat()),
							Double.parseDouble(artesania.getGmlong()), latUser, longUser);
					artesania.setDistancia(String.valueOf(distancia));
				}

				artesaniasList.add(artesania);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getArtesanias: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getArtesanias: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getArtesanias: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getArtesanias: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(artesaniasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(artesaniasList, new S12RecursosDefaultComparator());
		}

		S12Artesania[] artesaniasArray = new S12Artesania[artesaniasList.size()];
		artesaniasList.toArray(artesaniasArray);
		return artesaniasArray;
	}

	/**
	 * Obtiene la lista de Teatros y Cines que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Teatros y Cines
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12TeatrosCines[] getTeatrosCines(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12TeatrosCines> teatrosCinesList = new ArrayList<S12TeatrosCines>();
		S12TeatrosCines teatroCine;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT TEATROSYCINES.COREC, TEATROSYCINES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(TEATROSYCINES.COREC, TEATROSYCINES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(TEATROSYCINES.COREC, TEATROSYCINES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM TEATROSYCINES LEFT OUTER JOIN GEOREFERENCIACION ON TEATROSYCINES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON TEATROSYCINES.COREC = POSICIONAMIENTO.COREC AND TEATROSYCINES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON TEATROSYCINES.COREC = DATOS_GENERALES.COREC AND TEATROSYCINES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON TEATROSYCINES.COREC = MULTIMEDIA.COREC AND TEATROSYCINES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND TEATROSYCINES.COIDIOMA = ? ");
			sql.append("AND TEATROSYCINES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				teatroCine = new S12TeatrosCines();

				teatroCine.setCodigoRecurso(rs.getInt("COREC"));
				teatroCine.setIdioma(rs.getString("COIDIOMA"));
				teatroCine.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					teatroCine.setFotoPrincipal(multimedia);
					teatroCine.setDescFoto(descMultimedia);
				} else {
					teatroCine.setFotoPrincipal(foto);
					teatroCine.setDescFoto(pieFoto);
				}

				teatroCine.setUrlAmigable(rs.getString("URLAMIGABLE"));

				teatroCine.setGmlong(rs.getString("GMLNG"));
				teatroCine.setGmlat(rs.getString("GMLAT"));

				teatroCine.setTelefono(rs.getString("TELEFONO1"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& teatroCine.getGmlong() != null && teatroCine.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(teatroCine.getGmlat()),
							Double.parseDouble(teatroCine.getGmlong()), latUser, longUser);
					teatroCine.setDistancia(String.valueOf(distancia));
				}

				teatrosCinesList.add(teatroCine);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getTeatrosCines: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getTeatrosCines: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getTeatrosCines: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getTeatrosCines: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(teatrosCinesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(teatrosCinesList, new S12RecursosDefaultComparator());
		}

		S12TeatrosCines[] teatrosCinesArray = new S12TeatrosCines[teatrosCinesList.size()];
		teatrosCinesList.toArray(teatrosCinesArray);
		return teatrosCinesArray;
	}

	/**
	 * Obtiene la lista de Museos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Museos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Museos[] getMuseos(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Museos> museosList = new ArrayList<S12Museos>();
		ArrayList<String> arrServicios;
		S12Museos museo;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT CULTURA.COREC, CULTURA.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(CULTURA.COREC, CULTURA.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(CULTURA.COREC, CULTURA.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM CULTURA LEFT OUTER JOIN GEOREFERENCIACION ON CULTURA.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON CULTURA.COREC = POSICIONAMIENTO.COREC AND CULTURA.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON CULTURA.COREC = DATOS_GENERALES.COREC AND CULTURA.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					" LEFT JOIN MULTIMEDIA ON CULTURA.COREC = MULTIMEDIA.COREC AND CULTURA.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			// Club Producto
			sql.append(" LEFT JOIN REC_SRV TSERVPRODUCTO ON CULTURA.COREC = TSERVPRODUCTO.COREC AND TSERVPRODUCTO.COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO);

			// ECOLABEL
			sql.append(" LEFT JOIN REC_SRV TSERVECOL ON CULTURA.COREC = TSERVECOL.COREC AND TSERVECOL.COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL);

			// Certif. Innovación
			sql.append(" LEFT JOIN REC_SRV TSERVINNOVA ON CULTURA.COREC = TSERVINNOVA.COREC AND TSERVINNOVA.COSERVICIO = ").append(S12Constantes.SRV_INNOVACION);

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND CULTURA.COIDIOMA = ? ");
			sql.append("AND CULTURA.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				museo = new S12Museos();
				arrServicios = new ArrayList<String>();

				museo.setCodigoRecurso(rs.getInt("COREC"));
				museo.setIdioma(rs.getString("COIDIOMA"));
				museo.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					museo.setFotoPrincipal(multimedia);
					museo.setDescFoto(descMultimedia);
				} else {
					museo.setFotoPrincipal(foto);
					museo.setDescFoto(pieFoto);
				}

				museo.setUrlAmigable(rs.getString("URLAMIGABLE"));

				museo.setGmlong(rs.getString("GMLNG"));
				museo.setGmlat(rs.getString("GMLAT"));

				museo.setTelefono(rs.getString("TELEFONO1"));

				// OJO: el orden de los servicios en el array IDENTIFICA CADA SERVICIO.
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				museo.setArrServicios(arrServicios);

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& museo.getGmlong() != null && museo.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(museo.getGmlat()),
							Double.parseDouble(museo.getGmlong()), latUser, longUser);
					museo.setDistancia(String.valueOf(distancia));
				}

				museosList.add(museo);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getMuseos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getMuseos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getMuseos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getMuseos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(museosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(museosList, new S12RecursosDefaultComparator());
		}

		S12Museos[] museosArray = new S12Museos[museosList.size()];
		museosList.toArray(museosArray);
		return museosArray;
	}

	/**
	 * Obtiene la lista de Patrimonios Culturales que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Patrimonios Culturales
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12PatrimonioCultural[] getPatrimoniosCulturales(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12PatrimonioCultural> patrimoniosCulturalesList = new ArrayList<S12PatrimonioCultural>();
		S12PatrimonioCultural patrimonioCultural;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PATRIMONIOCULTURAL.COREC, PATRIMONIOCULTURAL.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PATRIMONIOCULTURAL.COREC, PATRIMONIOCULTURAL.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PATRIMONIOCULTURAL.COREC, PATRIMONIOCULTURAL.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("S12.GEO_MUNICIPALITY(PATRIMONIOCULTURAL.COREC) AS MUNICIPIO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PATRIMONIOCULTURAL LEFT OUTER JOIN GEOREFERENCIACION ON PATRIMONIOCULTURAL.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PATRIMONIOCULTURAL.COREC = POSICIONAMIENTO.COREC AND PATRIMONIOCULTURAL.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PATRIMONIOCULTURAL.COREC = DATOS_GENERALES.COREC AND PATRIMONIOCULTURAL.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PATRIMONIOCULTURAL.COREC = MULTIMEDIA.COREC AND PATRIMONIOCULTURAL.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND PATRIMONIOCULTURAL.COIDIOMA = ? ");
			sql.append("AND PATRIMONIOCULTURAL.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				patrimonioCultural = new S12PatrimonioCultural();

				patrimonioCultural.setCodigoRecurso(rs.getInt("COREC"));
				patrimonioCultural.setIdioma(rs.getString("COIDIOMA"));
				patrimonioCultural.setNombre(rs.getString("NOMBRE"));
				patrimonioCultural.setSubTipo(rs.getString("CODSUBTIPO"));
				if (patrimonioCultural.getSubTipo() != null && !"".equals(patrimonioCultural.getSubTipo())) {
					patrimonioCultural.setNombreSubTipo(Q70GestorMensajesi18n.getSingleton().getMessage(
							"s12PortalMovil", "h5." + patrimonioCultural.getSubTipo(), patrimonioCultural.getIdioma()));
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					patrimonioCultural.setFotoPrincipal(multimedia);
					patrimonioCultural.setDescFoto(descMultimedia);
				} else {
					patrimonioCultural.setFotoPrincipal(foto);
					patrimonioCultural.setDescFoto(pieFoto);
				}

				patrimonioCultural.setUrlAmigable(rs.getString("URLAMIGABLE"));

				patrimonioCultural.setGmlong(rs.getString("GMLNG"));
				patrimonioCultural.setGmlat(rs.getString("GMLAT"));

				patrimonioCultural.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& patrimonioCultural.getGmlong() != null && patrimonioCultural.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(patrimonioCultural.getGmlat()),
							Double.parseDouble(patrimonioCultural.getGmlong()), latUser, longUser);
					patrimonioCultural.setDistancia(String.valueOf(distancia));
				}

				patrimoniosCulturalesList.add(patrimonioCultural);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPatrimoniosCulturales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPatrimoniosCulturales: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPatrimoniosCulturales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPatrimoniosCulturales: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPatrimoniosCulturales: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(patrimoniosCulturalesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(patrimoniosCulturalesList, new S12RecursosDefaultComparator());
		}

		S12PatrimonioCultural[] patrimoniosCulturalesArray = new S12PatrimonioCultural[patrimoniosCulturalesList.size()];
		patrimoniosCulturalesList.toArray(patrimoniosCulturalesArray);
		return patrimoniosCulturalesArray;
	}

	/**
	 * Obtiene la lista de Puertos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Puertos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Puertos[] getPuertos(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Puertos> puertosList = new ArrayList<S12Puertos>();
		S12Puertos puerto;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PUERTOSPESQUEROS.COREC, PUERTOSPESQUEROS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PUERTOSPESQUEROS.COREC, PUERTOSPESQUEROS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PUERTOSPESQUEROS.COREC, PUERTOSPESQUEROS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("S12.GEO_MUNICIPALITY(PUERTOSPESQUEROS.COREC) AS MUNICIPIO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PUERTOSPESQUEROS LEFT OUTER JOIN GEOREFERENCIACION ON PUERTOSPESQUEROS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PUERTOSPESQUEROS.COREC = POSICIONAMIENTO.COREC AND PUERTOSPESQUEROS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PUERTOSPESQUEROS.COREC = DATOS_GENERALES.COREC AND PUERTOSPESQUEROS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PUERTOSPESQUEROS.COREC = MULTIMEDIA.COREC AND PUERTOSPESQUEROS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND PUERTOSPESQUEROS.COIDIOMA = ? ");
			sql.append("AND PUERTOSPESQUEROS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				puerto = new S12Puertos();

				puerto.setCodigoRecurso(rs.getInt("COREC"));
				puerto.setIdioma(rs.getString("COIDIOMA"));
				puerto.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					puerto.setFotoPrincipal(multimedia);
					puerto.setDescFoto(descMultimedia);
				} else {
					puerto.setFotoPrincipal(foto);
					puerto.setDescFoto(pieFoto);
				}

				puerto.setUrlAmigable(rs.getString("URLAMIGABLE"));

				puerto.setGmlong(rs.getString("GMLNG"));
				puerto.setGmlat(rs.getString("GMLAT"));

				puerto.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& puerto.getGmlong() != null && puerto.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(puerto.getGmlat()),
							Double.parseDouble(puerto.getGmlong()), latUser, longUser);
					puerto.setDistancia(String.valueOf(distancia));
				}

				puertosList.add(puerto);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPuertos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPuertos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPuertos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPuertos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(puertosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(puertosList, new S12RecursosDefaultComparator());
		}

		S12Puertos[] puertosArray = new S12Puertos[puertosList.size()];
		puertosList.toArray(puertosArray);
		return puertosArray;
	}

	/**
	 * Obtiene la lista de Deportes que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Deportes
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Deportes[] getDeportes(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Deportes> deportesList = new ArrayList<S12Deportes>();
		S12Deportes deporte;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT INSTALACIONESDEPORTIVAS.COREC, INSTALACIONESDEPORTIVAS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(INSTALACIONESDEPORTIVAS.COREC, INSTALACIONESDEPORTIVAS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(INSTALACIONESDEPORTIVAS.COREC, INSTALACIONESDEPORTIVAS.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAH6, MULTI2.DEMULT AS DESCMULTIMEDIAH6, ");
			sql.append("S12.GEO_PROVINCIA(INSTALACIONESDEPORTIVAS.COREC) AS PROVINCIA, S12.GEO_PROVINCIACODE(INSTALACIONESDEPORTIVAS.COREC) AS CODPROVINCIA, ");
			sql.append("S12.GEO_MUNICIPALITY(INSTALACIONESDEPORTIVAS.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(INSTALACIONESDEPORTIVAS.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_LOCALITY(INSTALACIONESDEPORTIVAS.COREC) AS LOCALIDAD, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM INSTALACIONESDEPORTIVAS LEFT OUTER JOIN GEOREFERENCIACION ON INSTALACIONESDEPORTIVAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON INSTALACIONESDEPORTIVAS.COREC = POSICIONAMIENTO.COREC AND INSTALACIONESDEPORTIVAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON INSTALACIONESDEPORTIVAS.COREC = DATOS_GENERALES.COREC AND INSTALACIONESDEPORTIVAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON INSTALACIONESDEPORTIVAS.COREC = MULTI1.COREC AND INSTALACIONESDEPORTIVAS.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON INSTALACIONESDEPORTIVAS.COREC = MULTI2.COREC AND INSTALACIONESDEPORTIVAS.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");
			// Idioma
			sql.append("AND INSTALACIONESDEPORTIVAS.COIDIOMA = ? ");
			sql.append("AND INSTALACIONESDEPORTIVAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				deporte = new S12Deportes();

				deporte.setCodigoRecurso(rs.getInt("COREC"));
				deporte.setIdioma(rs.getString("COIDIOMA"));
				deporte.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					deporte.setFotoPrincipal(multimedia);
					deporte.setDescFoto(descMultimedia);
				} else {
					deporte.setFotoPrincipal(foto);
					deporte.setDescFoto(pieFoto);
				}
				// Tomamos la foto para usar en el buscador de Puertos Deportivos, que va a distinto tama�o
				String multimediaH6 = rs.getString("MULTIMEDIAH6");
				String descMultimediaH6 = rs.getString("DESCMULTIMEDIAH6");
				deporte.setFotoPuertos(multimediaH6);
				deporte.setDescFotoPuertos(descMultimediaH6);

				deporte.setUrlAmigable(rs.getString("URLAMIGABLE"));

				deporte.setGmlong(rs.getString("GMLNG"));
				deporte.setGmlat(rs.getString("GMLAT"));

				deporte.setProvincia(rs.getString("PROVINCIA"));
				deporte.setProvinciaCode(rs.getString("CODPROVINCIA"));
				deporte.setMunicipio(rs.getString("MUNICIPIO"));
				deporte.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				deporte.setLocalidad(rs.getString("LOCALIDAD"));
				deporte.setSubTipo(rs.getString("CODSUBTIPO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& deporte.getGmlong() != null && deporte.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(deporte.getGmlat()),
							Double.parseDouble(deporte.getGmlong()), latUser, longUser);
					deporte.setDistancia(String.valueOf(distancia));
				}

				deportesList.add(deporte);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDeportes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDeportes: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDeportes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDeportes: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(deportesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(deportesList, new S12RecursosDefaultComparator());
		}

		S12Deportes[] deportesArray = new S12Deportes[deportesList.size()];
		deportesList.toArray(deportesArray);
		return deportesArray;
	}

	/**
	 * Obtiene la lista de Empresas de Alquiler Deportivo que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Empresas de Alquiler Deportivo
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12EmpresaAlquilerDeportivo[] getEmpresasAlquilerDeportivo(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EmpresaAlquilerDeportivo> empresasAlqDepList = new ArrayList<S12EmpresaAlquilerDeportivo>();
		S12EmpresaAlquilerDeportivo empresaAlqDep;
		StringBuffer sql;
		ArrayList<String> arrServicios;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT EMPRESASALQUILERDEPORTIVO.COREC, EMPRESASALQUILERDEPORTIVO.COIDIOMA, ");
			sql.append("DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(EMPRESASALQUILERDEPORTIVO.COREC, EMPRESASALQUILERDEPORTIVO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(EMPRESASALQUILERDEPORTIVO.COREC, EMPRESASALQUILERDEPORTIVO.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("S12.GEO_MUNICIPALITY(EMPRESASALQUILERDEPORTIVO.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(EMPRESASALQUILERDEPORTIVO.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(EMPRESASALQUILERDEPORTIVO.COREC) AS NOPROV, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("EMPRESASALQUILERDEPORTIVO.MATERIALDEPORTIVO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVSURF.COSERVICIO as SURFING, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM EMPRESASALQUILERDEPORTIVO LEFT OUTER JOIN GEOREFERENCIACION ON EMPRESASALQUILERDEPORTIVO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON EMPRESASALQUILERDEPORTIVO.COREC = POSICIONAMIENTO.COREC AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON EMPRESASALQUILERDEPORTIVO.COREC = PM_RECURSOS_TOWN.COREC AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON EMPRESASALQUILERDEPORTIVO.COREC = DATOS_GENERALES.COREC AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON EMPRESASALQUILERDEPORTIVO.COREC = MULTI1.COREC AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON EMPRESASALQUILERDEPORTIVO.COREC = MULTI2.COREC AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			// Q Oro
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVQO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			// Q Plata
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVQP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			// ISO
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVISO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			// buenas pr�cticas
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVBP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			// surfing
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_SURFING).append(" AND COIDIOMA = ?")
					.append(") TSERVSURF ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVSURF.COREC ");
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASALQUILERDEPORTIVO.COREC, COSERVICIO FROM EMPRESASALQUILERDEPORTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASALQUILERDEPORTIVO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON EMPRESASALQUILERDEPORTIVO.COREC = TSERVINNOVA.COREC ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND EMPRESASALQUILERDEPORTIVO.COIDIOMA = ? ");
			sql.append("AND EMPRESASALQUILERDEPORTIVO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				empresaAlqDep = new S12EmpresaAlquilerDeportivo();
				arrServicios = new ArrayList<String>();

				empresaAlqDep.setCodigoRecurso(rs.getInt("COREC"));
				empresaAlqDep.setIdioma(rs.getString("COIDIOMA"));
				empresaAlqDep.setNombre(rs.getString("NOMBRE"));

				empresaAlqDep.setDireccion(rs.getString("DIRECCION"));
				empresaAlqDep.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				empresaAlqDep.setMunicipio(rs.getString("MUNICIPIO"));
				empresaAlqDep.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				empresaAlqDep.setProvincia(rs.getString("NOPROV"));

				empresaAlqDep.setTelefono(rs.getString("TELEFONO1"));
				empresaAlqDep.setDescTelefono(rs.getString("DESCTELEFONO1"));
				empresaAlqDep.setTelefono2(rs.getString("TELEFONO2"));
				empresaAlqDep.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					empresaAlqDep.setFotoPrincipal(multimedia);
					empresaAlqDep.setDescFoto(descMultimedia);
				} else {
					empresaAlqDep.setFotoPrincipal(foto);
					empresaAlqDep.setDescFoto(pieFoto);
				}

				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				empresaAlqDep.setFotoA(multimediaA);
				empresaAlqDep.setDescFotoA(descMultimediaA);

				empresaAlqDep.setUrlAmigable(rs.getString("URLAMIGABLE"));
				empresaAlqDep.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				empresaAlqDep.setEmail(rs.getString("MAIL"));
				empresaAlqDep.setWeb(rs.getString("URL"));

				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("SURFING") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				empresaAlqDep.setArrServicios(arrServicios);

				empresaAlqDep.setGmlong(rs.getString("GMLNG"));
				empresaAlqDep.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& empresaAlqDep.getGmlong() != null && empresaAlqDep.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(empresaAlqDep.getGmlat()),
							Double.parseDouble(empresaAlqDep.getGmlong()), latUser, longUser);
					empresaAlqDep.setDistancia(String.valueOf(distancia));
				}

				// empresaAlqDep.setActividades(rs.getString("DEDESCRIPTORESTEMATICOS"));
				empresaAlqDep.setMaterial(rs.getString("MATERIALDEPORTIVO"));

				empresasAlqDepList.add(empresaAlqDep);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEmpresasAlquilerDeportivo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEmpresasAlquilerDeportivo: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEmpresasAlquilerDeportivo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEmpresasAlquilerDeportivo: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(empresasAlqDepList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(empresasAlqDepList, new S12RecursosDefaultComparator());
		}

		S12EmpresaAlquilerDeportivo[] empresasAlqDepArray = new S12EmpresaAlquilerDeportivo[empresasAlqDepList.size()];
		empresasAlqDepList.toArray(empresasAlqDepArray);
		return empresasAlqDepArray;
	}

	/**
	 * Obtiene la lista de Platos T�picos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Platos T�picos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12PlatosTipicos[] getPlatosTipicos(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12PlatosTipicos> platosTipicosList = new ArrayList<S12PlatosTipicos>();
		S12PlatosTipicos platoTipico;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PLATOSTIPICOS.COREC, PLATOSTIPICOS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PLATOSTIPICOS.COREC, PLATOSTIPICOS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PLATOSTIPICOS.COREC, PLATOSTIPICOS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, RECURSO.MARCAS ");
			sql.append("FROM PLATOSTIPICOS INNER JOIN RECURSO ON PLATOSTIPICOS.COREC = RECURSO.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PLATOSTIPICOS.COREC = POSICIONAMIENTO.COREC AND PLATOSTIPICOS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PLATOSTIPICOS.COREC = DATOS_GENERALES.COREC AND PLATOSTIPICOS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append("LEFT OUTER JOIN GEOREFERENCIACION ON PLATOSTIPICOS.COREC = GEOREFERENCIACION.COREC ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PLATOSTIPICOS.COREC = MULTIMEDIA.COREC AND PLATOSTIPICOS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1");

			// Idioma
			sql.append("AND PLATOSTIPICOS.COIDIOMA = ? ");
			sql.append("AND PLATOSTIPICOS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				platoTipico = new S12PlatosTipicos();

				platoTipico.setCodigoRecurso(rs.getInt("COREC"));
				platoTipico.setIdioma(rs.getString("COIDIOMA"));
				platoTipico.setNombre(rs.getString("NOMBRE"));

				platoTipico.setIdZona(rs.getString("MARCAS"));

				StringBuffer sbZona = new StringBuffer();
				if (platoTipico.getIdZona() != null && !"".equals(platoTipico.getIdZona())) {
					// Las marcas pueden ser m�ltiples
					String[] aMarcas = platoTipico.getIdZona().split(",");

					for (int i = 0; i < aMarcas.length; i++) {
						if (i != 0) {
							sbZona.append(",");
						}
						sbZona.append(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
								"zona." + aMarcas[i], platoTipico.getIdioma()));
					}
					platoTipico.setNombreZona(sbZona.toString());
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					platoTipico.setFotoPrincipal(multimedia);
					platoTipico.setDescFoto(descMultimedia);
				} else {
					platoTipico.setFotoPrincipal(foto);
					platoTipico.setDescFoto(pieFoto);
				}

				platoTipico.setUrlAmigable(rs.getString("URLAMIGABLE"));

				platoTipico.setGmlong(rs.getString("GMLNG"));
				platoTipico.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& platoTipico.getGmlong() != null && platoTipico.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(platoTipico.getGmlat()),
							Double.parseDouble(platoTipico.getGmlong()), latUser, longUser);
					platoTipico.setDistancia(String.valueOf(distancia));
				}

				platosTipicosList.add(platoTipico);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlatosTipicos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlatosTipicos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlatosTipicos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlatosTipicos: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getProductosTierra: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(platosTipicosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(platosTipicosList, new S12RecursosDefaultComparator());
		}

		S12PlatosTipicos[] platosTipicosArray = new S12PlatosTipicos[platosTipicosList.size()];
		platosTipicosList.toArray(platosTipicosArray);
		return platosTipicosArray;
	}

	/**
	 * Obtiene la lista de Productos de la Tierra que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Productos de la Tierra
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12ProductosTierra[] getProductosTierra(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12ProductosTierra> productosTierraList = new ArrayList<S12ProductosTierra>();
		S12ProductosTierra productoTierra;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.CODSUBTIPO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("S12.GEO_MUNICIPALITY(DATOS_GENERALES.COREC) AS MUNICIPIO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, RECURSO.MARCAS ");
			sql.append("FROM RECURSO INNER JOIN DATOS_GENERALES ON RECURSO.COREC = DATOS_GENERALES.COREC ");
			sql.append("LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");
			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				productoTierra = new S12ProductosTierra();

				productoTierra.setCodigoRecurso(rs.getInt("COREC"));
				productoTierra.setIdioma(rs.getString("COIDIOMA"));
				productoTierra.setNombre(rs.getString("NOMBRE"));
				productoTierra.setIdZona(rs.getString("MARCAS"));

				StringBuffer sbZona = new StringBuffer();
				if (productoTierra.getIdZona() != null && !"".equals(productoTierra.getIdZona())) {
					// Las marcas pueden ser m�ltiples
					String[] aMarcas = productoTierra.getIdZona().split(",");

					for (int i = 0; i < aMarcas.length; i++) {
						if (i != 0) {
							sbZona.append(",");
						}
						sbZona.append(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
								"zona." + aMarcas[i], productoTierra.getIdioma()));
					}
					productoTierra.setNombreZona(sbZona.toString());
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					productoTierra.setFotoPrincipal(multimedia);
					productoTierra.setDescFoto(descMultimedia);
				} else {
					productoTierra.setFotoPrincipal(foto);
					productoTierra.setDescFoto(pieFoto);
				}

				productoTierra.setUrlAmigable(rs.getString("URLAMIGABLE"));

				productoTierra.setGmlong(rs.getString("GMLNG"));
				productoTierra.setGmlat(rs.getString("GMLAT"));

				productoTierra.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& productoTierra.getGmlong() != null && productoTierra.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(productoTierra.getGmlat()),
							Double.parseDouble(productoTierra.getGmlong()), latUser, longUser);
					productoTierra.setDistancia(String.valueOf(distancia));
				}

				productosTierraList.add(productoTierra);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getProductosTierra: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getProductosTierra: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getProductosTierra: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getProductosTierra: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getProductosTierra: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(productosTierraList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(productosTierraList, new S12RecursosDefaultComparator());
		}

		S12ProductosTierra[] productosTierraArray = new S12ProductosTierra[productosTierraList.size()];
		productosTierraList.toArray(productosTierraArray);
		return productosTierraArray;
	}

	/**
	 * Obtiene la lista de Centros de Formaci�n que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Centros de Formaci�n
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12CentrosFormacion[] getCentrosFormacion(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12CentrosFormacion> centrosFormacionList = new ArrayList<S12CentrosFormacion>();
		S12CentrosFormacion centroFormacion;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT ESCUELASHOSTELERIA.COREC, ESCUELASHOSTELERIA.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(ESCUELASHOSTELERIA.COREC, ESCUELASHOSTELERIA.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(ESCUELASHOSTELERIA.COREC, ESCUELASHOSTELERIA.COIDIOMA) AS DEPIEFOTO,  ");
			sql.append("DATOS_GENERALES.TELEFONO1, MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM ESCUELASHOSTELERIA LEFT OUTER JOIN GEOREFERENCIACION ON ESCUELASHOSTELERIA.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON ESCUELASHOSTELERIA.COREC = POSICIONAMIENTO.COREC AND ESCUELASHOSTELERIA.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON ESCUELASHOSTELERIA.COREC = DATOS_GENERALES.COREC AND ESCUELASHOSTELERIA.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON ESCUELASHOSTELERIA.COREC = MULTIMEDIA.COREC AND ESCUELASHOSTELERIA.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND ESCUELASHOSTELERIA.COIDIOMA = ? ");
			sql.append("AND ESCUELASHOSTELERIA.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				centroFormacion = new S12CentrosFormacion();

				centroFormacion.setCodigoRecurso(rs.getInt("COREC"));
				centroFormacion.setIdioma(rs.getString("COIDIOMA"));
				centroFormacion.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					centroFormacion.setFotoPrincipal(multimedia);
					centroFormacion.setDescFoto(descMultimedia);
				} else {
					centroFormacion.setFotoPrincipal(foto);
					centroFormacion.setDescFoto(pieFoto);
				}

				centroFormacion.setUrlAmigable(rs.getString("URLAMIGABLE"));

				centroFormacion.setGmlong(rs.getString("GMLNG"));
				centroFormacion.setGmlat(rs.getString("GMLAT"));

				centroFormacion.setTelefono(rs.getString("TELEFONO1"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& centroFormacion.getGmlong() != null && centroFormacion.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(centroFormacion.getGmlat()),
							Double.parseDouble(centroFormacion.getGmlong()), latUser, longUser);
					centroFormacion.setDistancia(String.valueOf(distancia));
				}

				centrosFormacionList.add(centroFormacion);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCentrosFormacion: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCentrosFormacion: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCentrosFormacion: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCentrosFormacion: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(centrosFormacionList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(centrosFormacionList, new S12RecursosDefaultComparator());
		}

		S12CentrosFormacion[] centrosFormacionArray = new S12CentrosFormacion[centrosFormacionList.size()];
		centrosFormacionList.toArray(centrosFormacionArray);
		return centrosFormacionArray;
	}

	/**
	 * Obtiene la lista de Plazas de Toros que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Plazas de Toros
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12PlazasToros[] getPlazasToros(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12PlazasToros> plazasTorosList = new ArrayList<S12PlazasToros>();
		S12PlazasToros plazaToros;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PLAZASTOROS.COREC, PLAZASTOROS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PLAZASTOROS.COREC, PLAZASTOROS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PLAZASTOROS.COREC, PLAZASTOROS.COIDIOMA) AS DEPIEFOTO, PLAZASTOROS.CATEGORIA, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PLAZASTOROS LEFT OUTER JOIN GEOREFERENCIACION ON PLAZASTOROS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PLAZASTOROS.COREC = POSICIONAMIENTO.COREC AND PLAZASTOROS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PLAZASTOROS.COREC = DATOS_GENERALES.COREC AND PLAZASTOROS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PLAZASTOROS.COREC = MULTIMEDIA.COREC AND PLAZASTOROS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND PLAZASTOROS.COIDIOMA = ? ");
			sql.append("AND PLAZASTOROS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				plazaToros = new S12PlazasToros();

				plazaToros.setCodigoRecurso(rs.getInt("COREC"));
				plazaToros.setIdioma(rs.getString("COIDIOMA"));
				plazaToros.setNombre(rs.getString("NOMBRE"));

				plazaToros.setIdCategoria(rs.getString("CATEGORIA"));
				if (plazaToros.getIdCategoria() != null && !"".equals(plazaToros.getIdCategoria())) {
					plazaToros.setNombreCategoria(Q70GestorMensajesi18n.getSingleton().getMessage("s12PortalMovil",
							"k1." + plazaToros.getIdCategoria(), plazaToros.getIdioma()));
				}

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					plazaToros.setFotoPrincipal(multimedia);
					plazaToros.setDescFoto(descMultimedia);
				} else {
					plazaToros.setFotoPrincipal(foto);
					plazaToros.setDescFoto(pieFoto);
				}

				plazaToros.setUrlAmigable(rs.getString("URLAMIGABLE"));

				plazaToros.setGmlong(rs.getString("GMLNG"));
				plazaToros.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& plazaToros.getGmlong() != null && plazaToros.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(plazaToros.getGmlat()),
							Double.parseDouble(plazaToros.getGmlong()), latUser, longUser);
					plazaToros.setDistancia(String.valueOf(distancia));
				}

				plazasTorosList.add(plazaToros);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlazasToros: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlazasToros: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlazasToros: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPlazasToros: Exception ", e);
		} catch (Q70GestorMensajesException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPlazasToros: Exception: " + e.getMessage());
			}
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(plazasTorosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(plazasTorosList, new S12RecursosDefaultComparator());
		}

		S12PlazasToros[] plazasTorosArray = new S12PlazasToros[plazasTorosList.size()];
		plazasTorosList.toArray(plazasTorosArray);
		return plazasTorosArray;
	}

	/**
	 * Obtiene la lista de Parque Tem�tico o de Atracciones que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Parque Tem�tico o de Atracciones
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12ParquesTematicosAtracciones[] getParquesTematicosAtracciones(ArrayList<String> arrRecursos,
			String idioma, double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12ParquesTematicosAtracciones> parquesTematicosAtraccionesList = new ArrayList<S12ParquesTematicosAtracciones>();
		S12ParquesTematicosAtracciones parqueTematicoAtracciones;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT PARQUESTEMATICOS.COREC, PARQUESTEMATICOS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(PARQUESTEMATICOS.COREC, PARQUESTEMATICOS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(PARQUESTEMATICOS.COREC, PARQUESTEMATICOS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.TELEFONO1, MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM PARQUESTEMATICOS LEFT OUTER JOIN GEOREFERENCIACION ON PARQUESTEMATICOS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON PARQUESTEMATICOS.COREC = POSICIONAMIENTO.COREC AND PARQUESTEMATICOS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON PARQUESTEMATICOS.COREC = DATOS_GENERALES.COREC AND PARQUESTEMATICOS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON PARQUESTEMATICOS.COREC = MULTIMEDIA.COREC AND PARQUESTEMATICOS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");
			// Idioma
			sql.append("AND PARQUESTEMATICOS.COIDIOMA = ? ");
			sql.append("AND PARQUESTEMATICOS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				parqueTematicoAtracciones = new S12ParquesTematicosAtracciones();

				parqueTematicoAtracciones.setCodigoRecurso(rs.getInt("COREC"));
				parqueTematicoAtracciones.setIdioma(rs.getString("COIDIOMA"));
				parqueTematicoAtracciones.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					parqueTematicoAtracciones.setFotoPrincipal(multimedia);
					parqueTematicoAtracciones.setDescFoto(descMultimedia);
				} else {
					parqueTematicoAtracciones.setFotoPrincipal(foto);
					parqueTematicoAtracciones.setDescFoto(pieFoto);
				}

				parqueTematicoAtracciones.setUrlAmigable(rs.getString("URLAMIGABLE"));

				parqueTematicoAtracciones.setGmlong(rs.getString("GMLNG"));
				parqueTematicoAtracciones.setGmlat(rs.getString("GMLAT"));

				parqueTematicoAtracciones.setTelefono(rs.getString("TELEFONO1"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& parqueTematicoAtracciones.getGmlong() != null
						&& parqueTematicoAtracciones.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(parqueTematicoAtracciones.getGmlat()),
							Double.parseDouble(parqueTematicoAtracciones.getGmlong()), latUser, longUser);
					parqueTematicoAtracciones.setDistancia(String.valueOf(distancia));
				}

				parquesTematicosAtraccionesList.add(parqueTematicoAtracciones);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getParquesTematicosAtracciones: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getParquesTematicosAtracciones: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getParquesTematicosAtracciones: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getParquesTematicosAtracciones: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(parquesTematicosAtraccionesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(parquesTematicosAtraccionesList, new S12RecursosDefaultComparator());
		}

		S12ParquesTematicosAtracciones[] parquesTematicosAtraccionesArray = new S12ParquesTematicosAtracciones[parquesTematicosAtraccionesList
				.size()];
		parquesTematicosAtraccionesList.toArray(parquesTematicosAtraccionesArray);
		return parquesTematicosAtraccionesArray;
	}

	/**
	 * Obtiene la lista de Aquariums que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Aquariums
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Aquariums[] getAquariums(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Aquariums> aquariumsList = new ArrayList<S12Aquariums>();
		S12Aquariums aquarium;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT AQUARIUMS.COREC, AQUARIUMS.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(AQUARIUMS.COREC, AQUARIUMS.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(AQUARIUMS.COREC, AQUARIUMS.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM AQUARIUMS LEFT OUTER JOIN GEOREFERENCIACION ON AQUARIUMS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON AQUARIUMS.COREC = POSICIONAMIENTO.COREC AND AQUARIUMS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON AQUARIUMS.COREC = DATOS_GENERALES.COREC AND AQUARIUMS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON AQUARIUMS.COREC = MULTIMEDIA.COREC AND AQUARIUMS.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND AQUARIUMS.COIDIOMA = ? ");
			sql.append("AND AQUARIUMS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				aquarium = new S12Aquariums();

				aquarium.setCodigoRecurso(rs.getInt("COREC"));
				aquarium.setIdioma(rs.getString("COIDIOMA"));
				aquarium.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					aquarium.setFotoPrincipal(multimedia);
					aquarium.setDescFoto(descMultimedia);
				} else {
					aquarium.setFotoPrincipal(foto);
					aquarium.setDescFoto(pieFoto);
				}

				aquarium.setUrlAmigable(rs.getString("URLAMIGABLE"));

				aquarium.setGmlong(rs.getString("GMLNG"));
				aquarium.setGmlat(rs.getString("GMLAT"));

				aquarium.setTelefono(rs.getString("TELEFONO1"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& aquarium.getGmlong() != null && aquarium.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(aquarium.getGmlat()),
							Double.parseDouble(aquarium.getGmlong()), latUser, longUser);
					aquarium.setDistancia(String.valueOf(distancia));
				}

				aquariumsList.add(aquarium);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAquariums: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAquariums: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getAquariums: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getAquariums: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(aquariumsList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(aquariumsList, new S12RecursosDefaultComparator());
		}

		S12Aquariums[] aquariumsArray = new S12Aquariums[aquariumsList.size()];
		aquariumsList.toArray(aquariumsArray);
		return aquariumsArray;
	}

	/**
	 * Obtiene la lista de Casinos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Casinos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Casinos[] getCasinos(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Casinos> casinosList = new ArrayList<S12Casinos>();
		S12Casinos casino;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, DATOS_GENERALES.TELEFONO1, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM DATOS_GENERALES LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				casino = new S12Casinos();

				casino.setCodigoRecurso(rs.getInt("COREC"));
				casino.setIdioma(rs.getString("COIDIOMA"));
				casino.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					casino.setFotoPrincipal(multimedia);
					casino.setDescFoto(descMultimedia);
				} else {
					casino.setFotoPrincipal(foto);
					casino.setDescFoto(pieFoto);
				}

				casino.setUrlAmigable(rs.getString("URLAMIGABLE"));

				casino.setGmlong(rs.getString("GMLNG"));
				casino.setGmlat(rs.getString("GMLAT"));

				casino.setTelefono(rs.getString("TELEFONO1"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& casino.getGmlong() != null && casino.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(casino.getGmlat()),
							Double.parseDouble(casino.getGmlong()), latUser, longUser);
					casino.setDistancia(String.valueOf(distancia));
				}

				casinosList.add(casino);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCasinos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCasinos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCasinos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCasinos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(casinosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(casinosList, new S12RecursosDefaultComparator());
		}

		S12Casinos[] casinosArray = new S12Casinos[casinosList.size()];
		casinosList.toArray(casinosArray);
		return casinosArray;
	}

	/**
	 * Obtiene la lista de Zona de Bares o Pintxos que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Zona de Bares o Pintxos
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12ZonasBaresPintxos[] getZonasBaresPintxos(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12ZonasBaresPintxos> zonasBaresPintxosList = new ArrayList<S12ZonasBaresPintxos>();
		S12ZonasBaresPintxos zonaBaresPintxos;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM DATOS_GENERALES LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				zonaBaresPintxos = new S12ZonasBaresPintxos();

				zonaBaresPintxos.setCodigoRecurso(rs.getInt("COREC"));
				zonaBaresPintxos.setIdioma(rs.getString("COIDIOMA"));
				zonaBaresPintxos.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					zonaBaresPintxos.setFotoPrincipal(multimedia);
					zonaBaresPintxos.setDescFoto(descMultimedia);
				} else {
					zonaBaresPintxos.setFotoPrincipal(foto);
					zonaBaresPintxos.setDescFoto(pieFoto);
				}

				zonaBaresPintxos.setUrlAmigable(rs.getString("URLAMIGABLE"));

				zonaBaresPintxos.setGmlong(rs.getString("GMLNG"));
				zonaBaresPintxos.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& zonaBaresPintxos.getGmlong() != null && zonaBaresPintxos.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(zonaBaresPintxos.getGmlat()),
							Double.parseDouble(zonaBaresPintxos.getGmlong()), latUser, longUser);
					zonaBaresPintxos.setDistancia(String.valueOf(distancia));
				}

				zonasBaresPintxosList.add(zonaBaresPintxos);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getZonasBaresPintxos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getZonasBaresPintxos: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getZonasBaresPintxos: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getZonasBaresPintxos: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(zonasBaresPintxosList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(zonasBaresPintxosList, new S12RecursosDefaultComparator());
		}

		S12ZonasBaresPintxos[] zonasBaresPintxosArray = new S12ZonasBaresPintxos[zonasBaresPintxosList.size()];
		zonasBaresPintxosList.toArray(zonasBaresPintxosArray);
		return zonasBaresPintxosArray;
	}

	/**
	 * Obtiene la lista de Zonas de Tiendas que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Zonas de Tiendas
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12ZonasTiendas[] getZonasTiendas(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12ZonasTiendas> zonasTiendasList = new ArrayList<S12ZonasTiendas>();
		S12ZonasTiendas zonaTiendas;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(DATOS_GENERALES.COREC, DATOS_GENERALES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("S12.GEO_MUNICIPALITY(DATOS_GENERALES.COREC) AS MUNICIPIO, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE ");
			sql.append("FROM DATOS_GENERALES LEFT OUTER JOIN GEOREFERENCIACION ON DATOS_GENERALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON DATOS_GENERALES.COREC = POSICIONAMIENTO.COREC AND DATOS_GENERALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON DATOS_GENERALES.COREC = MULTIMEDIA.COREC AND DATOS_GENERALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND DATOS_GENERALES.COIDIOMA = ? ");
			sql.append("AND DATOS_GENERALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				zonaTiendas = new S12ZonasTiendas();

				zonaTiendas.setCodigoRecurso(rs.getInt("COREC"));
				zonaTiendas.setIdioma(rs.getString("COIDIOMA"));
				zonaTiendas.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					zonaTiendas.setFotoPrincipal(multimedia);
					zonaTiendas.setDescFoto(descMultimedia);
				} else {
					zonaTiendas.setFotoPrincipal(foto);
					zonaTiendas.setDescFoto(pieFoto);
				}

				zonaTiendas.setUrlAmigable(rs.getString("URLAMIGABLE"));

				zonaTiendas.setGmlong(rs.getString("GMLNG"));
				zonaTiendas.setGmlat(rs.getString("GMLAT"));

				zonaTiendas.setMunicipio(rs.getString("MUNICIPIO"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& zonaTiendas.getGmlong() != null && zonaTiendas.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(zonaTiendas.getGmlat()),
							Double.parseDouble(zonaTiendas.getGmlong()), latUser, longUser);
					zonaTiendas.setDistancia(String.valueOf(distancia));
				}

				zonasTiendasList.add(zonaTiendas);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getZonasTiendas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getZonasTiendas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getZonasTiendas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getZonasTiendas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(zonasTiendasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(zonasTiendasList, new S12RecursosDefaultComparator());
		}

		S12ZonasTiendas[] zonasTiendasArray = new S12ZonasTiendas[zonasTiendasList.size()];
		zonasTiendasList.toArray(zonasTiendasArray);
		return zonasTiendasArray;
	}

	/**
	 * Obtiene la lista de Centros Comerciales que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Centros Comerciales
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12CentrosComerciales[] getCentrosComerciales(ArrayList<String> arrRecursos, String idioma, double latUser,
			double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12CentrosComerciales> centrosComercialesList = new ArrayList<S12CentrosComerciales>();
		S12CentrosComerciales centroComercial;
		ArrayList<String> arrServicios;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT CENTROSCOMERCIALES.COREC, CENTROSCOMERCIALES.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(CENTROSCOMERCIALES.COREC, CENTROSCOMERCIALES.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(CENTROSCOMERCIALES.COREC, CENTROSCOMERCIALES.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.DIRECCION, DATOS_GENERALES.CODIGOPOSTAL, ");
			sql.append("S12.GEO_MUNICIPALITY(CENTROSCOMERCIALES.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(CENTROSCOMERCIALES.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(CENTROSCOMERCIALES.COREC) AS NOPROV, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, ");
			sql.append("DATOS_GENERALES.MAIL, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.FAX, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVISO.COSERVICIO AS ISO, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVQO.COSERVICIO as Q_ORO, TSERVQP.COSERVICIO as Q_PLATA, TSERVQC.COSERVICIO as Q_CALIDAD, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION, ");
			sql.append("PM_RECURSOS_TOWN.URLTOWNAMIGABLE ");
			sql.append("FROM CENTROSCOMERCIALES LEFT OUTER JOIN GEOREFERENCIACION ON CENTROSCOMERCIALES.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON CENTROSCOMERCIALES.COREC = POSICIONAMIENTO.COREC AND CENTROSCOMERCIALES.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON CENTROSCOMERCIALES.COREC = PM_RECURSOS_TOWN.COREC AND CENTROSCOMERCIALES.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON CENTROSCOMERCIALES.COREC = DATOS_GENERALES.COREC AND CENTROSCOMERCIALES.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON CENTROSCOMERCIALES.COREC = MULTIMEDIA.COREC AND CENTROSCOMERCIALES.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			// Q Oro
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON CENTROSCOMERCIALES.COREC = TSERVQO.COREC ");
			// Q Plata
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON CENTROSCOMERCIALES.COREC = TSERVQP.COREC ");
			// Q de Calidad
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON CENTROSCOMERCIALES.COREC = TSERVQC.COREC ");
			// buenas pr�cticas
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON CENTROSCOMERCIALES.COREC = TSERVBP.COREC ");
			// ISO
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON CENTROSCOMERCIALES.COREC = TSERVISO.COREC ");
			// accesibilidad
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON CENTROSCOMERCIALES.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			// Certif. Innovación
			sql.append("LEFT OUTER JOIN (SELECT CENTROSCOMERCIALES.COREC, COSERVICIO FROM CENTROSCOMERCIALES, REC_SRV WHERE REC_SRV.COREC = CENTROSCOMERCIALES.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON CENTROSCOMERCIALES.COREC = TSERVINNOVA.COREC ");
			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND CENTROSCOMERCIALES.COIDIOMA = ? ");

			sql.append("AND CENTROSCOMERCIALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				arrServicios = new ArrayList<String>();

				centroComercial = new S12CentrosComerciales();

				centroComercial.setCodigoRecurso(rs.getInt("COREC"));
				centroComercial.setIdioma(rs.getString("COIDIOMA"));
				centroComercial.setNombre(rs.getString("NOMBRE"));

				centroComercial.setDireccion(rs.getString("DIRECCION"));
				centroComercial.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				centroComercial.setMunicipio(rs.getString("MUNICIPIO"));
				centroComercial.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				centroComercial.setProvincia(rs.getString("NOPROV"));

				centroComercial.setTelefono(rs.getString("TELEFONO1"));
				centroComercial.setTelefono2(rs.getString("TELEFONO2"));
				centroComercial.setDescTelefono(rs.getString("DESCTELEFONO1"));
				centroComercial.setDescTelefono2(rs.getString("DESCTELEFONO2"));
				centroComercial.setFax(rs.getString("FAX"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					centroComercial.setFotoPrincipal(multimedia);
					centroComercial.setDescFoto(descMultimedia);
				} else {
					centroComercial.setFotoPrincipal(foto);
					centroComercial.setDescFoto(pieFoto);
				}

				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				centroComercial.setArrServicios(arrServicios);

				centroComercial.setUrlAmigable(rs.getString("URLAMIGABLE"));
				centroComercial.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				centroComercial.setEmail(rs.getString("MAIL"));
				centroComercial.setWeb(rs.getString("URL"));

				centroComercial.setGmlong(rs.getString("GMLNG"));
				centroComercial.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& centroComercial.getGmlong() != null && centroComercial.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(centroComercial.getGmlat()),
							Double.parseDouble(centroComercial.getGmlong()), latUser, longUser);
					centroComercial.setDistancia(String.valueOf(distancia));
				}

				centrosComercialesList.add(centroComercial);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCentrosComerciales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCentrosComerciales: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getCentrosComerciales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getCentrosComerciales: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(centrosComercialesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(centrosComercialesList, new S12RecursosDefaultComparator());
		}

		S12CentrosComerciales[] centrosComercialesArray = new S12CentrosComerciales[centrosComercialesList.size()];
		centrosComercialesList.toArray(centrosComercialesArray);
		return centrosComercialesArray;
	}

	/**
	 * Obtiene la lista de Mercados Tradicionales que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Mercados Tradicionales
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12MercadosTradicionales[] getMercadosTradicionales(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12MercadosTradicionales> mercadosTradicionalesList = new ArrayList<S12MercadosTradicionales>();
		S12MercadosTradicionales mercadoTradicional;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT MERCADOSTRADICIONALES.COREC, MERCADOSTRADICIONALES.COIDIOMA, MERCADOSTRADICIONALES.NORECURSO, ");
			sql.append("MERCADOSTRADICIONALES.NOFOTO, MERCADOSTRADICIONALES.DEPIEFOTO, MERCADOSTRADICIONALES.DEDIRECCION, MERCADOSTRADICIONALES.NOCODIGOPOSTAL, ");
			sql.append("S12.GEO_MUNICIPALITY(MERCADOSTRADICIONALES.COREC) AS MUNICIPIO, ");
			sql.append("MERCADOSTRADICIONALES.NOMINIATURAB AS MULTIMEDIA, MERCADOSTRADICIONALES.DEMINIATURAB AS DESCMULTIMEDIA, ");
			sql.append("MERCADOSTRADICIONALES.NOTELEFONO, MERCADOSTRADICIONALES.NOURL, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, DESTACADOS.URLAMIGABLE ");
			sql.append("FROM MERCADOSTRADICIONALES, GEOREFERENCIACION, DESTACADOS ");
			sql.append("WHERE MERCADOSTRADICIONALES.COREC = GEOREFERENCIACION.COREC(+) ");
			sql.append("AND MERCADOSTRADICIONALES.COREC = DESTACADOS.COREC ");
			sql.append("AND MERCADOSTRADICIONALES.COIDIOMA = DESTACADOS.COIDIOMA ");

			// Idioma
			sql.append("AND MERCADOSTRADICIONALES.COIDIOMA = ? ");
			sql.append("AND MERCADOSTRADICIONALES.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				mercadoTradicional = new S12MercadosTradicionales();

				mercadoTradicional.setCodigoRecurso(rs.getInt("COREC"));
				mercadoTradicional.setIdioma(rs.getString("COIDIOMA"));
				mercadoTradicional.setNombre(rs.getString("NORECURSO"));

				mercadoTradicional.setDireccion(rs.getString("DEDIRECCION"));
				mercadoTradicional.setCodigoPostal(rs.getString("NOCODIGOPOSTAL"));
				mercadoTradicional.setMunicipio(rs.getString("MUNICIPIO"));

				mercadoTradicional.setTelefono(rs.getString("NOTELEFONO"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					mercadoTradicional.setFotoPrincipal(multimedia);
					mercadoTradicional.setDescFoto(descMultimedia);
				} else {
					mercadoTradicional.setFotoPrincipal(foto);
					mercadoTradicional.setDescFoto(pieFoto);
				}

				mercadoTradicional.setUrlAmigable(rs.getString("URLAMIGABLE"));

				mercadoTradicional.setWeb(rs.getString("NOURL"));

				mercadoTradicional.setGmlong(rs.getString("GMLNG"));
				mercadoTradicional.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& mercadoTradicional.getGmlong() != null && mercadoTradicional.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(mercadoTradicional.getGmlat()),
							Double.parseDouble(mercadoTradicional.getGmlong()), latUser, longUser);
					mercadoTradicional.setDistancia(String.valueOf(distancia));
				}

				mercadosTradicionalesList.add(mercadoTradicional);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getMercadosTradicionales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getMercadosTradicionales: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getMercadosTradicionales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getMercadosTradicionales: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(mercadosTradicionalesList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(mercadosTradicionalesList, new S12RecursosDefaultComparator());
		}

		S12MercadosTradicionales[] mercadosTradicionalesArray = new S12MercadosTradicionales[mercadosTradicionalesList
				.size()];
		mercadosTradicionalesList.toArray(mercadosTradicionalesArray);
		return mercadosTradicionalesArray;
	}

	/**
	 * Obtiene todos los d�as de los programas experienciales.
	 * 
	 * @param idioma Idioma de la vista
	 * @param latUser latitud del usuario
	 * @param longUser longitud del usuario
	 * @param viajarCon the viajar con
	 * @param interes the interes
	 * @param original the original
	 * @param nDias the n dias
	 * @param codCapital the cod capital
	 * 
	 * @return ArrayList de objetos S12Poi
	 * 
	 * @throws S12PortalMovilDaoException Excepci�n
	 */
	public ArrayList<S12DiasProgrExperienciales> getDiasProgrExperienciales(String codCapital, int viajarCon,
			int interes, int nDias, String original, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {

		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12DiasProgrExperienciales> diasProgramasExpList = new ArrayList<S12DiasProgrExperienciales>();
		S12DiasProgrExperienciales diaProgramaExp;
		S12UnidadContenidoVI unidadContenidoVI;
		S12UnidadContenidoRecurso unidadContenidoRecurso;
		ArrayList<S12UnidadContenidoVI> listUnidadContenidoManana;
		ArrayList<S12UnidadContenidoVI> listUnidadContenidoComida;
		ArrayList<S12UnidadContenidoVI> listUnidadContenidoTarde;
		ArrayList<S12UnidadContenidoVI> listUnidadContenidoCena;
		String sqlViajarCon = "";
		String sqlInteres = "";
		StringBuffer sqlOpciones;
		StringBuffer sqlBuffer;
		ArrayList<String> codUnidadesList;

		try {

			for (int numDia = 1; numDia <= nDias; numDia++) {

				codUnidadesList = new ArrayList<String>();
				sqlBuffer = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
				sqlOpciones = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
				listUnidadContenidoManana = new ArrayList<S12UnidadContenidoVI>();
				listUnidadContenidoComida = new ArrayList<S12UnidadContenidoVI>();
				listUnidadContenidoTarde = new ArrayList<S12UnidadContenidoVI>();
				listUnidadContenidoCena = new ArrayList<S12UnidadContenidoVI>();

				conn = S12ConnectionManager.getConnection();

				diaProgramaExp = new S12DiasProgrExperienciales();
				diaProgramaExp.setNumDia(numDia);

				sqlBuffer.append("SELECT UC.COUNID, VIUC.COIDIOMA, VIUC.COESTADO, VIUC.NOUNIDAD, VIUC.DEDESCRIPCION,");
				sqlBuffer
						.append(" UP.COPROG, UP.CODIA, UP.COFRANJA, UP.CORDEN, S12.PEX_RECURSOS(UC.COUNID) AS RECURSOS ");
				sqlBuffer.append(" FROM PEX_UNIDADCONTENIDO UC, PEX_VI_UNIDADCONTENIDO VIUC, PEX_UNID_PROGRAMAS UP ");
				sqlBuffer.append(" WHERE UC.COUNID = VIUC.COUNID AND UC.COUNID = UP.COUNID ");
				sqlBuffer.append(" AND COIDIOMA = ? AND COCAPITAL = ?");
				sqlBuffer.append(" AND COPROG = ").append(nDias).append(" AND CODIA = ").append(numDia)
						.append(" AND COESTADO = 'PU'");
				sqlBuffer.append(" AND FEBAJA IS NULL AND COUSERFEBAJA IS NULL");

				switch (viajarCon) {
				case S12PortalMovilDAO.VIAJARCON_PAREJA:
					sqlViajarCon = "COGRUPOPAREJA = '1'";
					break;
				case S12PortalMovilDAO.VIAJARCON_NINOS:
					sqlViajarCon = "COGRUPONINOS = '1'";
					break;
				case S12PortalMovilDAO.VIAJARCON_AMIGOS:
					sqlViajarCon = "COGRUPOAMIGOS = '1'";
					break;
				default:
					break;
				}

				switch (interes) {
				case S12PortalMovilDAO.INTERES_CULTURA:
					sqlInteres = "COINTERESCULTURA = '1'";
					break;
				case S12PortalMovilDAO.INTERES_GASTRONOMIA:
					sqlInteres = "COINTERESGASTRONOMIA = '1'";
					break;
				case S12PortalMovilDAO.INTERES_BIENESTAR:
					sqlInteres = "COINTERESBIENESTAR = '1'";
					break;
				case S12PortalMovilDAO.INTERES_NATURALEZA:
					sqlInteres = "COINTERESNATURALEZA = '1'";
					break;
				case S12PortalMovilDAO.INTERES_COMPRAS:
					sqlInteres = "COINTERESCOMPRAS = '1'";
					break;
				case S12PortalMovilDAO.INTERES_EVENTOS:
					sqlInteres = "COINTERESEVENTOS = '1'";
					break;
				default:
					break;
				}

				if (sqlViajarCon.length() > 0 && sqlInteres.length() > 0 && !"".equals(original)) {
					sqlOpciones.append(" AND (").append(sqlViajarCon).append(" OR ").append(sqlInteres)
							.append(" OR COORIGINAL = '1')");
				} else if (sqlViajarCon.length() > 0 && sqlInteres.length() > 0) {
					sqlOpciones.append(" AND COORIGINAL = '0' AND (").append(sqlViajarCon).append(" OR ")
							.append(sqlInteres).append(")");
				} else if (sqlViajarCon.length() > 0 && !"".equals(original)) {
					sqlOpciones.append(" AND (").append(sqlViajarCon).append(" OR COORIGINAL = '1')");
				} else if (sqlInteres.length() > 0 && !"".equals(original)) {
					sqlOpciones.append(" AND (").append(sqlInteres).append(" OR COORIGINAL = '1')");
				} else if (sqlViajarCon.length() > 0) {
					sqlOpciones.append(" AND COORIGINAL = '0' AND ").append(sqlViajarCon);
				} else if (sqlInteres.length() > 0) {
					sqlOpciones.append(" AND COORIGINAL = '0' AND ").append(sqlInteres);
				} else if ("".equals(original)) {
					sqlOpciones.append(" AND COORIGINAL = '0'");
				}

				if (sqlOpciones.length() > 0) {
					sqlBuffer.append(sqlOpciones.toString());
				}

				sqlBuffer.append(" ORDER BY CORDEN");

				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.DEBUG,
							"S12PortalMovilDAO:: SQL: " + sqlBuffer.toString());
				}
				BLogger.blog(BLogger.DEBUG, "Se realiza la SQL de UNIDADES DE CONTENIDO:" + sqlBuffer.toString());

				prepStmt = conn.prepareStatement(sqlBuffer.toString());
				int index = 1;
				prepStmt.setString(index++, idioma);	
				prepStmt.setString(index++, codCapital);	
				rs = prepStmt.executeQuery();
				
				while (rs != null && rs.next()) {

					unidadContenidoVI = new S12UnidadContenidoVI();
					unidadContenidoVI.setCodigoUnidad(rs.getLong("COUNID"));
					unidadContenidoVI.setDescripcionUnidad(rs.getString("DEDESCRIPCION"));

					// String con los c�digos de los recursos asociados a la unidad de contenido separados por comas
					String recursos = rs.getString("RECURSOS");

					if (recursos != null) {
						// Obtener datos de los recursos asociados
						String[] aRecursos = recursos.split(",");
						ArrayList<S12UnidadContenidoRecurso> unidadContenidoRecursos = new ArrayList<S12UnidadContenidoRecurso>();
						for (int i = 0; i < aRecursos.length; i++) {
							unidadContenidoRecurso = this.getUnidadContenidoRecurso(aRecursos[i], idioma);
							if (unidadContenidoRecurso != null) {
								unidadContenidoRecursos.add(unidadContenidoRecurso);
							}
						}
						unidadContenidoVI.setRecursos(unidadContenidoRecursos);
					}

					int codigoFranja = rs.getInt("COFRANJA");
					if (codigoFranja == 1) {
						listUnidadContenidoManana.add(unidadContenidoVI);
					} else if (codigoFranja == 2) {
						listUnidadContenidoComida.add(unidadContenidoVI);
					} else if (codigoFranja == 3) {
						listUnidadContenidoTarde.add(unidadContenidoVI);
					} else if (codigoFranja == 4) {
						listUnidadContenidoCena.add(unidadContenidoVI);
					}

					codUnidadesList.add(String.valueOf(unidadContenidoVI.getCodigoUnidad()));
				}

				diaProgramaExp.setFranjaManana(listUnidadContenidoManana);
				diaProgramaExp.setFranjaComida(listUnidadContenidoComida);
				diaProgramaExp.setFranjaTarde(listUnidadContenidoTarde);
				diaProgramaExp.setFranjaCena(listUnidadContenidoCena);
				diaProgramaExp.setCodUnidadesList(codUnidadesList);

				// b�squeda para mostrar los multimedia pertenecientes a ese programa Experiencial(seg�n el d�a y el
				// lenguaje)
				ArrayList<S12UnidadMultimedia> arMultimediaUnidades = this.getMultimedia(diaProgramaExp, nDias, idioma);
				diaProgramaExp.setUrlGaleriaMultimedia(this.crearXmlMultimedia(arMultimediaUnidades, idioma));

				diasProgramasExpList.add(diaProgramaExp);
			}

		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDiasProgrExperienciales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDiasProgrExperienciales: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDiasProgrExperienciales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDiasProgrExperienciales: Exception ", e);
		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getDiasProgrExperienciales: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getDiasProgrExperienciales: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return diasProgramasExpList;
	}

	/**
	 * Obtiene los datos del recurso asociado a la unidad de contenido.
	 * 
	 * @param codigoRecurso c�digo del recurso tur�stico
	 * @param idioma idioma
	 * 
	 * @return recurso asociado a la unidad de recurso
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	private S12UnidadContenidoRecurso getUnidadContenidoRecurso(String codigoRecurso, String idioma)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		S12UnidadContenidoRecurso unidadContenidoRecurso = null;
		StringBuffer sql;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT COREC, LANGUAGE, TEMPLATETYPE, NAME, IMAGE, MULTIMEDIA, GMLAT, GMLNG, URLAMIGABLE, DESCRIPTION ");
			sql.append("FROM CONSULTAMAT_RECURSOS_PM ");
			sql.append("WHERE COREC = ?");
			// Idioma
			sql.append(" AND LANGUAGE = ?");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setLong(index++, Long.parseLong(codigoRecurso));	
			prepStmt.setString(index++, idioma);	
			rs = prepStmt.executeQuery();

			if (rs.next()) {
				unidadContenidoRecurso = new S12UnidadContenidoRecurso();
				unidadContenidoRecurso.setCodigoRecurso(rs.getInt("COREC"));
				unidadContenidoRecurso.setGmlat(rs.getString("GMLAT"));
				unidadContenidoRecurso.setGmlong(rs.getString("GMLNG"));
				unidadContenidoRecurso.setIdioma(rs.getString("LANGUAGE"));
				unidadContenidoRecurso.setNombre(rs.getString("NAME"));
				unidadContenidoRecurso.setTemplateType(rs.getString("TEMPLATETYPE"));
				unidadContenidoRecurso.setUrlAmigable(rs.getString("URLAMIGABLE"));
				unidadContenidoRecurso.setDescripcion(rs.getString("DESCRIPTION"));

				// Si no existe foto principal seleccionamos la primera foto de los multimedia
				String foto = rs.getString("IMAGE");
				String multimedia = rs.getString("MULTIMEDIA");
				if (foto != null && !"".equals(foto)) {
					unidadContenidoRecurso.setFotoPrincipal(foto);
				} else {
					unidadContenidoRecurso.setFotoPrincipal(multimedia);
				}
			}

		} catch (NumberFormatException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getUnidadContenidoRecurso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getUnidadContenidoRecurso: Exception ", e);
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getUnidadContenidoRecurso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getUnidadContenidoRecurso: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getUnidadContenidoRecurso: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getUnidadContenidoRecurso: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return unidadContenidoRecurso;
	}

	/**
	 * Crear xml multimedia.
	 * 
	 * @param arMultimediaUnidades the ar multimedia unidades
	 * @param idioma the idioma
	 * 
	 * @return the string
	 */
	public S12GaleriaXml crearXmlMultimedia(ArrayList<S12UnidadMultimedia> arMultimediaUnidades, String idioma) {

		S12UnidadMultimedia unidadMultimedia = null;
		String urlPEX = Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO", "URL_CONTENIDO_PEX");

		S12GaleriaXml galeriaXml = new S12GaleriaXml();
		S12ImagenXml imagenXml;
		for (int i = 0; i < arMultimediaUnidades.size(); i++) {
			unidadMultimedia = arMultimediaUnidades.get(i);
			imagenXml = new S12ImagenXml();
			imagenXml.setTitulo(S12Utils.encodeHtmlTag(unidadMultimedia.getDescripcionMultimedia()));
			imagenXml.setUrl(urlPEX + idioma + "_prog_exp/media/" + unidadMultimedia.getUrlMultimedia());
			// if (unidadMultimedia.getCodigoTipoMultimedia() == 1){
			// imagenXml.setTipo("foto");
			// }else if (unidadMultimedia.getCodigoTipoMultimedia() == 2){
			// imagenXml.setTipo("video");
			//
			// }
			// imagenXml.setTextAlt(S12Utils.encodeHtmlTag(unidadMultimedia.getDescripcionMultimedia()));
			galeriaXml.getImagen().add(imagenXml);
		}

		BLogger.blog(BLogger.DEBUG, "XMLMultimedia:" + galeriaXml.toJSONString());

		return galeriaXml;
	}

	/**
	 * Obtiene todos los Enlaces de la capital.
	 * 
	 * @param idioma Idioma de la vista
	 * @param codCapital the cod capital
	 * 
	 * @return ArrayList de objetos S12EnlacesCapital
	 * 
	 * @throws S12PortalMovilDaoException Excepci�n
	 */
	public ArrayList<S12EnlacesCapital> getEnlacesCapital(String codCapital, String idioma)
			throws S12PortalMovilDaoException {

		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EnlacesCapital> enlacesList = new ArrayList<S12EnlacesCapital>();
		S12EnlacesCapital enlacesCapital;

		try {
			conn = S12ConnectionManager.getConnection();

			// construct the SQL statement
			StringBuffer sqlBuffer = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sqlBuffer.append("SELECT COENLACE, COIDIOMA, NOENLACE, URLENLACE ");
			sqlBuffer.append("FROM PEX_ENLACES_CAPITAL WHERE COCAPITAL = ? ");
			sqlBuffer.append(" AND COIDIOMA = ? AND COESTADO = 'PU'");

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, codCapital);	
			prepStmt.setString(index++, idioma);	
			rs = prepStmt.executeQuery();

			while (rs != null && rs.next()) {
				enlacesCapital = new S12EnlacesCapital();
				enlacesCapital.setCodigoEnlace(rs.getLong("COENLACE"));
				enlacesCapital.setIdioma(rs.getString("COIDIOMA"));
				enlacesCapital.setNombreEnlace(rs.getString("NOENLACE"));
				enlacesCapital.setUrlEnlace(rs.getString("URLENLACE"));

				enlacesList.add(enlacesCapital);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEnlacesCapital: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEnlacesCapital: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEnlacesCapital: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEnlacesCapital: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return enlacesList;
	}

	/**
	 * Gets the multimedia.
	 * 
	 * @param diasPrograma the dias programa
	 * @param language the language
	 * @param diaProgramaExp the dia programa exp
	 * 
	 * @return the multimedia
	 * 
	 * @throws Exception the exception
	 */
	public ArrayList<S12UnidadMultimedia> getMultimedia(S12DiasProgrExperienciales diaProgramaExp, int diasPrograma,
			String language) throws Exception {

		ArrayList<S12UnidadMultimedia> resultado = new ArrayList<S12UnidadMultimedia>();
		// declare variables
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
		S12UnidadMultimedia unidadMultimedia;
		String codUnidadContenido;
		StringBuffer codUnidades = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
		ArrayList<String> listaCodigos = diaProgramaExp.getCodUnidadesList();

		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = S12ConnectionManager.getConnection();

			for (int i = 0; i < listaCodigos.size(); i++) {
				codUnidadContenido = listaCodigos.get(i);
				if (codUnidades.length() == 0) {
					codUnidades.append(codUnidadContenido);
				} else {
					codUnidades.append(",").append(codUnidadContenido);
				}
			}

			// construct the SQL statement
			sqlBuffer
					.append("SELECT COMULT, UM.COUNID, COIDIOMA, COTIPMULT, URLMULT, DEMULT, UP.CODIA, UP.COFRANJA, UP.CORDEN ");
			sqlBuffer.append("FROM PEX_UNID_MULTIMEDIA UM, PEX_UNID_PROGRAMAS UP ");
			sqlBuffer.append("WHERE UM.COUNID = UP.COUNID AND COIDIOMA = ? ");
			sqlBuffer.append("AND COPROG = ").append(diasPrograma);
			sqlBuffer.append(" AND UM.COUNID IN (" + codUnidades.toString() + ") ORDER BY COFRANJA,CORDEN");

			BLogger.blog(BLogger.DEBUG, "Se realiza la SQL de MULTIMEDIA del dia: " + diaProgramaExp.getNumDia() + "; "
					+ sqlBuffer.toString());

			prepStmt = conn.prepareStatement(sqlBuffer.toString());
			int index = 1;
			prepStmt.setString(index++, language);	
			rs = prepStmt.executeQuery();
			while (rs != null && rs.next()) {
				unidadMultimedia = new S12UnidadMultimedia();
				unidadMultimedia.setCodigoMultimedia(rs.getLong("COMULT"));
				unidadMultimedia.setCodigoUnidad(rs.getLong("COUNID"));
				unidadMultimedia.setIdioma(rs.getString("COIDIOMA"));
				unidadMultimedia.setCodigoTipoMultimedia(rs.getLong("COTIPMULT"));
				unidadMultimedia.setUrlMultimedia(rs.getString("URLMULT"));
				unidadMultimedia.setDescripcionMultimedia(rs.getString("DEMULT"));

				resultado.add(unidadMultimedia);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}

	/**
	 * Obtiene todos los recursos importantes
	 * 
	 * @param idioma Idioma de la vista
	 * @param importancia Importancia del recurso
	 * @param latUser latitud del usuario
	 * @param longUser longitud del usuario
	 * 
	 * @return ArrayList de objetos S12Poi
	 * 
	 * @throws S12PortalMovilDaoException Excepci�n
	 */
	public ArrayList<S12Poi> getRecursosImportantes(String idioma, String importancia, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Poi> poisList = new ArrayList<S12Poi>();

		try {
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append(" SELECT COREC, LANGUAGE, TEMPLATETYPE, NAME, IMAGE, MULTIMEDIA, GMLAT, GMLNG, URLAMIGABLE ");
			sql.append(" FROM CONSULTAMAT_RECURSOS_PM WHERE ");

			// C�digos de importancia
			String[] arrayCodigosImportancia = importancia.split(",");

			sql.append("IMPORTANCE IN (");

			for (int i = 0; i < arrayCodigosImportancia.length; i++) {
				sql.append(arrayCodigosImportancia[i]);

				if (i < arrayCodigosImportancia.length - 1) {
					sql.append(", ");
				}
			}
			sql.append(") ");

			sql.append("AND LANGUAGE = ? ");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				S12Poi poi = new S12Poi();

				poi.setCodigoRecurso(rs.getInt("COREC"));
				poi.setTipoRecurso(rs.getString("TEMPLATETYPE"));
				poi.setTemplateType(rs.getString("TEMPLATETYPE"));
				poi.setIdioma(rs.getString("LANGUAGE"));
				poi.setNombre(rs.getString("NAME"));

				// Si no existe foto principal seleccionamos la primera foto de los multimedia
				String foto = rs.getString("IMAGE");
				String multimedia = rs.getString("MULTIMEDIA");
				if (foto != null && !"".equals(foto)) {
					poi.setFotoPrincipal(foto);
				} else {
					poi.setFotoPrincipal(multimedia);
				}

				poi.setUrlAmigable(rs.getString("URLAMIGABLE"));
				poi.setGmlong(rs.getString("GMLNG"));
				poi.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& poi.getGmlong() != null && poi.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(poi.getGmlat()),
							Double.parseDouble(poi.getGmlong()), latUser, longUser);
					poi.setDistancia(String.valueOf(distancia));
				}

				poisList.add(poi);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosImportantes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosImportantes: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getRecursosImportantes: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getRecursosImportantes: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		return poisList;
	}

	/**
	 * Obtiene todos los pois filtrados por tipo
	 * 
	 * @param idioma Idioma de la vista
	 * @param tiposRecursos String Tipos de recursos a filtrar separados por ','. Formato:
	 *            tipoRecurso_subTipoRecurso_Categoria. Ejemplo: A1_H_1,B1_1,C2_
	 * @param latUser latitud del usuario
	 * @param longUser longitud del usuario
	 * 
	 * @return ArrayList de objetos S12Poi
	 * 
	 * @throws S12PortalMovilDaoException Excepci�n
	 */
	public ArrayList<S12Poi> getPoisNearLocation(String idioma, String tiposRecursos, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Poi> poisList = new ArrayList<S12Poi>();

		try {
			
			String[] tiposRecursoArray = tiposRecursos.split(",");
			
			conn = S12ConnectionManager.getConnection();

			StringBuffer sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append(" SELECT COREC, LANGUAGE, TEMPLATETYPE, NAME, IMAGE, MULTIMEDIA, GMLAT, GMLNG, URLAMIGABLE, TYPE, IMPORTANCE, ROOM ");
			sql.append(" FROM CONSULTAMAT_RECURSOS_PM WHERE (");

			// Tipos, subtipos y categor�a de los recursos
			for (int i = 0; i < tiposRecursoArray.length; i++) {
				String[] tipoRecurso = tiposRecursoArray[i].split("_");

				String codigoTipoRecurso = tipoRecurso[0];

				if (i > 0) {
					sql.append(" OR ");
				}

				sql.append("(");

				// C�digo de Tipo de Recurso (TEMPLATETYPE)
				sql.append("TEMPLATETYPE = '");
				sql.append(codigoTipoRecurso);
				sql.append("'");

				// Subtipo de Recurso (TYPE)
				if (tipoRecurso.length > 1) {
					String subTipoRecurso = tipoRecurso[1];

					if (S12Constantes.EXPERIENCIAS.equals(codigoTipoRecurso)) {
						// Tratamiento especial para Experiencias (D6)
						if ("A".equals(subTipoRecurso)) { // Agua
							sql.append(" AND WATER IS NOT NULL ");
						} else if ("P".equals(subTipoRecurso)) { // Paisaje
							sql.append(" AND LANDSCAPE IS NOT NULL ");
						} else if ("G".equals(subTipoRecurso)) { // Gastronom�a
							sql.append(" AND CUISINE IS NOT NULL ");
						} else if ("C".equals(subTipoRecurso)) { // Cultura
							sql.append(" AND CULTURE IS NOT NULL ");
						}
					} else {
						sql.append(" AND TYPE = '");
						sql.append(subTipoRecurso);
						sql.append("'");
					}
				}

				// Categor�a (CATEGORY)
				if (tipoRecurso.length > 2 && tipoRecurso[2].indexOf("TOP") == -1) {
					String categoria = tipoRecurso[2];
					if ("S".equals(categoria)) { // Hoteles con sala de reuniones
						sql.append(" AND ROOM IS NOT NULL ");
					} else {
						sql.append(" AND CATEGORY = '");
						sql.append(categoria);
						sql.append("'");
					}
					if (S12Constantes.EXPERIENCIAS.equals(codigoTipoRecurso)) {
						sql.append(" AND (IMPORTANCE IS NULL OR IMPORTANCE > 1)");
					}
				} else if (tipoRecurso.length > 2 && tipoRecurso[2].indexOf("TOP") != -1) {
					sql.append(" AND IMPORTANCE = 1 ");
				} else if (S12Constantes.EXPERIENCIAS.equals(codigoTipoRecurso)) {
					sql.append(" AND (IMPORTANCE IS NULL OR IMPORTANCE > 1)");
				}

				sql.append(")");
			}

			// Idioma
			sql.append(") AND LANGUAGE = ? ");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			rs = prepStmt.executeQuery();

			while (rs.next()) {
				S12Poi poi = new S12Poi();

				poi.setCodigoRecurso(rs.getInt("COREC"));
				poi.setTemplateType(rs.getString("TEMPLATETYPE"));

				// Se concatena el subtipo
				String templateType = rs.getString("TEMPLATETYPE");
				String type = rs.getString("TYPE");
				String importance = rs.getString("IMPORTANCE");
				String room = rs.getString("ROOM");
				StringBuffer sTipoRecurso = new StringBuffer(templateType);

				if (type != null) {
					sTipoRecurso.append("_");
					sTipoRecurso.append(type);

					// Para Hoteles con salas de reuniones. Para que se muestre otro icono.
					if ("H".equals(type) && room != null) {
						sTipoRecurso.append("_S");
					}
				}

				// Distinguir experiencias TOP y no TOP
				if ("D6".equals(templateType) && "1".equals(importance)) {
					sTipoRecurso.append("_TOP");
				}
				poi.setTipoRecurso(sTipoRecurso.toString());

				poi.setIdioma(rs.getString("LANGUAGE"));
				poi.setNombre(rs.getString("NAME"));

				// Si no existe foto principal seleccionamos la primera foto de los multimedia
				String foto = rs.getString("IMAGE");
				String multimedia = rs.getString("MULTIMEDIA");
				if (foto != null && !"".equals(foto)) {
					poi.setFotoPrincipal(foto);
				} else {
					poi.setFotoPrincipal(multimedia);
				}

				poi.setUrlAmigable(rs.getString("URLAMIGABLE"));
				poi.setGmlong(rs.getString("GMLNG"));
				poi.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& poi.getGmlong() != null && poi.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(poi.getGmlat()),
							Double.parseDouble(poi.getGmlong()), latUser, longUser);
					poi.setDistancia(String.valueOf(distancia));
				}

				poisList.add(poi);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPoisNearLocation: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPoisNearLocation: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPoisNearLocation: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPoisNearLocation: Exception ", e);
		} catch (NullPointerException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getPoisNearLocation: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getPoisNearLocation: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(poisList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(poisList, new S12RecursosDefaultComparator());
		}

		return poisList;
	}

	/**
	 * Gets the empresa turismo activo.
	 * 
	 * @param arrRecursos the arr recursos
	 * @param idioma the idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * 
	 * @return the empresa turismo activo
	 * 
	 * @throws S12PortalMovilDaoException the s12 portal movil dao exception
	 */
	public S12EmpresaTurismoActivo[] getEmpresaTurismoActivo(ArrayList<String> arrRecursos, String idioma,
			double latUser, double longUser) throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12EmpresaTurismoActivo> empresaTurismoActivoList = new ArrayList<S12EmpresaTurismoActivo>();
		S12EmpresaTurismoActivo empresaTurismoActivo;
		StringBuffer sql;
		ArrayList<String> arrServicios;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT EMPRESASTURISMOACTIVO.COREC, EMPRESASTURISMOACTIVO.COIDIOMA, DATOS_GENERALES.NOMBRE, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(EMPRESASTURISMOACTIVO.COREC, EMPRESASTURISMOACTIVO.COIDIOMA) AS NOFOTO, S12.DESC_FOTO_PRINCIPAL_RECURSO(EMPRESASTURISMOACTIVO.COREC, EMPRESASTURISMOACTIVO.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("MULTIMEDIA.ARCHIVOMULT AS MULTIMEDIA, MULTIMEDIA.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT, POSICIONAMIENTO.URLAMIGABLE, ");
			sql.append("TSERVQC.COSERVICIO AS Q_CALIDAD, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVSURF.COSERVICIO as SURFING, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM EMPRESASTURISMOACTIVO LEFT OUTER JOIN GEOREFERENCIACION ON EMPRESASTURISMOACTIVO.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON EMPRESASTURISMOACTIVO.COREC = POSICIONAMIENTO.COREC AND EMPRESASTURISMOACTIVO.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("INNER JOIN DATOS_GENERALES ON EMPRESASTURISMOACTIVO.COREC = DATOS_GENERALES.COREC AND EMPRESASTURISMOACTIVO.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append(
					"LEFT OUTER JOIN MULTIMEDIA ON EMPRESASTURISMOACTIVO.COREC = MULTIMEDIA.COREC AND EMPRESASTURISMOACTIVO.COIDIOMA = MULTIMEDIA.COIDIOMA AND MULTIMEDIA.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append("LEFT OUTER JOIN(SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// Q de calidad
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON EMPRESASTURISMOACTIVO.COREC = TSERVQC.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// Q Oro
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON EMPRESASTURISMOACTIVO.COREC = TSERVQO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// Q Plata
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON EMPRESASTURISMOACTIVO.COREC = TSERVQP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// ISO
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON  EMPRESASTURISMOACTIVO.COREC = TSERVISO.COREC ");
			// buenas pr�cticas
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON EMPRESASTURISMOACTIVO.COREC = TSERVBP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// surfing
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_SURFING).append(" AND COIDIOMA = ?")
					.append(") TSERVSURF ON EMPRESASTURISMOACTIVO.COREC = TSERVSURF.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// ECOLABEL
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL).append(" AND COIDIOMA = ?")
					.append(") TSERVECOL ON EMPRESASTURISMOACTIVO.COREC = TSERVECOL.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			// club producto
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO).append(" AND COIDIOMA = ?")
					.append(") TSERVPRODUCTO ON EMPRESASTURISMOACTIVO.COREC = TSERVPRODUCTO.COREC ");
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT EMPRESASTURISMOACTIVO.COREC, COSERVICIO FROM EMPRESASTURISMOACTIVO, REC_SRV WHERE REC_SRV.COREC = EMPRESASTURISMOACTIVO.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON EMPRESASTURISMOACTIVO.COREC = TSERVINNOVA.COREC ");

			sql.append("WHERE 1 = 1 ");

			// Idioma
			sql.append("AND EMPRESASTURISMOACTIVO.COIDIOMA = ? ");
			sql.append("AND EMPRESASTURISMOACTIVO.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				empresaTurismoActivo = new S12EmpresaTurismoActivo();
				arrServicios = new ArrayList<String>();

				empresaTurismoActivo.setCodigoRecurso(rs.getInt("COREC"));
				empresaTurismoActivo.setIdioma(rs.getString("COIDIOMA"));
				empresaTurismoActivo.setNombre(rs.getString("NOMBRE"));

				empresaTurismoActivo.setTelefono(rs.getString("TELEFONO1"));
				empresaTurismoActivo.setDescTelefono(rs.getString("DESCTELEFONO1"));
				empresaTurismoActivo.setTelefono2(rs.getString("TELEFONO2"));
				empresaTurismoActivo.setDescTelefono2(rs.getString("DESCTELEFONO2"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					empresaTurismoActivo.setFotoPrincipal(multimedia);
					empresaTurismoActivo.setDescFoto(descMultimedia);
				} else {
					empresaTurismoActivo.setFotoPrincipal(foto);
					empresaTurismoActivo.setDescFoto(pieFoto);
				}

				empresaTurismoActivo.setUrlAmigable(rs.getString("URLAMIGABLE"));

				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("SURFING") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				empresaTurismoActivo.setArrServicios(arrServicios);

				empresaTurismoActivo.setGmlong(rs.getString("GMLNG"));
				empresaTurismoActivo.setGmlat(rs.getString("GMLAT"));

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& empresaTurismoActivo.getGmlong() != null && empresaTurismoActivo.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(
							Double.parseDouble(empresaTurismoActivo.getGmlat()),
							Double.parseDouble(empresaTurismoActivo.getGmlong()), latUser, longUser);
					empresaTurismoActivo.setDistancia(String.valueOf(distancia));
				}

				empresaTurismoActivoList.add(empresaTurismoActivo);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEmpresaTurismoActivo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getParkings: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getEmpresaTurismoActivo: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getEmpresaTurismoActivo: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(empresaTurismoActivoList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(empresaTurismoActivoList, new S12RecursosDefaultComparator());
		}

		S12EmpresaTurismoActivo[] empresaTurismoActivoArray = new S12EmpresaTurismoActivo[empresaTurismoActivoList
				.size()];
		empresaTurismoActivoList.toArray(empresaTurismoActivoArray);
		return empresaTurismoActivoArray;
	}

	/**
	 * Obtiene la lista de Zonas de Tiendas que cumplen los criterios.
	 * 
	 * @param idioma idioma
	 * @param latUser the lat user
	 * @param longUser the long user
	 * @param arrRecursos the arr recursos
	 * 
	 * @return lista de Zonas de Tiendas
	 * 
	 * @throws S12PortalMovilDaoException Exception del DAO del Portal M�vil
	 */
	public S12Tiendas[] getTiendas(ArrayList<String> arrRecursos, String idioma, double latUser, double longUser)
			throws S12PortalMovilDaoException {
		Connection conn = null;
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		ArrayList<S12Tiendas> tiendasList = new ArrayList<S12Tiendas>();
		S12Tiendas tiendas;
		StringBuffer sql;
		ArrayList<String> arrServicios;

		try {
			conn = S12ConnectionManager.getConnection();

			sql = new StringBuffer(S12PortalMovilDAO.SIZE_STRINGBUFFER);
			sql.append("SELECT TIENDAS.COREC, TIENDAS.COIDIOMA, DATOS_GENERALES.NOMBRE, S12.DESC_FOTO_PRINCIPAL_RECURSO(TIENDAS.COREC, TIENDAS.COIDIOMA) AS DEPIEFOTO, ");
			sql.append("S12.FOTO_PRINCIPAL_RECURSO(TIENDAS.COREC, TIENDAS.COIDIOMA) AS NOFOTO, DATOS_GENERALES.CODIGOPOSTAL, DATOS_GENERALES.DIRECCION, DATOS_GENERALES.URL, ");
			sql.append("DATOS_GENERALES.TELEFONO1, DATOS_GENERALES.DESCTELEFONO1, DATOS_GENERALES.TELEFONO2, DATOS_GENERALES.DESCTELEFONO2, ");
			sql.append("MULTI1.ARCHIVOMULT AS MULTIMEDIA, MULTI1.DEMULT AS DESCMULTIMEDIA, ");
			sql.append("MULTI2.ARCHIVOMULT AS MULTIMEDIAA, MULTI2.DEMULT AS DESCMULTIMEDIAA, ");
			sql.append("S12.GEO_MUNICIPALITY(TIENDAS.COREC) AS MUNICIPIO, ");
			sql.append("S12.GEO_MUNICIPALITYCODE(TIENDAS.COREC) AS CODMUNICIPIO, ");
			sql.append("S12.GEO_PROVINCIA(TIENDAS.COREC) AS NOPROV, ");
			sql.append("DATOS_GENERALES.CODSUBTIPO, GEOREFERENCIACION.GMLNG, GEOREFERENCIACION.GMLAT,  ");
			sql.append("POSICIONAMIENTO.URLAMIGABLE, PM_RECURSOS_TOWN.URLTOWNAMIGABLE, ");
			sql.append("TSERVQC.COSERVICIO AS Q_CALIDAD, ACC.INDOPTASELLO AS ACCESIBILIDAD, ");
			sql.append("TSERVQO.COSERVICIO AS Q_ORO, TSERVQP.COSERVICIO AS Q_PLATA, ");
			sql.append("TSERVISO.COSERVICIO as ISO, ");
			sql.append("TSERVBP.COSERVICIO as BUENAS_PRACTICAS, ");
			sql.append("TSERVECOL.COSERVICIO as ECOLABEL, ");
			sql.append("TSERVPRODUCTO.COSERVICIO as CLUBPRODUCTO, ");
			sql.append("ACCES.INDVISUAL, ACCES.INDOPTASELLO, ACCES.INDAUDITIVA, ");
			sql.append("ACCES.INDINTELECTUAL, ACCES.INDORGANICA, ACCES.INDFISICA, ");
			sql.append("TIENDAS.ESPECIALIDAD ESPECIALIDAD, ");
			sql.append("TSERVINNOVA.COSERVICIO as INNOVACION ");
			sql.append("FROM TIENDAS LEFT OUTER JOIN GEOREFERENCIACION ON TIENDAS.COREC = GEOREFERENCIACION.COREC ");
			sql.append("INNER JOIN POSICIONAMIENTO ON TIENDAS.COREC = POSICIONAMIENTO.COREC AND TIENDAS.COIDIOMA = POSICIONAMIENTO.COIDIOMA ");
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACCES ON TIENDAS.COREC = ACCES.COREC ");
			sql.append("INNER JOIN DATOS_GENERALES ON TIENDAS.COREC = DATOS_GENERALES.COREC AND TIENDAS.COIDIOMA = DATOS_GENERALES.COIDIOMA ");
			sql.append("LEFT OUTER JOIN PM_RECURSOS_TOWN ON TIENDAS.COREC = PM_RECURSOS_TOWN.COREC AND TIENDAS.COIDIOMA = PM_RECURSOS_TOWN.COIDIOMA ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI1 ON TIENDAS.COREC = MULTI1.COREC AND TIENDAS.COIDIOMA = MULTI1.COIDIOMA AND MULTI1.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_1).append(" ");
			sql.append(
					"LEFT JOIN MULTIMEDIA MULTI2 ON TIENDAS.COREC = MULTI2.COREC  AND TIENDAS.COIDIOMA = MULTI2.COIDIOMA AND MULTI2.TIPOIMAGEN = ")
					.append(S12Constantes.TIPO_IMAGEN_MINIATURA_LISTADO_2).append(" ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// Q de calidad
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_CALIDAD).append(" AND COIDIOMA = ?")
					.append(") TSERVQC ON TIENDAS.COREC = TSERVQC.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// Q Oro
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_ORO).append(" AND COIDIOMA = ?")
					.append(") TSERVQO ON TIENDAS.COREC = TSERVQO.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// Q Plata
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_Q_PLATA).append(" AND COIDIOMA = ?")
					.append(") TSERVQP ON TIENDAS.COREC = TSERVQP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// ISO
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ISO).append(" AND COIDIOMA = ?")
					.append(") TSERVISO ON TIENDAS.COREC = TSERVISO.COREC ");
			sql.append("LEFT OUTER JOIN ACCESIBILIDAD ACC ON TIENDAS.COREC = ACC.COREC AND ACC.INDOPTASELLO = ").append(S12Constantes.OPTA_SELLO);
			// buenas pr�cticas
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_BUENAS_PRACTICAS).append(" AND COIDIOMA = ?")
					.append(") TSERVBP ON TIENDAS.COREC = TSERVBP.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// ECOLABEL
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_ECOLABEL).append(" AND COIDIOMA = ?")
					.append(") TSERVECOL ON TIENDAS.COREC = TSERVECOL.COREC ");
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			// club producto
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_CLUBPRODUCTO).append(" AND COIDIOMA = ?")
					.append(") TSERVPRODUCTO ON TIENDAS.COREC = TSERVPRODUCTO.COREC ");
			// Certif. Innovacion
			sql.append("LEFT OUTER JOIN (SELECT TIENDAS.COREC, COSERVICIO FROM TIENDAS, REC_SRV WHERE REC_SRV.COREC = TIENDAS.COREC ");
			sql.append("AND COSERVICIO = ").append(S12Constantes.SRV_INNOVACION).append(" AND COIDIOMA = ?")
					.append(") TSERVINNOVA ON TIENDAS.COREC = TSERVINNOVA.COREC ");

			sql.append("WHERE 1 = 1 ");
			// Idioma
			sql.append("AND TIENDAS.COIDIOMA = ? ");
			sql.append("AND TIENDAS.COREC IN (");
			//PARAMETRIZANDO CORECs EN PREPAREDSTATEMENT
			sql.append(prepareElementosIN(arrRecursos.size()));
			sql.append(")");

			prepStmt = conn.prepareStatement(sql.toString());
			int index = 1;
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			prepStmt.setString(index++, idioma);	
			index = prepareCodigosRecursoIN(arrRecursos, prepStmt, index);
			rs = prepStmt.executeQuery();

			while (rs.next()) {

				tiendas = new S12Tiendas();
				arrServicios = new ArrayList<String>();

				tiendas.setCodigoRecurso(rs.getInt("COREC"));
				tiendas.setIdioma(rs.getString("COIDIOMA"));
				tiendas.setNombre(rs.getString("NOMBRE"));

				// Si no existe foto de miniatura (multimedia), usamos la foto principal
				String foto = rs.getString("NOFOTO");
				String pieFoto = rs.getString("DEPIEFOTO");
				String multimedia = rs.getString("MULTIMEDIA");
				String descMultimedia = rs.getString("DESCMULTIMEDIA");
				if (multimedia != null && !"".equals(multimedia)) {
					tiendas.setFotoPrincipal(multimedia);
					tiendas.setDescFoto(descMultimedia);
				} else {
					tiendas.setFotoPrincipal(foto);
					tiendas.setDescFoto(pieFoto);
				}
				// Se incorpora imagen de miniaturaA necesaria para buscador de Txikiteo
				String multimediaA = rs.getString("MULTIMEDIAA");
				String descMultimediaA = rs.getString("DESCMULTIMEDIAA");
				tiendas.setFotoA(multimediaA);
				tiendas.setDescFotoA(descMultimediaA);

				tiendas.setUrlAmigable(rs.getString("URLAMIGABLE"));
				tiendas.setUrlTownAmigable(rs.getString("URLTOWNAMIGABLE"));

				tiendas.setGmlong(rs.getString("GMLNG"));
				tiendas.setGmlat(rs.getString("GMLAT"));

				tiendas.setMunicipio(rs.getString("MUNICIPIO"));
				tiendas.setMunicipioCode(rs.getString("CODMUNICIPIO"));
				tiendas.setProvincia(rs.getString("NOPROV"));

				tiendas.setCodigoPostal(rs.getString("CODIGOPOSTAL"));
				tiendas.setDireccion(rs.getString("DIRECCION"));
				tiendas.setTelefono(rs.getString("TELEFONO1"));
				tiendas.setDescTelefono(rs.getString("DESCTELEFONO1"));
				tiendas.setTelefono2(rs.getString("TELEFONO2"));
				tiendas.setDescTelefono2(rs.getString("DESCTELEFONO2"));
				tiendas.setWeb(rs.getString("URL"));
				tiendas.setEspecialidad(rs.getString("ESPECIALIDAD"));
				tiendas.setCodigoTipo(rs.getString("CODSUBTIPO"));

				// indicadores de accesibilidad
				tiendas.setIndauditiva(rs.getString("INDAUDITIVA"));
				tiendas.setIndfisica(rs.getString("INDFISICA"));
				tiendas.setIndintelectual(rs.getString("INDINTELECTUAL"));
				tiendas.setIndoptasello(rs.getString("INDOPTASELLO"));
				tiendas.setIndorganica(rs.getString("INDORGANICA"));
				tiendas.setIndvisual(rs.getString("INDVISUAL"));

				// OJO: LA POSICION EN EL ARRAY DE SERVICIOS IDENTIFICA CADA SERVICIO.
				if (rs.getString("Q_CALIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("BUENAS_PRACTICAS") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ACCESIBILIDAD") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("CLUBPRODUCTO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_ORO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("Q_PLATA") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ISO") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("ECOLABEL") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}
				if (rs.getString("INNOVACION") != null) {
					arrServicios.add("1");
				} else {
					arrServicios.add("0");
				}

				tiendas.setArrServicios(arrServicios);

				// llamada a la funci�n de c�lculo de distancia, si el usuario nos ha especificado su Latitud y Longitud
				if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR
						&& tiendas.getGmlong() != null && tiendas.getGmlat() != null) {
					double distancia = S12Utils.getDistanciaGeodesica(Double.parseDouble(tiendas.getGmlat()),
							Double.parseDouble(tiendas.getGmlong()), latUser, longUser);
					tiendas.setDistancia(String.valueOf(distancia));
				}

				tiendasList.add(tiendas);
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getTiendas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getTiendas: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12PortalMovilDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12PortalMovilDAO::getTiendas: Exception: " + e.getMessage());
			}
			throw new S12PortalMovilDaoException("S12PortalMovilDAO::getTiendas: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(prepStmt);
			S12ConnectionManager.close(conn);
		}

		// ordenar array por distancia
		if (latUser != S12Constantes.LATITUD_SIN_VALOR && longUser != S12Constantes.LONGITUD_SIN_VALOR) {
			Collections.sort(tiendasList, new S12RecursosComparator());
		} else { // Alfab�tica
			Collections.sort(tiendasList, new S12RecursosDefaultComparator());
		}

		S12Tiendas[] zonasTiendasArray = new S12Tiendas[tiendasList.size()];
		tiendasList.toArray(zonasTiendasArray);
		return zonasTiendasArray;
	}

	/**
	 * Construye un String para parametrizar en SQL una clausaula IN de N elementos
	 * @param size Numero de elementos
	 * @return String con parametros ? separados por comas
	 */
	private String prepareElementosIN(int size) {
		StringBuffer sql = new StringBuffer();
		for (int i = 0; i < size; i++) {
			if (i < (size - 1)) {
				sql .append("?").append(", ");
			} else {
				sql.append("?");
			}
		}
		return sql.toString();
	}

	/**
	 * Establece los valores a pasar al PreparedStatement construidos a partir de un array de cdigos de Recurso
	 * @param arrRecursos Codigos de recurso en tipo String
	 * @param prepStmt PreparedStatement receptor
	 * @param index Posicion a partir de la cual se deben aadir los valores
	 * @return Posicion del siguiente valor de indice para valores sucesivos en el PreparedStatement 
	 * @throws NumberFormatException
	 * @throws SQLException
	 */
	private int prepareCodigosRecursoIN(ArrayList<String> arrRecursos, PreparedStatement prepStmt, int index) throws NumberFormatException, SQLException {
		int indice = index;
		for (int i = 0; i < arrRecursos.size(); i++) {
			prepStmt.setLong(indice++, Long.parseLong(arrRecursos.get(i)));
		}
		return indice;
	}
	
}
