package s12.mapas.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 * Clase S12RecursoGastronomika.
 *
 * Representa uno de los recursos usados en el visor de Google Maps de Euskadi Gastronomika
 *
 *  
 */
public class S12RecursoGastronomika implements JSONString {

	/**	Cdigo asociado al recurso */
	private String codigoRecurso;

	/** Cdigo del tipo de recurso */
	private String tipoRecurso;

	/** Nombre del recurso */
	private String nombreRecurso;

	/** Cdigo del tipo de recurso dentro de Euskadi Gastronomika */
	private String tipoRecursoGastronomika;

	/** Valor de la coordenada geogrfica correspondiente a la longitud donde se encuentra el recurso */
	private String longitud;

	/** Valor de la coordenada geogrfica correspondiente a la latitud donde se encuentra el recurso */
	private String latitud;

	/** Tipologa del recurso */
	private String tipologia;

	/** Idioma del recurso */
	private String idioma;

	/**
	 * Constructor.
	 */
	public S12RecursoGastronomika() {
	}

	/**
	 * Retorna el valor del campo codigoRecurso.
	 *
	 * @return Cdigo del recurso
	 */
	public String getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el valor del campo codigoRecurso.
	 *
	 * @param codigoRecurso Cdigo del recurso
	 */
	public void setCodigoRecurso(String codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * Retorna el valor del campo tipoRecurso.
	 *
	 * @return Tipo de recurso
	 */
	public String getTipoRecurso() {
		return this.tipoRecurso;
	}

	/**
	 * Establece el valor del campo tipoRecurso.
	 *
	 * @param tipoRecurso Tipo de recurso
	 */
	public void setTipoRecurso(String tipoRecurso) {
		this.tipoRecurso = tipoRecurso;
	}

	/**
	 * Retorna el valor del campo nombreRecurso.
	 *
	 * @return Nombre del recurso
	 */
	public String getNombreRecurso() {
		return this.nombreRecurso;
	}

	/**
	 * Establece el valor del campo nombreRecurso.
	 *
	 * @param nombreRecurso Nombre del recurso
	 */
	public void setNombreRecurso(String nombreRecurso) {
		this.nombreRecurso = nombreRecurso;
	}

	/**
	 * Retorna el valor del campo tipoRecursoGastronomika
	 * 
	 * @return Tipo de recurso dentro de Euskadi Gastronomika
	 */
	public String getTipoRecursoGastronomika() {
		return this.tipoRecursoGastronomika;
	}

	/**
	 * Establece el valor del campo tipoRecursoGastronomika
	 * 
	 * @param tipoRecursoGastronomika Tipo de recurso dentro de Euskadi Gastronomika
	 */
	public void setTipoRecursoGastronomika(String tipoRecursoGastronomika) {
		this.tipoRecursoGastronomika = tipoRecursoGastronomika;
	}

	/**
	 * Retorna el valor del campo longitud.
	 *
	 * @return Longitud del recurso
	 */
	public String getLongitud() {
		return this.longitud;
	}

	/**
	 * Establece el valor del campo longitud.
	 *
	 * @param longitud Longitud del recurso
	 */
	public void setLongitud(String longitud) {
		this.longitud = longitud;
	}

	/**
	 * Retorna el valor del campo latitud.
	 *
	 * @return Latitud del recurso
	 */
	public String getLatitud() {
		return this.latitud;
	}

	/**
	 * Establece el valor del campo latitud.
	 *
	 * @param latitud Latitud del recurso
	 */
	public void setLatitud(String latitud) {
		this.latitud = latitud;
	}

	/**
	 * Retorna el valor del campo tipologia.
	 *
	 * @return tipologia Tipologa del recurso
	 */
	public String getTipologia() {
		return this.tipologia;
	}

	/**
	 * Establece el valor del campo tipologia.
	 *
	 * @param tipologia Tipologa del recurso
	 */
	public void setTipologia(String tipologia) {
		this.tipologia = tipologia;
	}

	/**
	 * @return Retorna el valor del campo idioma.
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * @param idioma Establece el valor del campo idioma.
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("r", this.codigoRecurso);
			jObject.put("t", this.tipoRecursoGastronomika);
			jObject.put("m", S12Utils.encodeHtmlTag(this.nombreRecurso));
			jObject.put("y", this.latitud);
			jObject.put("x", this.longitud);
			jObject.put("tp", this.tipoRecurso);
			jObject.put("ty", this.tipologia);
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Equals.
	 *
	 * @param o the o
	 *
	 * @return true, if equals
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof S12RecursoGastronomika)) {
			return false;
		}
		S12RecursoGastronomika other = (S12RecursoGastronomika) o;
		return other.getCodigoRecurso().equals(this.codigoRecurso);
	}


}
