package s12.mapas.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 * Clase S12Recurso.
 *
 * Representa uno de los municipios usados en el visor de Google Maps del Portal
 *
 *  
 */
public class S12Municipio implements JSONString {

	/**	Cdigo asociado al recurso */
	private String codigoRecurso;

	/** Nombre del municipio */
	private String nombreMunicipio;

	/** Valor de la coordenada geogrfica correspondiente a la longitud donde se encuentra el recurso */
	private String longitud;

	/** Valor de la coordenada geogrfica correspondiente a la latitud donde se encuentra el recurso */
	private String latitud;

	/**
	 * Constructor.
	 */
	public S12Municipio() {
	}

	/**
	 * Retorna el valor del campo codigoRecurso.
	 *
	 * @return Cdigo del recurso
	 */
	public String getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el valor del campo codigoRecurso.
	 *
	 * @param codigoRecurso Cdigo del recurso
	 */
	public void setCodigoRecurso(String codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * Retorna el valor del campo nombreMunicipio.
	 *
	 * @return Nombre del recurso
	 */
	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Establece el valor del campo nombreRecurso.
	 *
	 * @param nombreMunicipio Nombre del recurso
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * Retorna el valor del campo longitud.
	 *
	 * @return Longitud del recurso
	 */
	public String getLongitud() {
		return this.longitud;
	}

	/**
	 * Establece el valor del campo longitud.
	 *
	 * @param longitud Longitud del recurso
	 */
	public void setLongitud(String longitud) {
		this.longitud = longitud;
	}

	/**
	 * Retorna el valor del campo latitud.
	 *
	 * @return Latitud del recurso
	 */
	public String getLatitud() {
		return this.latitud;
	}

	/**
	 * Establece el valor del campo latitud.
	 *
	 * @param latitud Latitud del recurso
	 */
	public void setLatitud(String latitud) {
		this.latitud = latitud;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("r", this.codigoRecurso);
			jObject.put("t", "D2");
			jObject.put("m", S12Utils.encodeHtmlTag(this.nombreMunicipio));
			jObject.put("y", this.latitud);
			jObject.put("x", this.longitud);
		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	/**
	 * Implementacin de la serializacin XML del objeto
	 *
	 * @return Serializacin XML del objeto
	 *
	 */
	public String toXMLString() {
		StringBuffer xml = new StringBuffer();

		xml.append("<Placemark>");
		xml.append("<name codrec=\"\" tipo=\"\" categoria=\"\"><![CDATA[ ");
		xml.append(this.nombreMunicipio);
		xml.append(" ]]></name>");
		xml.append("<description><![CDATA[ ]]></description>");
		xml.append("<link>");
		xml.append("</link>");
		xml.append("<Point>");
		xml.append("<coordinates>");
		xml.append(this.longitud);
		xml.append(",");
		xml.append(this.latitud);
		xml.append("</coordinates>");
		xml.append("</Point>");
		xml.append("</Placemark>");

		return xml.toString();
	}
	
	/**
	 * Implementacin de la serializacin GeoJSON del objeto
	 *
	 * @return Serializacin GeoJSON del objeto
	 *
	 */
	public String toGeoJSONString() {
		StringBuffer geojson = new StringBuffer();
		geojson.append("\"type\": \"Feature\",");
		geojson.append("\"geometry\": {");
		//Point
		geojson.append("\"type\": \"Point\",");
		geojson.append("\"coordinates\": [");
		geojson.append(this.longitud);
		geojson.append(", ");
		geojson.append(this.latitud);
		geojson.append("]}");
		//properties
		geojson.append(",\"properties\": {");
		geojson.append("\"r\": ");
		geojson.append(this.codigoRecurso);
		geojson.append(",\"t\": \"D2\"");
		geojson.append(",\"m\": \"");
		geojson.append(S12Utils.encodeHtmlTag(this.nombreMunicipio));
		geojson.append("\"");
		geojson.append("}");
			
		return geojson.toString();
	}
	
}
