package s12.layar.valueObjects;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

/**
 *
 *  
 *
 */
public class S12LayarRaiz implements JSONString {

	private String layer;	//obligatorio
	private S12LayarHotspot[] hotspots; //obligatorio
	private Integer errorCode;	//obligatorio
	private String errorString;	//obligatorio
	private String nextPageKey;	//opcional
	private boolean morePages;	//opcional
//	private S12LayarAction[] actions; 	//opcional ELIMINADO COMO POSIBLE CAUSA DE BUG CUANDO VA VACIO.
	private String showMessage;	//opcional
	//showDialog?
	private String biwStyle;	//opcional

	/**
	 * Devuelve el string en formato JSON
	 * @return string en formato JSON
	 */
	public String toJSONString() {
		JSONObject jObject = this.getJSONObject();
		return jObject.toString();
	}

	/**
	 * Devuelve el objeto para la serializacion a JSON
	 * @return JSONObject
	 */
	public JSONObject getJSONObject() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("layer", this.layer);
			jObject.put("hotspots", new JSONArray(this.hotspots));
			jObject.put("errorCode", this.errorCode);
			jObject.put("errorString", this.errorString);
			jObject.put("nextPageKey", this.nextPageKey);
			jObject.put("morePages", this.morePages);
//			if (this.actions!=null){
//				jObject.put("actions", new JSONArray(this.actions));
//			} else {
//				jObject.put("actions", JSONObject.NULL);
//			}
			jObject.put("showMessage", this.showMessage);
			jObject.put("biwStyle", this.biwStyle);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return jObject;
	}

	/**
	 * @return the layer
	 */
	public String getLayer() {
		return this.layer;
	}

	/**
	 * @param layer the layer to set
	 */
	public void setLayer(String layer) {
		this.layer = layer;
	}

	/**
	 * @return the hotspots
	 */
	public S12LayarHotspot[] getHotspots() {
		return this.hotspots;
	}

	/**
	 * @param hotspots the hotspots to set
	 */
	public void setHotspots(S12LayarHotspot[] hotspots) {
		this.hotspots = hotspots;
	}

	/**
	 * @return the errorCode
	 */
	public Integer getErrorCode() {
		return this.errorCode;
	}

	/**
	 * @param errorCode the errorCode to set
	 */
	public void setErrorCode(Integer errorCode) {
		this.errorCode = errorCode;
	}

	/**
	 * @return the errorString
	 */
	public String getErrorString() {
		return this.errorString;
	}

	/**
	 * @param errorString the errorString to set
	 */
	public void setErrorString(String errorString) {
		this.errorString = errorString;
	}

	/**
	 * @return the nextPageKey
	 */
	public String getNextPageKey() {
		return this.nextPageKey;
	}

	/**
	 * @param nextPageKey the nextPageKey to set
	 */
	public void setNextPageKey(String nextPageKey) {
		this.nextPageKey = nextPageKey;
	}

	/**
	 * @return the morePages
	 */
	public boolean isMorePages() {
		return this.morePages;
	}

	/**
	 * @param morePages the morePages to set
	 */
	public void setMorePages(boolean morePages) {
		this.morePages = morePages;
	}

//	/**
//	 * @return the actions
//	 */
//	public S12LayarAction[] getActions() {
//		return this.actions;
//	}
//
//	/**
//	 * @param actions the actions to set
//	 */
//	public void setActions(S12LayarAction[] actions) {
//		this.actions = actions;
//	}

	/**
	 * @return the showMessage
	 */
	public String getShowMessage() {
		return this.showMessage;
	}

	/**
	 * @param showMessage the showMessage to set
	 */
	public void setShowMessage(String showMessage) {
		this.showMessage = showMessage;
	}

	/**
	 * @return the biwStyle
	 */
	public String getBiwStyle() {
		return this.biwStyle;
	}

	/**
	 * @param biwStyle the biwStyle to set
	 */
	public void setBiwStyle(String biwStyle) {
		this.biwStyle = biwStyle;
	}

}
