package s12.layar.valueObjects;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

/**
 *
 *  
 *
 */
public class S12LayarHotspot implements JSONString {

	//atributos privados
	private String id; 			//obligatorio
	private S12LayarGeolocation geolocation; 	//obligatorio, ir en "anchor"
	private String textTitle; 			//obligatorio
	private String textDescription; 			//opcional
	private String textFootnote; 			//opcional
	private S12LayarAction[] actions; 	//opcional
	private String imageURL; 		//opcional
	private boolean showSmallBiw;	//opcional
	private boolean showBiwOnClick; //opcional
	private String iconURL; 		//opcional: url o type
	private Integer iconType; 		//opcional: url o type
	//private boolean inFocus; 		//opcional

	/**
	 * Devuelve el string en formato JSON
	 * @return string en formato JSON
	 */
	public String toJSONString() {
		JSONObject jObject = this.getJSONObject();
		return jObject.toString();
	}

	/**
	 * Devuelve el objeto para la serializacion a JSON
	 * @return JSONObject
	 */
	public JSONObject getJSONObject() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("id", this.id);
			jObject.put("anchor", this.geolocation.getJSONObject());
			JSONObject text = new JSONObject();
			text.put("title", this.textTitle);
			text.put("description", this.textDescription);
			text.put("footnote", this.textFootnote);
			jObject.put("text", text);
//			JSONArray actionsArray = new JSONArray();
//			for (int i=0; i<this.actions.length; i++){
//				actionsArray.put(this.actions[i].getJSONObject());
//			}
			if (this.actions!=null){
				jObject.put("actions", new JSONArray(this.actions));
			} else {
				jObject.put("actions", JSONObject.NULL);
			}
			jObject.put("imageURL", this.imageURL);
			jObject.put("showSmallBiw", this.showSmallBiw);
			jObject.put("showBiwOnClick", this.showBiwOnClick);
			JSONObject icon = new JSONObject();
			icon.put("url", this.iconURL);
			icon.put("type", this.iconType);
			jObject.put("icon", icon);

		} catch (JSONException e) {
			e.printStackTrace();
		}
		return jObject;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the geolocation
	 */
	public S12LayarGeolocation getGeolocation() {
		return this.geolocation;
	}

	/**
	 * @param geolocation the geolocation to set
	 */
	public void setGeolocation(S12LayarGeolocation geolocation) {
		this.geolocation = geolocation;
	}


	/**
	 * @return the textTitle
	 */
	public String getTextTitle() {
		return this.textTitle;
	}

	/**
	 * @param textTitle the textTitle to set
	 */
	public void setTextTitle(String textTitle) {
		this.textTitle = textTitle;
	}

	/**
	 * @return the textDescription
	 */
	public String getTextDescription() {
		return this.textDescription;
	}

	/**
	 * @param textDescription the textDescription to set
	 */
	public void setTextDescription(String textDescription) {
		this.textDescription = textDescription;
	}

	/**
	 * @return the textFootnote
	 */
	public String getTextFootnote() {
		return this.textFootnote;
	}

	/**
	 * @param textFootnote the textFootnote to set
	 */
	public void setTextFootnote(String textFootnote) {
		this.textFootnote = textFootnote;
	}

	/**
	 * @return the actions
	 */
	public S12LayarAction[] getActions() {
		return this.actions;
	}

	/**
	 * @param actions the actions to set
	 */
	public void setActions(S12LayarAction[] actions) {
		this.actions = actions;
	}

	/**
	 * @return the imageURL
	 */
	public String getImageURL() {
		return this.imageURL;
	}

	/**
	 * @param imageURL the imageURL to set
	 */
	public void setImageURL(String imageURL) {
		this.imageURL = imageURL;
	}

	/**
	 * @return the showSmallBiw
	 */
	public boolean isShowSmallBiw() {
		return this.showSmallBiw;
	}

	/**
	 * @param showSmallBiw the showSmallBiw to set
	 */
	public void setShowSmallBiw(boolean showSmallBiw) {
		this.showSmallBiw = showSmallBiw;
	}

	/**
	 * @return the showBiwOnClick
	 */
	public boolean isShowBiwOnClick() {
		return this.showBiwOnClick;
	}

	/**
	 * @param showBiwOnClick the showBiwOnClick to set
	 */
	public void setShowBiwOnClick(boolean showBiwOnClick) {
		this.showBiwOnClick = showBiwOnClick;
	}

	/**
	 * @return the iconURL
	 */
	public String getIconURL() {
		return this.iconURL;
	}

	/**
	 * @param iconURL the iconURL to set
	 */
	public void setIconURL(String iconURL) {
		this.iconURL = iconURL;
	}

	/**
	 * @return the iconType
	 */
	public Integer getIconType() {
		return this.iconType;
	}

	/**
	 * @param iconType the iconType to set
	 */
	public void setIconType(Integer iconType) {
		this.iconType = iconType;
	}



}

