package s12.layar.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

/**
 *
 *  
 *
 */
public class S12LayarGeolocation implements JSONString {

	private double lat; 			//obligatorio
	private double lon; 			//obligatorio
	private double alt; 			//opcional

	/**
	 * Devuelve el string en formato JSON
	 * @return string en formato JSON
	 */
	public String toJSONString() {
		JSONObject jObject = this.getJSONObject();
		return jObject.toString();
	}

	/**
	 * Devuelve el objeto para la serializacion a JSON
	 * @return JSONObject
	 */
	public JSONObject getJSONObject() {
		JSONObject jObject = new JSONObject();
		try {
			JSONObject geoloc = new JSONObject();
			geoloc.put("lat", this.lat);
			geoloc.put("lon", this.lon);
			geoloc.put("alt", this.alt);
			jObject.put("geolocation", geoloc);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return jObject;
	}


	/**
	 * @return the lat
	 */
	public double getLat() {
		return this.lat;
	}
	/**
	 * @param lat the lat to set
	 */
	public void setLat(double lat) {
		this.lat = lat;
	}
	/**
	 * @return the lon
	 */
	public double getLon() {
		return this.lon;
	}
	/**
	 * @param lon the lon to set
	 */
	public void setLon(double lon) {
		this.lon = lon;
	}
	/**
	 * @return the alt
	 */
	public double getAlt() {
		return this.alt;
	}
	/**
	 * @param alt the alt to set
	 */
	public void setAlt(double alt) {
		this.alt = alt;
	}

}
