package s12.layar.valueObjects;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

/**
 *
 *  
 *
 */
public class S12LayarAction implements JSONString {

	public static int TIPO_ACCION_INFORMACION = 1;
	public static int TIPO_ACCION_TELEFONO = 2;
	public static int TIPO_ACCION_IMAGENES = 3;
	public static int TIPO_ACCION_EMAIL = 4;
	public static int TIPO_ACCION_PORTALTUR = 5;
	public static int TIPO_ACCION_WEB = 6;

	//atributos privados
	private String uri; 			//obligatorio
	private String label; 			//obligatorio geolayers.
	private String contentType; 	//obligatorio. The type of document that is being fetched.
	private String method = "GET"; 	//opcional
	private String[] params; 		//opcional. Comma-separated list of parameters to be added to the request. Valores posibles: "lat", "lon", "alt", "lang", "countrycode", "localCountryCode", "version"
	private Integer activityType; 	//opcional. identificador del icono cuando se muestra la accion en forma de botn
	private boolean showActivity;	//opcional. Indicates whether to show the background activity.
	private String activityMessage;	//opcional. This is shown to the user while waiting for the response, instead of the spinning wheel
	private boolean closeBiw;		//opcional. If true, the layar client will close the BIW after the user clicked the button of the action.
	private Integer autoTriggerRange;	//opcional. Only for Geo POIs, indicates whether or not this action can be autotriggered by reaching the POI.
	private boolean autoTrigger;		//opcional. Only for Vision POIs, indicates whether or not this action can be autotriggered by reaching the POI.
	private boolean autoTriggerOnly;	//opcional. Indicates whether or not this action can be invoked manually.
	private Integer tipoAccion; 	//de uso propio, para diferenciar actions de tipo info.

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = this.getJSONObject();
		return jObject.toString();
	}

	/**
	 * Devuelve un objeto para la serializacion a JSON
	 * @return JSONObject
	 */
	public JSONObject getJSONObject() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("uri", this.uri);
			jObject.put("label", this.label);
			jObject.put("contentType", this.contentType);
			jObject.put("method", this.method);
			JSONArray jArray = new JSONArray(this.params);
			jObject.put("params", jArray);
			jObject.put("activityType", this.activityType);
			jObject.put("showActivity", this.showActivity);
			jObject.put("closeBiw", this.closeBiw);
			jObject.put("autoTriggerRange", this.autoTriggerRange);
			jObject.put("autoTrigger", this.autoTrigger);
			jObject.put("autoTriggerOnly", this.autoTriggerOnly);
			jObject.put("tipoAccion", this.tipoAccion);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return jObject;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return this.uri;
	}

	/**
	 * @param uri the uri to set
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return the label
	 */
	public String getLabel() {
		return this.label;
	}

	/**
	 * @param label the label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return the contentType
	 */
	public String getContentType() {
		return this.contentType;
	}

	/**
	 * @param contentType the contentType to set
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * @return the method
	 */
	public String getMethod() {
		return this.method;
	}

	/**
	 * @param method the method to set
	 */
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * @return the params
	 */
	public String[] getParams() {
		return this.params;
	}

	/**
	 * @param params the params to set
	 */
	public void setParams(String[] params) {
		this.params = params;
	}

	/**
	 * @return the activityType
	 */
	public Integer getActivityType() {
		return this.activityType;
	}

	/**
	 * @param activityType the activityType to set
	 */
	public void setActivityType(Integer activityType) {
		this.activityType = activityType;
	}

	/**
	 * @return the showActivity
	 */
	public boolean isShowActivity() {
		return this.showActivity;
	}

	/**
	 * @param showActivity the showActivity to set
	 */
	public void setShowActivity(boolean showActivity) {
		this.showActivity = showActivity;
	}

	/**
	 * @return the activityMessage
	 */
	public String getActivityMessage() {
		return this.activityMessage;
	}

	/**
	 * @param activityMessage the activityMessage to set
	 */
	public void setActivityMessage(String activityMessage) {
		this.activityMessage = activityMessage;
	}

	/**
	 * @return the closeBiw
	 */
	public boolean isCloseBiw() {
		return this.closeBiw;
	}

	/**
	 * @param closeBiw the closeBiw to set
	 */
	public void setCloseBiw(boolean closeBiw) {
		this.closeBiw = closeBiw;
	}

	/**
	 * @return the autoTriggerRange
	 */
	public Integer getAutoTriggerRange() {
		return this.autoTriggerRange;
	}

	/**
	 * @param autoTriggerRange the autoTriggerRange to set
	 */
	public void setAutoTriggerRange(Integer autoTriggerRange) {
		this.autoTriggerRange = autoTriggerRange;
	}

	/**
	 * @return the autoTrigger
	 */
	public boolean isAutoTrigger() {
		return this.autoTrigger;
	}

	/**
	 * @param autoTrigger the autoTrigger to set
	 */
	public void setAutoTrigger(boolean autoTrigger) {
		this.autoTrigger = autoTrigger;
	}

	/**
	 * @return the autoTriggerOnly
	 */
	public boolean isAutoTriggerOnly() {
		return this.autoTriggerOnly;
	}

	/**
	 * @param autoTriggerOnly the autoTriggerOnly to set
	 */
	public void setAutoTriggerOnly(boolean autoTriggerOnly) {
		this.autoTriggerOnly = autoTriggerOnly;
	}

	/**
	 * @return the tipoAccion
	 */
	public Integer getTipoAccion() {
		return this.tipoAccion;
	}

	/**
	 * @param tipoAccion the tipoAccion to set
	 */
	public void setTipoAccion(Integer tipoAccion) {
		this.tipoAccion = tipoAccion;
	}


}
