package s12.layar.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import javax.naming.NamingException;

import bilbofrmk.util.BLogger;

import s12.layar.valueObjects.S12LayarAction;
import s12.layar.valueObjects.S12LayarDatos;
import s12.layar.valueObjects.S12LayarGeolocation;
import s12.layar.valueObjects.S12LayarHotspot;
import s12.layar.valueObjects.S12LayarRaiz;
import s12.mapas.dao.S12MapasDaoException;
import s12.util.S12ConnectionManager;
import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * Acceso a datos para las clases de Layar
 *  
 *
 */
public class S12LayarDAO {

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "LAYAR";
	private static final int SIZE_STRINGBUFFER = 350;
	private static final int RESULTADOS = 50; //eran 50. //limitar nmero de resultados POIs)
	private static final int SIZE_ACTIONS = 6;
	private static final Integer ACTIVITY_INFO = new Integer(1);
	private static final Integer ACTIVITY_TELEFONO = new Integer(4);
	private static final Integer ACTIVITY_EMAIL = new Integer(5);
	private static final Integer ACTIVITY_VIEW = new Integer(27); //el icono es un ojo
	private final static String PREFIJO_URLAMIGABLE = Q70ListenerUtils.getApplicationProperty("PREFIJO_URLAMIGABLE");
	private final static String SUFIJO_URLAMIGABLE = Q70ListenerUtils.getApplicationProperty("SUFIJO_URLAMIGABLE");
	private final static String LAYER_NAME = Q70ListenerUtils.getApplicationProperty("LAYER_NAME");
	private final static String SEPARADOR = Q70ListenerUtils.getApplicationProperty("SEPARADOR");
	private final static String URL_LAYAR_INFO = Q70ListenerUtils.getApplicationProperty("URL_LAYAR_INFO");
	private final static String URL_LAYAR_IMAGENES = Q70ListenerUtils.getApplicationProperty("URL_LAYAR_IMAGENES");
	private final static String SUFIJO_NOPORTAL = "R01HNoPortal=true";
	private static final String SUFIJO_DUPLICADOS = "bis";




	/**
	 * Metodo principal de los servicios de layar, obtiene los POIs.
	 *
	 * @param latitud parametro geoloc lat
	 * @param longitud parametro geoloc lon
	 * @param distancia distancia en metros para el alcance
	 * @param codCategoria codigo de la categoria de recursos a obtener
	 * @param idioma idioma de la informacion a devolver
	 * @param resultadosMax the resultados max
	 * @return objeto preparado para devolver el JSON
	 * @throws Exception propagacion de excepciones no controladas
	 */
	public S12LayarRaiz getPOIs(String latitud, String longitud, String distancia, String codCategoria, String idioma, int resultadosMax) throws Exception {

		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<S12LayarHotspot> hotspotsList = new ArrayList<S12LayarHotspot>();
		S12LayarRaiz respuestaLayar = new S12LayarRaiz();
		String valorIdioma = idioma.toLowerCase();

		try {
			conn = S12ConnectionManager.getConnection();

			if (idioma==null || idioma.trim().length()==0){
				valorIdioma="es"; //por defecto si no trae valor el parametro
			}
			String filtroCategorias = this.trataParametroCategoria(codCategoria);

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarDAO::getPOIs: codcategoria = " + codCategoria);
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarDAO::getPOIs: filtroCategorias = " + filtroCategorias);
			}

			StringBuffer sql = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
			sql.append(" SELECT IDCATEGORY,COTIPREC,TYPO,COREC,COIDIOMA,NORECURSO,DEDESCRIPCION,NOTELEFONO,NOMAIL,NOURL, ");
			sql.append(" DEDIRECCION,NOFOTO, COTIPO,COESTADO,URLAMIGABLE,GMLNG,GMLAT,URLIMAGEN,");
			sql.append(" F_DISTANCIA_HAVERSINE(");
			sql.append(latitud);
			sql.append(", ");
			sql.append(longitud);
			sql.append(", GMLAT, GMLNG) as DISTANCIA");
			sql.append(" FROM CONSULTAMAT_RECURSOS_LAYAR");
			sql.append(" WHERE COIDIOMA='" + valorIdioma + "'");
			if (filtroCategorias!=null && filtroCategorias.trim().length()>0){
				sql.append(" AND IDCATEGORY IN (");
				sql.append(filtroCategorias);
				sql.append(")");
			}
			if (distancia!=null && distancia.trim().length()>0){
				sql.append(" AND F_DISTANCIA_HAVERSINE(");
				sql.append(latitud);
				sql.append(", ");
				sql.append(longitud);
				sql.append(", GMLAT, GMLNG) <= ");
				sql.append(distancia);
			}
			//quitamos ROWNUM porque limita resultados antes de ordenar, con lo que tipos de recursos ms cercanos se quedan fuera.
//			sql.append(" AND ROWNUM<=" + S12LayarDAO.RESULTADOS);
			sql.append(" ORDER BY DISTANCIA ASC");	//primero los ms cercanos

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql.toString());

			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.DEBUG,"S12LayarDAO::getPOIs: ejecutada query." );
			}
			int contador=1;
			if (resultadosMax<=0){
				resultadosMax = S12LayarDAO.RESULTADOS;
			}
			/**
			 * MODIFICACION PARA IDs DUPLICADOS
			 * La introduccin de la categoria REUNIONES produce el unico caso en que
			 * un mismo recurso puede tener dos categorias: un hotel = ALOJAMIENTO y REUNIONES
			 * Para eliminar duplicidad de IDs, aadimos sufijo a una.
			 * Los registros duplicados vendrn seguidos en el recordset ya que se ordena por distancia y
			 * estn en la misma ubicacin exacta (es el mismo recurso).
			 */
			String idAnterior = "";
			while (rs.next() && contador<=resultadosMax) {
				S12LayarHotspot hotspot = new S12LayarHotspot();

				//tomamos actions del hotspot
				S12LayarAction[] actions = this.transformaActions(rs);

				//informamos campos

				hotspot.setActions(actions);
				S12LayarGeolocation geoloc = new S12LayarGeolocation();
				geoloc.setLat(rs.getDouble("GMLAT"));
				geoloc.setLon(rs.getDouble("GMLNG"));
				hotspot.setGeolocation(geoloc);
				//hotspot.setIconType(new Integer(1));
				hotspot.setIconType(new Integer(rs.getInt("IDCATEGORY")));
				//hotspot.setIconURL("http://www.turismo.euskadi.net/contenidos/recurso_tecnico/x65_comun/es_x65/images/wikitude/AR_aparcamientos_64x64.png");
				String id = rs.getString("COREC");
				if (idAnterior.equalsIgnoreCase(id)){
					id = id.concat(SUFIJO_DUPLICADOS);
					BLogger.blog(BLogger.DEBUG,"S12LayarDAO::getPOIs: DUPLICADO modificado = " + id);
				}
				idAnterior = id;
				hotspot.setId(id);

				StringBuffer urlImagen = new StringBuffer(rs.getString("URLIMAGEN"));
				String nombreFoto = rs.getString("NOFOTO");

				//comprobamos la foto principal, si no tiene se le establece la primera de Multimedia
				if (nombreFoto==null || nombreFoto.equals("")){
					nombreFoto = this.obtenerImagenGaleria(rs.getString("COREC"), idioma);
					if (!nombreFoto.equals("")){
						urlImagen.append(nombreFoto);
					}else{
						urlImagen = new StringBuffer();
					}
				}
				hotspot.setImageURL(urlImagen.toString());

				hotspot.setShowBiwOnClick(true);
				hotspot.setShowSmallBiw(true);
				String descripcion = rs.getString("DEDESCRIPCION");
				if (descripcion==null){
					descripcion = "";
				}
				hotspot.setTextDescription(descripcion);
				hotspot.setTextFootnote("");
				hotspot.setTextTitle(rs.getString("NORECURSO"));

				//incluimos en los resultados
				hotspotsList.add(hotspot);
				contador++;

				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::getPOIs: Aadido hotspot " + hotspotsList.size());
			}

			//completamos los datos de la raiz de la estructura y montamos la respuesta
//			respuestaLayar.setActions(new S12LayarAction[0]); ELIMINADO COMO POSIBLE CAUSA DE BUG en Layar v.7+
			//respuestaLayar.setBiwStyle("VALOR");
			respuestaLayar.setErrorCode(new Integer(0));
			respuestaLayar.setErrorString("Ok");
			S12LayarHotspot[] arrayHotspots = new S12LayarHotspot[hotspotsList.size()];
			//haciendo toArray de un arrayList perdemos el array de actions. Por tanto, modificamos para tratar arrays de dimensin fija.
			//hotspotsList.toArray(arrayHotspots);
			for (int i=0; i< hotspotsList.size(); i++){
				arrayHotspots[i] = (S12LayarHotspot)hotspotsList.get(i);
			}
			respuestaLayar.setHotspots(arrayHotspots);
			respuestaLayar.setLayer(S12LayarDAO.LAYER_NAME);
			respuestaLayar.setMorePages(false);
			//respuestaLayar.setNextPageKey("VALOR");
			//respuestaLayar.setShowMessage("VALOR");

			BLogger.blog(BLogger.DEBUG,"S12LayarDAO::getPOIs: Finalizado getPOIs, nmero resultados = " + contador);

		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::GetPOIs: Exception: " + e.getMessage());
			}
			throw new S12MapasDaoException("S12LayarDAO::GetPOIs: Exception ", e );
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::GetPOIs: Exception: " + e.getMessage());
			}
			throw new S12MapasDaoException("S12LayarDAO::GetPOIs: Exception ", e );
		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::GetPOIs: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::GetPOIs: Exception ", e );
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return respuestaLayar;

	}

	/**
	 * Devuelve la URL a la primera imagen de galeria del recurso.
	 * Para usar cuando no hay imagen principal publicada.
	 * @param codigo codigo del recurso
	 * @param idioma idioma de consulta
	 * @return url a la primera imagen
	 * @throws Exception error
	 */
	private String obtenerImagenGaleria(String codigo, String idioma) throws Exception {
		ArrayList<String> imagenes = new ArrayList<String>();
		try {
			imagenes = this.getMultimediaLayar(codigo, idioma);
		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::obtenerImagenGaleria: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::obtenerImagenGaleria: Exception ", e );
		}
		String urlResultado = "";
		if (imagenes==null){
			return urlResultado;
		}
		while (imagenes.iterator().hasNext()) {
			String url = imagenes.iterator().next();
			if (url!=null){
				urlResultado = url;
				break;
			}
		}
		return urlResultado;
	}

	/**
	 * Trata el parametro para filtrar por categoria, preparandolo para usar en la SQL.
	 * @param codCategoria valor para el filtro
	 * @return valores separados por comas
	 */
	private String trataParametroCategoria(String codCategoria) {

		// puede venir vaco, con categoria cero=TODAS, o con varias en cadena
		if (codCategoria==null){
			return null;
		}
		String resultado = codCategoria.replaceAll(S12LayarDAO.SEPARADOR, ",");
		//si el nico valor a filtrar es "0", lo quitamos ya que es el filtro TODAS
		if (resultado.trim().equalsIgnoreCase("0")){
			return null;
		}
		return resultado;
	}

	/**
	 * Transforma las actions de la fila actual del recordset
	 * @param rs recordset en curso
	 * @return array de actions del recurso actual
	 * @throws SQLException Propagacion de excepcion en el tratamiento del recordset
	 * @throws Exception Propagacion de excepcion
	 */
	private S12LayarAction[] transformaActions(ResultSet rs) throws SQLException, Exception {

		S12LayarAction[] actionsArray = null;
		String etiquetaBoton = "";
		String idioma = "";
		try {

			//Formamos las posibles acciones a recoger:
			int indice = 0;
			String[] paramsArray={"lon","lat","alt"};

			//ArrayList acciones = new ArrayList();
			S12LayarAction layarAction = new S12LayarAction();

			//se van a definir 5 acciones por cada hotspot, pero algunas pueden no traer dato.
			int size = S12LayarDAO.SIZE_ACTIONS;
			if (rs.getString("NOTELEFONO")==null){
				size--;
			}
			if (rs.getString("NOMAIL")==null){
				size--;
			}
			if (rs.getString("DEDESCRIPCION")==null){
				size--;
			}
			if (rs.getString("NOURL")==null){
				size--;
			}
			actionsArray = new S12LayarAction[size];
			idioma = rs.getString("COIDIOMA");

			//Informacin (url)
			//si no hay descripcion del recurso no habilitamos la ficha.
			if (rs.getString("DEDESCRIPCION")!=null){
			String urlInfo = S12LayarDAO.URL_LAYAR_INFO + "?codRec=" + rs.getString("COREC") + "&lang=" + idioma + "&" + S12LayarDAO.SUFIJO_NOPORTAL;
			layarAction.setActivityMessage("");
			layarAction.setActivityType(S12LayarDAO.ACTIVITY_INFO);
			layarAction.setAutoTrigger(false);
			layarAction.setAutoTriggerOnly(false);
			layarAction.setAutoTriggerRange(null);
			layarAction.setCloseBiw(false);
			layarAction.setContentType("text/html");
			etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.info",idioma);
			layarAction.setLabel(etiquetaBoton);
			layarAction.setMethod("GET");
			layarAction.setParams(paramsArray);
			layarAction.setShowActivity(false);
			layarAction.setUri(urlInfo);
			layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_INFORMACION));
			//acciones.add(layarAction);
			actionsArray[indice++] = layarAction;
			BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());
			}
			//Telfono (tel)
			//no todos los POIs tendrn dato
			if (rs.getString("NOTELEFONO")!=null){
				layarAction = new S12LayarAction();
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_TELEFONO);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("application/vnd.layar.internal");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.telefono",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri("tel:".concat(rs.getString("NOTELEFONO")));
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_TELEFONO));
				//acciones.add(layarAction);
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());
			}

			//Ver imgenes (url)
			layarAction = new S12LayarAction();
			String urlVisorImagenes = S12LayarDAO.URL_LAYAR_IMAGENES + "?codRec=" + rs.getString("COREC") + "&lang=" + idioma + "&galeria&" + S12LayarDAO.SUFIJO_NOPORTAL;
			layarAction.setActivityMessage("");
			layarAction.setActivityType(S12LayarDAO.ACTIVITY_VIEW);
			layarAction.setAutoTrigger(false);
			layarAction.setAutoTriggerOnly(false);
			layarAction.setAutoTriggerRange(null);
			layarAction.setCloseBiw(false);
			layarAction.setContentType("text/html");
			etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.imagenes",idioma);
			layarAction.setLabel(etiquetaBoton);
			layarAction.setMethod("GET");
			layarAction.setParams(paramsArray);
			layarAction.setShowActivity(false);
			layarAction.setUri(urlVisorImagenes);
			layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_IMAGENES));
			//acciones.add(layarAction);
			actionsArray[indice++] = layarAction;
			BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());

			//e-mail (mailto)
			//no todos los POIs tendrn dato
			if (rs.getString("NOMAIL")!=null){
				layarAction = new S12LayarAction();
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_EMAIL);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("application/vnd.layar.internal");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.email",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri("mailto:" + rs.getString("NOMAIL"));
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_EMAIL));
				//acciones.add(layarAction);
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());
			}

			//Web (url) a la web del recurso
			//no todos los POIs tendrn dato
			if (rs.getString("NOURL")!=null){
				layarAction = new S12LayarAction();
				String urlWeb = rs.getString("NOURL");
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_INFO);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("text/html");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.web",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri(urlWeb);
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_WEB));
				//acciones.add(layarAction);
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());
			}

			//"Ms..." (url) a la ficha en el portal
			layarAction = new S12LayarAction();
			String urlPortalWeb = S12LayarDAO.PREFIJO_URLAMIGABLE + rs.getString("URLAMIGABLE") + S12LayarDAO.SUFIJO_URLAMIGABLE + rs.getString("COIDIOMA") + "/";
			layarAction.setActivityMessage("");
			layarAction.setActivityType(S12LayarDAO.ACTIVITY_INFO);
			layarAction.setAutoTrigger(false);
			layarAction.setAutoTriggerOnly(false);
			layarAction.setAutoTriggerRange(null);
			layarAction.setCloseBiw(false);
			layarAction.setContentType("text/html");
			etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.verMas",idioma);
			layarAction.setLabel(etiquetaBoton);
			layarAction.setMethod("GET");
			layarAction.setParams(paramsArray);
			layarAction.setShowActivity(false);
			layarAction.setUri(urlPortalWeb);
			layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_PORTALTUR));
			//acciones.add(layarAction);
			actionsArray[indice++] = layarAction;
			BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());


			//Como llegar
			//(esta no se define como accin, sino que se configura a nivel de capa en Layar.com, activando el check "Take me there")

			//Preparamos el resultado
//			actionsArray = new S12LayarAction[acciones.size()];
//			acciones.toArray( actionsArray );
		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::transformaActions: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::transformaActions: Exception ", e );
		}

		return actionsArray;
	}


	/**
	 * Gets the categorias layar.
	 *
	 * @param idioma the idioma
	 *
	 * @return the categorias layar
	 *
	 * @throws Exception the exception
	 */
	public ArrayList<String> getCategoriasLayar(String idioma) throws Exception{

		ArrayList<String> resultado = new ArrayList<String>();
//		declare variables
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);

		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = S12ConnectionManager.getConnection();

			// construct the SQL statement
			sqlBuffer.append("SELECT IDCATEGORIA, COIDIOMA, DECATEGORIA FROM CATEGORIAS_LAYAR WHERE COIDIOMA = '" + idioma + "'");

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlBuffer.toString());
			while (rs!=null && rs.next()) {
				resultado.add(rs.getString("DECATEGORIA"));
			}
		}
		catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::getCategoriasLayar: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::getCategoriasLayar: Exception ", e );
		}
		finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return resultado;
	}


	/**
	 * Gets the datos layar.
	 *
	 * @param codigo the codigo
	 * @param idioma the idioma
	 *
	 * @return the datos layar
	 *
	 * @throws Exception the exception
	 */
	public S12LayarDatos getDatosLayar(String codigo, String idioma) throws Exception{

//		declare variables
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer sqlBuffer = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
		String tablaRecurso = "";
		String nomColumnaSubTipo = "";
		S12LayarDatos datosLayar = new S12LayarDatos();
		final String DOMINIO = Q70ListenerUtils.getApplicationProperty("url_dominio_" + idioma);

		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = S12ConnectionManager.getConnection();

			//consulta para obtener la tabla del tipo de recurso
			sqlBuffer.append("SELECT NOBDTABLE FROM RECURSO, TIPO_RECURSO ");
			sqlBuffer.append("WHERE RECURSO.COTIPREC = TIPO_RECURSO.COTIPREC AND COREC = ").append(codigo);

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlBuffer.toString());
			while (rs!=null && rs.next()) {
				tablaRecurso = rs.getString("NOBDTABLE");
			}

			if(tablaRecurso.equals("ALOJAMIENTO")){
				nomColumnaSubTipo = "COTIPO";
			}else if(tablaRecurso.equals("RESTAURACION")){
				nomColumnaSubTipo = "COTIPOESTABLECIMIENTO";
			}

			//consulta para obtener los datos del recurso
			sqlBuffer = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
			sqlBuffer.append("SELECT NORECURSO, DEDESCRIPCION, NOFOTO, R.COTIPREC, URLAMIGABLE, NOMAIL, T1.COIDIOMA, NOURL, NOTELEFONO");

			//si es A1 o B1, cogemos el subtipo de la consulta
			if (!nomColumnaSubTipo.equals("")){
				sqlBuffer.append(", ").append(nomColumnaSubTipo).append(" AS COTIPO");
			}
			sqlBuffer.append(" FROM ").append(tablaRecurso).append(" T1, RECURSO R, DESTACADOS D ");
			sqlBuffer.append("WHERE T1.COREC = R.COREC AND T1.COREC = ").append(codigo).append(" AND T1.COIDIOMA = '").append(idioma).append("'");
			sqlBuffer.append(" AND T1.COREC = D.COREC AND T1.COIDIOMA = D.COIDIOMA");
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlBuffer.toString());
			while (rs!=null && rs.next()) {
				datosLayar.setTitulo(rs.getString("NORECURSO"));
				datosLayar.setDescripcion(rs.getString("DEDESCRIPCION"));
				datosLayar.setFoto(rs.getString("NOFOTO"));
				datosLayar.setTipoRecurso(rs.getString("COTIPREC"));
				datosLayar.setEmail(rs.getString("NOMAIL"));
				datosLayar.setUrl(rs.getString("NOURL"));
				datosLayar.setTelefono(rs.getString("NOTELEFONO"));
				datosLayar.setUrlAmigable(DOMINIO + rs.getString("URLAMIGABLE") + S12LayarDAO.SUFIJO_URLAMIGABLE + rs.getString("COIDIOMA") + "/");
				if (!nomColumnaSubTipo.equals("")){
					datosLayar.setSubTipoRecurso(rs.getString("COTIPO"));
				}
			}

		}
		catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::getDatosLayar: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::getDatosLayar: Exception ", e );
		}
		finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return datosLayar;
	}


	/**
	 * Gets the multimedia layar.
	 *
	 * @param codigo the codigo
	 * @param idioma the idioma
	 *
	 * @return the multimedia layar
	 *
	 * @throws Exception the exception
	 */
	public ArrayList<String> getMultimediaLayar(String codigo, String idioma) throws Exception{

		//	declare variables
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		StringBuffer sqlFoto = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
		StringBuffer sqlMultimedia = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
		ArrayList<String> arMultimedia = new ArrayList<String>();

		try {
			// get the user-specified connection or get a connection from the ResourceManager
			conn = S12ConnectionManager.getConnection();

			//consulta para la foto del recurso
			sqlFoto = new StringBuffer(S12LayarDAO.SIZE_STRINGBUFFER);
			sqlFoto.append("SELECT NOFOTO FROM CONSULTAMAT_RECURSOS_LAYAR");
			sqlFoto.append(" WHERE COREC = ").append(codigo).append(" AND COIDIOMA = '").append(idioma).append("'");

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlFoto.toString());
			while (rs!=null && rs.next()) {
				if (null != rs.getString("NOFOTO")){
					arMultimedia.add(rs.getString("NOFOTO"));
				}
			}


			//consulta para obtener los multimedia de cada recurso
			sqlMultimedia.append("SELECT URLMULT FROM MULTIMEDIA ");
			sqlMultimedia.append("WHERE COREC = ").append(codigo);
			sqlMultimedia.append(" AND COIDIOMA = '").append(idioma).append("'");
			sqlMultimedia.append(" AND COTIPMULT = 1 ORDER BY COMULT");

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlMultimedia.toString());
			while (rs!=null && rs.next()) {
				arMultimedia.add(rs.getString("URLMULT"));
			}

		}
		catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::getMultimediaLayar: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::getMultimediaLayar: Exception ", e );
		}
		finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		return arMultimedia;
	}

	/**
	 * Mtodo para crear un JSON de prueba.
	 *
	 * @param latitud the latitud
	 * @param longitud the longitud
	 * @param distancia the distancia
	 * @param codCategoria the cod categoria
	 * @param idioma the idioma
	 * @param nombrecapa the nombrecapa
	 * 
	 * @return the test po is
	 * 
	 * @throws Exception the exception
	 */
	public S12LayarRaiz getTestPOIs(String latitud, String longitud, String distancia, String codCategoria, String idioma, String nombrecapa) throws Exception {

		ArrayList hotspotsList = new ArrayList();
		S12LayarRaiz respuestaLayar = new S12LayarRaiz();
//		String valorIdioma = idioma.toLowerCase();

		//VALORES DE PRUEBA
		String codRecTest = "5";
		String strTelefonoTest = "944216308";
		String strMailTest = "jfernandez@bilbomatica.es";
		String urlWebTest = "http://turismo.euskadi.net/en/cultural-heritage/bilbao-arena/x65-12375/en/";
		double latitudTest = 43.24;
		double longitudTest = -2.92;
		String strImgURLTest = "http://turismo.euskadi.net/contenidos/i_deportes/0000048702_i2_rec_turismo/en_48702/images/";
		String strTextDescipcionTest = "Texto descripcion de prueba evitando caracteres especiales";
		String strTituloTest = "TITULO RECURSO";

		try {
			String[] paramsArray={"lon","lat","alt"};
			int contador=1;
			while (contador<2) {
				S12LayarHotspot hotspot = new S12LayarHotspot();

				//actions del hotspot
				S12LayarAction[] actionsArray = new S12LayarAction[5];

				S12LayarAction layarAction = new S12LayarAction();
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_INFO);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("text/html");
				String etiquetaBoton = "informacion";
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				String urlInfo = S12LayarDAO.URL_LAYAR_INFO + "?codRec=" + codRecTest + "&lang=" + idioma + "&" + S12LayarDAO.SUFIJO_NOPORTAL;
				layarAction.setUri(urlInfo);
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_INFORMACION));

				int indice = 0;
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());

				//Telfono (tel)
				layarAction = new S12LayarAction();
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_TELEFONO);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("application/vnd.layar.internal");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.telefono",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri("tel:".concat(strTelefonoTest));
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_TELEFONO));
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());

				//Ver imgenes (url)
				layarAction = new S12LayarAction();
				String urlVisorImagenes = S12LayarDAO.URL_LAYAR_IMAGENES + "?codRec=" + codRecTest + "&lang=" + idioma + "&galeria&" + S12LayarDAO.SUFIJO_NOPORTAL;
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_VIEW);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("text/html");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.imagenes",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri(urlVisorImagenes);
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_IMAGENES));
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());

				//e-mail (mailto)
				layarAction = new S12LayarAction();
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_EMAIL);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("application/vnd.layar.internal");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.email",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri("mailto:" + strMailTest);
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_EMAIL));
				actionsArray[indice++] = layarAction;
				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::transformaActions: Aadida action " + layarAction.getLabel());

				//Web (url) a la ficha en el portal
				layarAction = new S12LayarAction();
//				String urlWeb = S12LayarDAO.PREFIJO_URLAMIGABLE + rs.getString("URLAMIGABLE") + S12LayarDAO.SUFIJO_URLAMIGABLE + rs.getString("COIDIOMA") + "/";
				layarAction.setActivityMessage("");
				layarAction.setActivityType(S12LayarDAO.ACTIVITY_INFO);
				layarAction.setAutoTrigger(false);
				layarAction.setAutoTriggerOnly(false);
				layarAction.setAutoTriggerRange(null);
				layarAction.setCloseBiw(false);
				layarAction.setContentType("text/html");
				etiquetaBoton = Q70GestorMensajesi18n.getSingleton().getMessage("s12Layar","layar.boton.web",idioma);
				layarAction.setLabel(etiquetaBoton);
				layarAction.setMethod("GET");
				layarAction.setParams(paramsArray);
				layarAction.setShowActivity(false);
				layarAction.setUri(urlWebTest);
				layarAction.setTipoAccion(new Integer(S12LayarAction.TIPO_ACCION_WEB));
				actionsArray[indice++] = layarAction;
				//informamos campos

				hotspot.setActions(actionsArray);
				S12LayarGeolocation geoloc = new S12LayarGeolocation();
				geoloc.setLat(latitudTest);
				geoloc.setLon(longitudTest);
				hotspot.setGeolocation(geoloc);
				hotspot.setIconType(new Integer(1));
//				hotspot.setIconType(new Integer(rs.getInt("IDCATEGORY")));
				hotspot.setId(codRecTest);
//				String urlImagen = rs.getString("URLIMAGEN");
//				if (urlImagen==null){
//					urlImagen = obtenerImagenGaleria(rs.getString("COREC"), idioma);
//				}
				hotspot.setImageURL(strImgURLTest);
				hotspot.setShowBiwOnClick(true);
				hotspot.setShowSmallBiw(true);
				String descripcion = strTextDescipcionTest;
				if (descripcion==null){
					descripcion = "";
				}
				hotspot.setTextDescription(descripcion);
				hotspot.setTextFootnote("");
				hotspot.setTextTitle(strTituloTest);

				//incluimos en los resultados
				hotspotsList.add(hotspot);
				contador++;

				BLogger.blog(BLogger.DEBUG,"S12LayarDAO::getPOIs: Aadido hotspot " + hotspotsList.size());
			}

			//completamos los datos de la raiz de la estructura y montamos la respuesta
//			respuestaLayar.setActions(null); ELIMINADO COMO POSIBLE CAUSA DE BUG en Layar v.7+
			//respuestaLayar.setBiwStyle("VALOR");
			respuestaLayar.setErrorCode(new Integer(0));
			respuestaLayar.setErrorString("Ok");
			S12LayarHotspot[] arrayHotspots = new S12LayarHotspot[hotspotsList.size()];
			//haciendo toArray de un arrayList perdemos el array de actions. Por tanto, modificamos para tratar arrays de dimensin fija.
			//hotspotsList.toArray(arrayHotspots);
			for (int i=0; i< hotspotsList.size(); i++){
				arrayHotspots[i] = (S12LayarHotspot)hotspotsList.get(i);
			}
			respuestaLayar.setHotspots(arrayHotspots);
//			respuestaLayar.setLayer(S12LayarDAO.LAYER_NAME);
			respuestaLayar.setLayer(nombrecapa);
			respuestaLayar.setMorePages(false);
			//respuestaLayar.setNextPageKey("VALOR");
			//respuestaLayar.setShowMessage("VALOR");

		} catch (Exception e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LayarDAO.COMPONENTE, Q70TraceLevel.ERROR,"S12LayarDAO::GetPOIs: Exception: " + e.getMessage());
			}
			throw new Exception("S12LayarDAO::GetPOIs: Exception ", e );
		} finally {
		}

		return respuestaLayar;

	}
}
