/*
 * Created on 16/12/2011
 *
 */
package s12.eventos.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;


import s12.eventos.valueObjects.S12FormularioEventos;
import s12.util.S12ConnectionManager;


	/**
	 * The Class S12FormularioEventosDao.
	 *  
	 */
	public class S12FormularioEventosDao {

		private static final int SIZE_STRINGBUFFER = 160;


		/**
		 * Insert formulario.
		 *
		 * @param formularioEventos the formulario eventos
		 *
		 * @throws Exception the exception
		 */
		public void insertFormulario(S12FormularioEventos formularioEventos) throws Exception{

			Connection conn = null;
			PreparedStatement prepStmt = null;
			ResultSet rs = null;
			StringBuffer sqlBuffer = new StringBuffer(S12FormularioEventosDao.SIZE_STRINGBUFFER);
			StringBuffer sqlSequence = new StringBuffer(S12FormularioEventosDao.SIZE_STRINGBUFFER);

			try {
				// get the user-specified connection or get a connection from the ResourceManager
				conn = S12ConnectionManager.getConnection();

				//coger el valor del secuenciador
				long secuenciador = 0;
				sqlSequence.append("Select S12.S1214Q00.nextval from dual");
				prepStmt = conn.prepareStatement(sqlSequence.toString());
				rs = prepStmt.executeQuery();
	    	while (rs!=null && rs.next()) {
	    		secuenciador = rs.getLong("nextval");
				}


				// construct the SQL statement
				sqlBuffer.append("INSERT INTO S12_FORMULARIO_EVENTOS (CODSUBSCRIPTOR, CODIDIOMA, NOMBRE, EMPRESA, EMAIL,");
				sqlBuffer.append(" CARGO, SECTOR, DIRECCION, CP, LOCALIDAD) VALUES (?,?,?,?,?,?,?,?,?,?)");

				prepStmt = conn.prepareStatement(sqlBuffer.toString());
				int index = 1;
				prepStmt.setLong(index++, secuenciador);
				prepStmt.setString(index++, formularioEventos.getCodigoIdioma());
				prepStmt.setString(index++, formularioEventos.getNombre());
				prepStmt.setString(index++, formularioEventos.getEmpresa());
				prepStmt.setString(index++, formularioEventos.getEmail());
				prepStmt.setString(index++, formularioEventos.getCargo());
				prepStmt.setLong(index++, formularioEventos.getSector());
				prepStmt.setString(index++, formularioEventos.getDireccion());
				prepStmt.setString(index++, formularioEventos.getCodigoPostal());
				prepStmt.setString(index++, formularioEventos.getLocalidad());
				prepStmt.executeQuery();

			}catch (Exception e) {
				throw new Exception( "Error en S12FormularioEventosDao", e );
			}finally {
				S12ConnectionManager.close(rs);
	    	S12ConnectionManager.close(prepStmt);
	    	S12ConnectionManager.close(conn);
			}
		}


		/**
		 * Gets the texto evento.
		 *
		 * @param idTexto the id texto
		 * @param idioma the idioma
		 *
		 * @return the texto evento
		 *
		 * @throws Exception the exception
		 */
		public String getTextoEvento(long idTexto, String idioma) throws Exception{

			// declare variables
			Connection conn = null;
			PreparedStatement prepStmt = null;
			ResultSet rs = null;
			StringBuffer sqlBuffer = new StringBuffer(S12FormularioEventosDao.SIZE_STRINGBUFFER);
			String strTexto = "";

			try {
				// get the user-specified connection or get a connection from the ResourceManager
				conn = S12ConnectionManager.getConnection();

				// construct the SQL statement
				sqlBuffer.append("SELECT TEXTO FROM S12_TEXTO_EVENTOS WHERE CODTEXTO = ? AND CODIDIOMA = ?");

				prepStmt = conn.prepareStatement(sqlBuffer.toString());
				int index = 1;
				prepStmt.setLong(index++, idTexto);
				prepStmt.setString(index++, idioma);
				rs = prepStmt.executeQuery();
	    	while (rs!=null && rs.next()) {
	    		strTexto = rs.getString("TEXTO");
				}
			}
			catch (Exception e) {
				e.printStackTrace();
			}
			finally {
				S12ConnectionManager.close(rs);
	    	S12ConnectionManager.close(prepStmt);
	    	S12ConnectionManager.close(conn);
			}

			return strTexto;
		}

	}




