/*
 * Created on 17-sep-2007
 *
 */
package s12.constantes;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * Nota: Los literales de salida deben ser ISO-8859-1 (ver pageEncoding y contentType de las JSP)
 * 
 */
public class S12Constantes {

	// Tipos de recurso
	public static final String ALOJAMIENTO = "A1";
	public static final String RESTAURACION = "B1";
	public static final String AEROPUERTO = "C1";
	public static final String COMPANIAS_TRANSPORTE = "C2";
	public static final String ESTACIONES = "C3";
	public static final String PARKINGS = "C6";
	public static final String TERRITORIOS_HISTORICOS = "D1";
	public static final String LOCALIDAD = "D2";
	public static final String DESTINOS = "D3";
	public static final String RUTAS = "D4";
	public static final String ETAPAS = "D5";
	public static final String EXPERIENCIAS = "D6";
	public static final String OFICINA_TURISMO = "E1";
	public static final String PLAYAS = "G1";
	public static final String ESPACIOS_NATURALES = "G2";
	public static final String TEATROS_CINES = "H1";
	public static final String ARTESANOS_ASOCIACIONES = "H10";
	public static final String CULTURA = "H4";
	public static final String PATRIMONIO_CULTURAL = "H5";
	public static final String PUERTOS_PESQUEROS = "H6";
	public static final String INSTALACIONES_DEPORTIVAS = "I2";
	public static final String EMPRESAS_ALQUILER_DEPORTIVO = "I31";
	public static final String EMPRESAS_TURISMO_ACTIVO = "I32";
	public static final String PLATOS_TIPICOS = "J1";
	public static final String PRODUCTOS_TIERRA = "J2";
	public static final String FERIAS_MERCADOS = "J3";
	public static final String ESCUELAS_HOSTELERIA = "J4";
	public static final String PLAZAS_TOROS = "K1";
	public static final String PARQUES_TEMATICOS = "K3";
	public static final String LOCALES_NOCHE = "K10";
	public static final String AQUARIUMS = "K5";
	public static final String CASINOS = "K7";
	public static final String ZONAS_BARES = "K8";
	public static final String ZONAS_TIENDAS = "L1";
	public static final String TIENDAS = "L2";
	public static final String CENTROS_COMERCIALES = "L3";
	public static final String AGENDA = "M1";
	public static final String OFERTAS = "M2";
	public static final String PALACIOS_CONGRESO = "N1";
	public static final String RECINTOS_FERIALES = "N2";
	public static final String EMPRESAS_RELACIONADAS = "N3";
	public static final String EMPRESAS_SALUD = "N5";
	public static final String NOVEDADES = "O1";
	public static final String RECURSO_TOP = "TOP";

	// Constantes de Tipo de contenido

	/**
	 * Creacion del mapa de contentType.
	 * 
	 * @return the content type map
	 */
	private static Map<String, String> getContentTypeMap() {
		Map<String, String> contenTypeMap = new HashMap<String, String>();
		contenTypeMap.put("A", "a_alojamiento");
		contenTypeMap.put("B", "b_restauracion");
		contenTypeMap.put("C", "c_transporte_y_movilidad");
		contenTypeMap.put("D", "d_destinos_turisticos");
		contenTypeMap.put("E", "e_oficinas_turisticas");
		contenTypeMap.put("F", "d_destinos_turisticos");
		contenTypeMap.put("G", "g_naturaleza");
		contenTypeMap.put("H", "h_cultura_y_patrimonio");
		contenTypeMap.put("I", "i_deportes");
		contenTypeMap.put("J", "j_gastronomia");
		contenTypeMap.put("K", "k_ocio");
		contenTypeMap.put("L", "l_compras");
		contenTypeMap.put("M", "evento");
		contenTypeMap.put("N", "n_negocios");
		contenTypeMap.put("O", "noticia");

		return contenTypeMap;
	}

	/**
	 * Metodo que devuelve el contentType a traves del templateType
	 * 
	 * @param templateType (A1, A2, ....)
	 * @return contentType (a_alojamiento)
	 */
	public static String getContentType(String templateType) {

		if (templateType == null) {
			return null;
		}
		String contentTypeKey = "";
		StringBuffer contentType = new StringBuffer("");

		if (templateType.length() > 0) {

			Map<String, String> contentTypes = S12Constantes.getContentTypeMap();

			if (templateType.indexOf(',') != -1) {

				String[] arrayTemp = templateType.split(",");
				String temp = "";

				contentType.append("(");

				for (int i = 0; i < arrayTemp.length; i++) {
					if (i > 0) {
						contentType.append(",");
					}
					temp = arrayTemp[i].trim();
					temp = temp.substring(0, 1).toUpperCase();
					contentType.append(contentTypes.get(temp));
				}

				contentType.append(")");
			} else {
				contentTypeKey = templateType.substring(0, 1).toUpperCase();
				contentType = new StringBuffer(contentTypes.get(contentTypeKey));
			}

		} else {
			return null;
		}

		return contentType.toString();
	}

	public static String rutaContenidoAdjunto(String idioma, String tipoRecurso, String codigoRecurso,
			String nombreAdjunto) {

		String ruta = "";
		try {
			// Genera rutas de contenidos anexos del tipo:
			// "/contenidos/c_transporte_y_movilidad/0000009664_c3_rec_turismo/es_9664/adjuntos/s41MapData2.txt"
			int numZeros = 10 - codigoRecurso.length();
			String zeroPad = "0000000000".substring(0, numZeros).concat(codigoRecurso);
			ruta = "/contenidos/".concat(getContentType(tipoRecurso)).concat("/").concat(zeroPad);
			ruta = ruta.concat("_").concat(tipoRecurso.toLowerCase()).concat("_rec_turismo/");
			ruta = ruta.concat(idioma).concat("_").concat(codigoRecurso);
			ruta = ruta.concat("/adjuntos/").concat(nombreAdjunto);
		} catch (Exception e) {
			ruta = "";
		}
		return ruta;

	}

	// constantes de los metadatos DE FORMULARIO DE BUSQUEDA
	public static final String SF_HISTORIC_TERRITORY_CODE = "historicTerritoryCode";
	public static final String SF_MUNICIPALITY_CODE = "municipalityCode";
	public static final String SF_MUNICIPALITY = "municipality";
	public static final String SF_MUNICIPALITY_CODE_MULTIPLE = "municipalityCodeMultiple";
	public static final String SF_LOCALITY_CODE = "localityCode";
	public static final String SF_LOCALITY = "locality";
	public static final String SF_LOCALITY_CODE_MULTIPLE = "localityCodeMultiple";
	public static final String SF_LOCALITYMUNICIPALITY = "localitymunicipality";
	public static final String SF_LODGING_TYPE = "lodgingType";
	public static final String SF_CATEGORY = "category";
	public static final String SF_TYPE = "type";
	public static final String SF_DOCUMENT_NAME = "documentName";
	public static final String SF_DOCUMENT_LANGUAGE = "documentLanguage";
	public static final String SF_QUALITY_Q = "qualityQ";
	public static final String SF_MICHELIN = "michelinStar";
	public static final String SF_REPSOL_SUN = "repsolSun";
	public static final String SF_ACCESIBILITY = "accesibility";
	public static final String SF_SURFING = "surfing";
	public static final String SF_RESTORATION_TYPE = "restorationType";
	public static final String SF_SPORT_TYPE = "sportType";
	public static final String SF_FUN_TYPE = "funType";
	public static final String SF_EVENT_TYPE = "eventType";
	public static final String SF_RECOMENDED = "recomended";
	public static final String SF_DATE_1 = "date1";
	public static final String SF_DATE_2 = "date2";
	public static final String SF_LANGUAGE_APLICATION = "languageAplication";
	public static final String SF_PAGINA = "pagina";
	public static final String SF_TEMPLATE_TYPE = "templateType";
	public static final String SF_TIPO_RECURSO = "tipoRecurso"; // por necesidad heredada de la capa de presentaci?n
	public static final String SF_EVENT_SEARCH_DATE_1 = "eventSearchDate1";
	public static final String SF_EVENT_SEARCH_DATE_2 = "eventSearchDate2";
	public static final String SF_EVENT_TOWN_NAME = "eventTownName";
	public static final String SF_EVENT_TOWN = "eventTown";
	public static final String SF_EVENT_LOCATION_NAME = "eventLocationName";
	public static final String SF_EVENT_LOCATION = "eventLocation";
	public static final String SF_MARKS = "marks";
	public static final String SF_MARKS_MULTIPLE = "marksMultiple";
	public static final String SF_QUALITY_ASSURANCE = "qualityAssurance";
	// public static final String SF_ECOLABEL = "ECOLABEL";
	public static final String SF_VISIT = "visit";
	public static final String SF_MONTHS = "months";
	public static final String SF_IMPORTANCE = "importance";
	public static final String SF_ROOM = "room";
	public static final String SF_GENERAL = "general";
	public static final String SF_TRANSPORT_TYPE = "transportType";
	public static final String SF_DURATION = "duration";
	public static final String SF_PERFIL = "perfil";
	public static final String SF_PROFILE = "profile";
	public static final String SF_TEMATICA = "topic";
	public static final String SF_TEMATICA_PLANES = "tematica";
	public static final String SF_TEMATICA_AGUA = "water";
	public static final String SF_TEMATICA_PAISAJE = "landscape";
	public static final String SF_TEMATICA_GASTRONOMIA = "cuisine";
	public static final String SF_TEMATICA_CULTURA = "culture";
	public static final String SF_LANGUAGES = "languages";
	public static final String SF_PARA = "para";
	public static final String SF_PARA_PAREJA = "couple";
	public static final String SF_PARA_AMIGOS = "friends";
	public static final String SF_PARA_NINIOS = "children";
	public static final String SF_TOP = "top";
	public static final String SF_PREMIUM = "premium";
	public static final String SF_FECHA_NOVEDADES = "commDate";
	public static final String SF_SECTOR_TYPE = "sectorType";
	public static final String SF_NATURE_TYPE = "natureType";
	public static final String SF_SUB_TYPE = "subtype";
	public static final String SF_CULTURE_TYPE = "cultureType";
	public static final String SF_TIPO = "tipo";
	public static final String SF_SEARCHABLE = "searchable";
	public static final String SF_CLUB_PRODUCTO = "productClub";
	public static final String SF_BUY_TYPE = "buyType";
	public static final String SF_RESTAURANTE = "restaurant";
	public static final String SF_100x100_BASQUE = "basque100";
	public static final String SF_EUS_GASTRO_TYPE = "eusGastroType";
	public static final String SF_PRODUCT_CLUB = "productClub";
	public static final String SF_SECCION_NOTICIAS_ASINOSVEN = "noticiasAsiNosVen";
	public static final String SF_GASTRONOMY_TYPE = "gastronomyType";
	public static final String SF_MODALIDAD = "modalidad";
	public static final String SF_TIPO_ARCHIVO = "tipoarchivo";
	public static final String SF_SECCION = "seccion";
	public static final String SF_DIFICULTAD = "dificultad";
	public static final String SF_DISTANCIA_METROS = "distancia_max";
	public static final String SF_DISTANCIA_KM = "distanciaKm";
	public static final String SF_LATITUD = "u_latitude";
	public static final String SF_LONGITUD = "u_longitude";

	// constantes de los campos de la vista materializada CONSULTAMAT_RECURSOS_PM para el Portal M?vil
	public static final String PM_MUNICIPALITY_CODE = "MUNICIPALITYCODE";
	public static final String PM_MUNICIPALITY = "MUNICIPALITY";
	public static final String PM_TYPE = "TYPE";
	public static final String PM_CATEGORY = "CATEGORY";
	public static final String PM_LANGUAGE = "LANGUAGE";
	public static final String PM_LANGUAGES = "LANGUAGES";
	public static final String PM_QUALITY_Q = "QUALITYQ";
	public static final String PM_ACCESIBILITY = "ACCESIBILITY";
	public static final String PM_SURFING = "SURFING";
	public static final String PM_RECOMENDED = "RECOMENDED";
	public static final String PM_TEMPLATE_TYPE = "TEMPLATETYPE";
	public static final String PM_MARKS = "MARKS";
	public static final String PM_MONTHS = "MONTHS";
	public static final String PM_QUALITY_ASSURANCE = "QUALITYASSURANCE";
	// public static final String PM_ECOLABEL = "ECOLABEL";
	public static final String PM_ROOM = "ROOM";
	public static final String PM_TRANSPORT_TYPE = "TRANSPORTTYPE";
	public static final String PM_DURATION = "DURATION";
	public static final String PM_PROFILE = "PROFILE";
	public static final String PM_NAME = "NAME";
	public static final String PM_VISIT = "VISIT";
	public static final String PM_WATER = "WATER";
	public static final String PM_LANDSCAPE = "LANDSCAPE";
	public static final String PM_CUISINE = "CUISINE";
	public static final String PM_CULTURE = "CULTURE";
	public static final String PM_BASQUE = "BASQUE";
	public static final String PM_ACCESIBLE = "ACCESIBLE";
	public static final String PM_DEPORTE = "DEPORTE";
	public static final String PM_PEQUE = "PEQUE";
	public static final String PM_SALUD = "SALUD";
	public static final String PM_URBANAS = "URBANAS";
	public static final String PM_COUPLE = "COUPLE";
	public static final String PM_CHILDREN = "CHILDREN";
	public static final String PM_FRIENDS = "FRIENDS";
	public static final String PM_DATE_FROM = "DATEFROM";
	public static final String PM_DATE_TO = "DATETO";
	public static final String PM_CULTURE_TYPE = "CULTURETYPE";
	public static final String PM_SEARCHABLE = "SEARCHABLE";
	public static final String PM_RESTAURANT = "RESTAURANT";
	public static final String PM_PRODUCT_CLUB = "PRODUCTCLUB";
	public static final String PM_IMPORTANCE = "IMPORTANCE";
	public static final String PM_LOCALITY_CODE = "LOCALITYCODE";
	public static final String PM_LOCALITY = "LOCALITY";
	public static final String PM_MICHELIN = "MICHELINSTAR";
	public static final String PM_REPSOL_SUN = "REPSOLSUN";
	public static final String PM_MODALIDAD = "MODALIDAD";
	public static final String PM_FECREACION = "FECREACION";
	public static final String PM_FEPUBLICACION = "FEPUBLICACION";
	public static final String PM_SECCION = "COSECCION";

	// Constantes para algunos c?digos de servicios en BD
	public static final String OPTA_SELLO = "1";
	public static final String SRV_Q_CALIDAD = "38";
	public static final String SRV_Q_ORO = "182";
	public static final String SRV_Q_PLATA = "183";
	public static final String SRV_ISO = "184";
	public static final String SRV_BUENAS_PRACTICAS = "191";
	public static final String SRV_COUPLE = "205";
	public static final String SRV_CHILDREN = "206";
	public static final String SRV_FRIENDS = "207";
	public static final String SRV_CLUBPRODUCTO = "208";
	public static final String SRV_SURFING = "210";
	public static final String SRV_BEST50 = "213";
	public static final String SRV_ECOLABEL = "214";
	public static final String SRV_INNOVACION = "221";

	public static final String SRV_PLAZAS_DISCAP = "125";

	// Constantes para algunos valores no inicializados
	public static final double LATITUD_SIN_VALOR = 0;
	public static final double LONGITUD_SIN_VALOR = 0;
	public static final int DISTANCIA_SIN_VALOR = -1;

	// Playgrounds
	public static final double[][] COORD_GRAN_BILBAO = { { 43.361134, -3.004074 }, { 43.327675, -2.990685 },
			{ 43.306194, -2.965279 }, { 43.281769, -2.933993 }, { 43.270454, -2.888718 }, { 43.251205, -2.890091 },
			{ 43.237190, -2.928540 }, { 43.245701, -2.969050 }, { 43.261707, -2.987251 }, { 43.272202, -2.998580 },
			{ 43.319683, -3.052483 }, { 43.337666, -3.058662 }, { 43.353146, -3.083725 }, { 43.368370, -3.113590 },
			{ 43.373112, -3.108100 }, { 43.379601, -3.079260 }, { 43.379848, -3.061750 }, { 43.380089, -3.037720 },
			{ 43.378101, -3.014374 }, { 43.361134, -3.004074 } };
	public static final double[][] COORD_RESERVA_BIOSFERA_URDAIBAI = { { 43.400299, -2.755850 },
			{ 43.374111, -2.731470 }, { 43.336159, -2.728720 }, { 43.307751, -2.709760 }, { 43.293571, -2.687870 },
			{ 43.286140, -2.660490 }, { 43.280201, -2.635000 }, { 43.306690, -2.603410 }, { 43.311680, -2.571480 },
			{ 43.326172, -2.578350 }, { 43.385578, -2.574230 }, { 43.394821, -2.602380 }, { 43.395691, -2.626760 },
			{ 43.411781, -2.632940 }, { 43.418011, -2.643580 }, { 43.422001, -2.658690 }, { 43.417011, -2.684780 },
			{ 43.463131, -2.752410 }, { 43.450169, -2.791550 }, { 43.428982, -2.817990 }, { 43.424812, -2.813015 },
			{ 43.421539, -2.805934 }, { 43.414494, -2.789283 }, { 43.400299, -2.755850 } };
	public static final double[][] COORD_RIOJA_ALAVESA = { { 42.626381, -2.842020 }, { 42.620571, -2.771980 },
			{ 42.604649, -2.777480 }, { 42.595039, -2.772670 }, { 42.582409, -2.778160 }, { 42.574821, -2.795330 },
			{ 42.564201, -2.802880 }, { 42.552059, -2.819360 }, { 42.552570, -2.829660 }, { 42.578869, -2.841330 },
			{ 42.583420, -2.834470 }, { 42.592010, -2.819360 }, { 42.625870, -2.839960 }, { 42.622082, -2.801510 },
			{ 42.620312, -2.785370 }, { 42.620312, -2.770610 }, { 42.618801, -2.758940 }, { 42.616268, -2.743140 },
			{ 42.610210, -2.728040 }, { 42.596062, -2.691650 }, { 42.594028, -2.682030 }, { 42.535881, -2.695080 },
			{ 42.515629, -2.706750 }, { 42.526260, -2.678600 }, { 42.511082, -2.678600 }, { 42.506020, -2.662120 },
			{ 42.483231, -2.647700 }, { 42.494881, -2.627790 }, { 42.491840, -2.615430 }, { 42.496899, -2.607190 },
			{ 42.499439, -2.601700 }, { 42.491341, -2.590710 }, { 42.478680, -2.601010 }, { 42.468552, -2.590710 },
			{ 42.477661, -2.587280 }, { 42.483231, -2.592080 }, { 42.485771, -2.575600 }, { 42.482220, -2.527540 },
			{ 42.491840, -2.535090 }, { 42.510571, -2.517240 }, { 42.519180, -2.515180 }, { 42.510571, -2.517240 },
			{ 42.498932, -2.518610 }, { 42.489311, -2.512430 }, { 42.488300, -2.480850 }, { 42.498932, -2.450630 },
			{ 42.488300, -2.428660 }, { 42.488800, -2.416300 }, { 42.511082, -2.425910 }, { 42.517151, -2.390900 },
			{ 42.533352, -2.397760 }, { 42.543968, -2.397760 }, { 42.561668, -2.389520 }, { 42.579880, -2.397760 },
			{ 42.599091, -2.398450 }, { 42.606670, -2.421790 }, { 42.570782, -2.449260 }, { 42.586960, -2.462990 },
			{ 42.587971, -2.492520 }, { 42.614761, -2.499390 }, { 42.594028, -2.682030 }, { 42.618290, -2.752760 },
			{ 42.621578, -2.797050 }, { 42.636990, -2.813873 }, { 42.645069, -2.832413 }, { 42.639011, -2.848206 },
			{ 42.626381, -2.842020 } };
	public static final double[][] COORD_AIZKORRI = { { 43.018200, -2.241210 }, { 43.048065, -2.254601 },
			{ 43.063869, -2.342491 }, { 43.052330, -2.411490 }, { 43.005138, -2.453380 }, { 42.964958, -2.410810 },
			{ 42.929028, -2.348328 }, { 42.929531, -2.296143 }, { 42.951389, -2.263870 }, { 43.018200, -2.241210 } };
	public static final double[][] COORD_GEOPARQUE = { { 43.316929, -2.390550 }, { 43.315430, -2.373040 },
			{ 43.308441, -2.351760 }, { 43.304440, -2.327040 }, { 43.303940, -2.302660 }, { 43.311680, -2.275200 },
			{ 43.316929, -2.254600 }, { 43.313931, -2.241210 }, { 43.297440, -2.238120 }, { 43.285450, -2.247040 },
			{ 43.268452, -2.250130 }, { 43.254452, -2.244980 }, { 43.237701, -2.246704 }, { 43.236950, -2.270050 },
			{ 43.240452, -2.288933 }, { 43.240200, -2.338028 }, { 43.265450, -2.393640 }, { 43.281200, -2.412180 },
			{ 43.295940, -2.415610 }, { 43.316929, -2.390550 } };
	public static final double[][] COORD_COSTA_GETARIA = { { 43.336658, -1.963120 }, { 43.315430, -2.061990 },
			{ 43.306690, -2.105940 }, { 43.290951, -2.129630 }, { 43.295940, -2.155030 }, { 43.295689, -2.174600 },
			{ 43.306690, -2.218550 }, { 43.295189, -2.232970 }, { 43.281700, -2.224730 }, { 43.271198, -2.219580 },
			{ 43.264198, -2.213400 }, { 43.259949, -2.210990 }, { 43.251949, -2.200690 }, { 43.233440, -2.176660 },
			{ 43.232689, -2.132030 }, { 43.238949, -2.116920 }, { 43.252449, -2.073660 }, { 43.265701, -1.960370 },
			{ 43.279705, -1.940117 }, { 43.319431, -1.937370 }, { 43.336658, -1.963120 } };
	public static final double[][] COORD_CORAZON_EUSKADI = { { 43.227188, -2.016670 }, { 43.217686, -2.054443 },
			{ 43.195667, -2.086029 }, { 43.177139, -2.095642 }, { 43.162117, -2.115555 }, { 43.146587, -2.128601 },
			{ 43.119030, -2.156067 }, { 43.091457, -2.182159 }, { 43.075909, -2.202759 }, { 43.063370, -2.233650 },
			{ 42.976017, -2.054443 }, { 42.987068, -2.033844 }, { 42.996109, -2.027664 }, { 43.006153, -2.032471 },
			{ 43.029247, -2.040710 }, { 43.033764, -2.034531 }, { 43.038784, -2.031097 }, { 43.051830, -2.019424 },
			{ 43.065880, -2.021484 }, { 43.072399, -2.013245 }, { 43.078419, -1.987152 }, { 43.097977, -1.980972 },
			{ 43.119530, -1.978912 }, { 43.142078, -1.980972 }, { 43.161617, -1.972733 }, { 43.183151, -1.962433 },
			{ 43.194160, -1.933590 }, { 43.220680, -1.930840 }, { 43.227188, -2.016670 } };
	public static final double[][] COORD_GORBEIA = { { 43.150097, -2.789154 }, { 43.124039, -2.936780 },
			{ 42.976521, -2.958750 }, { 42.925251, -2.883220 }, { 42.956421, -2.712930 }, { 42.955921, -2.636030 },
			{ 42.997608, -2.624350 }, { 43.058853, -2.635345 }, { 43.098476, -2.682037 }, { 43.150089, -2.729410 },
			{ 43.159111, -2.754820 }, { 43.150097, -2.789154 } };

	/**
	 * Obtiene las coordenadas del Playground.
	 * 
	 * @param playgroung nombre del Playground
	 * 
	 * @return coordenadas del Playground
	 */
	public static double[][] getCoordenadasPlayGround(String playgroung) {
		double[][] coordenadas = { {} };

		if ("CONST_LABEL_GRAN_BILBAO".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_GRAN_BILBAO;
		} else if ("CONST_LABEL_RESERVA_BIOSFERA_URDAIBAI".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_RESERVA_BIOSFERA_URDAIBAI;
		} else if ("CONST_LABEL_RIOJA_ALAVESA".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_RIOJA_ALAVESA;
		} else if ("CONST_LABEL_AIZKORRI".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_AIZKORRI;
		} else if ("CONST_LABEL_COSTA_GETARIA".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_COSTA_GETARIA;
		} else if ("CONST_LABEL_CORAZON_EUSKADI".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_CORAZON_EUSKADI;
		} else if ("CONST_LABEL_GORBEIA".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_GORBEIA;
		} else if ("CONST_LABEL_GEOPARQUE".equals(playgroung)) {
			coordenadas = S12Constantes.COORD_GEOPARQUE;
		}

		return coordenadas;
	}

	// CONSTANTE DE ZONA DE PINTXOS
	public static final String PINTXOS = "0002";
	// CONSTANTE DE BARES DE PINTXOS
	public static final String BARES_PINTXOS = "0004";

	// CONSTANTE DE SPORT_TYPE PUERTOS DEPORTIVOS
	public static final String SPORTYPE_PUERTOS_DEPORTIVOS = "1004"; // NO_UCD

	// CONTASTES PARA LA URL DEL FORWARD
	public static final String QUERY_PARAM = "?r01kQry=";

	// CONSTANTES PARA LOS CSS
	public static final String CSS_INCLUDED = "OK"; // NO_UCD

	// IDIOMAS
	public static final String IDIOMA_ES = "es";
	public static final String IDIOMA_EU = "eu";
	public static final String IDIOMA_EN = "en";
	public static final String IDIOMA_FR = "fr";
	public static final String IDIOMA_DE = "de";

	// CONSTANTES PARA GOOGLEMAPS
	public static final String TIPORECURSOALOJAMIENTOS = "A1";
	public static final String TIPORECURSOEMPRESAS_RELACIONADAS = "N3";
	// public static final String EXPERIENCIAS = "D6";

	// Newsletter, par?metros para el phpList
	public static final String EMAIL = "email";
	public static final String IDIOMA_PHP_LIST = "lists";

	// Recursos locales
	public static final String GENERAL = "1";

	// Indicador de Seccion para Noticias o As? Nos Ven
	public static final String SECCION_NOTICIAS = "0";
	public static final String SECCION_ASI_NOS_VEN = "1";

	// Tipos de imagen
	public static final Integer TIPO_IMAGEN_PRINCIPAL = 0;
	public static final Integer TIPO_IMAGEN_MINIATURA_1 = 1;
	public static final Integer TIPO_IMAGEN_MINIATURA_2 = 2;
	public static final Integer TIPO_IMAGEN_MINIATURA_3 = 3;
	public static final Integer TIPO_IMAGEN_MINIATURA_4 = 4;
	public static final Integer TIPO_IMAGEN_MINIATURA_5 = 5;
	public static final Integer TIPO_IMAGEN_MINIATURA_6 = 6;
	public static final Integer TIPO_IMAGEN_MINIATURA_7 = 7;
	public static final Integer TIPO_IMAGEN_MINIATURA_8 = 8;
	public static final Integer TIPO_IMAGEN_MINIATURA_LISTADO_1 = 9;
	public static final Integer TIPO_IMAGEN_MINIATURA_LISTADO_2 = 10;
	public static final Integer TIPO_IMAGEN_MINIATURA_FICHA_REDUCIDA = 11;
	public static final Integer TIPO_IMAGEN_GALERIA = 20;

	/**
	 * Creaci?n del mapa de Recursos con Q de Calidad.
	 * 
	 * @return the recurso type map es
	 */
	public static Map<String, String> getRecursoTypeMapEs() {

		Map<String, String> recursoTypeMap = new HashMap<String, String>();
		recursoTypeMap.put("A1", "Alojamientos");
		recursoTypeMap.put("B1", "Restauracin");
		recursoTypeMap.put("C1", "Aeropuertos");
		recursoTypeMap.put("C2", "Compaas de transporte");
		recursoTypeMap.put("C3", "Estaciones de transporte");
		recursoTypeMap.put("C4", "Puente Colgante");
		recursoTypeMap.put("C5", "Autopistas");
		recursoTypeMap.put("C6", "Parkings-aparcamiento");
		recursoTypeMap.put("D2", "Localidades");
		recursoTypeMap.put("E1", "Oficinas de turismo");
		recursoTypeMap.put("G1", "Playas, pantanos y ros");
		recursoTypeMap.put("G2", "Espacios naturales");
		recursoTypeMap.put("H1", "Teatros y Cines");
		recursoTypeMap.put("H2", "Bibliotecas y archivos");
		recursoTypeMap.put("H3", "Orquestas sinfnicas");
		recursoTypeMap.put("H4", "Auditorios");
		recursoTypeMap.put("H5", "Patrimonio cultural");
		recursoTypeMap.put("H6", "Puertos pesqueros");
		recursoTypeMap.put("H7", "Principales festivales");
		recursoTypeMap.put("I2", "Instalaciones deportivas");
		recursoTypeMap.put("I4", "Oficina de actividades deportivas");
		recursoTypeMap.put("J4", "Escuelas de hostelera");
		recursoTypeMap.put("K1", "Plazas de toros");
		recursoTypeMap.put("K2", "reas de recreo");
		recursoTypeMap.put("K3", "Parques temticos y de atracciones");
		recursoTypeMap.put("L2", "Tiendas");
		recursoTypeMap.put("L3", "Centros comerciales");
		recursoTypeMap.put("L4", "Mercados tradicionales");
		recursoTypeMap.put("N1", "Palacios de congresos");
		recursoTypeMap.put("N2", "Recintos feriales");
		recursoTypeMap.put("N3", "Empresas relacionadas");
		recursoTypeMap.put("N5", "Turismo de salud");

		return recursoTypeMap;
	}

	/**
	 * Creaci?n del mapa de Recursos con Q de Calidad.
	 * 
	 * @return the recurso type map eu
	 */
	public static Map<String, String> getRecursoTypeMapEu() {

		Map<String, String> recursoTypeMap = new HashMap<String, String>();
		recursoTypeMap.put("A1", "Ostatuak");
		recursoTypeMap.put("B1", "Sukaldaritza");
		recursoTypeMap.put("C1", "Aireportuak");
		recursoTypeMap.put("C2", "Garraio konpainiak");
		recursoTypeMap.put("C3", "Garraio geltokiak");
		recursoTypeMap.put("C4", "Zubi esekia");
		recursoTypeMap.put("C5", "Autobideak");
		recursoTypeMap.put("C6", "Aparkalekuak");
		recursoTypeMap.put("D2", "Herriak");
		recursoTypeMap.put("E1", "Turismo bulegoak");
		recursoTypeMap.put("G1", "Hondartzak, urtegiak, eta errekak");
		recursoTypeMap.put("G2", "Naturguneak");
		recursoTypeMap.put("H1", "Antzokiak eta zinema aretoak");
		recursoTypeMap.put("H2", "Liburutegi eta archiboak");
		recursoTypeMap.put("H3", "Orkestra sinfonikoak");
		recursoTypeMap.put("H4", "Auditorioak");
		recursoTypeMap.put("H5", "Ondare kulturala");
		recursoTypeMap.put("H6", "Arrantza portuak");
		recursoTypeMap.put("H7", "Jaialdi nagusiak");
		recursoTypeMap.put("I2", "Kirol instalazioak");
		recursoTypeMap.put("I4", "Kirol-jardueren bulegoa");
		recursoTypeMap.put("J4", "Ostalaritza eskolak");
		recursoTypeMap.put("K1", "Zezen plazak");
		recursoTypeMap.put("K2", "Zabalguneak");
		recursoTypeMap.put("K3", "Gai eta aisialdi parkeak");
		recursoTypeMap.put("L2", "Dendak");
		recursoTypeMap.put("L3", "Merkataritzaguneak");
		recursoTypeMap.put("L4", "Merkatu tradizionalak");
		recursoTypeMap.put("N1", "Biltzar jauregiak");
		recursoTypeMap.put("N2", "Erakustazokak");
		recursoTypeMap.put("N3", "Turismoarekin lotura duten enpresak");
		recursoTypeMap.put("N5", "Osasun turismoa");

		return recursoTypeMap;
	}

	/**
	 * Instantiates a new s12 constantes.
	 */
	private S12Constantes() {
		super();
	}

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_BD.put(SF_MUNICIPALITY_CODE, PM_MUNICIPALITY_CODE);
		METADATOS_COLUMNAS_BD.put(SF_MUNICIPALITY, PM_MUNICIPALITY);
		METADATOS_COLUMNAS_BD.put(SF_LOCALITY_CODE, PM_LOCALITY_CODE);
		METADATOS_COLUMNAS_BD.put(SF_LOCALITY, PM_LOCALITY);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_TOWN_NAME, PM_MUNICIPALITY);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_TOWN, PM_MUNICIPALITY_CODE);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_LOCATION_NAME, PM_LOCALITY);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_LOCATION, PM_LOCALITY_CODE);
		METADATOS_COLUMNAS_BD.put(SF_MARKS, PM_MARKS);
		METADATOS_COLUMNAS_BD.put(SF_TEMPLATE_TYPE, PM_TEMPLATE_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_TIPO_RECURSO, PM_TEMPLATE_TYPE);

		METADATOS_COLUMNAS_BD.put(SF_LODGING_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_RESTORATION_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_TRANSPORT_TYPE, PM_TRANSPORT_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_NATURE_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_SUB_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_SPORT_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_FUN_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_BUY_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_SECTOR_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_TEMATICA, PM_TYPE);

		METADATOS_COLUMNAS_BD.put(SF_DOCUMENT_NAME, PM_NAME);
		METADATOS_COLUMNAS_BD.put(SF_CATEGORY, PM_CATEGORY);
		METADATOS_COLUMNAS_BD.put(SF_DURATION, PM_DURATION);
		METADATOS_COLUMNAS_BD.put(SF_PERFIL, PM_PROFILE);
		METADATOS_COLUMNAS_BD.put(SF_MONTHS, PM_MONTHS);
		METADATOS_COLUMNAS_BD.put(SF_LANGUAGES, PM_LANGUAGES);
		METADATOS_COLUMNAS_BD.put(SF_CULTURE_TYPE, PM_CULTURE_TYPE);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_SEARCH_DATE_1, PM_DATE_FROM);
		METADATOS_COLUMNAS_BD.put(SF_EVENT_SEARCH_DATE_2, PM_DATE_TO);
		METADATOS_COLUMNAS_BD.put(SF_FECHA_NOVEDADES, PM_DATE_FROM);

		METADATOS_COLUMNAS_BD.put(SF_IMPORTANCE, PM_IMPORTANCE);
		METADATOS_COLUMNAS_BD.put(SF_SEARCHABLE, PM_SEARCHABLE);
		METADATOS_COLUMNAS_BD.put(SF_GENERAL, "");
		METADATOS_COLUMNAS_BD.put(SF_PROFILE, PM_PROFILE);

		METADATOS_COLUMNAS_BD.put(SF_MICHELIN, PM_MICHELIN);
		METADATOS_COLUMNAS_BD.put(SF_REPSOL_SUN, PM_REPSOL_SUN);
		
		METADATOS_COLUMNAS_BD.put(SF_MODALIDAD, PM_MODALIDAD);
	}

	/**
	 * HashMap con los metadatos que corresponden con servicios, ya que tienen un tratamiento especial en la consulta a
	 * la tabla materializada CONSULTAMAT_RECURSOS_PM
	 */
	public static HashMap<String, String> METADATOS_SERVICIO = new HashMap<String, String>();

	static {
		METADATOS_SERVICIO.put(SF_QUALITY_Q, PM_QUALITY_Q);
		METADATOS_SERVICIO.put(SF_ACCESIBILITY, PM_ACCESIBILITY);
		METADATOS_SERVICIO.put(SF_SURFING, PM_SURFING);
		METADATOS_SERVICIO.put(SF_CLUB_PRODUCTO, PM_PRODUCT_CLUB);
		METADATOS_SERVICIO.put(SF_RESTAURANTE, PM_RESTAURANT);
		METADATOS_SERVICIO.put(SF_RECOMENDED, PM_RECOMENDED);
		METADATOS_SERVICIO.put(SF_QUALITY_ASSURANCE, PM_QUALITY_ASSURANCE);
		// METADATOS_SERVICIO.put(SF_ECOLABEL, PM_ECOLABEL);
		METADATOS_SERVICIO.put(SF_VISIT, PM_VISIT);
		METADATOS_SERVICIO.put(SF_ROOM, PM_ROOM);

		METADATOS_SERVICIO.put(SF_PARA_PAREJA, PM_COUPLE);
		METADATOS_SERVICIO.put(SF_PARA_AMIGOS, PM_FRIENDS);
		METADATOS_SERVICIO.put(SF_PARA_NINIOS, PM_CHILDREN);

		METADATOS_SERVICIO.put(SF_TEMATICA_AGUA, PM_WATER);
		METADATOS_SERVICIO.put(SF_TEMATICA_PAISAJE, PM_LANDSCAPE);
		METADATOS_SERVICIO.put(SF_TEMATICA_GASTRONOMIA, PM_CUISINE);
		METADATOS_SERVICIO.put(SF_TEMATICA_CULTURA, PM_CULTURE);
	}

	/** Identificador que se incluye en las URLs de los buscadores a modo de ancla */
	public static String ANCLA_BUSCADOR = "#buscador";

	/**
	 * CAMBIO: Al haber cambiado la forma de los buscadores, que ahora tiran contra BBDD, nos creamos varios HashMap
	 * segn operador a utilizar: =, IN, LIKE, >=, <=, ...
	 */

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM que usen
	 * la operacin EQ (=)
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_EQ_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_EQ_BD.put(SF_TEMPLATE_TYPE, PM_TEMPLATE_TYPE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_TIPO_RECURSO, PM_TEMPLATE_TYPE);

		METADATOS_COLUMNAS_EQ_BD.put(SF_TRANSPORT_TYPE, PM_TRANSPORT_TYPE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_NATURE_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_SPORT_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_EVENT_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_TEMATICA, PM_TYPE);

		METADATOS_COLUMNAS_EQ_BD.put(SF_CATEGORY, PM_CATEGORY);
		METADATOS_COLUMNAS_EQ_BD.put(SF_DURATION, PM_DURATION);
		METADATOS_COLUMNAS_EQ_BD.put(SF_PERFIL, PM_PROFILE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_MONTHS, PM_MONTHS);
		METADATOS_COLUMNAS_EQ_BD.put(SF_LANGUAGES, PM_LANGUAGES);
		METADATOS_COLUMNAS_EQ_BD.put(SF_CULTURE_TYPE, PM_CULTURE_TYPE);

		METADATOS_COLUMNAS_EQ_BD.put(SF_IMPORTANCE, PM_IMPORTANCE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_SEARCHABLE, PM_SEARCHABLE);
		METADATOS_COLUMNAS_EQ_BD.put(SF_GENERAL, "");
		METADATOS_COLUMNAS_EQ_BD.put(SF_PROFILE, PM_PROFILE);
		
		METADATOS_COLUMNAS_EQ_BD.put(SF_MODALIDAD, PM_MODALIDAD);
	}

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM que usen
	 * la operacin LIKE
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_LIKE_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_LIKE_BD.put(SF_DOCUMENT_NAME, PM_NAME);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_MARKS, PM_MARKS);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_MUNICIPALITY_CODE, PM_MUNICIPALITY_CODE);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_MUNICIPALITY, PM_MUNICIPALITY);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_LOCALITY_CODE, PM_LOCALITY_CODE);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_LOCALITY, PM_LOCALITY);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_EVENT_TOWN_NAME, PM_MUNICIPALITY);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_EVENT_TOWN, PM_MUNICIPALITY_CODE);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_EVENT_LOCATION_NAME, PM_LOCALITY);
		METADATOS_COLUMNAS_LIKE_BD.put(SF_EVENT_LOCATION, PM_LOCALITY_CODE);
	}

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM que usen
	 * la operacin IN (x,x,x)
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_IN_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_IN_BD.put(SF_LODGING_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_FUN_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_BUY_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_RESTORATION_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_SECTOR_TYPE, PM_TYPE);
		METADATOS_COLUMNAS_IN_BD.put(SF_SUB_TYPE, PM_TYPE);
	}

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM que usen
	 * la operacin GTE (>=)
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_GTE_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_GTE_BD.put(SF_MICHELIN, PM_MICHELIN);
		METADATOS_COLUMNAS_GTE_BD.put(SF_REPSOL_SUN, PM_REPSOL_SUN);
		METADATOS_COLUMNAS_GTE_BD.put(SF_EVENT_SEARCH_DATE_1, PM_DATE_FROM);
		METADATOS_COLUMNAS_GTE_BD.put(SF_FECHA_NOVEDADES, PM_DATE_FROM);
	}

	/**
	 * HashMap con la equivalencia entre metadatos y columnas de la tabla materializada CONSULTAMAT_RECURSOS_PM que usen
	 * la operacin LTE (<=)
	 */
	public static HashMap<String, String> METADATOS_COLUMNAS_LTE_BD = new HashMap<String, String>();

	static {
		METADATOS_COLUMNAS_LTE_BD.put(SF_EVENT_SEARCH_DATE_2, PM_DATE_TO);
	}

	public static final String TIPO_OFERTA_A1 = "0100";

	// Rutas y nombres de los archivos generados y subidos al Gestor de Contenidos
	public static final String HTML_FICHA = "-ficha2.html";
	public static final String HTML_MINIATURA = "-miniatura";
	public static final String XML_OPENDATA = "_openData.xml";

	// Pginas del Portal
	public static final String PAGINA_FICHA = "aa30-12375";
	public static final String PAGINA_FICHA_EXPERIENCIAS = "aa30-12378";
	public static final String PAGINA_PREVIEW_MINIATURAS = "aa30-preview";

	public static final String PAGINA_FICHA_TOP = "aa30-12376";
	public static final String PAGINA_FICHA_RUTA_IMPORTANTE = "aa30-12379";

	/**
	 * Creacion del mapa de subdominios por idioma.
	 * 
	 * @return the subdominios turismo map
	 */
	public static Map<String, String> getSubdominiosTurismoMap() {
		Map<String, String> subdominiosMap = new HashMap<String, String>();
		subdominiosMap.put("turismo", "es");
		subdominiosMap.put("turismoa", "eu");
		subdominiosMap.put("tourism", "en");
		subdominiosMap.put("tourisme", "fr");
		subdominiosMap.put("tourismus", "de");

		return subdominiosMap;
	}

	//cookie para idioma
	public static final String R01_EUSKADI_COOKIE = "r01euskadiCookie";

	//espacio
	public static final String ESPACIO_BLANCO = " ";
	public static final String ESPACIO_BLANCO_HTML = "&nbsp;";

	//White list de zonas (marks)
	public static final String ZONA_COSTAVASCA   = "1";
	public static final String ZONA_VERDENATURAL = "2";
	public static final String ZONA_RIOJAALAVESA = "3";
	public static final String ZONA_BILBAO       = "4";
	public static final String ZONA_DONOSTI      = "5";
	public static final String ZONA_GASTEIZ      = "6";
	public static final String ZONA_NOESPECIFICADA = "";

}