/*
 * Created on Jan 19, 2011
 *
 */
package s12.buscadores.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

/**
 * Clase S12Localidad.
 *
 * Representa uno de los registros usados en la funcionalidad de autocompletado de los formularios
 * del nuevo Portal
 *
 *  
 */
public class S12Localidad implements JSONString {

	/**
	 * Constructor.
	 */
	public S12Localidad() {

	}

	/**
	 * Constructor
	 *
	 * @param id id
	 * @param value value
	 */
	public S12Localidad(String id, String value) {
		this.id = id;
		this.value = value;
	}


	/**
	 * Identificador
	 *
	 * 	Cdigo asociado a la localidad (10 caracteres)
	 *
	 */
	private String id;

	/**
	 * Value
	 *
	 *  Nombre de la localidad
	 *
	 */
	private String value;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the value.
	 *
	 * @return the value
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * Sets the value.
	 *
	 * @param value the new value
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		
		try {
			jObject.put("id", this.getId());
			jObject.put("value", this.getValue());
		} catch (JSONException e) {
			e.printStackTrace();
		}
		
		return jObject.toString();
	}

}
