/*
 * Created on 22/06/2012
 *
 */
package s12.buscadores.valueObjects;

import org.json.JSONObject;
import org.json.JSONString;

/**
 * Clase S12Establecimiento.
 *
 * Representa uno de los registros usados en la funcionalidad de autocompletado de los formularios
 * del nuevo Portal
 *
 *  
 */
public class S12Establecimiento implements JSONString {

	/**
	 * Constructor.
	 */
	public S12Establecimiento() {

	}

	/**
	 * Constructor
	 *
	 * @param id id
	 * @param value value
	 */
	public S12Establecimiento(String id, String value) {
		this.id = id;
		this.value = value;
	}


	/**
	 * Identificador
	 *
	 * 	Cdigo asociado al municipio (6 caracteres)
	 *
	 */
	private String id;

	/**
	 * Value
	 *
	 *  Nombre del municipio
	 *
	 */
	private String value;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the value.
	 *
	 * @return the value
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * Sets the value.
	 *
	 * @param value the new value
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * Implementacin de la serializacin JSON del objeto
	 *
	 * @return Serializacin JSON del objeto
	 *
	 * @see org.json.JSONString#toJSONString()
	 */
	public String toJSONString() {
		return new JSONObject(this).toString();
	}

}
