/*
 * Created on Jan 19, 2011
 *
 */
package s12.buscadores.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;

import javax.naming.NamingException;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import s12.buscadores.valueObjects.S12Municipio;
import s12.util.S12ConnectionManager;
import s12.util.S12Utils;

/**
 * The Class S12MunicipioDAO.
 * 
 *  
 */
public class S12MunicipioDAO { // NO_UCD

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Filtrar municipios.
	 * 
	 * Obtiene aquellos municipios cuyo nombre contenga los caracteres
	 * especificados en el filtro
	 * 
	 * @param filtro filtro
	 * 
	 * @return Array de objetos S12Municipio
	 * 
	 * @throws S12BuscadoresDaoException Excepcin
	 */
	public S12Municipio[] filtrarMunicipios(String filtro) throws S12BuscadoresDaoException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<S12Municipio> municipiosList = new ArrayList<S12Municipio>();

		String nomMunicip = "";
		String id = "";

		try {
			// El string de filtro viene codificado en UTF-8
			// Se convierte a iso-8859-1 para poder hacer la consulta a base de datos
			String nuevoFiltro = S12Utils.utf8toIso88591(filtro);
			//////////////
						
			conn = S12ConnectionManager.getConnection();

			String sql = "SELECT PROVINCIA_ID CODPROVINC, ID CODMUNICIP, DS_O NOMMUNICIP FROM T17_MUNICIPIO WHERE PROVINCIA_ID IN (1,20,48) AND UPPER(DS_O) LIKE '%"
					+ nuevoFiltro.toUpperCase(new Locale("es", "es")) + "%' ORDER BY NOMMUNICIP";

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				id = rs.getString("CODMUNICIP");
				nomMunicip = rs.getString("NOMMUNICIP");
				municipiosList.add(new S12Municipio(id, nomMunicip));
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12MunicipioDAO.COMPONENTE, Q70TraceLevel.ERROR, "S12MunicipioDAO::filtrarMunicipios: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12MunicipioDAO::filtrarMunicipios: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12MunicipioDAO.COMPONENTE, Q70TraceLevel.ERROR, "S12MunicipioDAO::filtrarMunicipios: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12MunicipioDAO::filtrarMunicipios: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		S12Municipio municipiosArray[] = new S12Municipio[municipiosList.size()];
		municipiosList.toArray(municipiosArray);
		return municipiosArray;
	}
}
