package s12.buscadores.dao;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;

import javax.naming.NamingException;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import s12.buscadores.valueObjects.S12LocalidadMunicipio;
import s12.util.S12ConnectionManager;
import s12.util.S12Utils;

/**
 * The Class S12LocalidadMunicipioDAO.
 * 
 *  
 */
public class S12LocalidadMunicipioDAO {
	 // NO_UCD

		/** The Constant COMPONENTE. */
		private static final String COMPONENTE = "BUSCADORES";

		/**
		 * Filtrar localidades.
		 * 
		 * Obtiene aquellas localidades cuyo nombre contenga los caracteres
		 * especificados en el filtro
		 * 
		 * @param filtro filtro
		 * 
		 * @return Array de objetos S12LocalidadMunicipio
		 * 
		 * @throws S12BuscadoresDaoException Excepcin
		 */
		public S12LocalidadMunicipio[] filtrarLocalidades(String filtro) throws S12BuscadoresDaoException {
			Connection conn = null;
			Statement stmt = null;
			ResultSet rs = null;
			
			ArrayList<S12LocalidadMunicipio> localidadesList = new ArrayList<S12LocalidadMunicipio>();

			String nomLocalid = "";
			String nomMunicip = "";
			// String id = "";
			String idLocalidad = "";
			String idMunicipio = "";

			try {
				// El string de filtro viene codificado en UTF-8
				// Se convierte a iso-8859-1 para poder hacer la consulta a base de datos
				String nuevoFiltro = S12Utils.utf8toIso88591(filtro);
				//////////////
				
				conn = S12ConnectionManager.getConnection();
				stmt = conn.createStatement();
				
				String sql2 = "SELECT PROVINCIA_ID CODPROVINC, ID CODMUNICIP, DS_O NOMMUNICIP FROM T17_MUNICIPIO WHERE PROVINCIA_ID IN (1,20,48) AND UPPER(DS_O) LIKE '%"
					+ nuevoFiltro.toUpperCase(new Locale("es", "es")) + "%' ORDER BY DS_O";
				
//				String sql = "SELECT LOCALIDADES.CODPROVINC, LOCALIDADES.CODMUNICIP, LOCALIDADES.CODLOCALID, LOCALIDADES.NOMLOCALID, MUNICIPIOS.CODPROVINC, MUNICIPIOS.NOMMUNICIP FROM LOCALIDADES INNER JOIN MUNICIPIOS ON LOCALIDADES.CODMUNICIP=MUNICIPIOS.CODMUNICIP AND LOCALIDADES.CODPROVINC=MUNICIPIOS.CODPROVINC WHERE (LOCALIDADES.CODPROVINC IN (1,20,48) AND MUNICIPIOS.CODPROVINC IN (1,20,48) AND LOCALIDADES.NOMLOCALID LIKE '%"
//					+ nuevoFiltro.toUpperCase(new Locale("es", "es")) + "%') ORDER BY NOMLOCALID";
				
				rs = stmt.executeQuery(sql2);
				// Municipios:
				while (rs.next()) {
					idMunicipio = rs.getString("CODMUNICIP");
					nomMunicip = rs.getString("NOMMUNICIP");
					localidadesList.add(new S12LocalidadMunicipio(idMunicipio, nomMunicip));
				}

				StringBuilder sql = new StringBuilder();
				sql.append(" SELECT LOCALIDADES.PROVINCIA_ID CODPROVINC, LOCALIDADES.MUNICIPIO_ID CODMUNICIP, ");
				sql.append(" LOCALIDADES.ID CODLOCALID, LOCALIDADES.DS_O NOMLOCALID, MUNICIPIOS.DS_O NOMMUNICIP ");
				sql.append(" FROM T17_LOCALIDAD LOCALIDADES ");
				sql.append(" INNER JOIN T17_MUNICIPIO MUNICIPIOS ON LOCALIDADES.MUNICIPIO_ID=MUNICIPIOS.ID AND LOCALIDADES.PROVINCIA_ID=MUNICIPIOS.PROVINCIA_ID ");
				sql.append(" WHERE (LOCALIDADES.PROVINCIA_ID IN (1,20,48) ");
				sql.append(" AND MUNICIPIOS.PROVINCIA_ID IN (1,20,48) ");
				sql.append(" AND UPPER(LOCALIDADES.DS_O) LIKE '%").append(nuevoFiltro.toUpperCase(new Locale("es", "es"))).append("%') ");
				sql.append(" ORDER BY NOMLOCALID ");
				
				// Localidades:
				rs = stmt.executeQuery(sql.toString());
				while (rs.next()) {
					//Solo devuelvo la localidad en caso de llamarse distinto del municipio
					if (!rs.getString("NOMLOCALID").equals(rs.getString("NOMMUNICIP"))){
						
						//idLocalidad = String.format("%02d", rs.getInt("CODPROVINC")) + String.format("%03d", rs.getInt("CODMUNICIP"))								+ String.format("%015d", rs.getLong("CODLOCALID"));
						idLocalidad = rs.getString("CODLOCALID");
						
						nomLocalid = rs.getString("NOMLOCALID") + " (" + rs.getString("NOMMUNICIP") +  ")";
						localidadesList.add(new S12LocalidadMunicipio(idLocalidad, nomLocalid));
					}					
					
				}
				
			} catch (NamingException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12LocalidadMunicipioDAO.COMPONENTE, Q70TraceLevel.ERROR,
							"S12LocalidadMunicipioDAO::filtrarLocalidades: Exception: " + e.getMessage());
				}
				throw new S12BuscadoresDaoException("S12LocalidadDAO::filtrarLocalidades: Exception ", e);
			} catch (SQLException e) {
				if (Q70Factoria.getTraza().isTraceActive()) {
					Q70Factoria.getTraza().trace(S12LocalidadMunicipioDAO.COMPONENTE, Q70TraceLevel.ERROR,
							"S12LocalidadMunicipioDAO::filtrarLocalidades: Exception: " + e.getMessage());
				}
				throw new S12BuscadoresDaoException("S12LocalidadMunicipioDAO::filtrarLocalidades: Exception ", e);
			} finally {
				S12ConnectionManager.close(rs);
				S12ConnectionManager.close(stmt);
				S12ConnectionManager.close(conn);
			}

			
			S12LocalidadMunicipio localidadesArray[] = new S12LocalidadMunicipio[localidadesList.size()];
			localidadesList.toArray(localidadesArray);
			return localidadesArray;
		}
		
}
