package s12.buscadores.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;

import javax.naming.NamingException;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import s12.buscadores.valueObjects.S12Localidad;
import s12.util.S12ConnectionManager;
import s12.util.S12Utils;

/**
 * The Class S12LocalidadDAO.
 * 
 *  
 */
public class S12LocalidadDAO { // NO_UCD

	/** The Constant COMPONENTE. */
	private static final String COMPONENTE = "BUSCADORES";

	/**
	 * Filtrar localidades.
	 * 
	 * Obtiene aquellas localidades cuyo nombre contenga los caracteres
	 * especificados en el filtro
	 * 
	 * @param filtro filtro
	 * 
	 * @return Array de objetos S12Localidad
	 * 
	 * @throws S12BuscadoresDaoException Excepcin
	 */
	public S12Localidad[] filtrarLocalidades(String filtro) throws S12BuscadoresDaoException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<S12Localidad> localidadesList = new ArrayList<S12Localidad>();

		String nomLocalid = "";
		String id = "";

		try {
			// El string de filtro viene codificado en UTF-8
			// Se convierte a iso-8859-1 para poder hacer la consulta a base de datos
			String nuevoFiltro = S12Utils.utf8toIso88591(filtro);
			//////////////
			
			conn = S12ConnectionManager.getConnection();

			String sql = "SELECT PROVINCIA_ID CODPROVINC, MUNICIPIO_ID CODMUNICIP, ID CODLOCALID, DS_O NOMLOCALID FROM T17_LOCALIDAD WHERE PROVINCIA_ID IN (1,20,48) AND UPPER(DS_O) LIKE '%"
					+ nuevoFiltro.toUpperCase(new Locale("es", "es")) + "%' ORDER BY NOMLOCALID";

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				id = rs.getString("CODLOCALID");
				nomLocalid = rs.getString("NOMLOCALID");
				localidadesList.add(new S12Localidad(id, nomLocalid));
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LocalidadDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12LocalidadDAO::filtrarLocalidades: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12LocalidadDAO::filtrarLocalidades: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LocalidadDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12LocalidadDAO::filtrarLocalidades: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12LocalidadDAO::filtrarLocalidades: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		S12Localidad localidadesArray[] = new S12Localidad[localidadesList.size()];
		localidadesList.toArray(localidadesArray);
		return localidadesArray;
	}
	
	/**
	 * Filtrar localidades.
	 * 
	 * Obtiene aquellas localidades cuyo nombre contenga los caracteres
	 * especificados en el filtro
	 *
	 * @param filtro filtro
	 * @param municipio Municipio. Formato PPMMMM donde PP es el cdigo de provincia y MMMM es el cdigo de municipio
	 * 
	 * @return Array de objetos S12Localidad
	 * 
	 * @throws S12BuscadoresDaoException Excepcin
	 */
	public S12Localidad[] filtrarLocalidades(String filtro, String municipio) throws S12BuscadoresDaoException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList<S12Localidad> localidadesList = new ArrayList<S12Localidad>();

		String nomLocalid = "";
		String id = "";

		try {
			// El string de filtro viene codificado en UTF-8
			// Se convierte a iso-8859-1 para poder hacer la consulta a base de datos
			String nuevoFiltro = S12Utils.utf8toIso88591(filtro);
			//////////////
			
			conn = S12ConnectionManager.getConnection();

			String sql = "SELECT PROVINCIA_ID CODPROVINC, MUNICIPIO_ID CODMUNICIP, ID CODLOCALID, DS_O NOMLOCALID FROM T17_LOCALIDAD WHERE UPPER(DS_O) LIKE '%"
					+ nuevoFiltro.toUpperCase(new Locale("es", "es")) + "%' AND PROVINCIA_ID = " + municipio 
					+ " AND MUNICIPIO_ID = " + municipio + " ORDER BY NOMLOCALID";

			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next()) {
				id = rs.getString("CODLOCALID");
				nomLocalid = rs.getString("NOMLOCALID");
				localidadesList.add(new S12Localidad(id, nomLocalid));
			}
		} catch (NamingException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LocalidadDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12LocalidadDAO::filtrarLocalidades: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12LocalidadDAO::filtrarLocalidades: Exception ", e);
		} catch (SQLException e) {
			if (Q70Factoria.getTraza().isTraceActive()) {
				Q70Factoria.getTraza().trace(S12LocalidadDAO.COMPONENTE, Q70TraceLevel.ERROR,
						"S12LocalidadDAO::filtrarLocalidades: Exception: " + e.getMessage());
			}
			throw new S12BuscadoresDaoException("S12LocalidadDAO::filtrarLocalidades: Exception ", e);
		} finally {
			S12ConnectionManager.close(rs);
			S12ConnectionManager.close(stmt);
			S12ConnectionManager.close(conn);
		}

		S12Localidad localidadesArray[] = new S12Localidad[localidadesList.size()];
		localidadesList.toArray(localidadesArray);
		return localidadesArray;
	}
}
