package s12.buscadorText.valueObjects;

import java.sql.Blob;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import com.ejie.r01m.objects.searchengine.query.R01MSearchedMetaData;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineConstants;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import s12.constantes.S12Constantes;
import s12.portalMovil.dao.S12PortalMovilDAO;
import s12.portalMovil.dao.S12PortalMovilDaoException;
import s12.util.S12Utils;

/**
 * Clase S12Aeropuerto.
 *
 * Representa un aeropuerto
 *
 *  
 */
public class S12RecursoBuscadorText   implements JSONString {

	/** codigoRecurso  */
	private Long codigoRecurso;
	/** nombre  */
	private String nombre;
	/** descripcion  */	
	private String descripcion;
	/** fechaInicio  */
	private String fechaInicio;
	/** fechaFin  */
	private String fechaFin;
	/** codigoTipologia  */
	private String codigoTipologia;
	/** descTipologia  */
	private String descTipologia;	

	/** Telfono  */
	private String telefono;
	
	/** tipo de plantilla para rutas  */
	private String tipoPlantillaRuta;
	/** url amigable del recurso  */
	private String urlAmigable;
	/** fecha de la noticia  */
	private String fechaNoticia;
	
	/** Enlaces a municipios (DCR) */
	private List<S12EnlaceMunicipio> enlacesMunicipio;

	/**
	 * Constructor.
	 */
	public S12RecursoBuscadorText() {
	}

	/**
	 * @return Retorna el valor del campo telefono.
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * @param telefono Establece el valor del campo telefono.
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * @return Retorna el valor del campo codigoRecurso.
	 */
	public Long getCodigoRecurso() {
		return codigoRecurso;
	}

	/**
	 * @param telefono Establece el valor del campo codigoRecurso.
	 */
	public void setCodigoRecurso(Long codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * @return Retorna el valor del campo nombre.
	 */
	public String getNombre() {
		return nombre;
	}

	/**
	 * @param telefono Establece el valor del campo nombre.
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * @return Retorna el valor del campo descripcion.
	 */
	public String getDescripcion() {
		return descripcion;
	}

	/**
	 * @param telefono Establece el valor del campo descripcion.
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	/**
	 * @return Retorna el valor del campo fechaInicio.
	 */
	public String getFechaInicio() {
		return fechaInicio;
	}

	/**
	 * @param telefono Establece el valor del campo fechaInicio.
	 */
	public void setFechaInicio(String fechaInicio) {
		this.fechaInicio = fechaInicio;
	}

	/**
	 * @return Retorna el valor del campo fechaFin.
	 */
	public String getFechaFin() {
		return fechaFin;
	}

	/**
	 * @param telefono Establece el valor del campo fechaFin.
	 */
	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	/**
	 * @return Retorna el valor del campo codigoTipologia.
	 */
	public String getCodigoTipologia() {
		return codigoTipologia;
	}

	/**
	 * @param telefono Establece el valor del campo codigoTipologia.
	 */
	public void setCodigoTipologia(String codigoTipologia) {
		this.codigoTipologia = codigoTipologia;
	}

	/**
	 * @return Retorna el valor del campo descTipologia.
	 */
	public String getDescTipologia() {
		return descTipologia;
	}

	/**
	 * @param telefono Establece el valor del campo descTipologia.
	 */
	public void setDescTipologia(String descTipologia) {
		this.descTipologia = descTipologia;
	}

	/**
	 * @return Retorna el valor del campo teenlacesMunicipiolefono.
	 */
	public List<S12EnlaceMunicipio> getEnlacesMunicipio() {
		return enlacesMunicipio;
	}

	/**
	 * @param telefono Establece el valor del campo enlacesMunicipio.
	 */
	public void setEnlacesMunicipio(List<S12EnlaceMunicipio> enlacesMunicipio) {
		this.enlacesMunicipio = enlacesMunicipio;
	}
	
	

	public String getTipoPlantillaRuta() {
		return tipoPlantillaRuta;
	}

	public void setTipoPlantillaRuta(String tipoPlantillaRuta) {
		this.tipoPlantillaRuta = tipoPlantillaRuta;
	}
	

	public String getUrlAmigable() {
		return urlAmigable;
	}

	public void setUrlAmigable(String urlAmigable) {
		this.urlAmigable = urlAmigable;
	}
	
	

	public String getFechaNoticia() {
		return fechaNoticia;
	}

	public void setFechaNoticia(String fechaNoticia) {
		this.fechaNoticia = fechaNoticia;
	}

	@Override
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("codigoRecurso", this.getCodigoRecurso());
			jObject.put("nombre", S12Utils.encodeHtmlTag(this.getNombre()));
			jObject.put("descripcion", S12Utils.encodeHtmlTag(this.getDescripcion()));
			jObject.put("telefono", S12Utils.encodeHtmlTag(this.getTelefono()));
				if(this.getFechaInicio()!=null){
				jObject.put("fechaInicio", this.getFechaInicio());
			}else{
				jObject.put("fechaInicio", "");
			}
			if(this.getFechaFin()!=null){
				jObject.put("fechaFin", this.getFechaFin());
			}else{
				jObject.put("fechaFin", "");
			}
			jObject.put("codigoTipologia", this.getCodigoTipologia());
			jObject.put("descTipologia",  S12Utils.encodeHtmlTag(this.getDescTipologia()));
			jObject.put("enlacesMunicipio", this.getEnlacesMunicipio());
			jObject.put("tipoPlantillaRutaEtapa", this.getTipoPlantillaRuta());
			jObject.put("urlAmigable", this.getUrlAmigable());
			jObject.put("fechaNoticia", this.getFechaNoticia());
			

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	


	

}
