package s12.buscadorText.valueObjects;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

import s12.util.S12Utils;

/**
 * Clase que representa el enlace a un recurso de tipo municipio (D2) donde está ubicado el recurso
 *
 *  
 *
 */
public class S12EnlaceMunicipio implements JSONString {

	/** Codigo del recurso */
	private Long codigoRecurso;

	/** Nombre del municipio */
	private String nombreMunicipio;
	
	/** Nombre del provincia */
	private String nombreProvincia;

	/** URL amigable del recurso en el idioma en curso */
	private String urlAmigable;

	

	/**
	 * Obtiene el campo codigoRecurso
	 *
	 * @return codigoRecurso
	 */
	public Long getCodigoRecurso() {
		return this.codigoRecurso;
	}

	/**
	 * Establece el campo codigoRecurso
	 *
	 * @param codigoRecurso codigoRecurso
	 */
	public void setCodigoRecurso(Long codigoRecurso) {
		this.codigoRecurso = codigoRecurso;
	}

	/**
	 * Obtiene el campo nombreMunicipio
	 *
	 * @return nombreMunicipio
	 */
	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Establece el campo nombreMunicipio
	 *
	 * @param nombreMunicipio nombreMunicipio
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	
	
	
	public String getUrlAmigable() {
		return urlAmigable;
	}

	public void setUrlAmigable(String urlAmigable) {
		this.urlAmigable = urlAmigable;
	}

	public String getNombreProvincia() {
		return nombreProvincia;
	}

	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	@Override
	public String toJSONString() {
		JSONObject jObject = new JSONObject();
		try {
			jObject.put("codigoRecurso", this.getCodigoRecurso());
			jObject.put("nombreMunicipio", S12Utils.encodeHtmlTag(this.getNombreMunicipio()));
			jObject.put("nombreProvincia", S12Utils.encodeHtmlTag(this.getNombreProvincia()));
			jObject.put("urlAmigable", this.getUrlAmigable());
			

		} catch (JSONException e) {
			e.printStackTrace();
		}

		return jObject.toString();
	}

	

	
}
