/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.listeners.listasenlazadas;

import es.ejie.frmk.control.excepciones.Q70GestorDeExcepciones;
import es.ejie.frmk.infraestructura.logs.navegacion.Q70LogNavegacion;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasCodigos;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70HTTPListener;
import es.ejie.frmk.listeners.base.Q70LogDataUtils;
import es.ejie.frmk.listeners.listasenlazadas.Q70ListasEnlazadasException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.DynaBean;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;

public class Q70ListasEnlazadasListener
extends HttpServlet
implements Q70HTTPListener {
    private static final String COMPONENTE = "LISTAS_ENLAZADAS";
    private static final String CANAL = "BROWSER-PC AUXILIAR";
    private static Q70Traza tr = null;
    private static Q70LogNavegacion logNav = null;

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (null == tr) {
                tr = Q70Traza.getSingleton();
            }
            if (null == logNav) {
                logNav = Q70LogNavegacion.getSingleton();
            }
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Entrando al servlet Q70ListasEnlazadasListener...");
            }
            Q70LogDataUtils.processPrepareLogData(httpServletRequest, CANAL, COMPONENTE);
            this.writeNavLogBegin();
            this.listen(httpServletRequest, httpServletResponse);
            this.writeNavLogEnd();
        }
        catch (ServletException servletException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "ServletException.");
            }
            this.catchGenericThrowables(servletException, httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "IOException.");
            }
            this.catchGenericThrowables(iOException, httpServletRequest, httpServletResponse);
        }
        catch (Throwable throwable) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Throwable recogida por el Q70ListasEnlazadasListener.");
            }
            this.catchGenericThrowables(throwable, httpServletRequest, httpServletResponse);
        }
        Q70LogDataUtils.clearLogData(COMPONENTE);
    }

    public void listen(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, Q70ListasEnlazadasException {
        this.process(httpServletRequest, httpServletResponse);
    }

    public void catchGenericThrowables(Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Q70GestorDeExcepciones.getSingleton().recogerThrowable(throwable, httpServletRequest, httpServletResponse);
    }

    public void writeNavLogBegin() {
        logNav.log("OK", "ENTRADA");
    }

    public void writeNavLogEnd() {
        logNav.log("OK", "SALIDA");
    }

    public void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Q70ListasEnlazadasException, IOException {
        CharSequence charSequence;
        if (tr.isTraceActive()) {
            charSequence = new StringBuffer("Q70ListasEnlazadasListener: Procesando peticion con valores: \n");
            ((StringBuffer)charSequence).append("-retFunc=").append(httpServletRequest.getParameter("retFunc")).append("\n").append("-targetTag=").append(httpServletRequest.getParameter("targetTag")).append("\n").append("-targetTagValue=").append(httpServletRequest.getParameter("targetTagValue")).append("\n").append("-sourceTag=").append(httpServletRequest.getParameter("sourceTag")).append("\n").append("-sourceTagValue=").append(httpServletRequest.getParameter("sourceTagValue")).append("\n").append("-formName=").append(httpServletRequest.getParameter("formName")).append("\n").append("-table=").append(httpServletRequest.getParameter("table")).append("\n").append("-labelColumn=").append(httpServletRequest.getParameter("labelColumn")).append("\n").append("-valueColumn=").append(httpServletRequest.getParameter("valueColumn")).append("\n").append("-predicateColumn=").append(httpServletRequest.getParameter("predicateColumn")).append("\n").append("-predicateColumnNumeric=").append(httpServletRequest.getParameter("predicateColumnNumeric")).append("\n").append("-extraPredicate=").append(httpServletRequest.getParameter("extraPredicate")).append("\n").append("-locale=").append(httpServletRequest.getLocale().toString());
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ((StringBuffer)charSequence).toString());
        }
        charSequence = this.getData(httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("table"), httpServletRequest.getParameter("labelColumn"), httpServletRequest.getParameter("valueColumn"), httpServletRequest.getParameter("predicateColumn"), httpServletRequest.getParameter("predicateColumnNumeric"), httpServletRequest.getParameter("extraPredicate"), httpServletRequest.getLocale());
        if (httpServletRequest.getParameter("technology") != null && httpServletRequest.getParameter("technology").equalsIgnoreCase("iframe")) {
            String string = this.composeHtmlResponse(httpServletRequest.getParameter("formName"), httpServletRequest.getParameter("targetTag"), httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTag"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("retFunc"), (String)charSequence);
            this.sendResponse(string, httpServletResponse);
        } else {
            this.sendXmlResponse(httpServletRequest.getParameter("formName"), httpServletRequest.getParameter("targetTag"), httpServletRequest.getParameter("targetTagValue"), httpServletRequest.getParameter("sourceTag"), httpServletRequest.getParameter("sourceTagValue"), httpServletRequest.getParameter("retFunc"), (String)charSequence, httpServletResponse);
        }
    }

    private String getData(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Locale locale) throws Q70ListasEnlazadasException {
        StringBuffer stringBuffer = null;
        try {
            Serializable serializable;
            Vector<String> vector = new Vector<String>(3);
            vector.add(string5);
            vector.add(string4);
            vector.add(string6);
            StringBuffer stringBuffer2 = new StringBuffer(64);
            if (null != string2 && 0 < string2.trim().length()) {
                stringBuffer2.append(string6);
                stringBuffer2.append("=");
                if (string7.equals("true")) {
                    stringBuffer2.append(string2);
                } else {
                    stringBuffer2.append("'").append(string2).append("'");
                }
            }
            if (null != string8 && 0 < string8.trim().length()) {
                stringBuffer2.append(stringBuffer2.length() > 0 ? " AND " : "").append("(").append(string8).append(")");
            }
            if (tr.isTraceActive()) {
                serializable = new StringBuffer("Q70ListasEnlazadasListener: Llamando al Gestor de Tablas y Codigos con valores: \n");
                ((StringBuffer)serializable).append("-table=").append(string3).append("\n").append("-where=").append(stringBuffer2.toString()).append("\n").append("-lenguage=").append(locale.getLanguage()).append("\n").append("-cols=").append(vector.toString());
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ((StringBuffer)serializable).toString());
            }
            serializable = Q70GestorTablasCodigos.getSingleton().selectRecordsFromTable(string3, stringBuffer2.toString(), locale.getLanguage(), vector);
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ListasEnlazadasListener: El tamanio de la coleccion devuelta por el Gestor de tablas y Codigos es: " + serializable.toArray().length);
            }
            if (!serializable.isEmpty()) {
                Iterator iterator = serializable.iterator();
                if (iterator.hasNext()) {
                    stringBuffer = new StringBuffer();
                }
                while (iterator.hasNext()) {
                    DynaBean dynaBean = (DynaBean)iterator.next();
                    if (dynaBean.get(string6) == null) continue;
                    stringBuffer.append(dynaBean.get(string5).toString()).append("~").append(dynaBean.get(string4).toString()).append("|");
                }
                if (stringBuffer != null) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
            }
        }
        catch (Q70GestorTablasException q70GestorTablasException) {
            throw new Q70ListasEnlazadasException(this.getClass().toString(), "getDescription", "Excepcion generada por el Gestor de Tablas y Codigos", q70GestorTablasException);
        }
        catch (Exception exception) {
            throw new Q70ListasEnlazadasException(this.getClass().toString(), "getDescription", "Excepcion sin especificar recogida", exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ListasEnlazadasListener: El resultado de la consulta contra el Gestor de Tablas y Codigos es: " + (stringBuffer != null ? stringBuffer.toString() : ""));
        }
        return stringBuffer != null ? stringBuffer.toString() : "";
    }

    private String composeHtmlResponse(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Q70ListasEnlazadasException {
        StringBuffer stringBuffer;
        if (tr.isTraceActive()) {
            stringBuffer = new StringBuffer("Comenzando a componer el codigo html de respuesta del Validador Remoto para los valores: \n");
            stringBuffer.append("-formName=").append(string).append("\n").append("-targetTag=").append(string2).append("\n").append("-targetTagValue=").append(string3).append("\n").append("-sourceTag=").append(string4).append("\n").append("-sourceTagValue=").append(string5).append("\n").append("-targetTagValue=").append(string3).append("\n").append("-retFunc=").append(string6).append("\n").append("-strData=").append(string7);
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, stringBuffer.toString());
        }
        stringBuffer = null;
        try {
            stringBuffer = new StringBuffer(256);
            stringBuffer.append("<script language='JavaScript' type='text/javascript'>");
            if (null != string6 && 0 < string6.length()) {
                if (string6.indexOf("()") > 0) {
                    string6.substring(string6.length() - 2);
                }
                stringBuffer.append("parent.").append(string6).append("(\"").append(string5).append("\",\"").append(string7).append("\");");
            } else {
                stringBuffer.append("parent.frmkFillList(\"").append(string2).append("\",\"").append(string7).append("\");");
            }
            stringBuffer.append("</script>");
        }
        catch (Exception exception) {
            throw new Q70ListasEnlazadasException(this.getClass().toString(), "composeHtmlResponse", "Excepcion recogida", exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q70ListasEnlazadasListener: El codigo html a devolver es: " + (null != stringBuffer ? stringBuffer.toString() : ""));
        }
        return null != stringBuffer ? stringBuffer.toString() : "";
    }

    private void sendXmlResponse(String string, String string2, String string3, String string4, String string5, String string6, String string7, HttpServletResponse httpServletResponse) throws Q70ListasEnlazadasException {
        Object object;
        if (tr.isTraceActive()) {
            object = new StringBuffer("Comenzando a componer el codigo XML de respuesta del Validador Remoto para los valores: \n");
            ((StringBuffer)object).append("-formName=").append(string).append("\n").append("-targetTag=").append(string2).append("\n").append("-targetTagValue=").append(string3).append("\n").append("-sourceTag=").append(string4).append("\n").append("-sourceTagValue=").append(string5).append("\n").append("-targetTagValue=").append(string3).append("\n").append("-retFunc=").append(string6).append("\n").append("-strData=").append(string7);
            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ((StringBuffer)object).toString());
        }
        try {
            object = XMLOutputStreamFactory.newInstance();
            XMLOutputStream xMLOutputStream = object.newOutputStream((Writer)new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8"));
            httpServletResponse.setContentType("text/xml");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartDocument((String)"UTF-8", (String)"1.0"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"listenerResponse"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"listener"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"listasEnlazadas"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"listener"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"elementos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            if (null != string6 && 0 < string6.length()) {
                if (string6.indexOf("()") > 0) {
                    string6.substring(string6.length() - 2);
                }
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"funcionRetorno"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string6));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"funcionRetorno"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"sourceTagValue"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string5));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"sourceTagValue"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            } else {
                xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"targetTag"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string2));
                xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"targetTag"));
                xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            }
            xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"datos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)string7));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"datos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"elementos"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"listenerResponse"));
            xMLOutputStream.add((XMLEvent)ElementFactory.createCharacterData((String)"\n"));
            xMLOutputStream.flush();
            xMLOutputStream.close();
        }
        catch (Exception exception) {
            throw new Q70ListasEnlazadasException(this.getClass().toString(), "sendXmlResponse", "Excepcion recogida", exception);
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q70ListasEnlazadasListener: Se ha devuelto el XML.");
        }
    }

    private void sendResponse(String string, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.println(string);
        servletOutputStream.flush();
    }
}

