/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01j.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01j.services.R01JUnPublisherOutBoxAccessor;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01p.datastore.walker.R01PRawWorkAreaWalker;
import com.ejie.r01p.datastore.walker.R01PWorkAreaWalkerAPIStoreAccessor;
import com.ejie.r01p.datastore.walker.R01PWorkAreaWalkerEventListener;
import com.ejie.r01p.datastore.walker.R01PWorkAreaWalkerStoreAccessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01JUnPublisherOutBoxAccesorIWImpl
implements R01JUnPublisherOutBoxAccessor {
    private static final String LOG_TYPE = "r01j.class";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01j.class").intValue() != Level.OFF.intValue();
    private static final String UNPUB_INDEXFILES_OUTBOX_BASE = XMLProperties.getProperty((String)R01MConstants.PUBLISHER_APPCODE, (String)"unpublish/expiredFilesOutBox/basePath");
    private static final String UNPUB_INDEXFILES_OUTBOX_FLDR = XMLProperties.getProperty((String)R01MConstants.PUBLISHER_APPCODE, (String)"unpublish/expiredFilesOutBox/relPath");
    private static final String UNPUB_INDEXFILES_OUTBOX = UNPUB_INDEXFILES_OUTBOX_BASE + UNPUB_INDEXFILES_OUTBOX_FLDR;
    private static String _PATH_SEPARATOR = null;
    private R01MRawDataAPI _rawDataAPI = this._obtainDataAPI();

    @Override
    public String getFileSeparator() {
        if (_PATH_SEPARATOR == null && this._rawDataAPI != null) {
            try {
                _PATH_SEPARATOR = this._rawDataAPI.getPathSeparator();
            }
            catch (R01MDataStoreException ex) {
                ex.printStackTrace(System.out);
            }
        }
        if (_PATH_SEPARATOR == null) {
            _PATH_SEPARATOR = "/";
        }
        return _PATH_SEPARATOR;
    }

    @Override
    public String[] obtainExpiredFiles(String publicationOid) throws R01MPublisherException {
        FileNameFilter fileNameFilter = new FileNameFilter("[" + publicationOid + "]");
        try {
            R01PRawWorkAreaWalker walker = new R01PRawWorkAreaWalker((R01PWorkAreaWalkerStoreAccessor)new R01PWorkAreaWalkerAPIStoreAccessor(this._rawDataAPI), UNPUB_INDEXFILES_OUTBOX_BASE, UNPUB_INDEXFILES_OUTBOX_FLDR, (R01PWorkAreaWalkerEventListener)fileNameFilter);
            while (walker.hasNext()) {
                walker.next();
            }
        }
        catch (R01MDataStoreException ignoreEx) {
            ignoreEx.printStackTrace(System.out);
        }
        Collection files = fileNameFilter.getFiles();
        if (files != null && !files.isEmpty()) {
            return files.toArray(new String[files.size()]);
        }
        return null;
    }

    @Override
    public void renameUnpublishIndexFile(String fileOldPath, String fileNewName) throws R01MPublisherException {
        try {
            String[] fileOldPathSplitted = this._splitIWVPath(fileOldPath);
            this._rawDataAPI.renameFile(fileOldPathSplitted[0], fileOldPathSplitted[1], fileNewName);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException((Exception)((Object)secEx));
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPublisherException((Exception)((Object)dsEx));
        }
    }

    @Override
    public String writeUnpublishIndexFileInOutBox(String outBoxPath, String unPublishIndexFileName, String unPublishIndexFileContents) throws R01MPublisherException {
        String thePath = UNPUB_INDEXFILES_OUTBOX + this.getFileSeparator() + outBoxPath;
        String[] outBoxPathSplitted = this._splitIWVPath(thePath);
        try {
            boolean outBoxExists = this._rawDataAPI.checkFolder(outBoxPathSplitted[0], outBoxPathSplitted[1]);
            if (!outBoxExists) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE).info("R01JPublisher: El buzon de salida " + thePath + " para el proceso de despublicaci\u00f3n en el que se va a escribir el fichero indice NO existe. Se crea.");
                }
                this._rawDataAPI.createFolder(outBoxPathSplitted[0], outBoxPathSplitted[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE).severe("R01JPublisher: No se puede crear el buzon de salida " + thePath + ": " + ex.getMessage() + "\r\nComprobar los permisos del usuario con el que se ejecuta la aplicaci\u00f3n");
            throw new R01MPublisherException(ex);
        }
        String filePath = null;
        try {
            filePath = outBoxPathSplitted[1] + this._rawDataAPI.getPathSeparator() + unPublishIndexFileName;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE).info("\t\t-fichero indice :" + outBoxPathSplitted[0] + this._rawDataAPI.getPathSeparator() + filePath);
            }
            this._rawDataAPI.updateFile(outBoxPathSplitted[0], filePath, (InputStream)new ByteArrayInputStream(unPublishIndexFileContents.getBytes()), null, true);
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException((Exception)((Object)secEx));
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MPublisherException("No se pude generar el fichero indice " + filePath + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
        return filePath;
    }

    private R01MRawDataAPI _obtainDataAPI() {
        R01MRawDataAPI api = null;
        try {
            api = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
        }
        catch (R01MSecurityException ex) {
            ex.printStackTrace(System.out);
        }
        return api;
    }

    private String[] _splitIWVPath(String vPath) {
        Pattern p = Pattern.compile("(//iwmnt/[^/]+/main/[^/]+/WORKAREA/[^/]+/)(.+)");
        Matcher m = p.matcher(vPath);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public class FileNameFilter
    implements R01PWorkAreaWalkerEventListener {
        private String _fileNameFilter = null;
        private List _filteredFilePaths = new ArrayList();

        public FileNameFilter() {
        }

        public FileNameFilter(String fileNameFilter) {
            this._fileNameFilter = fileNameFilter;
        }

        public void file(R01MDataStoreItem theFile) {
            String fileAbsolutePath = theFile.getAbsolutePath();
            if (fileAbsolutePath.indexOf(this._fileNameFilter) > 0 || this._fileNameFilter != null && this._fileNameFilter.length() == 0) {
                this._filteredFilePaths.add(fileAbsolutePath);
            }
        }

        public void enteringDirectory(R01MDataStoreItem theDirectory) {
        }

        public void exitingDirectory(R01MDataStoreItem theDirectory) {
        }

        public Collection getFiles() {
            return this._filteredFilePaths;
        }
    }
}

