/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01j.services;

import com.ejie.r01f.file.DirectoryExtractor;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01j.services.R01JUnPublisherOutBoxAccessor;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.utils.R01MConstants;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Level;
import org.apache.commons.lang.StringEscapeUtils;

public class R01JUnPublisherOutBoxAccesorFileSystemImpl
implements R01JUnPublisherOutBoxAccessor {
    private static final String LOG_TYPE = "r01j.class";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01j.class").intValue() != Level.OFF.intValue();
    private static final String UNPUB_INDEXFILES_OUTBOX = XMLProperties.getProperty((String)R01MConstants.PUBLISHER_APPCODE, (String)"unpublish/expiredFilesOutBox/basePath") + XMLProperties.getProperty((String)R01MConstants.PUBLISHER_APPCODE, (String)"unpublish/expiredFilesOutBox/relPath");

    @Override
    public String getFileSeparator() {
        return File.separator;
    }

    @Override
    public String[] obtainExpiredFiles(String publicationOid) throws R01MPublisherException {
        DirectoryExtractor directoryExtractor = new DirectoryExtractor(UNPUB_INDEXFILES_OUTBOX);
        Collection files = directoryExtractor.getFiles((FileFilter)new FileNameFilter("[" + publicationOid + "]"));
        if (files != null && !files.isEmpty()) {
            String[] outFilesPaths = new String[files.size()];
            int i = 0;
            File currFile2 = null;
            for (File currFile2 : files) {
                outFilesPaths[i] = currFile2.getAbsolutePath();
                ++i;
            }
            return outFilesPaths;
        }
        return null;
    }

    @Override
    public void renameUnpublishIndexFile(String fileOldPath, String fileNewName) throws R01MPublisherException {
        try {
            String[] fileOldPathSplitted = fileOldPath.split(StringEscapeUtils.escapeJava((String)this.getFileSeparator()));
            String basePath = fileOldPath.substring(0, fileOldPath.indexOf(fileOldPathSplitted[fileOldPathSplitted.length - 1]));
            FileUtils.renameFile((String)fileOldPath, (String)(basePath + this.getFileSeparator() + fileNewName));
        }
        catch (IOException ioEx) {
            throw new R01MPublisherException("No se puede renombrar el fichero indice " + fileOldPath + " a " + fileNewName + " para posibilitar su despublicaci\u00f3n: " + ioEx.getMessage(), (Exception)ioEx);
        }
    }

    @Override
    public String writeUnpublishIndexFileInOutBox(String outBoxPath, String unPublishIndexFileName, String unPublishIndexFileContents) throws R01MPublisherException {
        String thePath = UNPUB_INDEXFILES_OUTBOX + this.getFileSeparator() + outBoxPath;
        File outBoxFile = new File(thePath);
        if (!outBoxFile.exists() || !outBoxFile.isDirectory()) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE).info("R01JPublisher: El buzon de salida " + thePath + " para el proceso de despublicaci\u00f3n en el que se va a escribir el fichero indice NO existe. Se crea.");
            }
            try {
                outBoxFile.mkdirs();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                R01FLog.to((String)LOG_TYPE).severe("R01JPublisher: No se puede crear el buzon de salida " + thePath + ": " + ex.getMessage() + "\r\nComprobar los permisos del usuario con el que se ejecuta la aplicaci\u00f3n");
                throw new R01MPublisherException(ex);
            }
        }
        String filePath = thePath + this.getFileSeparator() + unPublishIndexFileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE).info("\t\t-fichero indice :" + filePath);
            }
            ((OutputStream)out).write(unPublishIndexFileContents.getBytes());
        }
        catch (FileNotFoundException fnfEx) {
            throw new R01MPublisherException("No se pude crear el fichero indice " + filePath + ": " + fnfEx.getMessage(), (Exception)fnfEx);
        }
        catch (IOException ioEx) {
            throw new R01MPublisherException("No se pude generar el fichero indice " + filePath + ": " + ioEx.getMessage(), (Exception)ioEx);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioEx) {
                    throw new R01MPublisherException("No se puede cerrar el fichero indice " + filePath, (Exception)ioEx);
                }
            }
        }
        return filePath;
    }

    private class FileNameFilter
    implements FileFilter {
        private String _fileNameFilter;

        public FileNameFilter() {
        }

        public FileNameFilter(String fileNameFilter) {
            this();
            this._fileNameFilter = fileNameFilter;
        }

        @Override
        public boolean accept(File fichero) {
            String fileAbsPath = fichero.getAbsolutePath();
            return fileAbsPath.indexOf(this._fileNameFilter) > 0 || this._fileNameFilter != null && this._fileNameFilter.length() == 0;
        }
    }
}

