/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01j.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.URLEncoder;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01j.objects.R01MInvocationType;
import com.ejie.r01j.publisher.R01JPublisherConfig;
import com.ejie.r01j.publisher.R01JPublisherInvoker;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublicationResponse;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.portalmodel.R01MPage;
import com.ejie.r01m.objects.portalmodel.R01MPortal;
import com.ejie.r01m.objects.portalmodel.R01MPortalLocation;
import com.ejie.r01m.objects.portalmodel.R01MPortalPublicationTarget;
import com.ejie.r01m.objects.publisher.R01MPublicationDestination;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.R01MPortalManagerAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.portal.R01MPortalPathHelpper;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.publisher.R01PPublisherManager;
import com.ejie.r01p.services.bzd.R01PPublisherBzd;
import com.ejie.r01p.utils.publisher.R01MPublisherUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01JPublisherServices
implements R01PPublisherBzd {
    private static final String LOG_TYPE_ID = "r01j.class";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01j.class").intValue() != Level.OFF.intValue();
    private static final boolean SIMULATE = XMLProperties.getBoolean((String)R01MConstants.PUBLISHER_APPCODE, (String)"simulationOnly");
    private static final long DEFAULT_TIME_TO_DELIVER = XMLProperties.getLong((String)R01MConstants.PUBLISHER_APPCODE, (String)"publishMessagesManagement/timeToDeliverPublishIndex", (long)-1L);

    public void execPublish(R01PPublishDefinition pubDefinition) throws R01MPublisherException {
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "userName", (Object)pubDefinition.getUserName()));
        params.add(new R01MJmsQueueParam(1, "objectOid", (Object)pubDefinition.getObjectOid()));
        params.add(new R01MJmsQueueParam(3, "objectType", (Object)Integer.toString(pubDefinition.getObjectType())));
        params.add(new R01MJmsQueueParam(1, "filePattern", (Object)(pubDefinition.getFilePattern() == null ? "" : pubDefinition.getFilePattern())));
        params.add(new R01MJmsQueueParam(1, "resourcesRelativePaths", (Object)(pubDefinition.getResourcesRelativePaths() == null ? "" : pubDefinition.getResourcesRelativePaths().toString().replaceFirst("\\[", "").replaceFirst("\\]", ""))));
        params.add(new R01MJmsQueueParam(1, "repositoryOid", (Object)pubDefinition.getRepositoryOid()));
        params.add(new R01MJmsQueueParam(3, "publicationType", (Object)Integer.toString(pubDefinition.getPublicationType())));
        params.add(new R01MJmsQueueParam(1, "pubDateInMillis", (Object)(pubDefinition.getPublicationDate() != null ? Long.toString(pubDefinition.getPublicationDate().getTime()) : "")));
        params.add(new R01MJmsQueueParam(1, "stepsActions", (Object)(pubDefinition.getStepsActions() != null && !pubDefinition.getStepsActions().isEmpty() ? pubDefinition.getStepsActions().toString().replaceFirst("\\[", "").replaceFirst("\\]", "") : "")));
        params.add(new R01MJmsQueueParam(2, "executeIndexOnPostPublish", (Object)Boolean.toString(pubDefinition.isExecuteIndexOnPostPublish())));
        String JMSQueueId = "r01PublishObject";
        long timeToDeliver = -1L;
        if (pubDefinition.getObjectType() == 9 || pubDefinition.getObjectType() == 8 || pubDefinition.getObjectType() == 11) {
            timeToDeliver = DEFAULT_TIME_TO_DELIVER;
        }
        if (pubDefinition.getObjectType() == 1 || pubDefinition.getUserName().trim().equals("Client-x42t")) {
            timeToDeliver = DEFAULT_TIME_TO_DELIVER * 3L;
        }
        try {
            if (timeToDeliver != -1L) {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params);
            } else {
                R01MJMSUtils.sendJMSMessage((String)JMSQueueId, params, (long)timeToDeliver);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01JPublisherServices.execPublish >> Enviado mensaje de publicaci\u00f3n del objeto " + (pubDefinition.getObjectOid() == null ? "[no definido]" : pubDefinition.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDefinition.getObjectType()] + ". Operaci\u00f3n lanzada correctamente.");
            }
        }
        catch (R01MJMSException jmsExc) {
            throw new R01MPublisherException("R01JPublisherServices.execPublish >> Error en el env\u00edo del mensaje de publicaci\u00f3n del objeto " + (pubDefinition.getObjectOid() == null ? "[no definido]" : pubDefinition.getObjectOid()) + " de tipo " + R01MConstants.OBJECT_DESCS[pubDefinition.getObjectType()] + ". Error: " + jmsExc.getMessage(), (Exception)((Object)jmsExc));
        }
    }

    public void execPerformPublish(R01PPublishDefinition pubDefinition) throws R01MPublisherException {
        int objectType = pubDefinition.getObjectType();
        int publicationType = pubDefinition.getPublicationType();
        String objectOid = pubDefinition.getObjectOid();
        String filePattern = pubDefinition.getFilePattern();
        String userName = pubDefinition.getUserName();
        String repositoryOid = pubDefinition.getRepositoryOid();
        List stepsActions = pubDefinition.getStepsActions();
        List resourcesRelativePaths = pubDefinition.getResourcesRelativePaths();
        Date publicationDate = pubDefinition.getPublicationDate();
        String aggregatorPacketOid = pubDefinition.getAggregatorPacketOid();
        String aggregatorItemOid = pubDefinition.getAggregatorItemOid();
        String publisherManagerClassName = R01MConstants.PORTAL_PUBLISHER_MANAGER;
        if (R01MConstants.CONTENT_MODEL_OBJECT.contains(Integer.valueOf(Integer.toString(objectType)))) {
            publisherManagerClassName = R01MConstants.CONTENT_PUBLISHER_MANAGER;
        }
        R01PPublisherManager publisherManager = null;
        try {
            publisherManager = (R01PPublisherManager)ReflectionUtils.getObjectInstance((String)publisherManagerClassName, null, null, (boolean)true);
        }
        catch (ReflectionException rEx) {
            throw new R01MPublisherException("R01JPublisherServices.execPerformPublish >> Error al instanciar la clase manejadora de la publicaci\u00f3n al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Llamando a la clase manejadora " + publisherManagerClassName + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
        }
        R01MPublishActionObject prePublishAction = null;
        R01MPublishActionObject publishAction = null;
        R01MPublishActionObject postPublishAction = null;
        if (stepsActions != null && !stepsActions.isEmpty()) {
            for (R01MPublishActionObject action : stepsActions) {
                if (action.getStep() == 1) {
                    prePublishAction = action;
                    continue;
                }
                if (action.getStep() == 2) {
                    publishAction = action;
                    continue;
                }
                if (action.getStep() != 3) continue;
                postPublishAction = action;
            }
        }
        try {
            publisherManager.prepareToPublish(pubDefinition);
        }
        catch (R01MPublisherException pubEx) {
            throw new R01MPublisherException("R01JPublisherServices.execPerformPublish >> Error al preparar los datos para la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " con la clase manejadora de publicaci\u00f3n " + publisherManagerClassName + ". Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
        }
        try {
            this._launchDeployment(userName, objectOid, objectType, filePattern, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate, prePublishAction == null ? "" : prePublishAction.toString(), publishAction == null ? "" : publishAction.toString(), postPublishAction == null ? "" : postPublishAction.toString(), aggregatorPacketOid, aggregatorItemOid);
        }
        catch (R01MPublisherException pubEx) {
            throw new R01MPublisherException("R01JPublisherServices.execPerformPublish >> Error al ejecutar la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " con la clase manejadora de publicaci\u00f3n " + publisherManagerClassName + ". Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
        }
        if (SIMULATE) {
            pubDefinition.setPublicationOid("simulacion");
            if (pubDefinition.getPublicationDate() == null) {
                pubDefinition.setPublicationDate(new Date());
            }
            try {
                publisherManager.prePublish(pubDefinition);
            }
            catch (R01MPublisherException pubEx) {
                throw new R01MPublisherException("R01JPublisherServices.execPerformPublish >> Error al preparar los datos para la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " con la clase manejadora de publicaci\u00f3n " + publisherManagerClassName + ". Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01JPublisherServices.execPerformPublish >> El objeto de Oid " + (objectOid == null ? "[no definido]" : objectOid) + " y tipo " + Integer.toString(objectType) + " Se publica (SIMULACI\u00d3N) en el repositorio " + repositoryOid);
            }
            try {
                pubDefinition.setPublicationState(publicationType == 0 || publicationType == 1 ? 1 : 0);
                publisherManager.postPublish(pubDefinition);
            }
            catch (R01MPublisherException pubEx) {
                throw new R01MPublisherException("R01JPublisherServices.execPerformPublish >> Error al preparar los datos para la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + " con la clase manejadora de publicaci\u00f3n " + publisherManagerClassName + ". Error:" + pubEx.getMessage(), (Exception)((Object)pubEx));
            }
        }
    }

    public void execPrepareToPublishFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerPublication) throws R01MPublisherException {
    }

    public void execPrePublishFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerPublication) throws R01MPublisherException {
    }

    public void execPublishFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerPublication) throws R01MPublisherException {
    }

    public void execPostPublishFinished(String objectOid, int objectType, String message, Map<String, String> resultsPerPublication) throws R01MPublisherException {
    }

    public void execRemoveDeployment(R01MPublish pubInfo) throws R01MPublisherException {
        if (!SIMULATE) {
            this._getPublisherInvoker(pubInfo).removeScheduleDeployment(pubInfo);
        }
    }

    public R01MPublish execObtainPublicationInfoObject(String userName, String objectOid, int objectType, String filePattern, List<String> resourcesRelativePaths, String publisherManagerClassName, String repositoryOid, int publicationType, Date publicationDate) throws R01MPublisherException {
        R01MLogicalPublicationInfo logicalPublicationInfo;
        R01MPublish pub = new R01MPublish();
        try {
            logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
        }
        catch (R01MConfigLoadException cfgEx) {
            throw new R01MPublisherException("R01JPublisherServices._obtainPublicationInfoObject >> Error al cargar la informaci\u00f3n l\u00f3gica de la publicaci\u00f3n de " + repositoryOid, (Exception)((Object)cfgEx));
        }
        List<String> logicalDestinationNames = Arrays.asList(logicalPublicationInfo.getDestinationSystemsOids());
        ArrayList<R01MPublicationDestination> publicationDestinationList = new ArrayList<R01MPublicationDestination>(logicalDestinationNames.size());
        Iterator<String> iteratorLogicalDestinationNames = logicalDestinationNames.iterator();
        while (iteratorLogicalDestinationNames.hasNext()) {
            R01MPublicationDestination logicalDest = new R01MPublicationDestination(iteratorLogicalDestinationNames.next());
            publicationDestinationList.add(logicalDest);
        }
        pub.setOid(pub.getOid() + "_" + R01MConstants.OBJECT_DESCS[objectType].toUpperCase());
        pub.setLogicalPublicationOid(logicalPublicationInfo.getOid());
        pub.source = logicalPublicationInfo.getSourceSystemOid();
        pub.destinations = publicationDestinationList;
        String string = pub.programmed = publicationType == 1 || publicationType == 3 ? R01MPublish.PROGRAMMED_YES : R01MPublish.PROGRAMMED_NO;
        if (publicationType == 0 || publicationType == 2) {
            pub.programmeddate = R01MDateUtils.dateTimeSecondsToStr((Date)new Date(), (String)"es");
        } else if (publicationType == 1 || publicationType == 3) {
            pub.programmeddate = R01MDateUtils.dateTimeSecondsToStr((Date)publicationDate, (String)"es");
        } else {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).warning("R01JPublisherServices._obtainPublicationInfoObject >> Tipo de operaci\u00f3n para la publicaci\u00f3n no reconocido para el objeto" + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + Integer.toString(objectType) + ". Se ha solicitado una publicaci\u00f3n de tipo " + Integer.toString(publicationType) + ". Se realiza publicaci\u00f3n inmediata");
            }
            pub.programmeddate = R01MDateUtils.dateTimeSecondsToStr((Date)new Date(), (String)"es");
        }
        pub.expiration = R01MPublish.EXPIRATION_NO;
        pub.requestdate = Calendar.getInstance().getTime().toString();
        pub.user = userName;
        if (R01MConstants.CONTENT_MODEL_OBJECT.contains(Integer.valueOf(Integer.toString(objectType)))) {
            this._updatePublicationContentModelInfoObject(pub, logicalPublicationInfo, userName, objectOid, objectType, filePattern, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        } else if (R01MConstants.PORTAL_MODEL_OBJECT.contains(Integer.valueOf(Integer.toString(objectType)))) {
            String newUserName = userName;
            if (objectType == 12 || objectType == 14 || objectType == 18) {
                pub.setUser(pub.getUser() + "-" + objectOid);
                newUserName = userName + "-" + objectOid;
            }
            this._updatePublicationPortalModelInfoObject(newUserName, pub, objectOid, objectType, filePattern, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, logicalPublicationInfo, publicationDate);
        }
        return pub;
    }

    public void execUpdateStatePublishInfo(String objectOid, int objectType, String publicationOid, int publicationState) throws R01MPublisherException {
        String publisherManagerClassName = R01MConstants.PORTAL_PUBLISHER_MANAGER;
        if (R01MConstants.CONTENT_MODEL_OBJECT.contains(Integer.valueOf(Integer.toString(objectType)))) {
            publisherManagerClassName = R01MConstants.CONTENT_PUBLISHER_MANAGER;
        }
        try {
            R01PPublisherManager publisherManager = (R01PPublisherManager)ReflectionUtils.getObjectInstance((String)publisherManagerClassName, null, null, (boolean)true);
            publisherManager.updateStatePublishInfo(objectOid, objectType, publicationOid, publicationState);
        }
        catch (ReflectionException rEx) {
            throw new R01MPublisherException("R01JPublisherServices.execUpdateStatePublishInfo >> Error al instanciar la clase manejadora de la publicaci\u00f3n al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Llamando a la clase manejadora " + publisherManagerClassName + ". Error: " + rEx.getMessage(), (Exception)((Object)rEx));
        }
    }

    private void _launchDeployment(String userName, String objectOid, int objectType, String filePattern, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate, String prePublishAction, String publishAction, String postPublishAction, String aggregatorPacketOid, String aggregatorItemOid) throws R01MPublisherException {
        R01MPublish pub = this.execObtainPublicationInfoObject(userName, objectOid, objectType, filePattern, resourcesRelativePaths, publisherManagerClassName, repositoryOid, publicationType, publicationDate);
        try {
            pub.properties.put("prePublishAction", URLEncoder.encode((String)prePublishAction, (String)"UTF-8"));
            pub.properties.put("publishAction", URLEncoder.encode((String)publishAction, (String)"UTF-8"));
            pub.properties.put("postPublishAction", URLEncoder.encode((String)postPublishAction, (String)"UTF-8"));
            if (aggregatorPacketOid != null) {
                pub.properties.put("aggregatorPacketOid", URLEncoder.encode((String)aggregatorPacketOid, (String)"UTF-8"));
            }
            if (aggregatorItemOid != null) {
                pub.properties.put("aggregatorItemOid", URLEncoder.encode((String)aggregatorItemOid, (String)"UTF-8"));
            }
            pub.properties.put("clusterName", R01MConstants.CLUSTER);
        }
        catch (UnsupportedEncodingException ex) {
            throw new R01MPublisherException("R01JPublisherServices._launchDeployment >> Encode no soportado:" + ex.getMessage());
        }
        try {
            this._invokePublisher(pub);
        }
        catch (R01MPublisherException publishEx) {
            throw new R01MPublisherException("R01JPublisherServices._launchDeployment >> Error en llamada al API de Publicaci\u00f3n: " + publishEx.getMessage(), (Exception)((Object)publishEx));
        }
        catch (Exception genericPublishEx) {
            throw new R01MPublisherException("R01JPublisherServices._launchDeployment >> Error desconocido en la Publicaci\u00f3n: " + genericPublishEx.getMessage(), genericPublishEx);
        }
        if (!StringUtils.isEmptyString((String)objectOid) && DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01JPublisherServices._launchDeployment >> El objeto de Oid " + (objectOid == null ? "[no definido]" : objectOid) + " y tipo " + Integer.toString(objectType) + " ha sido publicado en el repositorio de Oid " + repositoryOid);
        }
    }

    private void _updatePublicationContentModelInfoObject(R01MPublish pub, R01MLogicalPublicationInfo logicalPublicationInfo, String userName, String objectOid, int objectType, String filePattern, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate) throws R01MPublisherException {
        if (publicationType == 0 || publicationType == 1) {
            if (objectType == 8 || objectType == 11 || objectType == 9 || objectType == 21) {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMERESOURCEPREFIX_CONTENT);
            } else if (objectType == 16) {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMERESOURCEFILELISTPREFIX);
            } else if (objectType == 20) {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMECONTENTRESOURCEPREFIX_CONTENT);
            } else if (objectType == 19) {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMEPREFIX_OPENDATA);
            } else {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMEPREFIX_CONTENT);
            }
        } else if (objectType == 16) {
            pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMERESOURCEFILELISTPREFIX);
        } else if (objectType == 20) {
            pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMECONTENTRESOURCEPREFIX_CONTENT);
        } else if (objectType == 11) {
            pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMERESOURCEPREFIX_CONTENT);
        } else {
            pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMEPREFIX_CONTENT);
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        String contentOid = null;
        String documentOid = null;
        R01MContentModelAPI contentModelAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)adminContext);
        if (objectType == 0 || objectType == 8 || objectType == 11 || objectType == 21) {
            contentOid = objectOid;
        } else if (objectType == 1 || objectType == 9 || objectType == 16 || objectType == 20) {
            documentOid = objectOid;
            try {
                contentOid = contentModelAPI.getDocumentParentContent(objectOid);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al acceder al modelo de contenidos para obtener el contenido al que pertenece el documento " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al acceder al modelo de contenidos para obtener el contenido al que pertenece el documento " + (objectOid == null ? "[null]" : objectOid), (Exception)((Object)cmEx));
            }
        }
        R01MContent content = null;
        R01MDocument document = null;
        if (objectType != 19) {
            try {
                content = contentModelAPI.loadContent(contentOid);
            }
            catch (R01MSecurityException secEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al acceder al modelo de contenidos para cargar el contenido " + (contentOid == null ? "[null]" : contentOid), (Exception)((Object)secEx));
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al acceder al modelo de contenidos para cargar el contenido " + (contentOid == null ? "[null]" : contentOid), (Exception)((Object)cmEx));
            }
            try {
                if (objectType == 1 || objectType == 9 || objectType == 20 || objectType == 16) {
                    document = content.getDocument(documentOid) == null ? contentModelAPI.loadDocument(documentOid) : content.getDocument(documentOid);
                }
            }
            catch (R01MSecurityException ex) {
                throw new R01MPublisherException(new StringBuffer().append("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al cargar el documento: ").append(documentOid == null ? "[null]" : documentOid).toString());
            }
            catch (R01MContentModelException ex) {
                throw new R01MPublisherException(new StringBuffer().append("R01JPublisherServices._updatePublicationContentModelInfoObject >> Error al cargar el documento: ").append(documentOid == null ? "[null]" : documentOid).toString());
            }
        }
        Date lastDate = null;
        if (document != null && document.getPublicationInfo() != null && objectType == 1) {
            for (R01MDocumentPublicationTarget publicationTarget : document.getPublicationInfo()) {
                if ((publicationTarget.getState() != 4 || publicationType != 0 && publicationType != 1) && (publicationTarget.getState() != 5 || publicationType != 2 && publicationType != 3 || lastDate != null && !lastDate.after(publicationTarget.getPublishDate()))) continue;
                pub.setOid(publicationTarget.getPublicationOid());
                lastDate = publicationTarget.getPublishDate();
            }
        }
        if (objectType == 11 || objectType == 16) {
            String fileListName = "";
            if (objectType == 11) {
                fileListName = "publicationContentResourceFilesFileList-" + content.getInternalName() + ".txt";
            } else if (objectType == 16) {
                fileListName = "publicationDocumentAliasFileList-" + document.getLanguage() + "_" + document.getInternalName() + ".txt";
            }
            String publishFileWARelPath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getName(), (String)content.getName()) + "/" + XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/publishDir") + "/" + fileListName;
            pub.resourcesList = this._getContentModelFilelist(content.getOid(), publishFileWARelPath);
        }
        pub.properties = objectType == 8 || objectType == 9 || objectType == 11 || objectType == 21 ? this._obtainContentModelIndexDataDeploymentParameters(adminContext, content, document, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate) : (objectType == 16 ? this._obtainContentModelAliasDeploymentParameters(logicalPublicationInfo, content, document, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate) : (objectType == 20 ? this._obtainContentModelDocumentRelativeResourcesDeploymentParameters(content, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate, logicalPublicationInfo.getContentBasePath(), filePattern) : (objectType == 19 ? this._obtainContentModelPackageZipDeploymentParameters(content, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate, logicalPublicationInfo.getContentBasePath(), filePattern) : this._obtainContentModelInformationDataDeploymentParameters(content, document, logicalPublicationInfo.getContentBasePath(), userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate))));
    }

    private Map<String, String> _obtainContentModelAliasDeploymentParameters(R01MLogicalPublicationInfo logicalPublicationInfo, R01MContent content, R01MDocument document, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate) {
        HashMap<String, String> propiedades = new HashMap<String, String>();
        this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        String areaOrigen = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/")) + document.getLanguage() + "_" + document.getInternalName() + "/";
        areaOrigen = StringUtils.replaceString((String)areaOrigen, (String)"//", (String)"/");
        propiedades.put("area_origen", areaOrigen);
        propiedades.put("area_destino", logicalPublicationInfo.getContentBasePath() + "/html");
        propiedades.put("fileListSource", R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/" + XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/publishDir") + "/" + "publicationDocumentAliasFileList-" + document.getLanguage() + "_" + document.getInternalName() + ".txt")));
        return propiedades;
    }

    private Map<String, String> _obtainContentModelDocumentRelativeResourcesDeploymentParameters(R01MContent content, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate, String areaDestino, String includePattern) {
        HashMap<String, String> propiedades = new HashMap<String, String>();
        this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/"));
        if (stagingPath != null && stagingPath.startsWith("//iwmnt")) {
            stagingPath = stagingPath.substring(1);
        }
        propiedades.put("stagingVPath", stagingPath);
        propiedades.put("area_destino", areaDestino);
        propiedades.put("dest_repository_relative_path", content.getTypo().getTypeOid() + "/" + content.getName());
        propiedades.put("contentName", content.getName());
        propiedades.put("includePattern", includePattern);
        return propiedades;
    }

    private Map<String, String> _obtainContentModelPackageZipDeploymentParameters(R01MContent content, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate, String areaDestino, String includePattern) {
        HashMap<String, String> propiedades = new HashMap<String, String>();
        this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        propiedades.put("area_destino", areaDestino);
        String relative_path = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"openDataScheduled/fileList/destinationFolder", (String)"AVComun/exec/r01PackageZip");
        propiedades.put("relative_path", relative_path);
        String servlet_url = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"openDataScheduled/invoke/update/url", (String)"http://www.euskadi.eus:80/r01htContentServicesWAR/r01hOpenDataPackageUpdateServlet");
        propiedades.put("servlet_url", servlet_url);
        String wr01_system_area = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"storageConfigServer/systemWorkAreaOid");
        propiedades.put("wr01_system_area", wr01_system_area);
        return propiedades;
    }

    private Map<String, String> _obtainContentModelIndexDataDeploymentParameters(R01MUserContext usrCtx, R01MContent content, R01MDocument document, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate) throws R01MPublisherException {
        HashMap<String, String> propiedades = new HashMap<String, String>();
        this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        propiedades.put("filePattern", ".*");
        if (objectType == 8) {
            String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/r01Index"));
            propiedades.put("stagingVPath", StringUtils.replaceString((String)stagingPath, (String)"//", (String)"/"));
            String publishContentPath = "";
            R01MLogicalPublicationInfo logicalPublicationInfo = null;
            try {
                logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MPublisherException("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la publicaci\u00f3n de ficheros de indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede cargar la configuraci\u00f3n para el repositorio " + repositoryOid + ". " + "Error: " + clEx.getMessage(), (Exception)((Object)clEx));
            }
            if (logicalPublicationInfo != null) {
                publishContentPath = logicalPublicationInfo.getContentBasePath() + "/html" + "/" + content.getTypo().getTypeOid() + "/" + content.getName() + "/r01Index";
            }
            propiedades.put("publishedContentPath", StringUtils.replaceString((String)publishContentPath, (String)"//", (String)"/"));
            propiedades.put("publishedIDXFolder", publishContentPath);
        } else if (objectType == 21) {
            String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/opendata"));
            propiedades.put("stagingVPath", StringUtils.replaceString((String)stagingPath, (String)"//", (String)"/"));
            String publishContentPath = "";
            R01MLogicalPublicationInfo logicalPublicationInfo = null;
            try {
                logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MPublisherException("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la publicaci\u00f3n de ficheros de indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede cargar la configuraci\u00f3n para el repositorio " + repositoryOid + ". " + "Error: " + clEx.getMessage(), (Exception)((Object)clEx));
            }
            if (logicalPublicationInfo != null) {
                publishContentPath = logicalPublicationInfo.getContentBasePath() + "/html" + "/" + content.getTypo().getTypeOid() + "/" + content.getName() + "/opendata";
            }
            propiedades.put("publishedContentPath", StringUtils.replaceString((String)publishContentPath, (String)"//", (String)"/"));
        } else if (objectType == 9) {
            String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/" + document.getLanguage() + "_" + document.getInternalName() + "/r01Index"));
            propiedades.put("stagingVPath", StringUtils.replaceString((String)stagingPath, (String)"//", (String)"/"));
            String publishContentPath = "";
            R01MLogicalPublicationInfo logicalPublicationInfo = null;
            try {
                logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MPublisherException("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la publicaci\u00f3n de ficheros de indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede cargar la configuraci\u00f3n para el repositorio " + repositoryOid + ". " + "Error: " + clEx.getMessage(), (Exception)((Object)clEx));
            }
            if (logicalPublicationInfo != null) {
                publishContentPath = logicalPublicationInfo.getContentBasePath() + "/html/" + content.getTypo().getTypeOid() + "/" + content.getName() + "/" + document.getLanguage() + "_" + document.getInternalName() + "/r01Index";
                publishContentPath = StringUtils.replaceString((String)publishContentPath, (String)"//", (String)"/");
            }
            propiedades.put("publishedContentPath", publishContentPath);
            propiedades.put("publishedIDXFolder", publishContentPath);
        } else {
            String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)(content.getName() + "/"));
            propiedades.put("stagingVPath", StringUtils.replaceString((String)stagingPath, (String)"//", (String)"/"));
            String publishContentPath = "";
            R01MLogicalPublicationInfo logicalPublicationInfo = null;
            try {
                logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MPublisherException("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la publicaci\u00f3n de ficheros de indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede cargar la configuraci\u00f3n para el repositorio " + repositoryOid + ". " + "Error: " + clEx.getMessage(), (Exception)((Object)clEx));
            }
            if (logicalPublicationInfo != null) {
                publishContentPath = logicalPublicationInfo.getContentBasePath() + "/html" + "/" + content.getTypo().getTypeOid() + "/" + content.getName();
                publishContentPath = StringUtils.replaceString((String)publishContentPath, (String)"//", (String)"/");
            }
            propiedades.put("publishedContentPath", publishContentPath);
            ArrayList<String> documentsToPublish = new ArrayList<String>();
            if (document != null) {
                propiedades.put("publishedIDXFolder", publishContentPath + document.getLanguage() + "_" + document.getInternalName() + "/r01Index" + " " + publishContentPath + "/r01Index");
                documentsToPublish.add(document.getLanguage() + "_" + document.getInternalName());
            } else if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                for (R01MDocument currentDocument : content.getDocuments().values()) {
                    try {
                        R01MContentModelAPI contentAPI = null;
                        contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)usrCtx);
                        if (!contentAPI.isDocumentPublished(repositoryOid, currentDocument.getOid())) continue;
                        documentsToPublish.add(currentDocument.getLanguage() + "_" + currentDocument.getInternalName());
                    }
                    catch (R01MContentModelException cmEx) {
                        R01FLog.to((String)"r01n.upload").severe("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede verificar si el documento " + currentDocument.getOid() + " est\u00e1 publicado. " + "No se tratar\u00e1 (no se consolidar\u00e1 ni publicar\u00e1). " + "Error:" + cmEx.getMessage());
                    }
                    catch (R01MSecurityException secEx) {
                        R01FLog.to((String)"r01n.upload").severe("R01JPublisherServices._obtainIndexDataDeploymentParameters >> Error en la indexaci\u00f3n del contenido de identificador '" + content.getOid() + "'." + "No se puede verificar si el documento " + currentDocument.getOid() + " est\u00e1 publicado. " + "No se tratar\u00e1 (no se consolidar\u00e1 ni publicar\u00e1). " + "Error:" + secEx.getMessage());
                    }
                }
            }
            StringBuffer filePattern = new StringBuffer();
            StringBuffer publishedIDXFolder = new StringBuffer();
            if (resourcesRelativePaths != null && !resourcesRelativePaths.isEmpty()) {
                filePattern.append('(');
                for (String resource : resourcesRelativePaths) {
                    filePattern.append(resource);
                    filePattern.append('|');
                    publishedIDXFolder.append(" ").append(publishContentPath).append("/").append(resource.matches(".*/[^/]+\\.[^/]+$") ? resource.replaceAll("(.*)/[^/]+$", "$1") : resource);
                }
                filePattern.deleteCharAt(filePattern.length() - 1);
                filePattern.append(')');
            }
            propiedades.put("publishedIDXFolder", publishedIDXFolder.toString());
            propiedades.put("filePattern", filePattern.toString());
        }
        return propiedades;
    }

    private Map<String, String> _obtainContentModelInformationDataDeploymentParameters(R01MContent content, R01MDocument document, String areaDestino, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate) {
        HashMap<String, String> propiedades = new HashMap<String, String>();
        this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
        String stagingPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + (objectType == 0 || objectType == 8 || objectType == 11 || objectType == 21 ? R01MPathHelpper.getContentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName()) : R01MPathHelpper.getDocumentStagingRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName()));
        if (stagingPath != null && stagingPath.startsWith("//iwmnt")) {
            stagingPath = stagingPath.substring(1);
        }
        propiedades.put("stagingVPath", stagingPath);
        propiedades.put("area_destino", areaDestino);
        propiedades.put("dest_repository_relative_path", content.getTypo().getTypeOid() + "/" + content.getName() + (document == null ? "" : "/" + (!StringUtils.isEmptyString((String)document.getLanguage()) ? document.getLanguage() : "[language null or empty]") + "_" + (!StringUtils.isEmptyString((String)document.getInternalName()) ? document.getInternalName() : "[document internal name null or empty]")));
        if (DEBUG) {
            for (Map.Entry me : propiedades.entrySet()) {
                String propName = (String)me.getKey();
                String propValue = (String)me.getValue();
                R01FLog.to((String)LOG_TYPE_ID).info("R01JPublisherServices._obtainInformationDataDeploymentParameters >> Para el contenido " + content.getOid() + (document == null ? "" : " y el documento " + document.getOid()) + (StringUtils.isEmptyString((String)propName) ? "[empty or null]" : propName) + "=" + (StringUtils.isEmptyString((String)propValue) ? "[empty or null]" : propValue));
            }
        }
        return propiedades;
    }

    private void _updatePublicationPortalModelInfoObject(String userName, R01MPublish pub, String objectOid, int objectType, String filePattern, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, R01MLogicalPublicationInfo logicalPublicationInfo, Date publicationDate) throws R01MPublisherException {
        if (objectType == 13) {
            pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMEPREFIX_SYSTEM);
            HashMap<String, String> propiedades = new HashMap<String, String>();
            this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
            propiedades.put("filterPattern", filePattern);
            if (resourcesRelativePaths.size() != 1) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Se ha pasado m\u00e1s de una ruta relativa donde publicar y \u00e9sto no est\u00e1 permitido");
            }
            propiedades.put("relativePath", resourcesRelativePaths.get(0));
            pub.properties = propiedades;
        } else {
            String areaOrigen;
            R01MPortalLocation location;
            R01MPortal portal;
            if (objectType == 10) {
                if (publicationType == 0 || publicationType == 1) {
                    pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMERESOURCEPREFIX_PORTAL);
                } else {
                    pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMERESOURCEPREFIX_PORTAL);
                }
            } else if (objectType == 17 || objectType == 18) {
                if (publicationType == 0 || publicationType == 1) {
                    pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMERESOURCEFILELISTPREFIX);
                } else {
                    pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMERESOURCEFILELISTPREFIX);
                }
            } else if (publicationType == 0 || publicationType == 1) {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTPUBLISHNAMEPREFIX_PORTAL);
            } else {
                pub.setDeploymentNamePrefix(R01MPublish.DEPLOYMENTUNPUBLISHNAMEPREFIX_PORTAL);
            }
            R01MUserContext adminContext = null;
            try {
                adminContext = R01MAuthManager.createMasterSystemUserContext();
            }
            catch (R01MSecurityException secEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
            }
            R01MPage page = null;
            String portalOid = "";
            if (objectType == 4 || objectType == 10 || objectType == 17) {
                try {
                    page = R01MClientFactory.getPortalModelAPI((R01MUserContext)adminContext, null).loadPortalPage(objectOid);
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al acceder al modelo de portales", (Exception)((Object)secEx));
                }
                catch (R01MPortalModelException pmEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al acceder al modelo de portales", (Exception)((Object)pmEx));
                }
                portalOid = page != null && !StringUtils.isEmptyString((String)page.getPortalOid()) ? page.getPortalOid() : null;
                Date lastDate = null;
                if (page != null && page.getPublicationInfo() != null) {
                    for (R01MPortalPublicationTarget publicationTarget : page.getPublicationInfo()) {
                        if ((publicationTarget.getState() != 4 || publicationType != 0 && publicationType != 1) && (publicationTarget.getState() != 5 || publicationType != 2 && publicationType != 3 || lastDate != null && !lastDate.after(publicationTarget.getPublishDate()))) continue;
                        pub.setOid(publicationTarget.getPublicationOid());
                        lastDate = publicationTarget.getPublishDate();
                    }
                }
            } else if (objectType == 12 || objectType == 14 || objectType == 18) {
                portalOid = objectOid;
            } else if (objectType == 7) {
                try {
                    portalOid = R01MClientFactory.getPortalModelAPI((R01MUserContext)adminContext, null).getVisualAreaParentPortalOid(objectOid);
                }
                catch (R01MPortalModelException pmEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al obtener el portal a partir del \u00e1rea visual.", (Exception)((Object)pmEx));
                }
            }
            try {
                portal = R01MClientFactory.getPortalConfigAPI().loadPortal(portalOid, false);
            }
            catch (R01MConfigLoadException clEx) {
                throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al cargar la configuraci\u00f3n del portal " + (portalOid == null ? "[null]" : portalOid) + " para  obtener los datos necesarios en la composici\u00f3n del deployment.", (Exception)((Object)clEx));
            }
            HashMap<String, String> propiedades = new HashMap<String, String>();
            this._updateCommonODParameters(propiedades, userName, objectOid, objectType, resourcesRelativePaths, publisherManagerClassName, publicationType, repositoryOid, publicationDate);
            if (objectType == 10) {
                String pageInternalName = portalOid + "-" + page.getInternalName();
                String relativePagePath = R01MPortalPathHelpper.replacePortalPageCodeInPath((String)R01MPortalPathHelpper.INDEXES_DIR, (String)portalOid, (String)pageInternalName);
                R01MPortalManagerAPI portalAPI = R01MClientFactory.getPortalModelAPI((R01MUserContext)adminContext, (String)portalOid);
                String stagingVPath = null;
                try {
                    stagingVPath = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)portalAPI.getPortalLocation()) + (relativePagePath.length() > 0 && relativePagePath.charAt(0) == '/' ? relativePagePath.substring(1) : relativePagePath);
                }
                catch (R01MPortalModelException pmEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al obtener la localizaci\u00f3n del STAGING para ejecutar el deployment de los ficheros de indexaci\u00f3n de la p\u00e1gina " + (page == null ? "[null]" : page.getPortalOid() + "-" + page.getInternalName()), (Exception)((Object)pmEx));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Durante la publicaci\u00f3n del objeto " + (objectOid == null ? "[no definido]" : objectOid) + " de tipo " + R01MConstants.OBJECT_DESCS[objectType] + ". Error al obtener la localizaci\u00f3n del STAGING para ejecutar el " + "deployment de los ficheros de indexaci\u00f3n de la p\u00e1gina " + (page == null ? "[null]" : page.getPortalOid() + "-" + page.getInternalName()), (Exception)((Object)secEx));
                }
                propiedades.put("stagingVPath", StringUtils.replaceString((String)stagingVPath, (String)"//", (String)"/"));
                String publishContentPath = logicalPublicationInfo.getPortalBasePath() + relativePagePath;
                publishContentPath = StringUtils.replaceString((String)publishContentPath, (String)"//", (String)"/");
                propiedades.put("publishedContentPath", publishContentPath);
                ArrayList<String> objectsToPublish = new ArrayList<String>();
                try {
                    Map langAVs;
                    if (portalAPI.isPagePublished(page.getOid(), repositoryOid) && (langAVs = page.getVisualAreasGroupedByLanguage()) != null && !langAVs.isEmpty()) {
                        for (String currLang : langAVs.keySet()) {
                            objectsToPublish.add(currLang + "_" + pageInternalName);
                        }
                    }
                }
                catch (R01MPortalModelException pmEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Error al acceder al modelo de portales para el tipo " + R01MConstants.OBJECT_DESCS[objectType] + " y de identificador '" + (portalOid == null ? "[null]" : portalOid) + "'. No se puede verificar si la p\u00e1gina est\u00e1 publicada. Error:" + pmEx.getMessage(), (Exception)((Object)pmEx));
                }
                catch (R01MSecurityException secEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Error al acceder al modelo de portales para el tipo " + R01MConstants.OBJECT_DESCS[objectType] + " y de identificador '" + (portalOid == null ? "[null]" : portalOid) + "'. No se puede verificar si la p\u00e1gina est\u00e1 publicada. Error:" + secEx.getMessage(), (Exception)((Object)secEx));
                }
                catch (R01MPortalModelObjectsValidatorException pmovEx) {
                    throw new R01MPublisherException("R01JPublisherServices._updatePublicationPortalModelInfoObject >> Error al acceder al modelo de portales para el tipo " + R01MConstants.OBJECT_DESCS[objectType] + " y de identificador '" + (portalOid == null ? "[null]" : portalOid) + "'. No se pueden obtener las \u00e1reas visuales ordenadas por lenguaje. Error:" + pmovEx.getMessage(), (Exception)((Object)pmovEx));
                }
                StringBuffer filterPattern = new StringBuffer();
                StringBuffer publishedIDXFolder = new StringBuffer();
                filterPattern.append("(opendata/.*|r01Index/").append(pageInternalName).append("-idxContent.xml)");
                for (int i = 0; i < objectsToPublish.size(); ++i) {
                    publishedIDXFolder.append(publishContentPath).append((String)objectsToPublish.get(i)).append("/r01Index ");
                    filterPattern.append('|').append((String)objectsToPublish.get(i)).append("/r01Index/.*");
                }
                propiedades.put("publishedIDXFolder", publishedIDXFolder.toString().replaceAll("//", "/"));
            } else if (objectType == 12) {
                location = portal.getStoreLocation();
                propiedades.put("stagingVPath", R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)location) + portal.getOid() + "/html");
                propiedades.put("filePattern", filePattern);
                propiedades.put("publishedContentPath", logicalPublicationInfo.getPortalBasePath() + portal.getOid() + "/html");
                propiedades.put("publishedIDXFolder", "");
                areaOrigen = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)location) + portal.getOid();
                String resourceTypesPub = filePattern.indexOf("access") > 0 ? "-access" : "-analytics";
                String filelistSource = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)location) + R01MPathHelpper.getPortalPublicationFilelistFolderWorkAreaRelativePath((String)portal.getOid()) + R01MPublisherUtils.getFilelistName((String)(objectOid + resourceTypesPub), (int)objectType, (int)publicationType);
                propiedades.put("area_origen", areaOrigen);
                propiedades.put("area_destino", logicalPublicationInfo.getPortalBasePath() + portal.getOid());
                propiedades.put("fileListSource", filelistSource);
            } else {
                location = portal.getStoreLocation();
                areaOrigen = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)location) + portal.getOid();
                String filelistSource = R01MPathHelpper.getStagingLocationPath((R01MBaseLocationObject)location) + R01MPathHelpper.getPortalPublicationFilelistFolderWorkAreaRelativePath((String)portal.getOid()) + R01MPublisherUtils.getFilelistName((String)objectOid, (int)objectType, (int)publicationType);
                propiedades.put("area_origen", areaOrigen + (objectType == 17 || objectType == 18 ? "/html" : ""));
                propiedades.put("area_destino", logicalPublicationInfo.getPortalBasePath() + portal.getOid() + (objectType == 17 || objectType == 18 ? "/html" : ""));
                propiedades.put("fileListSource", filelistSource);
                if (objectType == 4 && publicationType == 2) {
                    propiedades.put("folderToUnindex", StringUtils.replaceString((String)(logicalPublicationInfo.getPortalBasePath() + R01MPortalPathHelpper.replacePortalPageCodeInPath((String)R01MPortalPathHelpper.INDEXES_DIR, (String)portalOid, (String)(portalOid + "-" + page.getInternalName()))), (String)"//", (String)"/"));
                }
            }
            pub.properties = propiedades;
        }
    }

    private void _updateCommonODParameters(Map<String, String> propiedades, String userName, String objectOid, int objectType, List<String> resourcesRelativePaths, String publisherManagerClassName, int publicationType, String repositoryOid, Date publicationDate) {
        propiedades.put("userName", userName);
        propiedades.put("objectOid", objectOid);
        propiedades.put("objectType", Integer.toString(objectType));
        propiedades.put("resourcesRelativePaths", resourcesRelativePaths == null ? "" : resourcesRelativePaths.toString().replaceFirst("\\[", "").replaceFirst("\\]", ""));
        propiedades.put("publisherManagerClassName", publisherManagerClassName);
        propiedades.put("repositoryOid", repositoryOid);
        propiedades.put("publicationType", Integer.toString(publicationType));
        propiedades.put("pubDateInMillis", publicationDate == null ? "" : Long.toString(publicationDate.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> _getContentModelFilelist(String contentOid, String path) throws R01MPublisherException {
        ArrayList<String> resourcesList;
        block19: {
            InputStream is;
            resourcesList = new ArrayList<String>();
            R01MUserContext adminContext = null;
            try {
                adminContext = R01MAuthManager.createMasterSystemUserContext();
            }
            catch (R01MSecurityException secEx) {
                throw new R01MPublisherException("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
            }
            try {
                is = R01MClientFactory.getContentDataAPI((R01MUserContext)adminContext, (String)contentOid).downloadPublishFile(path);
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MPublisherException("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al tratar de obtener el fichero de recursos de publicaci\u00f3n", (Exception)((Object)cmEx));
            }
            catch (R01MSecurityException secEx) {
                throw new R01MPublisherException("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al tratar de obtener el fichero de recursos de publicaci\u00f3n", (Exception)((Object)secEx));
            }
            if (is != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    resourcesList.add(line);
                }
                try {
                    reader.close();
                }
                catch (IOException ioEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al cerrar el buffer del fichero de publicaci\u00f3n: " + ioEx.getMessage());
                    }
                    break block19;
                }
                catch (IOException ioEx) {
                    block20: {
                        try {
                            if (!DEBUG) break block20;
                            R01FLog.to((String)LOG_TYPE_ID).warning("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al leer el buffer del fichero de publicaci\u00f3n: " + ioEx.getMessage());
                        }
                        catch (Throwable throwable) {
                            block21: {
                                try {
                                    reader.close();
                                }
                                catch (IOException ioEx2) {
                                    if (!DEBUG) break block21;
                                    R01FLog.to((String)LOG_TYPE_ID).warning("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al cerrar el buffer del fichero de publicaci\u00f3n: " + ioEx2.getMessage());
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException ioEx3) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("R01JPublisherServices._getContentModelFilelist >> Contenido: " + (contentOid == null ? "[null]" : contentOid) + "Error al cerrar el buffer del fichero de publicaci\u00f3n: " + ioEx3.getMessage());
                        }
                    }
                }
            }
        }
        return resourcesList;
    }

    private void _invokePublisher(R01MPublish pubInfo) throws R01MPublisherException {
        R01JPublisherInvoker publisherInvoker = this._getPublisherInvoker(pubInfo);
        R01MPublicationResponse pubResponse = null;
        if (!SIMULATE) {
            pubResponse = publisherInvoker.invoke(pubInfo);
        } else if (SIMULATE) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("SE est\u00e1 simulando la publicaci\u00f3n: NO SE INVOCA A OpenDeploy!!!!!");
            }
            pubResponse = new R01MPublicationResponse();
            pubResponse.setDeployDirection("SENDING");
            pubResponse.setDeployID("simulated");
            pubResponse.setDeployName("simulated");
            pubResponse.setDeployState("Completed");
            pubResponse.setDeployUUID("simulated");
        }
        if (pubResponse == null) {
            throw new R01MPublisherException("R01JPublisherServices._invokePublisher >> El resultado de la invocaci\u00f3n al publicador es NULO.");
        }
        pubInfo.status = pubResponse.getDeployState();
        pubInfo.enddate = R01MPublish.PROGRAMMED_NO.equals(pubInfo.programmed) ? DateUtils.getDateFormated((Date)new Date(System.currentTimeMillis()), (String)"dd/MM/yyyy HH:mm:ss") : pubInfo.programmeddate;
    }

    private R01JPublisherInvoker _getPublisherInvoker(R01MPublish pubInfo) throws R01MPublisherException {
        R01JPublisherInvoker publisherInvoker;
        R01MInvocationType invocationType;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHER-MANAGER: R01JPublisherServices._invokePublisher >> [" + pubInfo.getOid() + "] >>>> " + "Se almacena en base de datos la informaci\u00f3n de la publicaci\u00f3n solicitada y " + "se invoca al Publisher para que publique un contenido.");
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHER-MANAGER: R01JPublisherServices._invokePublisher >> [" + pubInfo.getOid() + "] >>>> " + "INICIO DE LA PUBLICACI\u00d3N !!!!!");
        }
        if ((invocationType = R01JPublisherConfig.getInvocationType((String)pubInfo.source, (String)R01JPublisherConfig.INVOCATION_TYPE_SELECTED)) == null) {
            throw new R01MPublisherException("R01JPublisherServices._invokePublisher >> NO se ha podido obtener el tipo de invocaci\u00f3n (comandos|webServices) seleccionada para el origen " + pubInfo.source + ". " + "Revisa el fichero r01j.properties.xml");
        }
        String publisherInvokerClassName = R01JPublisherInvoker.class.getPackage().getName() + "." + "R01JPublisherInvokerBy" + invocationType.getName();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PUBLISHER-MANAGER  [" + pubInfo.getOid() + "]>>>> Invocaci\u00f3n al opendeploy mediante comandos o webservices (en funci\u00f3n del valor del par\u00e1metro invocationtype del fichero de propiedades). La clase encargada de la invocaci\u00f3n es: " + publisherInvokerClassName);
        }
        try {
            publisherInvoker = (R01JPublisherInvoker)ReflectionUtils.getObjectInstance((String)publisherInvokerClassName);
        }
        catch (ReflectionException reflectEx) {
            throw new R01MPublisherException("R01JPublisherServices._invokePublisher >> NO se ha podido instanciar la clase " + publisherInvokerClassName + " que se encarga de la invocaci\u00f3n al publicador: " + reflectEx.getMessage(), (Exception)((Object)reflectEx));
        }
        return publisherInvoker;
    }
}

