/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01g.exceptions.R01GPortalModelPersistenceException;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelLoader;
import com.ejie.r01g.gestorportal.dbhelppers.dao.R01GDAOPortalModelManager;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaBMPUtil;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaCMPPK;
import com.ejie.r01g.gestorportal.ejb.visualarea.R01GVisualAreaCMPUtil;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MDuplicateVisualAreaException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MPortalModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.portalmodel.R01MVisualAreaInstance;
import com.ejie.r01m.utils.R01MConstants;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01GVisualAreaAdminManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.vaManager").intValue() != Level.OFF.intValue();
    private transient String _visualareaOid;
    private transient R01MUserContext _userCtx;

    public R01GVisualAreaAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public R01GVisualAreaAdminManager(R01MUserContext userCtx, String visualAreaOid) {
        this(userCtx);
        this._visualareaOid = visualAreaOid;
    }

    public void doCreateVisualArea(String portalOid, R01MVisualAreaInstance vaInstance) throws R01MPortalModelException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER (" + vaInstance.getOid() + ") > Creando la instancia de VA....");
        }
        if (this._validateVAInternalNameAndObject(portalOid, vaInstance)) {
            throw new R01MDuplicateVisualAreaException("Ya existe una instancia de VA con el nombre interno " + vaInstance.getName());
        }
        try {
            R01GVisualAreaBMPUtil.getLocalHome().create(this._userCtx, portalOid, vaInstance);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > Error al crear la instancia de VA.");
            throw new R01MPortalModelException("Error al crear la instancia de oid " + vaInstance.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > No se puede crear la instancia de VA.");
            throw new R01MPortalModelException("No se puede crear la instancia de oid " + vaInstance.getOid() + ". Error: " + crtEx.getMessage(), (Exception)((Object)crtEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > Error al obtener el interfaz home del BMP de instancia de VA.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del BMP de instancia de VA: " + namEx.getMessage(), (Exception)namEx);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > La instancia de VA " + vaInstance.getOid() + " ha sido creada!!!");
        }
    }

    public R01MVisualAreaInstance doLoadVisualAreaInstance(String vaInstanceOid) throws R01MPortalModelException {
        R01MVisualAreaInstance vaObject;
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > Cargando la instancia de oid " + vaInstanceOid);
        }
        String instanceXMLDefinition = "";
        try {
            instanceXMLDefinition = R01GVisualAreaCMPUtil.getLocalHome().findByPrimaryKey(new R01GVisualAreaCMPPK(vaInstanceOid)).getXMLInstance();
        }
        catch (FinderException fndEx) {
            if (DEBUG) {
                R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER (" + vaInstanceOid + ") > La instancia no existe.");
            }
            return null;
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstanceOid + ") > Error al obtener el interfaz home del CMP de instancia de VA.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de instancia de VA. Error: " + namEx.getMessage(), (Exception)namEx);
        }
        try {
            vaObject = (R01MVisualAreaInstance)XOManager.getObject((String)R01MConstants.PORTALMODEL_MAPFILE, (String)instanceXMLDefinition);
        }
        catch (XOMarshallerException xoEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstanceOid + ") > Error al mapear el XML de instancia de VA a objetos.");
            throw new R01MPortalModelException("Error al mapear el XML de instancia de VA a objetos. Error: " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        return vaObject;
    }

    public void doUpdateVisualArea(String portalOid, R01MVisualAreaInstance vaInstance) throws R01MPortalModelException, R01MDuplicateVisualAreaException, R01MPortalModelObjectsValidatorException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > Actualizando el Arwa Visual de oid  " + vaInstance.getOid());
        }
        if (this._validateVAInternalNameAndObjectOid(portalOid, vaInstance)) {
            throw new R01MDuplicateVisualAreaException("Ya existe una instancia de VA con el nombre interno " + vaInstance.getName());
        }
        try {
            R01GVisualAreaBMPUtil.getLocalHome().findByPrimaryKey(vaInstance.getOid()).update(this._userCtx, portalOid, vaInstance);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > Error al actualizar el VA.");
            throw new R01MPortalModelException("Error al actualizar el VA de oid " + vaInstance.getOid() + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (FinderException crtEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > No existe un VA con ese identificador.");
            throw new R01MPortalModelException("No se encuentra un VA con ese identificador.: " + crtEx.getMessage(), (Exception)((Object)crtEx));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.vaManager").severe("PORTALMANAGER (" + vaInstance.getOid() + ") > Error al obtener el interfaz home del SL de categor\u00eda.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del SL de Areas Visuales: " + namEx.getMessage(), (Exception)namEx);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER (" + vaInstance.getOid() + ") > Instancia de VA actualizada.");
        }
    }

    public void doDeleteVisualArea() throws R01MPortalModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("\tejbRemove()...");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("R01GVisualAreaBMP (" + this._visualareaOid + ") > DELETE > Borrando la \u00e1rea visual.");
        }
        try {
            R01GVisualAreaCMPUtil.getLocalHome().findByPrimaryKey(new R01GVisualAreaCMPPK(this._visualareaOid)).remove();
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01g.vaManager").severe("R01GVisualAreaBMP (" + this._visualareaOid + ") > DELETE > Error en CMP de \u00e1rea visual.");
            throw new R01MPortalModelException("Error al borrar el \u00e1rea visual " + this._visualareaOid + ": " + ejbEx.getMessage());
        }
        catch (RemoveException remEx) {
            R01FLog.to((String)"r01g.vaManager").severe("R01GVisualAreaBMP (" + this._visualareaOid + ") > DELETE > No se puede borrar el \u00e1rea visual.");
            throw new R01MPortalModelException("No se puede borrar el \u00e1rea visual " + this._visualareaOid + ": " + remEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.vaManager").severe("R01GVisualAreaBMP (" + this._visualareaOid + ")> DELETE > No existe el \u00e1rea visual.");
            throw new R01MPortalModelException("No existe el \u00e1rea visual " + this._visualareaOid + ": " + findEx.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.vaManager").severe("R01GVisualAreaBMP (" + this._visualareaOid + ")> DELETE > Error al localizar el home del CMP de \u00e1rea visual.");
            throw new R01MPortalModelException("Error al localizar el home del CMP de \u00e1rea visual: " + namEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("R01GVisualAreaBMP (" + this._visualareaOid + ")> DELETE > P\u00e1gina Borrada!");
        }
    }

    public void doRegisterChangeName(String vaInstanceOid, String oldVAInstanceName, String newVAInstanceName) {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > Registrar el cambio de nombre de VA migrada de oid " + vaInstanceOid);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("\tNombre anterior :" + oldVAInstanceName);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("\tNombre nuevo :" + newVAInstanceName);
        }
        R01GDAOPortalModelManager service = new R01GDAOPortalModelManager();
        try {
            service.insertChangeVAIname(vaInstanceOid, oldVAInstanceName, newVAInstanceName);
        }
        catch (R01GPortalModelPersistenceException ex) {
            R01FLog.to((String)"r01g.vaManager").warning("Error al cambiar el nombre interno de la instancia de VA de oid " + vaInstanceOid + ".Error:" + ex.getMessage());
        }
    }

    private boolean _validateVAInternalNameAndObject(String portalOid, R01MVisualAreaInstance vaInstance) throws R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > Comprobar la existencia de otra instancia de VA en el portal " + portalOid + " con el mismo nombre interno: " + vaInstance.getName());
        }
        vaInstance.validateObject();
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeValidateVAInstance(portalOid, vaInstance.getName());
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException("Error en la validaci\u00f3n del nombre interno de la instancia de VA del portal " + portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private boolean _validateVAInternalNameAndObjectOid(String portalOid, R01MVisualAreaInstance vaInstance) throws R01MPortalModelException, R01MPortalModelObjectsValidatorException {
        if (DEBUG) {
            R01FLog.to((String)"r01g.vaManager").info("PORTALMANAGER > Comprobar la existencia de otra instancia de VA en el portal " + portalOid + " con el mismo nombre interno: " + vaInstance.getName());
        }
        vaInstance.validateObject();
        R01GDAOPortalModelLoader service = new R01GDAOPortalModelLoader();
        try {
            return service.executeValidateVAInstanceOid(portalOid, vaInstance.getOid(), vaInstance.getName());
        }
        catch (R01GPortalModelPersistenceException ex) {
            throw new R01MPortalModelException("Error en la validaci\u00f3n del nombre interno de la instancia de VA del portal " + portalOid + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

