/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01g.services;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01g.api.R01GTemplateResourcesAPI;
import com.ejie.r01g.datastore.R01GPortalInDataStore;
import com.ejie.r01g.gestorportal.ejb.templates.R01GTemplateCMPLocal;
import com.ejie.r01g.gestorportal.ejb.templates.R01GTemplateCMPPK;
import com.ejie.r01g.gestorportal.ejb.templates.R01GTemplateCMPUtil;
import com.ejie.r01g.gestorportal.ejb.templates.R01GTemplateCMPValue;
import com.ejie.r01g.services.R01GBasePortalManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MPortalModelException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.portalmodel.R01MPortalTemplate;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01GTemplateAdminManager
extends R01GBasePortalManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01g.templateManager").intValue() != Level.OFF.intValue();
    private transient R01MUserContext _userCtx;

    public R01GTemplateAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void doCreateTemplate(String portalOid, String templateId) throws R01MPortalModelException, R01MSecurityException {
        R01MPortalTemplate templateDef;
        super.validateSecurityContext(this._userCtx, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.templateManager").info("TEMPLATEMANAGER (" + templateId + ") > Creando la plantilla ....");
        }
        boolean createDB = false;
        R01GTemplateCMPLocal templateCMP = null;
        try {
            templateCMP = R01GTemplateCMPUtil.getLocalHome().findByPrimaryKey(new R01GTemplateCMPPK(templateId, portalOid));
        }
        catch (FinderException fndEx) {
            createDB = true;
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateId + ") > Error al obtener el interfaz home del BMP de plantillas.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de plantillas : " + namEx.getMessage(), (Exception)namEx);
        }
        R01GTemplateResourcesAPI templatesAPI = new R01GTemplateResourcesAPI(this._userCtx);
        try {
            templateDef = templatesAPI.uploadTemplate(portalOid, templateId);
        }
        catch (R01MPortalModelException ex) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateId + ") > Error al crear la plantilla en el portal " + portalOid + ".");
            throw new R01MPortalModelException("Error al crear la plantilla en el portal " + portalOid + ": " + ex.getMessage(), (Exception)((Object)ex));
        }
        if (createDB) {
            R01GTemplateCMPValue templateVO = new R01GTemplateCMPValue();
            templateVO.setPortalOid(portalOid);
            templateVO.setTemplateOid(templateId);
            templateVO.setNameES(templateDef.getNameES());
            templateVO.setNameEU(templateDef.getNameEU());
            templateVO.setDescriptionES(templateDef.getDescriptionES());
            templateVO.setDescriptionEU(templateDef.getDescriptionEU());
            templateVO.setSubpage(templateDef.isSubpage() ? 1 : 0);
            try {
                R01GTemplateCMPUtil.getLocalHome().create(templateVO);
            }
            catch (CreateException crtEx) {
                R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateId + ") > No se puede crear la plantilla para el portal " + portalOid + ".");
                throw new R01MPortalModelException("No se puede crear la plantilla de oid " + templateId + " para el portal " + portalOid + ". Error: " + crtEx.getMessage(), (Exception)((Object)crtEx));
            }
            catch (NamingException namEx) {
                R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateId + ") > Error al obtener el interfaz home del BMP de plantillas.");
                throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de plantillas : " + namEx.getMessage(), (Exception)namEx);
            }
        } else if (templateCMP != null) {
            R01GTemplateCMPValue templateVO = templateCMP.getR01GTemplateCMPValue();
            templateVO.setNameES(templateDef.getNameES());
            templateVO.setNameEU(templateDef.getNameEU());
            templateVO.setDescriptionES(templateDef.getDescriptionES());
            templateVO.setDescriptionEU(templateDef.getDescriptionEU());
            templateCMP.setR01GTemplateCMPValue(templateVO);
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.templateManager").info("TEMPLATEMANAGER > La plantilla " + templateId + " ha sido creada!!!");
        }
    }

    public void doDeleteTemplate(String portalOid, String templateOid) throws R01MSecurityException, R01MPortalModelException {
        R01GPortalInDataStore datastore;
        super.validateSecurityContext(this._userCtx, portalOid, 0);
        if (DEBUG) {
            R01FLog.to((String)"r01g.templateManager").info("TEMPLATEMANAGER (" + templateOid + ") > Borrando la plantilla ....");
        }
        try {
            R01GTemplateCMPUtil.getLocalHome().remove((Object)new R01GTemplateCMPPK(templateOid, portalOid));
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateOid + ") > Error al obtener el interfaz home del BMP de plantillas.");
            throw new R01MPortalModelException("Error al obtener el interfaz home del CMP de plantillas : " + namEx.getMessage(), (Exception)namEx);
        }
        catch (EJBException ex) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateOid + ") > No se puede borrar la plantilla del portal " + portalOid + ".");
            throw new R01MPortalModelException("No se puede borrar la plantilla de oid " + templateOid + " del portal " + portalOid + ". Error: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (RemoveException rmEx) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateOid + ") > No se puede borrar la plantilla del portal " + portalOid + ".");
            throw new R01MPortalModelException("No se puede borrar la plantilla de oid " + templateOid + " del portal " + portalOid + ". Error: " + rmEx.getMessage(), (Exception)((Object)rmEx));
        }
        try {
            datastore = new R01GPortalInDataStore(this._userCtx, portalOid);
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateOid + ") > No se puede acceder al storage del portal " + portalOid);
            throw new R01MPortalModelException("No se puede acceder al storage del portal " + portalOid + ".Error:" + dsExc.getMessage(), (Exception)((Object)dsExc));
        }
        try {
            datastore.deleteTemplate(templateOid);
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)"r01g.templateManager").severe("TEMPLATEMANAGER (" + templateOid + ") > No se puede borrar la plantilla del storage del portal " + portalOid);
            throw new R01MPortalModelException("No se puede borrar la plantilla del storage del portal " + portalOid + ".Error:" + dsExc.getMessage(), (Exception)((Object)dsExc));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.templateManager").info("TEMPLATEMANAGER > La plantilla " + templateOid + " ha sido borrada!!!");
        }
    }
}

